/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.vault;

import games.strategy.net.INode;
import java.io.Serializable;

public class VaultID
implements Serializable {
    private static long s_currentID;
    private final INode m_generatedOn;
    private final long m_uniqueID = VaultID.getNextID();

    private static synchronized long getNextID() {
        return s_currentID++;
    }

    VaultID(INode generatedOn) {
        this.m_generatedOn = generatedOn;
    }

    INode getGeneratedOn() {
        return this.m_generatedOn;
    }

    long getUniqueID() {
        return this.m_uniqueID;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof VaultID)) {
            return false;
        }
        VaultID other = (VaultID)o;
        return other.m_generatedOn.equals(this.m_generatedOn) && other.m_uniqueID == this.m_uniqueID;
    }

    public int hashCode() {
        return (int)this.m_uniqueID ^ this.m_generatedOn.getName().hashCode();
    }

    public String toString() {
        return "VaultID generated on:" + this.m_generatedOn + " id:" + this.m_uniqueID;
    }
}

