/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.kingstable.delegate;

import games.strategy.common.delegate.BaseDelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.properties.GameProperties;
import games.strategy.engine.delegate.AutoSave;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.message.IRemote;
import games.strategy.kingstable.attachments.TerritoryAttachment;
import games.strategy.kingstable.delegate.KingsTablePlayExtendedDelegateState;
import games.strategy.kingstable.delegate.remote.IPlayDelegate;
import games.strategy.kingstable.ui.display.IKingsTableDisplay;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AutoSave(beforeStepStart=false, afterStepEnd=true)
public class PlayDelegate
extends BaseDelegate
implements IPlayDelegate {
    private Matches matches = null;

    @Override
    public void start(IDelegateBridge bridge) {
        super.start(bridge);
        if (this.matches == null) {
            this.matches = new Matches(this.getData());
        }
        IKingsTableDisplay display = (IKingsTableDisplay)bridge.getDisplayChannelBroadcaster();
        display.setStatus(this.m_player.getName() + "'s turn");
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public Serializable saveState() {
        KingsTablePlayExtendedDelegateState state = new KingsTablePlayExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        KingsTablePlayExtendedDelegateState s = (KingsTablePlayExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    @Override
    public String play(Territory start, Territory end) {
        String error = this.isValidPlay(start, end);
        if (error != null) {
            return error;
        }
        Collection<Territory> captured = this.checkForCaptures(end);
        this.performPlay(start, end, captured, this.m_player);
        return null;
    }

    private Collection<Territory> checkForCaptures(Territory end) {
        HashSet<Territory> captured = new HashSet<Territory>(4);
        if (end != null) {
            Territory below;
            Territory above;
            Territory right;
            Territory left;
            int endX = end.getX();
            int endY = end.getY();
            GameMap map = this.getData().getMap();
            Territory possibleCapture = map.getTerritoryFromCoordinates(endX, endY - 1);
            if (this.matches.eligibleForCapture(possibleCapture, this.m_player)) {
                Territory above2 = map.getTerritoryFromCoordinates(endX, endY - 2);
                if (this.matches.kingInSquare(possibleCapture)) {
                    left = map.getTerritoryFromCoordinates(endX - 1, endY - 1);
                    if (this.matches.eligibleParticipantsInKingCapture(this.m_player, above2, left, right = map.getTerritoryFromCoordinates(endX + 1, endY - 1))) {
                        captured.add(possibleCapture);
                    } else if (this.matches.kingCanBeCapturedLikeAPawn && this.matches.eligibleParticipantInPawnCapture(this.m_player, above2)) {
                        captured.add(possibleCapture);
                    }
                } else if (this.matches.eligibleParticipantInPawnCapture(this.m_player, above2)) {
                    captured.add(possibleCapture);
                }
            }
            if (this.matches.eligibleForCapture(possibleCapture = map.getTerritoryFromCoordinates(endX, endY + 1), this.m_player)) {
                Territory below2 = map.getTerritoryFromCoordinates(endX, endY + 2);
                if (this.matches.kingInSquare(possibleCapture)) {
                    left = map.getTerritoryFromCoordinates(endX - 1, endY + 1);
                    if (this.matches.eligibleParticipantsInKingCapture(this.m_player, below2, left, right = map.getTerritoryFromCoordinates(endX + 1, endY + 1))) {
                        captured.add(possibleCapture);
                    } else if (this.matches.kingCanBeCapturedLikeAPawn && this.matches.eligibleParticipantInPawnCapture(this.m_player, below2)) {
                        captured.add(possibleCapture);
                    }
                } else if (this.matches.eligibleParticipantInPawnCapture(this.m_player, below2)) {
                    captured.add(possibleCapture);
                }
            }
            if (this.matches.eligibleForCapture(possibleCapture = map.getTerritoryFromCoordinates(endX - 1, endY), this.m_player)) {
                Territory left2 = map.getTerritoryFromCoordinates(endX - 2, endY);
                if (this.matches.kingInSquare(possibleCapture)) {
                    above = map.getTerritoryFromCoordinates(endX - 1, endY - 1);
                    if (this.matches.eligibleParticipantsInKingCapture(this.m_player, left2, above, below = map.getTerritoryFromCoordinates(endX - 1, endY + 1))) {
                        captured.add(possibleCapture);
                    } else if (this.matches.kingCanBeCapturedLikeAPawn && this.matches.eligibleParticipantInPawnCapture(this.m_player, left2)) {
                        captured.add(possibleCapture);
                    }
                } else if (this.matches.eligibleParticipantInPawnCapture(this.m_player, left2)) {
                    captured.add(possibleCapture);
                }
            }
            if (this.matches.eligibleForCapture(possibleCapture = map.getTerritoryFromCoordinates(endX + 1, endY), this.m_player)) {
                Territory right2 = map.getTerritoryFromCoordinates(endX + 2, endY);
                if (this.matches.kingInSquare(possibleCapture)) {
                    above = map.getTerritoryFromCoordinates(endX + 1, endY - 1);
                    if (this.matches.eligibleParticipantsInKingCapture(this.m_player, right2, above, below = map.getTerritoryFromCoordinates(endX + 1, endY + 1))) {
                        captured.add(possibleCapture);
                    } else if (this.matches.kingCanBeCapturedLikeAPawn && this.matches.eligibleParticipantInPawnCapture(this.m_player, right2)) {
                        captured.add(possibleCapture);
                    }
                } else if (this.matches.eligibleParticipantInPawnCapture(this.m_player, right2)) {
                    captured.add(possibleCapture);
                }
            }
        }
        return captured;
    }

    private String isValidPlay(Territory start, Territory end) {
        int unitCount = start.getUnits().getUnitCount(this.m_player);
        if (unitCount < 1) {
            return this.m_player.getName() + " doesn't have a piece in the selected starting square.";
        }
        if (unitCount > 1) {
            return "The selected starting square contains more than one piece - that shouldn't be possible.";
        }
        if (!end.getUnits().isEmpty()) {
            return "The selected destination square is not empty";
        }
        int startX = start.getX();
        int endX = end.getX();
        int startY = start.getY();
        int endY = end.getY();
        GameMap map = this.getData().getMap();
        if (startX == endX) {
            int y2;
            int y1;
            if (startY < endY) {
                y1 = startY + 1;
                y2 = endY - 1;
            } else {
                y1 = endY + 1;
                y2 = startY - 1;
            }
            int y = y1;
            while (y <= y2) {
                Territory at;
                if ((at = map.getTerritoryFromCoordinates(startX, y++)).getUnits().size() <= 0) continue;
                return "Pieces can only move through empty spaces.";
            }
        } else if (startY == endY) {
            int x2;
            int x1;
            if (startX < endX) {
                x1 = startX + 1;
                x2 = endX - 1;
            } else {
                x1 = endX + 1;
                x2 = startX - 1;
            }
            int x = x1;
            while (x <= x2) {
                Territory at;
                if ((at = map.getTerritoryFromCoordinates(x++, startY)).getUnits().size() <= 0) continue;
                return "Intervening square (" + x + "," + startY + ") is not empty.";
            }
        } else {
            return "Pieces can only move in a straight line.";
        }
        if (!this.matches.kingInSquare(start) && this.matches.isKingsSquare(end)) {
            return "Only the king can go there";
        }
        return null;
    }

    private void performPlay(Territory start, Territory end, Collection<Territory> captured, PlayerID player) {
        Collection<Unit> units = start.getUnits().getUnits();
        String transcriptText = player.getName() + " moved from " + start.getName() + " to " + end.getName();
        this.m_bridge.getHistoryWriter().startEvent(transcriptText);
        this.m_bridge.getHistoryWriter().setRenderingData(units);
        Change removeUnit = ChangeFactory.removeUnits(start, units);
        Change removeStartOwner = ChangeFactory.changeOwner(start, PlayerID.NULL_PLAYERID);
        Change addUnit = ChangeFactory.addUnits(end, units);
        Change addEndOwner = ChangeFactory.changeOwner(end, player);
        CompositeChange change = new CompositeChange();
        change.add(removeUnit);
        change.add(removeStartOwner);
        change.add(addUnit);
        change.add(addEndOwner);
        for (Territory at : captured) {
            if (at == null) continue;
            Collection<Unit> capturedUnits = at.getUnits().getUnits();
            Change capture = ChangeFactory.removeUnits(at, capturedUnits);
            change.add(capture);
            Change removeOwner = ChangeFactory.changeOwner(at, PlayerID.NULL_PLAYERID);
            change.add(removeOwner);
        }
        this.m_bridge.addChange(change);
        IKingsTableDisplay display = (IKingsTableDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.performPlay(start, end, captured);
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IPlayDelegate.class;
    }

    private class Matches {
        private final boolean kingCanParticipateInCaptures;
        private final boolean cornerSquaresCanBeUsedToCapturePawns;
        private final boolean centerSquareCanBeUsedToCapturePawns;
        private final boolean cornerSquaresCanBeUsedToCaptureTheKing;
        private final boolean centerSquareCanBeUsedToCaptureTheKing;
        private final boolean edgeOfBoardCanBeUsedToCaptureTheKing;
        private final boolean kingCanBeCapturedLikeAPawn;

        Matches(GameData gameData) {
            GameProperties properties = gameData.getProperties();
            this.kingCanParticipateInCaptures = properties.get("King can participate in captures", true);
            this.cornerSquaresCanBeUsedToCapturePawns = properties.get("Corner squares can be used to capture pawns", true);
            this.centerSquareCanBeUsedToCapturePawns = properties.get("Center square can be used to capture pawns", false);
            this.cornerSquaresCanBeUsedToCaptureTheKing = properties.get("Corner squares can be used to capture the king", false);
            this.centerSquareCanBeUsedToCaptureTheKing = properties.get("Center square can be used to capture the king", true);
            this.edgeOfBoardCanBeUsedToCaptureTheKing = properties.get("Edge of board can be used to capture the king", false);
            this.kingCanBeCapturedLikeAPawn = properties.get("King can be captured like a pawn", false);
        }

        public boolean kingInSquare(Territory t) {
            if (t == null) {
                return false;
            }
            Collection<Unit> units = t.getUnits().getUnits();
            if (units.isEmpty()) {
                return false;
            }
            Unit unit = (Unit)units.toArray()[0];
            return unit.getType().getName().equals("king");
        }

        public boolean isKingsExit(Territory t) {
            TerritoryAttachment ta = (TerritoryAttachment)t.getAttachment("territoryAttachment");
            if (ta == null) {
                return false;
            }
            return ta.getKingsExit();
        }

        public boolean isKingsSquare(Territory t) {
            TerritoryAttachment ta = (TerritoryAttachment)t.getAttachment("territoryAttachment");
            if (ta == null) {
                return false;
            }
            return ta.getKingsSquare();
        }

        public boolean eligibleParticipantInPawnCapture(PlayerID currentPlayer, Territory territory) {
            if (territory == null) {
                return false;
            }
            if (territory.getOwner().equals(currentPlayer)) {
                if (territory.getUnits().isEmpty()) {
                    return false;
                }
                return this.kingCanParticipateInCaptures || !this.kingInSquare(territory);
            }
            if (this.cornerSquaresCanBeUsedToCapturePawns && this.isKingsExit(territory)) {
                return true;
            }
            return this.centerSquareCanBeUsedToCapturePawns && this.isKingsSquare(territory);
        }

        public boolean eligibleParticipantInKingCapture(PlayerID currentPlayer, Territory territory) {
            if (territory == null) {
                return this.edgeOfBoardCanBeUsedToCaptureTheKing;
            }
            if (territory.getOwner().equals(currentPlayer)) {
                return territory.getUnits().size() > 0;
            }
            if (this.cornerSquaresCanBeUsedToCaptureTheKing && this.isKingsExit(territory)) {
                return true;
            }
            return this.centerSquareCanBeUsedToCaptureTheKing && this.isKingsSquare(territory);
        }

        public boolean eligibleParticipantsInKingCapture(PlayerID currentPlayer, Territory ... territories) {
            if (territories == null || territories.length == 0) {
                return false;
            }
            for (Territory territory : territories) {
                if (this.eligibleParticipantInKingCapture(currentPlayer, territory)) continue;
                return false;
            }
            return true;
        }

        public boolean eligibleForCapture(Territory territory, PlayerID currentPlayer) {
            return territory != null && !territory.getUnits().isEmpty() && !territory.getOwner().equals(currentPlayer);
        }
    }
}

