/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.kingstable.player;

import games.strategy.common.player.AbstractHumanPlayer;
import games.strategy.kingstable.delegate.remote.IPlayDelegate;
import games.strategy.kingstable.player.IKingsTablePlayer;
import games.strategy.kingstable.ui.KingsTableFrame;
import games.strategy.kingstable.ui.PlayData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KingsTablePlayer
extends AbstractHumanPlayer<KingsTableFrame>
implements IKingsTablePlayer {
    public KingsTablePlayer(String name, String type) {
        super(name, type);
    }

    @Override
    public void start(String stepName) {
        if (this.m_ui != null && ((KingsTableFrame)this.m_ui).isGameOver()) {
            return;
        }
        if (!stepName.endsWith("Play")) {
            throw new IllegalArgumentException("Unrecognized step stepName:" + stepName);
        }
        this.play();
    }

    private void play() {
        IPlayDelegate playDel = (IPlayDelegate)this.m_bridge.getRemote();
        PlayData play = null;
        while (play == null) {
            play = ((KingsTableFrame)this.m_ui).waitForPlay(this.m_id, this.m_bridge);
            if (play == null) {
                return;
            }
            String error = playDel.play(play.getStart(), play.getEnd());
            if (error == null) continue;
            ((KingsTableFrame)this.m_ui).notifyError(error);
            play = null;
        }
    }
}

