/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net;

import games.strategy.net.IConnectionLogin;
import games.strategy.net.SocketStreams;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Set;

class ClientLoginHelper {
    private final IConnectionLogin m_login;
    private final SocketStreams m_streams;
    private String m_clientName;

    public ClientLoginHelper(IConnectionLogin login, SocketStreams streams, String clientName) {
        this.m_login = login;
        this.m_streams = streams;
        this.m_clientName = clientName;
    }

    public boolean login() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(this.m_streams.getBufferedOut());
            out.writeObject(this.m_clientName);
            out.flush();
            ObjectInputStream in = new ObjectInputStream(this.m_streams.getBufferedIn());
            Map challenge = (Map)in.readObject();
            if (challenge == null) {
                out.writeObject(null);
                out.flush();
                return true;
            }
            Set entries = challenge.entrySet();
            for (Map.Entry entry : entries) {
                if (entry.getKey() instanceof String || entry.getValue() instanceof String) continue;
                throw new IllegalStateException("Value must be a String");
            }
            if (this.m_login == null) {
                throw new IllegalStateException("Challenged, but no login generator");
            }
            Map<String, String> props = this.m_login.getProperties(challenge);
            out.writeObject(props);
            out.flush();
            String response = (String)in.readObject();
            if (response == null) {
                this.m_clientName = (String)in.readObject();
                return true;
            }
            this.m_login.notifyFailedLogin(response);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getClientName() {
        return this.m_clientName;
    }
}

