/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net;

import games.strategy.engine.message.ChannelMessenger;
import games.strategy.engine.message.IChannelMessenger;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.engine.message.RemoteMessenger;
import games.strategy.engine.message.UnifiedMessenger;
import games.strategy.net.IMessenger;

public class Messengers {
    private final IMessenger m_messenger;
    private final IRemoteMessenger m_remoteMessenger;
    private final IChannelMessenger m_channelMessenger;

    public Messengers(IMessenger messenger) {
        this.m_messenger = messenger;
        UnifiedMessenger unifiedMessenger = new UnifiedMessenger(messenger);
        this.m_channelMessenger = new ChannelMessenger(unifiedMessenger);
        this.m_remoteMessenger = new RemoteMessenger(unifiedMessenger);
    }

    public Messengers(IMessenger messenger, IRemoteMessenger remoteMessenger, IChannelMessenger channelMessenger) {
        this.m_messenger = messenger;
        this.m_remoteMessenger = remoteMessenger;
        this.m_channelMessenger = channelMessenger;
    }

    public IChannelMessenger getChannelMessenger() {
        return this.m_channelMessenger;
    }

    public IMessenger getMessenger() {
        return this.m_messenger;
    }

    public IRemoteMessenger getRemoteMessenger() {
        return this.m_remoteMessenger;
    }
}

