/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.sound;

import games.strategy.engine.data.properties.IEditableProperty;
import games.strategy.sound.SoundPath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClipPlayer {
    private static ClipPlayer s_clipPlayer;
    private boolean m_beSilent = false;
    private final HashSet<String> m_mutedClips = new HashSet();
    private final HashMap<String, Clip> m_sounds = new HashMap();
    private static final String SOUND_PREFERENCE_GLOBAL_SWITCH = "beSilent2";
    private static final String SOUND_PREFERENCE_PREFIX = "sound_";

    public static synchronized ClipPlayer getInstance() {
        if (s_clipPlayer == null) {
            s_clipPlayer = new ClipPlayer();
            SoundPath.preLoadSounds(SoundPath.SoundType.GENERAL);
        }
        return s_clipPlayer;
    }

    private ClipPlayer() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        this.m_beSilent = prefs.getBoolean(SOUND_PREFERENCE_GLOBAL_SWITCH, false);
        HashSet<String> choices = SoundPath.getAllSoundOptions();
        choices.remove("slap.wav");
        boolean slapMuted = prefs.getBoolean("sound_slap.wav", false);
        if (slapMuted) {
            this.m_mutedClips.add("slap.wav");
        }
        for (String sound : choices) {
            boolean muted = prefs.getBoolean(SOUND_PREFERENCE_PREFIX + sound, true);
            if (!muted) continue;
            this.m_mutedClips.add(sound);
        }
    }

    public static void setBeSilent(boolean aBool) {
        ClipPlayer clipPlayer = ClipPlayer.getInstance();
        clipPlayer.m_beSilent = aBool;
        Preferences prefs = Preferences.userNodeForPackage(clipPlayer.getClass());
        prefs.putBoolean(SOUND_PREFERENCE_GLOBAL_SWITCH, clipPlayer.m_beSilent);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    public static boolean getBeSilent() {
        ClipPlayer clipPlayer = ClipPlayer.getInstance();
        return clipPlayer.m_beSilent;
    }

    private void putSoundInPreferences(String clip, boolean isMuted) {
        ClipPlayer clipPlayer = ClipPlayer.getInstance();
        Preferences prefs = Preferences.userNodeForPackage(clipPlayer.getClass());
        prefs.putBoolean(SOUND_PREFERENCE_PREFIX + clip, isMuted);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList<IEditableProperty> getSoundOptions(SoundPath.SoundType sounds) {
        return SoundPath.getSoundOptions(sounds);
    }

    public boolean isMuted(String clipName) {
        return this.m_mutedClips.contains(clipName);
    }

    public void setMute(String clipName, boolean value) {
        boolean isCurrentCorrect;
        boolean bl = isCurrentCorrect = this.m_mutedClips.contains(clipName) == value;
        if (isCurrentCorrect) {
            return;
        }
        if (value) {
            this.m_mutedClips.add(clipName);
        } else {
            this.m_mutedClips.remove(clipName);
        }
        this.putSoundInPreferences(clipName, value);
    }

    public static void play(String clipName) {
        ClipPlayer.getInstance().playClip(clipName);
    }

    private void playClip(String clipName) {
        Clip clip = this.loadClip(clipName);
        if (clip != null) {
            clip.setFramePosition(0);
            clip.loop(0);
        }
    }

    public void preLoadClip(String clipName) {
        this.loadClip(clipName);
    }

    private Clip loadClip(String clipName) {
        Clip clip;
        if (this.m_beSilent || this.isMuted(clipName)) {
            return null;
        }
        if (this.m_sounds.containsKey(clipName)) {
            clip = this.m_sounds.get(clipName);
        } else {
            clip = this.loadClip(new File(SoundPath.SOUNDS_DIRECTORY.getAbsolutePath().concat(File.separator + clipName)));
            this.m_sounds.put(clipName, clip);
        }
        return clip;
    }

    private synchronized Clip loadClip(File clipFile) {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(clipFile);
            AudioFormat format = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(audioInputStream);
            return clip;
        }
        catch (LineUnavailableException e) {
            e.printStackTrace(System.out);
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace(System.out);
        }
        catch (RuntimeException re) {
            re.printStackTrace(System.out);
        }
        return null;
    }
}

