/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.sound;

import games.strategy.engine.data.properties.IEditableProperty;
import games.strategy.engine.framework.ui.PropertiesSelector;
import games.strategy.sound.ClipPlayer;
import games.strategy.sound.SoundOptionCheckBox;
import games.strategy.sound.SoundPath;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public final class SoundOptions {
    final ClipPlayer m_clipPlayer;

    public static void addToMenu(final JMenu parentMenu) {
        JMenuItem soundOptions = new JMenuItem("Sound Options...");
        soundOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new SoundOptions(parentMenu);
            }
        });
        parentMenu.add(soundOptions);
    }

    public static void addToPanel(final JPanel parentPanel) {
        JButton soundOptions = new JButton("Sound Options...");
        soundOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new SoundOptions(parentPanel);
            }
        });
        parentPanel.add(soundOptions);
    }

    public SoundOptions(JComponent parent) {
        block4: {
            Object pressedButton;
            ArrayList<IEditableProperty> properties;
            block5: {
                block3: {
                    this.m_clipPlayer = ClipPlayer.getInstance();
                    String ok = "OK";
                    String cancel = "Cancel";
                    String selectAll = "All";
                    String selectNone = "None";
                    properties = this.m_clipPlayer.getSoundOptions(SoundPath.SoundType.TRIPLEA);
                    pressedButton = PropertiesSelector.getButton(parent, properties, "OK", "All", "None", "Cancel");
                    if (!pressedButton.equals("OK")) break block3;
                    for (IEditableProperty property : properties) {
                        this.m_clipPlayer.setMute(((SoundOptionCheckBox)property).getClipName(), (Boolean)property.getValue() == false);
                    }
                    break block4;
                }
                if (pressedButton.equals("Cancel")) break block4;
                if (!pressedButton.equals("All")) break block5;
                for (IEditableProperty property : properties) {
                    property.setValue(true);
                    this.m_clipPlayer.setMute(((SoundOptionCheckBox)property).getClipName(), false);
                }
                break block4;
            }
            if (!pressedButton.equals("None")) break block4;
            for (IEditableProperty property : properties) {
                property.setValue(false);
                this.m_clipPlayer.setMute(((SoundOptionCheckBox)property).getClipName(), true);
            }
        }
    }

    public static void addGlobalSoundSwitchMenu(JMenu parentMenu) {
        final JCheckBoxMenuItem soundCheckBox = new JCheckBoxMenuItem("Enable Sound");
        soundCheckBox.setSelected(!ClipPlayer.getBeSilent());
        soundCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClipPlayer.setBeSilent(!soundCheckBox.isSelected());
            }
        });
        parentMenu.add(soundCheckBox);
    }

    public static void addGlobalSoundSwitchCheckbox(JPanel parentPanel) {
        final JCheckBox soundCheckBox = new JCheckBox("Enable Sound");
        soundCheckBox.setSelected(!ClipPlayer.getBeSilent());
        soundCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClipPlayer.setBeSilent(!soundCheckBox.isSelected());
            }
        });
        parentPanel.add(soundCheckBox);
    }
}

