/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.sound;

import games.strategy.engine.data.properties.IEditableProperty;
import games.strategy.engine.framework.GameRunner;
import games.strategy.sound.ClipPlayer;
import games.strategy.sound.SoundOptionCheckBox;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoundPath {
    public static final File SOUNDS_DIRECTORY = new File(GameRunner.getRootFolder(), "/sounds");
    public static final String CLIP_MESSAGE = "message.wav";
    public static final String CLIP_SLAP = "slap.wav";
    public static final String CLIP_START_GAME = "start_game.wav";
    public static final String CLIP_START_YOUR_TURN = "start_your_turn.wav";
    public static final String CLIP_ACTION_REQUIRED = "action_required.wav";
    public static final String CLIP_BUTTON_CLICK = "button_click.wav";
    public static final String CLIP_PLOT_CLICK = "plot_click.wav";
    public static final String CLIP_BOMB = "strat_bomb.wav";
    public static final String CLIP_ROCKET = "rocket.wav";
    public static final String CLIP_TECH = "tech.wav";
    public static final String CLIP_NAVAL_BATTLE = "naval_battle.wav";
    public static final String CLIP_LAND_BATTLE = "terrain_battle.wav";
    public static final String CLIP_CAPTURE = "capture.wav";

    public static void preLoadSounds(SoundType sounds) {
        ClipPlayer clipPlayer = ClipPlayer.getInstance();
        switch (sounds) {
            case GENERAL: {
                clipPlayer.preLoadClip(CLIP_START_GAME);
                clipPlayer.preLoadClip(CLIP_MESSAGE);
                clipPlayer.preLoadClip(CLIP_SLAP);
                clipPlayer.preLoadClip(CLIP_START_YOUR_TURN);
                break;
            }
            case TRIPLEA: {
                clipPlayer.preLoadClip(CLIP_BOMB);
            }
        }
    }

    public static HashSet<String> getAllSoundOptions() {
        HashSet<String> rVal = new HashSet<String>();
        rVal.add(CLIP_START_GAME);
        rVal.add(CLIP_MESSAGE);
        rVal.add(CLIP_SLAP);
        rVal.add(CLIP_START_YOUR_TURN);
        rVal.add(CLIP_BOMB);
        return rVal;
    }

    public static ArrayList<IEditableProperty> getSoundOptions(SoundType sounds) {
        ArrayList<IEditableProperty> rVal = new ArrayList<IEditableProperty>();
        rVal.add(new SoundOptionCheckBox(CLIP_MESSAGE, "Messaging"));
        rVal.add(new SoundOptionCheckBox(CLIP_SLAP, "Slapping"));
        rVal.add(new SoundOptionCheckBox(CLIP_START_GAME, "Game Start"));
        rVal.add(new SoundOptionCheckBox(CLIP_START_YOUR_TURN, "Start Your Turn"));
        switch (sounds) {
            case TRIPLEA: {
                rVal.add(new SoundOptionCheckBox(CLIP_BOMB, "Strategic Bombing"));
            }
        }
        return rVal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SoundType {
        GENERAL,
        TRIPLEA;

    }
}

