/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.CommandCenter;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.ai.Dynamix_AI.DMatches;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.delegate.Matches;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedCalculationCenter {
    public static HashMap<Territory, List<Territory>> CachedMapTersFromPoints = new HashMap();
    public static HashMap<List<Territory>, Route> CachedRoutes = new HashMap();
    public static HashMap<List<Territory>, Route> CachedAirPassableRoutes = new HashMap();
    public static HashMap<List<Territory>, Route> CachedLandRoutes = new HashMap();
    public static HashMap<List<Territory>, Route> CachedPassableLandRoutes = new HashMap();
    public static HashMap<List<Territory>, Route> CachedSeaRoutes = new HashMap();

    public static List<Territory> GetMapTersFromPoint(Territory target) {
        Territory key = target;
        if (!CachedMapTersFromPoints.containsKey(key)) {
            CachedMapTersFromPoints.put(key, DUtils.GetTerritoriesWithinXDistanceOfY(target.getData(), target, Integer.MAX_VALUE));
        }
        return CachedMapTersFromPoints.get(key);
    }

    public static Route GetRoute(GameData data, Territory ter1, Territory ter2) {
        List key = DUtils.ToList(DUtils.ToArray(ter1, ter2));
        if (!CachedRoutes.containsKey(key)) {
            CachedRoutes.put(key, data.getMap().getRoute(ter1, ter2));
        }
        return CachedRoutes.get(key);
    }

    public static Route GetAirPassableRoute(GameData data, Territory ter1, Territory ter2) {
        List key = DUtils.ToList(DUtils.ToArray(ter1, ter2));
        if (!CachedAirPassableRoutes.containsKey(key)) {
            CachedAirPassableRoutes.put(key, data.getMap().getRoute(ter1, ter2, Matches.TerritoryIsNotImpassable));
        }
        return CachedAirPassableRoutes.get(key);
    }

    public static Route GetLandRoute(GameData data, Territory ter1, Territory ter2) {
        List key = DUtils.ToList(DUtils.ToArray(ter1, ter2));
        if (!CachedLandRoutes.containsKey(key)) {
            CachedLandRoutes.put(key, data.getMap().getLandRoute(ter1, ter2));
        }
        return CachedLandRoutes.get(key);
    }

    public static Route GetPassableLandRoute(GameData data, Territory ter1, Territory ter2) {
        List key = DUtils.ToList(DUtils.ToArray(ter1, ter2));
        if (!CachedPassableLandRoutes.containsKey(key)) {
            CachedPassableLandRoutes.put(key, data.getMap().getRoute(ter1, ter2, DMatches.TerritoryIsLandAndPassable));
        }
        return CachedPassableLandRoutes.get(key);
    }

    public static Route GetSeaRoute(GameData data, Territory ter1, Territory ter2) {
        List key = DUtils.ToList(DUtils.ToArray(ter1, ter2));
        if (!CachedSeaRoutes.containsKey(key)) {
            CachedSeaRoutes.put(key, data.getMap().getWaterRoute(ter1, ter2));
        }
        return CachedSeaRoutes.get(key);
    }
}

