/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.CommandCenter;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Others.PhaseType;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.util.IntegerMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class GlobalCenter {
    public static boolean IsPaused = false;
    public static final Object IsPaused_Object = new Object();
    public static PhaseType FirstDynamixPhase;
    public static PlayerID FirstDynamixPlayer;
    public static int GameRound;
    private static Resource PUResource;
    public static PlayerID CurrentPlayer;
    public static int MapTerCount;
    public static float MapTerCountScale;
    public static PhaseType CurrentPhaseType;
    public static boolean IsFFAGame;
    public static int FastestUnitMovement;
    public static int FastestLandUnitMovement;
    public static int HighestTerProduction;
    public static int PUsAtEndOfLastTurn;
    private static ProductionFrontier MergedAndAveragedProductionFronter;
    public static List<UnitType> AllMapUnitTypes;

    public static Resource GetPUResource() {
        return PUResource;
    }

    public static void Initialize(GameData data) {
        FirstDynamixPhase = PhaseType.Unknown;
        FirstDynamixPlayer = null;
        GameRound = 0;
        PUResource = null;
        CurrentPlayer = null;
        MapTerCount = 0;
        MapTerCountScale = 1.0f;
        CurrentPhaseType = PhaseType.Unknown;
        IsFFAGame = false;
        FastestUnitMovement = 0;
        FastestLandUnitMovement = 0;
        HighestTerProduction = -1;
        PUsAtEndOfLastTurn = 0;
        MergedAndAveragedProductionFronter = null;
        AllMapUnitTypes = null;
        PUResource = data.getResourceList().getResource("PUs");
        MapTerCount = data.getMap().getTerritories().size();
        MapTerCountScale = (float)data.getMap().getTerritories().size() / 75.0f;
        IsFFAGame = true;
        for (String alliance : data.getAllianceTracker().getAlliances()) {
            List playersInAlliance = DUtils.ToList(data.getAllianceTracker().getPlayersInAlliance(alliance));
            if (playersInAlliance.size() <= 1) continue;
            IsFFAGame = false;
            break;
        }
        HighestTerProduction = DUtils.GetHighestTerProduction(data);
        GlobalCenter.GenerateMergedAndAveragedProductionFrontier(data);
    }

    private static void GenerateMergedAndAveragedProductionFrontier(GameData data) {
        MergedAndAveragedProductionFronter = new ProductionFrontier("Merged and averaged global production frontier", data);
        AllMapUnitTypes = new ArrayList<UnitType>();
        HashMap<UnitType, Integer> purchaseCountsForUnit = new HashMap<UnitType, Integer>();
        HashMap differentCosts = new HashMap();
        for (PlayerID player : data.getPlayerList().getPlayers()) {
            if (player.getProductionFrontier() == null) continue;
            for (ProductionRule rule : player.getProductionFrontier()) {
                UnitType ut = (UnitType)rule.getResults().keySet().iterator().next();
                UnitAttachment ua = UnitAttachment.get(ut);
                DUtils.AddObjToListValueForKeyInMap(differentCosts, ut, rule.getCosts().getInt(PUResource));
                purchaseCountsForUnit.put(ut, rule.getResults().keySet().size());
                int movement = ua.getMovement(player);
                if (movement > FastestUnitMovement) {
                    FastestUnitMovement = movement;
                }
                if (movement > FastestLandUnitMovement && !ua.getIsSea() && !ua.getIsAir()) {
                    FastestLandUnitMovement = movement;
                }
                AllMapUnitTypes.add(ut);
            }
        }
        for (UnitType unitType : differentCosts.keySet()) {
            int totalCosts = 0;
            List costs = (List)differentCosts.get(unitType);
            Iterator i$ = costs.iterator();
            while (i$.hasNext()) {
                int cost = (Integer)i$.next();
                totalCosts += cost;
            }
            int averagedCost = (int)((float)totalCosts / (float)costs.size());
            IntegerMap<NamedAttachable> results = new IntegerMap<NamedAttachable>();
            results.put((NamedAttachable)unitType, (Integer)purchaseCountsForUnit.get(unitType));
            IntegerMap<Resource> cost = new IntegerMap<Resource>();
            cost.put(PUResource, averagedCost);
            ProductionRule rule = new ProductionRule("Averaged production rule for unit " + unitType.getName(), data, results, cost);
            MergedAndAveragedProductionFronter.addRule(rule);
        }
    }

    public static ProductionFrontier GetMergedAndAveragedProductionFrontier() {
        return MergedAndAveragedProductionFronter;
    }
}

