/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.CommandCenter;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.ai.Dynamix_AI.Others.TerritoryStatus;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusCenter {
    private static HashMap<PlayerID, StatusCenter> s_SCInstances = new HashMap();
    private GameData m_data = null;
    private PlayerID m_player = null;
    private final HashMap<String, TerritoryStatus> TerritoryStatuses = new HashMap();

    public static StatusCenter get(GameData data, PlayerID player) {
        if (!s_SCInstances.containsKey(player)) {
            s_SCInstances.put(player, StatusCenter.create(data, player));
        }
        return s_SCInstances.get(player);
    }

    private static StatusCenter create(GameData data, PlayerID player) {
        return new StatusCenter(data, player);
    }

    public static void ClearStaticInstances() {
        s_SCInstances.clear();
    }

    public static void NotifyStartOfRound() {
        s_SCInstances.clear();
    }

    public StatusCenter(GameData data, PlayerID player) {
        this.m_data = data;
        this.m_player = player;
    }

    public TerritoryStatus GetStatusOfTerritory(Territory ter) {
        return this.GetStatusOfTerritory(ter.getName());
    }

    public TerritoryStatus GetStatusOfTerritory(String terName) {
        if (!this.TerritoryStatuses.containsKey(terName)) {
            this.TerritoryStatuses.put(terName, new TerritoryStatus());
        }
        return this.TerritoryStatuses.get(terName);
    }

    public List<Territory> GetTerritoriesThatHaveStatusesMatching(GameData data, Match<TerritoryStatus> match) {
        ArrayList<Territory> result = new ArrayList<Territory>();
        for (String key : this.TerritoryStatuses.keySet()) {
            TerritoryStatus status = this.TerritoryStatuses.get(key);
            if (status == null || !match.match(status)) continue;
            result.add(data.getMap().getTerritory(key));
        }
        return result;
    }
}

