/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.CachedCalculationCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.FactoryCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.GlobalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.StrategyCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.TacticalCenter;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.ThreatInvalidationCenter;
import games.strategy.triplea.ai.Dynamix_AI.DConstants;
import games.strategy.triplea.ai.Dynamix_AI.DMatches;
import games.strategy.triplea.ai.Dynamix_AI.DOddsCalculator;
import games.strategy.triplea.ai.Dynamix_AI.DSettings;
import games.strategy.triplea.ai.Dynamix_AI.DSorting;
import games.strategy.triplea.ai.Dynamix_AI.Dynamix_AI;
import games.strategy.triplea.ai.Dynamix_AI.Group.PurchaseGroup;
import games.strategy.triplea.ai.Dynamix_AI.Group.UnitGroup;
import games.strategy.triplea.ai.Dynamix_AI.Others.CM_Task;
import games.strategy.triplea.ai.Dynamix_AI.Others.CM_TaskType;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_Call;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_CallType;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_Task;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_TaskType;
import games.strategy.triplea.ai.Dynamix_AI.Others.PhaseType;
import games.strategy.triplea.ai.Dynamix_AI.Others.StrategyType;
import games.strategy.triplea.ai.Dynamix_AI.UI.UI;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MustFightBattle;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.oddsCalculator.ta.AggregateResults;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.InverseMatch;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DUtils {
    public static float GetAttackScoreOfUnits(Collection<Unit> units) {
        float result = 0.0f;
        for (Unit unit : units) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            PlayerID owner = unit.getOwner();
            float unitAttack = 1.0f;
            unitAttack += (float)ua.getAttack(owner);
            if (ua.getIsTwoHit()) {
                unitAttack *= 2.0f;
            }
            if (ua.getAttackRolls(owner) > 1) {
                unitAttack *= (float)ua.getAttackRolls(owner);
            }
            result += unitAttack;
        }
        return result;
    }

    public static float GetDefenseScoreOfUnits(Collection<Unit> units) {
        float result = 0.0f;
        for (Unit unit : units) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            PlayerID owner = unit.getOwner();
            float unitDefense = 1.0f;
            unitDefense += (float)ua.getDefense(owner);
            if (ua.getIsTwoHit()) {
                unitDefense *= 2.0f;
            }
            result += unitDefense;
        }
        return result;
    }

    public static float GetValueOfUnits(Collection<Unit> units) {
        float result = 0.0f;
        for (Unit unit : units) {
            UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
            result += 1.0f;
            result += DUtils.GetAttackStrengthOfUnit(unit);
            result += DUtils.GetDefenseStrengthOfUnit(unit);
            if (!ua.getIsAir()) continue;
            result += 3.0f;
        }
        return result;
    }

    public static List<Territory> GetMapTersFromPoint(Territory target) {
        return CachedCalculationCenter.GetMapTersFromPoint(target);
    }

    public static List<Unit> GetUnitsOnMap(GameData data) {
        return DUtils.GetUnitsMatchingXInTerritoriesMatchingY(data, Match.ALWAYS_MATCH, Match.ALWAYS_MATCH);
    }

    public static List<Unit> GetUnitsMatchingXOnMap(GameData data, Match<Unit> unitMatch) {
        return DUtils.GetUnitsMatchingXInTerritoriesMatchingY(data, unitMatch, Match.ALWAYS_MATCH);
    }

    public static List<Unit> GetUnitsMatchingXInTerritoriesMatchingY(GameData data, Match<Unit> unitMatch, Match<Territory> terMatch) {
        return DUtils.GetUnitsMatchingXInTerritories(DUtils.GetTerritoriesMatching(data, terMatch), unitMatch);
    }

    public static List<Unit> GetUnitsInTerritories(List<Territory> territories) {
        return DUtils.GetUnitsMatchingXInTerritories(territories, Match.ALWAYS_MATCH);
    }

    public static List<Unit> GetUnitsMatchingXInTerritories(List<Territory> territories, Match<Unit> unitMatch) {
        ArrayList<Unit> result = new ArrayList<Unit>();
        for (Territory ter : territories) {
            result.addAll(ter.getUnits().getMatches(unitMatch));
        }
        return result;
    }

    public static List<Unit> GetUnitsInUGs(List<UnitGroup> ugs) {
        ArrayList<Unit> result = new ArrayList<Unit>();
        for (UnitGroup ug : ugs) {
            result.addAll(ug.GetUnits());
        }
        return result;
    }

    public static int GetTUVOfUnit(Unit unit, ProductionFrontier frontier, Resource resource) {
        int result = 0;
        for (ProductionRule rule : frontier.getRules()) {
            if (!((UnitType)rule.getResults().keySet().toArray()[0]).getName().equals(unit.getUnitType().getName())) continue;
            result += rule.getCosts().getInt(resource) / rule.getResults().keySet().size();
        }
        return result;
    }

    public static int GetTUVOfUnit(Unit unit, Resource resource) {
        if (unit.getOwner().isNull() || unit.getOwner().getProductionFrontier() == null) {
            return DUtils.GetTUVOfUnit(unit, GlobalCenter.GetMergedAndAveragedProductionFrontier(), resource);
        }
        return DUtils.GetTUVOfUnit(unit, unit.getOwner().getProductionFrontier(), resource);
    }

    public static int GetTUVOfUnits(Collection<Unit> units, ProductionFrontier frontier, Resource resource) {
        int result = 0;
        for (Unit unit : units) {
            result += DUtils.GetTUVOfUnit(unit, frontier, resource);
        }
        return result;
    }

    public static int GetTUVOfUnits(Collection<Unit> units, Resource resource) {
        int result = 0;
        for (Unit unit : units) {
            result += DUtils.GetTUVOfUnit(unit, resource);
        }
        return result;
    }

    public static float GetDefenseStrengthOfUnit(Unit unit) {
        return DUtils.GetDefenseScoreOfUnits(Collections.singleton(unit));
    }

    public static float GetAttackStrengthOfUnit(Unit unit) {
        return DUtils.GetAttackScoreOfUnits(Collections.singleton(unit));
    }

    public static AggregateResults GetBattleResults(Territory ter, PlayerID player, GameData data, int runCount, boolean toTake) {
        ArrayList<Unit> attacking = new ArrayList<Unit>();
        ArrayList<Unit> defending = new ArrayList<Unit>();
        for (Unit unit : ter.getUnits().getUnits()) {
            if (unit.getOwner().equals(player)) {
                attacking.add(unit);
                continue;
            }
            if (data.getRelationshipTracker().isAllied(player, unit.getOwner())) continue;
            defending.add(unit);
        }
        return DUtils.GetBattleResults(attacking, defending, ter, data, runCount, toTake);
    }

    public static List CombineCollections(Collection ... collections) {
        ArrayList result = new ArrayList();
        for (Collection collection : collections) {
            result.addAll(collection);
        }
        return result;
    }

    public static List CombineListsInCollections(Collection ... collections) {
        ArrayList result = new ArrayList();
        for (Collection collection : collections) {
            for (Object list : collection.toArray()) {
                result.addAll((Collection)list);
            }
        }
        return result;
    }

    public static float ToFloat(int percentage) {
        return (float)percentage / 100.0f;
    }

    public static List ToList(Collection collection) {
        return new ArrayList(collection);
    }

    public static List ToList(Object[] array) {
        return Arrays.asList(array);
    }

    public static Object[] ToArray(Object ... toSmashIntoArray) {
        return toSmashIntoArray;
    }

    public static void AddObjToListValueForKeyInMap(HashMap map, Object key, Object obj) {
        DUtils.AddObjectsToListValueForKeyInMap(map, key, Collections.singletonList(obj));
    }

    public static void AddObjectsToListValueForKeyInMap(HashMap map, Object key, List objs) {
        if (map.containsKey(key)) {
            List newList = (List)map.get(key);
            newList.addAll(objs);
            map.put(key, newList);
        } else {
            ArrayList newList = new ArrayList();
            newList.addAll(objs);
            map.put(key, newList);
        }
    }

    public static void AddObjectsToHashSetValueForKeyInMap(HashMap map, Object key, List objs) {
        if (map.containsKey(key)) {
            HashSet newList = (HashSet)map.get(key);
            newList.addAll(objs);
            map.put(key, newList);
        } else {
            HashSet newList = new HashSet();
            newList.addAll(objs);
            map.put(key, newList);
        }
    }

    public static int GetHPScoreOfUnits(List<Unit> units) {
        int result = 0;
        for (Unit unit : units) {
            ++result;
            if (!UnitAttachment.get(unit.getType()).getIsTwoHit()) continue;
            ++result;
        }
        return result;
    }

    public static int GetAttackStrengthOfUnits(List<Unit> units) {
        int result = 0;
        for (Unit unit : units) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            result += ua.getAttack(unit.getOwner()) * (ua.getIsTwoHit() ? 2 : 1);
        }
        return result;
    }

    public static int GetDefenseStrengthOfUnits(List<Unit> units) {
        int result = 0;
        for (Unit unit : units) {
            UnitAttachment ua = UnitAttachment.get(unit.getType());
            result += ua.getDefense(unit.getOwner()) * (ua.getIsTwoHit() ? 2 : 1);
        }
        return result;
    }

    public static boolean CanPlayerPlaceAnywhere(GameData data, PlayerID player) {
        RulesAttachment ra;
        return Properties.getPlaceInAnyTerritory(data) && (ra = (RulesAttachment)player.getAttachment("rulesAttatchment")) != null && ra.getPlacementAnyTerritory();
    }

    public static List<PlayerID> GetAliveEnemyPlayers(GameData data, PlayerID player) {
        ArrayList<PlayerID> result = new ArrayList<PlayerID>();
        for (PlayerID enemy : data.getPlayerList().getPlayers()) {
            if (data.getRelationshipTracker().isAllied(player, enemy) || TerritoryAttachment.getAllCurrentlyOwnedCapitals(enemy, data).size() <= 0) continue;
            result.add(enemy);
        }
        return result;
    }

    public static List<PlayerID> GetEnemyPlayers(GameData data, PlayerID us) {
        ArrayList<PlayerID> result = new ArrayList<PlayerID>();
        for (PlayerID player : data.getPlayerList().getPlayers()) {
            if (data.getRelationshipTracker().isAllied(us, player)) continue;
            result.add(player);
        }
        return result;
    }

    public static List<PlayerID> GetAlliedPlayersIncludingUs(GameData data, PlayerID us) {
        ArrayList<PlayerID> result = new ArrayList<PlayerID>();
        for (PlayerID player : data.getPlayerList().getPlayers()) {
            if (!data.getRelationshipTracker().isAllied(us, player)) continue;
            result.add(player);
        }
        return result;
    }

    public static List<Route> GetXClosestSimiliarLengthLandRoutesBetweenTers(GameData data, int maxNumberOfRoutes, Territory ter1, Territory ter2) {
        Route route;
        ArrayList<Route> result = new ArrayList<Route>();
        ArrayList<Territory> allRouteTers = new ArrayList<Territory>();
        int uniqueRoutesFound = 0;
        while (uniqueRoutesFound < maxNumberOfRoutes && (route = data.getMap().getRoute_IgnoreEnd(ter1, ter2, new CompositeMatchAnd<Territory>(Matches.territoryIsNotInList(allRouteTers), Matches.TerritoryIsLand))) != null && (result.isEmpty() || ((Route)result.get(0)).getLength() + 2 >= route.getLength() && ((Route)result.get(0)).getLength() - 2 <= route.getLength())) {
            result.add(route);
            ++uniqueRoutesFound;
            for (Territory ter : route.getTerritories()) {
                if (ter.getName().equals(route.getStart().getName()) || ter.getName().equals(route.getEnd().getName()) || allRouteTers.contains(ter)) continue;
                allRouteTers.add(ter);
            }
        }
        return result;
    }

    public static Unit GetRandomUnitForPlayerMatching(PlayerID player, Match<Unit> match) {
        ProductionFrontier frontier;
        if (player == null) {
            player = PlayerID.NULL_PLAYERID;
        }
        if ((frontier = player.getProductionFrontier()) == null) {
            frontier = GlobalCenter.GetMergedAndAveragedProductionFrontier();
        }
        ArrayList<ProductionRule> rules = new ArrayList<ProductionRule>(frontier.getRules());
        Collections.shuffle(rules);
        for (ProductionRule rule : rules) {
            Object[] unitTypes = rule.getResults().keySet().toArray();
            Unit unit = ((UnitType)DUtils.PickRandom(unitTypes)).create(player);
            if (!match.match(unit)) continue;
            return unit;
        }
        return null;
    }

    public static List<UnitType> GetAllPurchasableUnitTypesForPlayer(PlayerID player, Match<Unit> match) {
        ProductionFrontier frontier;
        ArrayList<UnitType> result = new ArrayList<UnitType>();
        if (player == null) {
            player = PlayerID.NULL_PLAYERID;
        }
        if ((frontier = player.getProductionFrontier()) == null) {
            frontier = GlobalCenter.GetMergedAndAveragedProductionFrontier();
        }
        ArrayList<ProductionRule> rules = new ArrayList<ProductionRule>(frontier.getRules());
        Collections.shuffle(rules);
        for (ProductionRule rule : rules) {
            Unit unit = ((UnitType)rule.getResults().keySet().toArray()[0]).create(player);
            if (!match.match(unit)) continue;
            result.add(unit.getUnitType());
        }
        return result;
    }

    public static List<Unit> CreateDefendUnitsTillTakeoverChanceIsLessThanX(Collection<Unit> attackers, Collection<Unit> alreadyDefending, GameData data, Territory testTer, float maxChance) {
        PlayerID defender = testTer.getOwner();
        if (alreadyDefending.size() > 0) {
            defender = alreadyDefending.iterator().next().getOwner();
        }
        ArrayList<Unit> result = new ArrayList<Unit>();
        AggregateResults lastResults = DUtils.GetBattleResults(attackers, result, testTer, data, 50, true);
        block0: while (lastResults.getAttackerWinPercent() > (double)maxChance) {
            for (UnitType ut : GlobalCenter.AllMapUnitTypes) {
                lastResults = DUtils.GetBattleResults(attackers, result, testTer, data, 1, true);
                result.add(ut.create(defender));
                if (!(lastResults.getAttackerWinPercent() <= (double)maxChance)) continue;
                continue block0;
            }
        }
        lastResults = DUtils.GetBattleResults(attackers, result, testTer, data, 50, true);
        block2: while (lastResults.getAttackerWinPercent() > (double)maxChance) {
            for (UnitType ut : GlobalCenter.AllMapUnitTypes) {
                lastResults = DUtils.GetBattleResults(attackers, result, testTer, data, 5, true);
                result.add(ut.create(defender));
                if (!(lastResults.getAttackerWinPercent() <= (double)maxChance)) continue;
                continue block2;
            }
        }
        return result;
    }

    public static List<Unit> MultiplyDefenderUnitsTillTakeoverChanceIsLessThanX(Collection<Unit> attackers, Collection<Unit> defenders, GameData data, Territory testTer, float maxChance) {
        if (Match.getMatches(defenders, new CompositeMatchAnd(Matches.UnitIsNotAA, Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1))).isEmpty()) {
            CompositeMatchAnd<Unit> randUnitMatch = testTer.isWater() ? new CompositeMatchAnd(DUtils.CompMatchOr(Matches.UnitIsSea, Matches.UnitIsAir)) : new CompositeMatchAnd<Unit>(Matches.UnitIsLand, Matches.UnitIsNotAA, Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1));
            Unit randUnit = DUtils.GetRandomUnitForPlayerMatching(testTer.getOwner(), randUnitMatch);
            if (randUnit == null) {
                return new ArrayList<Unit>();
            }
            defenders.add(randUnit);
        }
        PlayerID defender = testTer.getOwner();
        if (defenders.size() > 0) {
            defender = defenders.iterator().next().getOwner();
        }
        ArrayList<Unit> result = new ArrayList<Unit>();
        AggregateResults lastResults = DUtils.GetBattleResults(attackers, result, testTer, data, 50, true);
        block0: while (lastResults.getAttackerWinPercent() > (double)maxChance) {
            for (Unit unit : defenders) {
                lastResults = DUtils.GetBattleResults(attackers, result, testTer, data, 1, true);
                result.add(unit.getUnitType().create(defender));
                if (!(lastResults.getAttackerWinPercent() <= (double)maxChance)) continue;
                continue block0;
            }
        }
        lastResults = DUtils.GetBattleResults(attackers, result, testTer, data, 50, true);
        block2: while (lastResults.getAttackerWinPercent() > (double)maxChance) {
            for (Unit unit : defenders) {
                lastResults = DUtils.GetBattleResults(attackers, result, testTer, data, 5, true);
                result.add(unit.getUnitType().create(defender));
                if (!(lastResults.getAttackerWinPercent() <= (double)maxChance)) continue;
                continue block2;
            }
        }
        return result;
    }

    public static Territory GetRandomTerritoryMatchingXInList(Collection<Territory> ters, Match<Territory> match) {
        ArrayList<Territory> list = new ArrayList<Territory>();
        for (Territory ter : ters) {
            if (!match.match(ter)) continue;
            list.add(ter);
        }
        if (list.isEmpty()) {
            return null;
        }
        return (Territory)DUtils.PickRandom(list);
    }

    public static Object PickRandom(Collection list) {
        return DUtils.PickRandom(list.toArray());
    }

    public static Object PickRandom(Object[] array) {
        return array[new Random().nextInt(array.length)];
    }

    public static Match CompMatchAnd(Match ... matches) {
        return new CompositeMatchAnd(matches);
    }

    public static Match CompMatchOr(Match ... matches) {
        return new CompositeMatchOr(matches);
    }

    public static Match CompMatchAnd(List<Match> matches) {
        return new CompositeMatchAnd(matches);
    }

    public static Match CompMatchOr(List<Match> matches) {
        return new CompositeMatchOr(matches);
    }

    public static List<Territory> GetEnemyTersThatCanBeAttackedByUnitsOwnedBy(GameData data, PlayerID player) {
        return DUtils.GetTersMatchingXThatCanBeAttackedByUnitsMatchingYInTersMatchingZ(data, player, DUtils.CompMatchAnd(Matches.TerritoryIsPassableAndNotRestricted(player, data), DUtils.CompMatchOr(DMatches.territoryIsOwnedByEnemy(data, player), Matches.territoryHasUnitsThatMatch(DUtils.CompMatchAnd(Matches.unitIsEnemyOf(data, player), Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1))))), DMatches.territoryIsOwnedByEnemy(data, player).invert(), Matches.unitIsOwnedBy(player));
    }

    public static List<Territory> GetEnemyLandTersThatCanBeAttackedByLandUnitsOwnedBy(GameData data, PlayerID player) {
        return DUtils.GetTersMatchingXThatCanBeAttackedByUnitsMatchingYInTersMatchingZ(data, player, DUtils.CompMatchAnd(Matches.TerritoryIsLandOrWater, DMatches.territoryIsOwnedByEnemy(data, player)), DMatches.territoryIsOwnedByEnemy(data, player).invert(), Matches.unitIsLandAndOwnedBy(player));
    }

    public static List<Territory> GetEnemySeaTersThatCanBeAttackedByUnitsOwnedBy(GameData data, PlayerID player) {
        return DUtils.GetTersMatchingXThatCanBeAttackedByUnitsMatchingYInTersMatchingZ(data, player, DUtils.CompMatchAnd(Matches.TerritoryIsWater, Matches.territoryHasEnemyUnits(player, data)), DMatches.territoryIsOwnedByEnemy(data, player).invert(), Matches.unitIsOwnedBy(player));
    }

    public static List<Territory> GetTersMatchingXThatCanBeAttackedByUnitsMatchingYInTersMatchingZ(GameData data, PlayerID player, Match<Territory> terMatch, Match<Territory> attackFromTerMatch, Match<Unit> unitMatch) {
        ArrayList<Territory> result = new ArrayList<Territory>();
        for (Territory ter : data.getMap().getTerritories()) {
            List<Unit> possibleAttackers;
            if (!terMatch.match(ter) || (possibleAttackers = DUtils.GetUnitsMatchingXThatCanReach(data, ter, attackFromTerMatch, unitMatch)).size() <= 0) continue;
            result.add(ter);
        }
        return result;
    }

    public static List<Territory> GetEnemyLandTersThatCanBeAttackedByLandUnitsInList(GameData data, PlayerID player, List<Unit> units, Territory territory) {
        List<Territory> attackLocs = DUtils.GetTersThatUnitsCanReach(data, Match.getMatches(units, Matches.UnitIsLand), territory, player, new CompositeMatchAnd<Territory>(DMatches.territoryIsOwnedByNNEnemy(data, player), Matches.TerritoryIsLandOrWater));
        ArrayList<Territory> result = new ArrayList<Territory>();
        for (Territory ter : attackLocs) {
            if (data.getRelationshipTracker().isAllied(ter.getOwner(), player) || ter.isWater() || ter.getOwner().isNull()) continue;
            result.add(ter);
        }
        return result;
    }

    public static List<Territory> GetLandTersThatCanBeReinforcedByUnitsOwnedBy(GameData data, PlayerID player) {
        return DUtils.GetTersMatchingXThatCanBeReinforcedByUnitsMatchingYInTersMatchingZ(data, player, DMatches.territoryIsOwnedByXOrAlly(data, player), DMatches.territoryIsOwnedByXOrAlly(data, player), Matches.unitIsOwnedBy(player));
    }

    public static List<Territory> GetLandTersThatCanBeReinforcedByLandUnitsOwnedBy(GameData data, PlayerID player) {
        return DUtils.GetTersMatchingXThatCanBeReinforcedByUnitsMatchingYInTersMatchingZ(data, player, DMatches.territoryIsOwnedByXOrAlly(data, player), DMatches.territoryIsOwnedByXOrAlly(data, player), Matches.unitIsLandAndOwnedBy(player));
    }

    public static List<Territory> GetTersMatchingXThatCanBeReinforcedByUnitsMatchingYInTersMatchingZ(GameData data, PlayerID player, Match<Territory> terMatch, Match<Territory> moveFromTerMatch, Match<Unit> unitMatch) {
        ArrayList<Territory> result = new ArrayList<Territory>();
        for (Territory ter : data.getMap().getTerritories()) {
            List<Unit> possibleAttackers;
            if (!terMatch.match(ter) || (possibleAttackers = DUtils.GetUnitsMatchingXThatCanReach(data, ter, moveFromTerMatch, unitMatch)).size() <= 0) continue;
            result.add(ter);
        }
        return result;
    }

    public static int GetProduction_PlusExtra(Territory ter) {
        if (ter == null) {
            return 0;
        }
        GameData data = ter.getData();
        int result = TerritoryAttachment.get(ter).getProduction();
        if (DMatches.territoryIsCapitalAndOwnedByEnemy(data, GlobalCenter.CurrentPlayer).match(ter)) {
            int puGainIfWeConquer = 0;
            for (PlayerID enemy : data.getPlayerList().getPlayers()) {
                List<Territory> enemyCapList = DUtils.GetAllOurCaps_ThatWeOwn(data, enemy);
                if (enemyCapList.size() != 1 || !enemyCapList.get(0).equals(ter)) continue;
                puGainIfWeConquer += enemy.getResources().getQuantity(GlobalCenter.GetPUResource());
            }
            result += puGainIfWeConquer;
        }
        return result;
    }

    public static int GetCheckedUnitProduction(Territory ter) {
        if (ter.getOwner().getRepairFrontier() != null) {
            return TerritoryAttachment.get(ter).getUnitProduction();
        }
        return TerritoryAttachment.get(ter).getProduction();
    }

    public static List<Territory> SortTerritoriesByNNEnemyNeighbors_A(List<Territory> list, final GameData data, final PlayerID player) {
        return DSorting.SortListByX(list, new Comparator<Territory>(){

            @Override
            public int compare(Territory ter1, Territory ter2) {
                int val1 = DUtils.GetTersThatMatchXThatUnitsOnTerCanAttack(data, ter1, DMatches.territoryIsOwnedByNNEnemy(data, player), player).size();
                int val2 = DUtils.GetTersThatMatchXThatUnitsOnTerCanAttack(data, ter2, DMatches.territoryIsOwnedByNNEnemy(data, player), player).size();
                return val1 - val2;
            }
        });
    }

    public static List<Territory> GetTerritoriesInListThatAreNotInRoute(List<Territory> list, Route exludeRoute) {
        ArrayList<Territory> result = new ArrayList<Territory>();
        for (Territory ter : list) {
            if (exludeRoute.getTerritories().contains(ter)) continue;
            result.add(ter);
        }
        return result;
    }

    public static HashMap<Object, Object> ReverseHashMap(HashMap<Object, Object> map, GameData data, PlayerID player) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        ArrayList<Object> invertedKeys = new ArrayList<Object>();
        for (Object obj : map.keySet()) {
            invertedKeys.add(obj);
        }
        Collections.reverse(invertedKeys);
        for (Object obj : invertedKeys) {
            result.put(obj, map.get(obj));
        }
        return result;
    }

    public static int GetSlowestMovementUnitInList(Collection<Unit> list) {
        int lowestMovement = Integer.MAX_VALUE;
        for (Unit unit : list) {
            TripleAUnit tu = TripleAUnit.get(unit);
            if (tu.getMovementLeft() >= lowestMovement || TripleAUnit.get(unit).getTransportedBy() != null && list.contains(TripleAUnit.get(unit).getTransportedBy())) continue;
            lowestMovement = tu.getMovementLeft();
        }
        if (lowestMovement == Integer.MAX_VALUE) {
            return -1;
        }
        return lowestMovement;
    }

    public static int GetFastestMovementUnitInList(Collection<Unit> list) {
        int fastestMovement = Integer.MIN_VALUE;
        for (Unit unit : list) {
            TripleAUnit tu = TripleAUnit.get(unit);
            if (tu.getMovementLeft() <= fastestMovement) continue;
            fastestMovement = tu.getMovementLeft();
        }
        if (fastestMovement == Integer.MIN_VALUE) {
            return -1;
        }
        return fastestMovement;
    }

    public static Unit GetCheapestUnitInList(Collection<Unit> list) {
        int cheapest = Integer.MAX_VALUE;
        Unit cheapestUnit = null;
        for (Unit unit : list) {
            int cost = DUtils.GetTUVOfUnit(unit, GlobalCenter.GetPUResource());
            if (cost >= cheapest) continue;
            cheapest = cost;
            cheapestUnit = unit;
        }
        return cheapestUnit;
    }

    public static HashMap<Integer, List<Unit>> SeperateUnitsInListIntoSeperateMovementLists(List<Unit> list) {
        HashMap<Integer, List<Unit>> result = new HashMap<Integer, List<Unit>>();
        for (Unit unit : list) {
            List<Object> oldUnits;
            TripleAUnit ta = TripleAUnit.get(unit);
            int movement = ta.getMovementLeft();
            if (result.containsKey(movement)) {
                oldUnits = result.get(movement);
                oldUnits.add(unit);
                result.put(movement, oldUnits);
                continue;
            }
            oldUnits = new ArrayList<Unit>();
            oldUnits.add(unit);
            result.put(movement, oldUnits);
        }
        return result;
    }

    public static List<Territory> GetXClosestTersInList(GameData data, List<Territory> ters, Territory target, int count) {
        if (ters == null || ters.isEmpty()) {
            return new ArrayList<Territory>();
        }
        return DSorting.SortTerritoriesByLandThenNoCondDistance_A(ters, data, target).subList(0, count);
    }

    public static Territory GetClosestTerInList(GameData data, List<Territory> ters, Territory target) {
        List<Territory> xClosest = DUtils.GetXClosestTersInList(data, ters, target, 1);
        if (xClosest.isEmpty()) {
            return null;
        }
        return xClosest.get(0);
    }

    public static Territory GetClosestTerMatchingX(GameData data, Territory target, Match<Territory> match) {
        List<Territory> matching = DUtils.GetTerritoriesWithinXDistanceOfYMatchingZ(data, target, Integer.MAX_VALUE, match);
        if (matching.isEmpty()) {
            return null;
        }
        return matching.get(0);
    }

    public static Territory GetClosestTerMatchingXAndHavingRouteMatchingY(GameData data, Territory target, Match<Territory> match, Match<Territory> routeMatch) {
        List<Territory> matching = DUtils.GetTerritoriesWithinXDistanceOfYMatchingZAndHavingRouteMatchingA(data, target, Integer.MAX_VALUE, match, routeMatch);
        if (matching.isEmpty()) {
            return null;
        }
        return matching.get(0);
    }

    public static List<Territory> GetAllCapitals(GameData data) {
        return Match.getMatches(data.getMap().getTerritories(), DMatches.territoryIsCapital);
    }

    public static List<Territory> GetAllCapsOwnedBy(GameData data, PlayerID player) {
        return Match.getMatches(DUtils.GetAllCapitals(data), DMatches.territoryIsOwnedBy(player));
    }

    public static List<Territory> GetAllOurCaps(GameData data, PlayerID player) {
        return TerritoryAttachment.getAllCapitals(player, data);
    }

    public static List<Territory> GetAllOurCaps_ThatWeOwn(GameData data, PlayerID player) {
        return Match.getMatches(DUtils.GetAllOurCaps(data, player), Matches.isTerritoryOwnedBy(player));
    }

    public static Territory GetOurClosestCap(GameData data, PlayerID player, Territory ter) {
        return DUtils.GetClosestTerInList(data, DUtils.GetAllOurCaps(data, player), ter);
    }

    public static Territory GetOurClosestCap_ThatWeOwn(GameData data, PlayerID player, Territory ter) {
        return DUtils.GetClosestTerInList(data, DUtils.GetAllOurCaps_ThatWeOwn(data, player), ter);
    }

    public static List<Territory> GetAllCapsOwnedByEnemies(GameData data, PlayerID player) {
        return Match.getMatches(DUtils.GetAllCapitals(data), Matches.isTerritoryEnemy(player, data));
    }

    public static List<Territory> GetAllEnemyCaps(GameData data, PlayerID player) {
        ArrayList<Territory> result = new ArrayList<Territory>();
        for (PlayerID enemy : data.getPlayerList().getPlayers()) {
            if (data.getRelationshipTracker().isAllied(enemy, player)) continue;
            result.addAll(DUtils.GetAllOurCaps(data, enemy));
        }
        return result;
    }

    public static List<Territory> GetAllEnemyCaps_ThatAreOwnedByOriginalOwner(GameData data, PlayerID player) {
        ArrayList<Territory> result = new ArrayList<Territory>();
        for (PlayerID enemy : data.getPlayerList().getPlayers()) {
            if (data.getRelationshipTracker().isAllied(enemy, player)) continue;
            result.addAll(DUtils.GetAllOurCaps_ThatWeOwn(data, enemy));
        }
        return result;
    }

    public static List<Territory> GetTerritoriesMatching(GameData data, Match<Territory> match) {
        return Match.getMatches(data.getMap().getTerritories(), match);
    }

    public static Territory GetUnitLocation(GameData data, Unit unit) {
        for (Territory ter : data.getMap().getTerritories()) {
            if (!ter.getUnits().getUnits().contains(unit)) continue;
            return ter;
        }
        return null;
    }

    public static List<Territory> GetUnitLocations(GameData data, List<Unit> units) {
        ArrayList<Territory> result = new ArrayList<Territory>();
        block0: for (Territory ter : data.getMap().getTerritories()) {
            for (Unit unit : units) {
                if (!ter.getUnits().getUnits().contains(unit)) continue;
                result.add(ter);
                continue block0;
            }
        }
        return result;
    }

    public static boolean CanUnitReachTer(GameData data, Territory ter, Unit unit, Territory target) {
        return DUtils.CanUnitReachTer(data, ter, unit, target, new ArrayList<Territory>());
    }

    public static boolean CanUnitReachTer(GameData data, Territory ter, Unit unit, Territory target, List<Territory> passthroughTers) {
        PlayerID player = unit.getOwner();
        if (GlobalCenter.CurrentPhaseType == PhaseType.Combat_Move) {
            if (ter == target) {
                return true;
            }
            if (DMatches.territoryContainsMultipleAlliances(data).match(ter)) {
                return false;
            }
            if (TacticalCenter.get(data, GlobalCenter.CurrentPlayer).GetFrozenUnits().contains(unit)) {
                return false;
            }
            if (ThreatInvalidationCenter.get(data, GlobalCenter.CurrentPlayer).IsUnitInvalidatedForTer(unit, target)) {
                return false;
            }
        } else {
            if (ter == target) {
                return true;
            }
            if (TacticalCenter.get(data, GlobalCenter.CurrentPlayer).GetFrozenUnits().contains(unit)) {
                return false;
            }
            if (ThreatInvalidationCenter.get(data, GlobalCenter.CurrentPlayer).IsUnitInvalidatedForTer(unit, target)) {
                return false;
            }
        }
        UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
        TripleAUnit ta = TripleAUnit.get(unit);
        Route noCondRoute = CachedCalculationCenter.GetRoute(data, ter, target);
        if (noCondRoute == null) {
            return false;
        }
        if (noCondRoute.getLength() > ta.getMovementLeft()) {
            return false;
        }
        if (ter.equals(target)) {
            return true;
        }
        if (ua.getIsAir()) {
            Route route;
            if (DMatches.territoryIsOwnedByXOrAlly(data, player).match(target) ? (route = data.getMap().getRoute(ter, target, Matches.TerritoryIsNotImpassable)) != null && ta.getMovementLeft() >= route.getLength() : DUtils.CanAirUnitLandWithXSurvivalChanceIfAttackingFromXToY(data, ter, target, unit, DUtils.ToFloat(DSettings.LoadSettings().AA_survivalChanceOfLandingTerRequiredForPlaneRecruit))) {
                return true;
            }
        } else if (ua.getIsSea()) {
            Route route;
            if (ter.isWater() && (route = DUtils.GetAttackRouteFromXToY_BySea(data, player, ter, target)) != null && ta.getMovementLeft() >= route.getLength()) {
                return true;
            }
        } else if (ter.isWater()) {
            if (ua.getCanNotMoveDuringCombatMove() && GlobalCenter.CurrentPhaseType != PhaseType.Non_Combat_Move) {
                return false;
            }
            Route route = DUtils.GetAttackRouteFromXToY_ByLand_CountZAsPassthroughs(data, player, ter, target, passthroughTers);
            if (route != null && ta.getMovementLeft() >= route.getLength()) {
                return true;
            }
        } else {
            if (ua.getCanNotMoveDuringCombatMove() && GlobalCenter.CurrentPhaseType != PhaseType.Non_Combat_Move) {
                return false;
            }
            Route route = DUtils.GetAttackRouteFromXToY_ByLand_CountZAsPassthroughs(data, player, ter, target, passthroughTers);
            if (route != null && ta.getMovementLeft() >= route.getLength()) {
                return true;
            }
        }
        return false;
    }

    public static List<Unit> GetUnitsMatching(List<Unit> units, Match<Unit> match) {
        return Match.getMatches(units, match);
    }

    public static List<Territory> GetEnemyTerritoriesWithinXLandDistanceThatHaveEnemyUnitsThatCanAttack(Territory target, GameData data, PlayerID player, int maxJumpDist) {
        ArrayList<Territory> result = new ArrayList<Territory>();
        block0: for (Territory ter : data.getMap().getTerritories()) {
            Route noCondRoute;
            if (ter == target || data.getRelationshipTracker().isAllied(player, ter.getOwner())) continue;
            List<Unit> enemyUnits = ter.getUnits().getMatches(Matches.unitIsEnemyOf(data, player));
            int dist = DUtils.GetJumpsFromXToY_PassableLand(data, ter, target);
            if (dist < 1 || dist > maxJumpDist || (noCondRoute = CachedCalculationCenter.GetRoute(data, ter, target)) == null || noCondRoute.getLength() > GlobalCenter.FastestUnitMovement) continue;
            for (Unit u : enemyUnits) {
                if (!DUtils.CanUnitReachTer(data, ter, u, target)) continue;
                result.add(ter);
                continue block0;
            }
        }
        return result;
    }

    public static int GetHighestTerProduction(GameData data) {
        int result = 0;
        for (Territory ter : data.getMap().getTerritories()) {
            TerritoryAttachment ta;
            if (ter.isWater() || (ta = TerritoryAttachment.get(ter)) == null || ta.getProduction() <= result) continue;
            result = ta.getProduction();
        }
        return result;
    }

    public static float GetValueOfLandTer(Territory target, GameData data, PlayerID player) {
        float result = 1.0f;
        Territory ourCap = DUtils.GetOurClosestCap(data, player, target);
        int jumps = DUtils.GetJumpsFromXToY_PassableLand(data, target, ourCap);
        if (jumps == 1) {
            result += 90.0f;
        } else if (jumps == 2) {
            result += 40.0f;
        } else if (jumps == 3) {
            result += 10.0f;
        }
        List<Territory> enemyCaps = DUtils.GetAllEnemyCaps(data, player);
        if (enemyCaps.contains(target)) {
            result += 250.0f;
        }
        if (ourCap.getName().equals(target.getName())) {
            result += 500.0f;
        }
        if (target.getUnits().getMatches(Matches.UnitIsFactory).size() > 0) {
            result += 100.0f;
        }
        result += (float)(TerritoryAttachment.get(target).getProduction() * 10);
        result += (float)(data.getMap().getNeighbors(target, Matches.TerritoryIsLand).size() * 2);
        return result += (float)data.getMap().getNeighbors(target, DMatches.territoryIsOwnedByNNEnemy(data, player)).size();
    }

    public static HashMap<PlayerID, StrategyType> CalculateStrategyAssignments(GameData data, PlayerID player) {
        HashMap<PlayerID, StrategyType> result = new HashMap<PlayerID, StrategyType>();
        if (GlobalCenter.IsFFAGame) {
            ArrayList<Territory> ourTersConnectedToCap = new ArrayList<Territory>();
            List<Territory> ourCaps = DUtils.GetAllOurCaps(data, player);
            for (Territory cap : ourCaps) {
                ourTersConnectedToCap.addAll(DUtils.GetTerritoriesWithinXDistanceOfYMatchingZAndHavingRouteMatchingA(data, cap, Integer.MAX_VALUE, DMatches.territoryIsOwnedBy(player), DMatches.territoryIsOwnedBy(player)));
            }
            HashSet<PlayerID> enemiesTouchingOurCapConnectedTers = new HashSet<PlayerID>();
            for (Territory enemyTer : data.getMap().getTerritories()) {
                if (!DMatches.territoryIsOwnedByNNEnemy(data, player).match(enemyTer) || Match.getMatches(data.getMap().getNeighbors(enemyTer), DMatches.territoryIsInList(ourTersConnectedToCap)).isEmpty() || !DMatches.territoryHasRouteMatchingXToTerritoryMatchingY(data, DMatches.territoryIsOwnedBy(enemyTer.getOwner()), DUtils.CompMatchAnd(DMatches.territoryIsOwnedBy(enemyTer.getOwner()), DMatches.territoryIsInList(DUtils.GetAllOurCaps(data, enemyTer.getOwner())))).match(enemyTer)) continue;
                enemiesTouchingOurCapConnectedTers.add(enemyTer.getOwner());
            }
            PlayerID weakestEnemyNeighbor = null;
            int weakestEnemyTUV = Integer.MAX_VALUE;
            for (PlayerID enemy : enemiesTouchingOurCapConnectedTers) {
                int tuv = DUtils.GetTUVOfUnits(DUtils.GetUnitsMatchingXInTerritoriesMatchingY(data, Matches.unitIsOwnedBy(enemy), Matches.TerritoryIsLandOrWater), GlobalCenter.GetPUResource());
                if (tuv >= weakestEnemyTUV) continue;
                weakestEnemyNeighbor = enemy;
                weakestEnemyTUV = tuv;
            }
            if (weakestEnemyNeighbor != null) {
                result.put(weakestEnemyNeighbor, StrategyType.Enemy_Offensive);
            }
            for (PlayerID otherPlayer : data.getPlayerList()) {
                if (otherPlayer == player) continue;
                if (data.getRelationshipTracker().isAtWar(player, otherPlayer)) {
                    if (result.containsKey(otherPlayer)) continue;
                    result.put(otherPlayer, StrategyType.Enemy_Defensive);
                    continue;
                }
                result.put(otherPlayer, StrategyType.Ally_OffensiveAssist);
            }
        } else {
            ArrayList<Territory> ourTersConnectedToCap = new ArrayList<Territory>();
            List<Territory> ourCaps = DUtils.GetAllOurCaps(data, player);
            for (Territory cap : ourCaps) {
                ourTersConnectedToCap.addAll(DUtils.GetTerritoriesWithinXDistanceOfYMatchingZAndHavingRouteMatchingA(data, cap, Integer.MAX_VALUE, DMatches.territoryIsOwnedBy(player), DMatches.territoryIsOwnedBy(player)));
            }
            HashSet<PlayerID> enemiesTouchingOurCapConnectedTers = new HashSet<PlayerID>();
            for (Territory enemyTer : data.getMap().getTerritories()) {
                if (!DMatches.territoryIsOwnedByNNEnemy(data, player).match(enemyTer) || Match.getMatches(data.getMap().getNeighbors(enemyTer), DMatches.territoryIsInList(ourTersConnectedToCap)).isEmpty() || !DMatches.territoryHasRouteMatchingXToTerritoryMatchingY(data, DMatches.territoryIsOwnedBy(enemyTer.getOwner()), DUtils.CompMatchAnd(DMatches.territoryIsOwnedBy(enemyTer.getOwner()), DMatches.territoryIsInList(DUtils.GetAllOurCaps(data, enemyTer.getOwner())))).match(enemyTer)) continue;
                enemiesTouchingOurCapConnectedTers.add(enemyTer.getOwner());
            }
            PlayerID weakestEnemyNeighbor = null;
            int weakestEnemyTUV = Integer.MAX_VALUE;
            for (PlayerID enemy : enemiesTouchingOurCapConnectedTers) {
                int tuv = DUtils.GetTUVOfUnits(DUtils.GetUnitsMatchingXInTerritoriesMatchingY(data, Matches.unitIsOwnedBy(enemy), Matches.TerritoryIsLandOrWater), GlobalCenter.GetPUResource());
                if (tuv >= weakestEnemyTUV) continue;
                weakestEnemyNeighbor = enemy;
                weakestEnemyTUV = tuv;
            }
            if (weakestEnemyNeighbor != null) {
                result.put(weakestEnemyNeighbor, StrategyType.Enemy_Offensive);
            }
            for (PlayerID otherPlayer : data.getPlayerList()) {
                if (otherPlayer == player) continue;
                if (data.getRelationshipTracker().isAtWar(player, otherPlayer)) {
                    if (result.containsKey(otherPlayer)) continue;
                    result.put(otherPlayer, StrategyType.Enemy_Defensive);
                    continue;
                }
                result.put(otherPlayer, StrategyType.Ally_OffensiveAssist);
            }
        }
        DUtils.Log(Level.FINE, "    Calculated strategy assignments: {0}", result);
        return result;
    }

    public static float GetCMTaskPriority_LandGrab(GameData data, PlayerID player, Territory ter) {
        float priority = 1000000.0f;
        priority += DUtils.GetValueOfLandTer(ter, data, player);
        StrategyType strategyType = StrategyCenter.get(data, player).GetCalculatedStrategyAssignments().get(ter.getOwner());
        if (strategyType == StrategyType.Enemy_Offensive) {
            priority += 100.0f;
        }
        return priority;
    }

    public static float GetCMTaskPriority_Stabalization(GameData data, PlayerID player, Territory ter) {
        float priority = 100.0f;
        priority += DUtils.GetValueOfLandTer(ter, data, player);
        if (TerritoryAttachment.getAllCapitals(player, data).contains(ter)) {
            priority = 1000.0f;
        }
        return priority;
    }

    public static float GetCMTaskPriority_Offensive(GameData data, PlayerID player, Territory ter) {
        List<Territory> enemyCaps;
        float priority = 0.0f;
        Territory ourCap = DUtils.GetOurClosestCap(data, player, ter);
        priority += DUtils.GetValueOfLandTer(ter, data, player);
        Territory neighborWeAreInThatsClosestToOurCap = null;
        int closestToCapDist = Integer.MAX_VALUE;
        for (Territory neighbor : data.getMap().getNeighbors(ter, Matches.territoryHasUnitsOwnedBy(player))) {
            int dist;
            Route routeToCap = data.getMap().getLandRoute(neighbor, ourCap);
            if (routeToCap == null || (dist = routeToCap.getLength()) >= closestToCapDist) continue;
            neighborWeAreInThatsClosestToOurCap = neighbor;
            closestToCapDist = dist;
        }
        if (neighborWeAreInThatsClosestToOurCap != null) {
            Territory closestFactToOurTer;
            Territory closestEnemyCapForOurTer = DUtils.GetClosestTerInList(data, DUtils.GetAllCapsOwnedByEnemies(data, player), neighborWeAreInThatsClosestToOurCap);
            Territory closestEnemyCapForTarget = DUtils.GetClosestTerInList(data, DUtils.GetAllCapsOwnedByEnemies(data, player), ter);
            if (closestEnemyCapForOurTer != null && closestEnemyCapForTarget != null && closestEnemyCapForOurTer.getName().equals(closestEnemyCapForTarget.getName()) && DUtils.GetJumpsFromXToY_PassableLand(data, ter, closestEnemyCapForTarget) < DUtils.GetJumpsFromXToY_PassableLand(data, neighborWeAreInThatsClosestToOurCap, closestEnemyCapForTarget)) {
                priority += 6.0f;
            }
            if (DUtils.GetJumpsFromXToY_PassableLand(data, ter, closestFactToOurTer = DUtils.GetClosestTerMatchingXAndHavingRouteMatchingY(data, neighborWeAreInThatsClosestToOurCap, Matches.territoryHasUnitsThatMatch(new CompositeMatchAnd<Unit>(Matches.UnitIsFactory, Matches.unitIsEnemyOf(data, player))), Matches.TerritoryIsLand)) < DUtils.GetJumpsFromXToY_PassableLand(data, neighborWeAreInThatsClosestToOurCap, closestFactToOurTer)) {
                float productionPercentOfHighest = (float)TerritoryAttachment.get(closestFactToOurTer).getProduction() / (float)GlobalCenter.HighestTerProduction;
                priority += productionPercentOfHighest * 5.0f;
            }
        }
        if ((enemyCaps = DUtils.GetAllCapsOwnedByEnemies(data, player)).contains(ter)) {
            priority += 25.0f;
        }
        if (ter.getOwner().isNull()) {
            priority *= 0.75f;
        }
        int enemyNeighbors = data.getMap().getNeighbors(ter, DUtils.CompMatchAnd(Matches.TerritoryIsLand, DMatches.territoryIsOwnedByEnemy(data, player))).size();
        if (ter.getOwner().isNull()) {
            priority /= (float)(enemyNeighbors * 2);
        }
        int friendlyNeighbors = data.getMap().getNeighbors(ter, DUtils.CompMatchAnd(Matches.TerritoryIsLand, DMatches.territoryIsOwnedByXOrAlly(data, player))).size();
        priority += (float)friendlyNeighbors;
        StrategyType strategyType = StrategyCenter.get(data, player).GetCalculatedStrategyAssignments().get(ter.getOwner());
        if (strategyType == StrategyType.Enemy_Offensive) {
            priority += 100.0f;
        }
        return priority;
    }

    public static float GetCMTaskPriority_Trade(GameData data, PlayerID player, Territory ter) {
        float priority = 1000.0f;
        priority += DUtils.GetValueOfLandTer(ter, data, player);
        StrategyType strategyType = StrategyCenter.get(data, player).GetCalculatedStrategyAssignments().get(ter.getOwner());
        if (strategyType == StrategyType.Enemy_Offensive) {
            priority += 100.0f;
        }
        return priority;
    }

    public static float GetNCMTaskPriority_Block(GameData data, PlayerID player, Territory ter) {
        float priority = 1000.0f;
        return priority += DUtils.GetValueOfLandTer(ter, data, player);
    }

    public static float GetNCMTaskPriority_Frontline(GameData data, PlayerID player, Territory ter) {
        float priority = 500.0f;
        priority += DUtils.GetValueOfLandTer(ter, data, player);
        return priority += (float)(data.getMap().getNeighbors(ter, DMatches.territoryIsOwnedByNNEnemy(data, player)).size() * 5);
    }

    public static float GetNCMTaskPriority_Stabalize(GameData data, PlayerID player, Territory ter) {
        float priority = 750.0f;
        return priority += DUtils.GetValueOfLandTer(ter, data, player);
    }

    public static float GetNCMTaskPriority_ConflictedContinent(GameData data, PlayerID player, Territory ter) {
        float priority = -500.0f;
        return priority += DUtils.GetValueOfLandTer(ter, data, player) * 1000.0f;
    }

    public static float GetNCMCallPriority_ForLandGrab(GameData data, PlayerID player, Territory ter) {
        float priority = 1000.0f;
        return priority += DUtils.GetValueOfLandTer(ter, data, player);
    }

    public static float GetNCMCallPriority_ForDefensiveFront(GameData data, PlayerID player, Territory ter) {
        float priority = 1000000.0f;
        return priority += DUtils.GetValueOfLandTer(ter, data, player);
    }

    public static float GetNCMCallPriority_ForCapitalDefense(GameData data, PlayerID player, Territory ter) {
        float priority = 0.0f;
        return priority += DUtils.GetValueOfLandTer(ter, data, player);
    }

    public static int GetDistance_ForLandThenNoCondComparison(GameData data, Territory ter1, Territory ter2) {
        Route route1 = CachedCalculationCenter.GetLandRoute(data, ter1, ter2);
        Route route1_nc = CachedCalculationCenter.GetRoute(data, ter1, ter2);
        if (route1_nc == null) {
            return DConstants.Integer_HalfMax;
        }
        int distance1 = route1_nc.getLength() * 100;
        if (route1 != null) {
            distance1 = route1.getLength();
        }
        return distance1;
    }

    public static List<Unit> InterleaveUnits_ForBestAttack(List<Unit> units) {
        GameData data = units.get(0).getData();
        Territory battleTer = (Territory)data.getMap().getTerritories().toArray()[0];
        PlayerID player = GlobalCenter.CurrentPlayer;
        List<Unit> defendStack = DUtils.MultiplyDefenderUnitsTillTakeoverChanceIsLessThanX(units, Collections.singletonList(DUtils.GetRandomUnitForPlayerMatching(battleTer.getOwner(), DMatches.UnitCanDefend)), data, battleTer, 0.9f);
        ArrayList<Unit> leftToAdd = new ArrayList<Unit>(units);
        ArrayList<Unit> result = new ArrayList<Unit>();
        while (result.size() < units.size()) {
            Unit nextToAdd = DUtils.CalculateUnitThatWillHelpWinAttackOnArmyTheMostPerPU(battleTer, data, player, result, leftToAdd, defendStack, Match.ALWAYS_MATCH, DSettings.LoadSettings().CA_CMNCM_sortsPossibleTaskRecruitsForOptimalAttackDefense);
            result.add(nextToAdd);
            leftToAdd.remove(nextToAdd);
        }
        return result;
    }

    public static List<Unit> InterleaveUnits_SoWhileSortingYPercentOfUnitsMatchX(List<Unit> units, Match<Unit> match, float percentage) {
        ArrayList<Unit> result = new ArrayList<Unit>();
        double xToOthersRatio = 0.5;
        while (result.size() < units.size()) {
            double dif;
            Unit nextToAdd = null;
            if (xToOthersRatio < (double)percentage) {
                nextToAdd = DUtils.GetFirstUnitMatching(units, DUtils.CompMatchAnd(match, DMatches.unitIsNotInList(result)), 0);
            } else if (xToOthersRatio > (double)percentage) {
                nextToAdd = DUtils.GetFirstUnitMatching(units, DUtils.CompMatchAnd(match.invert(), DMatches.unitIsNotInList(result)), 0);
            }
            if (nextToAdd == null) {
                result.addAll(Match.getMatches(units, DMatches.unitIsNotInList(result)));
                break;
            }
            result.add(nextToAdd);
            if (match.match(nextToAdd)) {
                dif = 1.0 - xToOthersRatio;
                xToOthersRatio += dif / (double)result.size();
                continue;
            }
            dif = 0.0 - xToOthersRatio;
            xToOthersRatio += dif / (double)result.size();
        }
        return result;
    }

    public static List<Unit> InterleaveUnits_CarriersAndPlanes(List<Unit> units, int planesThatDontNeedToLand) {
        if (!Match.someMatch(units, Matches.UnitIsCarrier) || !Match.someMatch(units, Matches.UnitCanLandOnCarrier)) {
            return units;
        }
        ArrayList<Unit> result = new ArrayList<Unit>(units);
        Unit seekedCarrier = null;
        int indexToPlaceCarrierAt = -1;
        int spaceLeftOnSeekedCarrier = -1;
        int processedPlaneCount = 0;
        ArrayList<Unit> filledCarriers = new ArrayList<Unit>();
        for (int i = result.size() - 1; i >= 0; --i) {
            Unit unit = result.get(i);
            UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
            if (ua.getCarrierCost() <= 0) continue;
            if (processedPlaneCount < planesThatDontNeedToLand) {
                ++processedPlaneCount;
                continue;
            }
            if (seekedCarrier == null) {
                int seekedCarrierIndex = DUtils.GetIndexOfLastUnitMatching(result, DUtils.CompMatchAnd(Matches.UnitIsCarrier, DMatches.unitIsNotInList(filledCarriers)), result.size() - 1);
                if (seekedCarrierIndex == -1) break;
                seekedCarrier = units.get(seekedCarrierIndex);
                indexToPlaceCarrierAt = i + 1;
                spaceLeftOnSeekedCarrier = UnitAttachment.get(seekedCarrier.getUnitType()).getCarrierCapacity();
            }
            if ((spaceLeftOnSeekedCarrier -= ua.getCarrierCost()) > 0) continue;
            if (spaceLeftOnSeekedCarrier < 0) {
                ++i;
            }
            if (result.indexOf(seekedCarrier) < i) {
                result.remove(seekedCarrier);
                result.add(indexToPlaceCarrierAt - 1, seekedCarrier);
                --i;
                filledCarriers.add(seekedCarrier);
                seekedCarrier = DUtils.GetLastUnitMatching(result, DUtils.CompMatchAnd(Matches.UnitIsCarrier, DMatches.unitIsNotInList(filledCarriers)), result.size() - 1);
                if (seekedCarrier == null) break;
                indexToPlaceCarrierAt = i;
                spaceLeftOnSeekedCarrier = UnitAttachment.get(seekedCarrier.getUnitType()).getCarrierCapacity();
                continue;
            }
            int oldIndex = result.indexOf(seekedCarrier);
            int carrierPlaceLocation = indexToPlaceCarrierAt;
            result.remove(seekedCarrier);
            if (oldIndex < indexToPlaceCarrierAt) {
                --carrierPlaceLocation;
            }
            result.add(carrierPlaceLocation, seekedCarrier);
            filledCarriers.add(seekedCarrier);
            List<Unit> planesBetweenHereAndCarrier = new ArrayList();
            for (int i2 = i; i2 < carrierPlaceLocation; ++i2) {
                Unit unit2 = result.get(i2);
                UnitAttachment ua2 = UnitAttachment.get(unit2.getUnitType());
                if (ua2.getCarrierCost() <= 0) continue;
                planesBetweenHereAndCarrier.add(unit2);
            }
            planesBetweenHereAndCarrier = DUtils.InvertList(planesBetweenHereAndCarrier);
            int planeMoveCount = 0;
            for (Unit plane : planesBetweenHereAndCarrier) {
                result.remove(plane);
                result.add(carrierPlaceLocation - 1, plane);
                ++planeMoveCount;
            }
            seekedCarrier = DUtils.GetLastUnitMatching(result, DUtils.CompMatchAnd(Matches.UnitIsCarrier, DMatches.unitIsNotInList(filledCarriers)), result.size() - 1);
            if (seekedCarrier == null) break;
            indexToPlaceCarrierAt = carrierPlaceLocation - planeMoveCount;
            spaceLeftOnSeekedCarrier = UnitAttachment.get(seekedCarrier.getUnitType()).getCarrierCapacity();
        }
        return result;
    }

    public static List<Unit> InterleaveUnits_InfantryAndArtillery(List<Unit> units, int infantryPerArtillery, int infantryThatDontNeedArtillery) {
        if (!Match.someMatch(units, Matches.UnitIsArtillery) || !Match.someMatch(units, Matches.UnitIsArtillerySupportable)) {
            return units;
        }
        ArrayList<Unit> result = new ArrayList<Unit>(units);
        Unit seekedArtillery = null;
        int indexToPlaceArtAt = -1;
        int spaceLeftOnSeekedArt = -1;
        int processedInfantryCount = 0;
        ArrayList<Unit> filledArts = new ArrayList<Unit>();
        for (int i = result.size() - 1; i >= 0; --i) {
            Unit unit = result.get(i);
            UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
            if (!ua.getArtillerySupportable()) continue;
            if (processedInfantryCount < infantryThatDontNeedArtillery) {
                ++processedInfantryCount;
                continue;
            }
            if (seekedArtillery == null) {
                int seekedArtIndex = DUtils.GetIndexOfLastUnitMatching(result, DUtils.CompMatchAnd(Matches.UnitIsArtillery, DMatches.unitIsNotInList(filledArts)), result.size() - 1);
                if (seekedArtIndex == -1) break;
                seekedArtillery = units.get(seekedArtIndex);
                indexToPlaceArtAt = i + 1;
                spaceLeftOnSeekedArt = infantryPerArtillery;
            }
            if (--spaceLeftOnSeekedArt > 0) continue;
            if (spaceLeftOnSeekedArt < 0) {
                ++i;
            }
            if (result.indexOf(seekedArtillery) < i) {
                result.remove(seekedArtillery);
                result.add(indexToPlaceArtAt - 1, seekedArtillery);
                --i;
                filledArts.add(seekedArtillery);
                seekedArtillery = DUtils.GetLastUnitMatching(result, DUtils.CompMatchAnd(Matches.UnitIsArtillery, DMatches.unitIsNotInList(filledArts)), result.size() - 1);
                if (seekedArtillery == null) break;
                indexToPlaceArtAt = i;
                spaceLeftOnSeekedArt = infantryPerArtillery;
                continue;
            }
            int oldIndex = result.indexOf(seekedArtillery);
            int artPlaceLocation = indexToPlaceArtAt;
            result.remove(seekedArtillery);
            if (oldIndex < indexToPlaceArtAt) {
                --artPlaceLocation;
            }
            result.add(artPlaceLocation, seekedArtillery);
            filledArts.add(seekedArtillery);
            List<Unit> infantryBetweenHereAndArtillery = new ArrayList();
            for (int i2 = i; i2 < artPlaceLocation; ++i2) {
                Unit unit2 = result.get(i2);
                UnitAttachment ua2 = UnitAttachment.get(unit2.getUnitType());
                if (!ua2.getArtillerySupportable()) continue;
                infantryBetweenHereAndArtillery.add(unit2);
            }
            infantryBetweenHereAndArtillery = DUtils.InvertList(infantryBetweenHereAndArtillery);
            int infantryMoveCount = 0;
            for (Unit infantry : infantryBetweenHereAndArtillery) {
                result.remove(infantry);
                result.add(artPlaceLocation - 1, infantry);
                ++infantryMoveCount;
            }
            seekedArtillery = DUtils.GetLastUnitMatching(result, DUtils.CompMatchAnd(Matches.UnitIsArtillery, DMatches.unitIsNotInList(filledArts)), result.size() - 1);
            if (seekedArtillery == null) break;
            indexToPlaceArtAt = artPlaceLocation - infantryMoveCount;
            spaceLeftOnSeekedArt = infantryPerArtillery;
        }
        return result;
    }

    public static Unit GetLastUnitMatching(List<Unit> units, Match<Unit> match, int endIndex) {
        int index = DUtils.GetIndexOfLastUnitMatching(units, match, endIndex);
        if (index == -1) {
            return null;
        }
        return units.get(index);
    }

    public static int GetIndexOfLastUnitMatching(List<Unit> units, Match<Unit> match, int endIndex) {
        for (int i = endIndex; i >= 0; --i) {
            Unit unit = units.get(i);
            if (!match.match(unit)) continue;
            return i;
        }
        return -1;
    }

    public static Unit GetFirstUnitMatching(List<Unit> units, Match<Unit> match, int startIndex) {
        int index = DUtils.GetIndexOfFirstUnitMatching(units, match, startIndex);
        if (index == -1) {
            return null;
        }
        return units.get(index);
    }

    public static int GetIndexOfFirstUnitMatching(List<Unit> units, Match<Unit> match, int startIndex) {
        for (int i = startIndex; i < units.size(); ++i) {
            Unit unit = units.get(i);
            if (!match.match(unit)) continue;
            return i;
        }
        return -1;
    }

    public static int HowWellIsUnitSuitedToTask(GameData data, CM_Task task, Territory ter, Unit unit) {
        if (TacticalCenter.get(data, GlobalCenter.CurrentPlayer).GetFrozenUnits().contains(unit) && ter != task.GetTarget()) {
            return Integer.MIN_VALUE;
        }
        int result = 0;
        Route route = CachedCalculationCenter.GetRoute(data, ter, task.GetTarget());
        if (route == null) {
            return Integer.MIN_VALUE;
        }
        int dist = route.getLength();
        UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
        TripleAUnit ta = TripleAUnit.get(unit);
        int tuv = DUtils.GetTUVOfUnit(unit, GlobalCenter.GetPUResource());
        int movementSpeed = ua.getMovement(unit.getOwner());
        int movementLeft = ta.getMovementLeft();
        if (TacticalCenter.get(data, GlobalCenter.CurrentPlayer).GetFrozenUnits().contains(unit)) {
            movementLeft = 0;
        }
        if (task.GetTaskType() == CM_TaskType.Land_Attack_Offensive) {
            List<Territory> targets = DUtils.GetTersThatUnitsCanReach(data, Collections.singletonList(unit), ter, GlobalCenter.CurrentPlayer, DUtils.CompMatchAnd(Matches.TerritoryIsLand, DMatches.territoryIsOwnedByNNEnemy(data, GlobalCenter.CurrentPlayer)));
            result -= targets.size();
        } else if (task.GetTaskType() == CM_TaskType.Land_Attack_Stabilize) {
            List<Territory> targets = DUtils.GetTersThatUnitsCanReach(data, Collections.singletonList(unit), ter, GlobalCenter.CurrentPlayer, DUtils.CompMatchAnd(Matches.TerritoryIsLand, DMatches.territoryIsOwnedByNNEnemy(data, GlobalCenter.CurrentPlayer)));
            result -= targets.size();
        } else if (task.GetTaskType() == CM_TaskType.Land_LandGrab) {
            if (ua.getIsAir()) {
                return Integer.MIN_VALUE;
            }
            int movementAfterBlitz = movementLeft - dist;
            if (DSettings.LoadSettings().TR_attackLandGrab_onlyGrabLandIfWeCanBlitzIt && (!ua.getCanBlitz() || movementAfterBlitz < dist)) {
                return Integer.MIN_VALUE;
            }
            result += movementAfterBlitz * 10;
            result -= dist;
        } else if (task.GetTaskType() == CM_TaskType.Land_Attack_Trade) {
            // empty if block
        }
        return result;
    }

    public static int HowWellIsUnitSuitedToTask(GameData data, NCM_Task task, Territory ter, Unit unit) {
        if (TacticalCenter.get(data, GlobalCenter.CurrentPlayer).GetFrozenUnits().contains(unit) && ter != task.GetTarget()) {
            return Integer.MIN_VALUE;
        }
        int result = 0;
        Route route = CachedCalculationCenter.GetRoute(data, ter, task.GetTarget());
        if (route == null) {
            return Integer.MIN_VALUE;
        }
        int dist = route.getLength();
        UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
        TripleAUnit ta = TripleAUnit.get(unit);
        int tuv = DUtils.GetTUVOfUnit(unit, GlobalCenter.GetPUResource());
        int movementSpeed = ua.getMovement(unit.getOwner());
        int movementLeft = ta.getMovementLeft();
        if (TacticalCenter.get(data, GlobalCenter.CurrentPlayer).GetFrozenUnits().contains(unit)) {
            movementLeft = 0;
        }
        if (task.GetTaskType().equals((Object)NCM_TaskType.Land_Reinforce_Block)) {
            if (ua.getIsAir()) {
                return Integer.MIN_VALUE;
            }
            result -= tuv;
        } else if (task.GetTaskType().equals((Object)NCM_TaskType.Land_Reinforce_FrontLine)) {
            if (ua.getIsAir()) {
                return Integer.MIN_VALUE;
            }
            if (movementLeft == 0 && !ter.equals(task.GetTarget())) {
                return Integer.MIN_VALUE;
            }
            int turnsToGetThere = (int)Math.ceil((double)dist / (double)movementSpeed);
            result -= turnsToGetThere;
            if (Matches.UnitIsAAforAnything.match(unit) && task.GetTarget().getUnits().getMatches(Matches.UnitIsFactory).size() > 0 && task.GetTarget().getUnits().getMatches(Matches.UnitIsAAforAnything).isEmpty()) {
                result += 10;
            }
        } else if (task.GetTaskType().equals((Object)NCM_TaskType.Land_Reinforce_Stabilize)) {
            if (ua.getIsAir()) {
                return Integer.MIN_VALUE;
            }
            if (movementLeft == 0 && !ter.equals(task.GetTarget())) {
                return Integer.MIN_VALUE;
            }
            int turnsToGetThere = (int)Math.ceil((double)dist / (double)movementSpeed);
            result -= turnsToGetThere;
            if (Matches.UnitIsAAforAnything.match(unit) && task.GetTarget().getUnits().getMatches(Matches.UnitIsFactory).size() > 0 && task.GetTarget().getUnits().getMatches(Matches.UnitIsAAforAnything).isEmpty()) {
                result += 10;
            }
        }
        return result;
    }

    public static int HowWellIsUnitSuitedToCall(GameData data, NCM_Call call, Territory ter, Unit unit) {
        int result = 0;
        Route route = CachedCalculationCenter.GetRoute(data, ter, call.GetTarget());
        if (route == null) {
            return Integer.MIN_VALUE;
        }
        int dist = route.getLength();
        UnitAttachment ua = UnitAttachment.get(unit.getUnitType());
        TripleAUnit ta = TripleAUnit.get(unit);
        int tuv = DUtils.GetTUVOfUnit(unit, GlobalCenter.GetPUResource());
        int movementSpeed = ua.getMovement(unit.getOwner());
        int movementLeft = ta.getMovementLeft();
        if (TacticalCenter.get(data, GlobalCenter.CurrentPlayer).GetFrozenUnits().contains(unit)) {
            movementLeft = 0;
        }
        if (call.GetCallType().equals((Object)NCM_CallType.Land_ForDefensiveFront)) {
            if (ua.getIsAir()) {
                return Integer.MIN_VALUE;
            }
            int turnsToGetThere = (int)Math.ceil((double)dist / (double)movementSpeed);
            result -= turnsToGetThere;
        } else if (call.GetCallType().equals((Object)NCM_CallType.Land_ForLandGrab)) {
            if (ua.getIsAir()) {
                return Integer.MIN_VALUE;
            }
            int turnsToGetThere = (int)Math.ceil((double)dist / (double)movementSpeed);
            result -= turnsToGetThere;
        } else if (call.GetCallType().equals((Object)NCM_CallType.Land_ForCapitalDefense)) {
            if (ua.getIsAir()) {
                return Integer.MIN_VALUE;
            }
            int turnsToGetThere = (int)Math.ceil((double)dist / (double)movementSpeed);
            result -= turnsToGetThere;
        }
        return result;
    }

    public static HashMap ToHashMap(Collection keys, Collection values) {
        HashMap result = new HashMap();
        Iterator valueIter = values.iterator();
        for (Object key : keys) {
            result.put(key, valueIter.next());
        }
        return result;
    }

    public static IntegerMap ToIntegerMap(HashMap map) {
        IntegerMap result = new IntegerMap(map.size());
        for (Object key : map.keySet()) {
            result.add(key, Integer.parseInt(map.get(key).toString()));
        }
        return result;
    }

    public static TreeMap ToTreeMap_AutoSortingByValues_A(Map map) {
        TreeMap result = new TreeMap(new ValueComparator_A(map));
        result.putAll(map);
        return result;
    }

    public static TreeMap ToTreeMap_AutoSortingByValues_D(Map map) {
        TreeMap result = new TreeMap(new ValueComparator_D(map));
        result.putAll(map);
        return result;
    }

    public static List<Integer> GetTUVChangeOfAttackerAndDefender(List<Unit> initialAttackers, List<Unit> initialDefenders, AggregateResults results) {
        PlayerID attacker = null;
        if (!initialAttackers.isEmpty()) {
            attacker = initialAttackers.get(0).getOwner();
        }
        PlayerID defender = null;
        if (!initialDefenders.isEmpty()) {
            defender = initialDefenders.get(0).getOwner();
        }
        List<Unit> oldAttackerUnits = Match.getMatches(initialAttackers, DMatches.UnitCanAttack);
        List<Unit> oldDefenderUnits = Match.getMatches(initialDefenders, DMatches.UnitCanDefend);
        List<Unit> newAttackerUnits = Match.getMatches(results.GetAverageAttackingUnitsRemaining(), DMatches.UnitCanAttack);
        List<Unit> newDefenderUnits = Match.getMatches(results.GetAverageDefendingUnitsRemaining(), DMatches.UnitCanDefend);
        float oldAttackerTUV = DUtils.GetTUVOfUnits(oldAttackerUnits, GlobalCenter.GetPUResource());
        float oldDefenderTUV = DUtils.GetTUVOfUnits(oldDefenderUnits, GlobalCenter.GetPUResource());
        float newAttackerTUV = DUtils.GetTUVOfUnits(newAttackerUnits, GlobalCenter.GetPUResource());
        float newDefenderTUV = DUtils.GetTUVOfUnits(newDefenderUnits, GlobalCenter.GetPUResource());
        float attackerTUVGainOrLoss = newAttackerTUV - oldAttackerTUV;
        float defenderTUVGainOrLoss = newDefenderTUV - oldDefenderTUV;
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add((int)attackerTUVGainOrLoss);
        result.add((int)defenderTUVGainOrLoss);
        return result;
    }

    public static int GetTUVSwingForTUVChange(List<Integer> attackerAndDefenderTUVChanges) {
        return attackerAndDefenderTUVChanges.get(0) - attackerAndDefenderTUVChanges.get(1);
    }

    public static float GetSwingForBeforeAndAfterChange(List<Integer> beforeAndAfter) {
        return beforeAndAfter.get(1) - beforeAndAfter.get(0);
    }

    public static float GetSwingForBeforeAndAfterChange_F(List<Float> beforeAndAfter) {
        return beforeAndAfter.get(1).floatValue() - beforeAndAfter.get(0).floatValue();
    }

    public static List<Territory> GetTerritoriesWithinXLandJumpsOfTer(GameData data, Territory territory, int maxJumps, Match<Territory> resultTerMatch) {
        ArrayList<Territory> result = new ArrayList<Territory>();
        for (Territory ter : data.getMap().getTerritories()) {
            if (!DUtils.CanWeGetFromXToY_ByPassableLand(data, ter, territory) || DUtils.GetJumpsFromXToY_PassableLand(data, ter, territory) > maxJumps) continue;
            result.add(ter);
        }
        return result;
    }

    public static float GetVulnerabilityOfArmy(GameData data, PlayerID player, Territory ter, List<Unit> defendUnits, int calcRuns) {
        List<Unit> possibleAttackers = DUtils.GetSPNNEnemyUnitsThatCanReach(data, ter, player, Matches.TerritoryIsLandOrWater);
        possibleAttackers = Match.getMatches(possibleAttackers, new CompositeMatchOr(Matches.UnitIsLand, Matches.UnitIsAir));
        AggregateResults results = DUtils.GetBattleResults(possibleAttackers, defendUnits, ter, data, calcRuns, true);
        float result = (float)results.getAttackerWinPercent();
        return result;
    }

    public static float GetSurvivalChanceOfArmy(GameData data, PlayerID player, Territory ter, Collection<Unit> defendUnits, int calcRuns) {
        List<Unit> possibleAttackers = DUtils.GetSPNNEnemyUnitsThatCanReach(data, ter, player, Matches.TerritoryIsLandOrWater);
        possibleAttackers = Match.getMatches(possibleAttackers, new CompositeMatchOr(Matches.UnitIsLand, Matches.UnitIsAir));
        AggregateResults results = DUtils.GetBattleResults(possibleAttackers, defendUnits, ter, data, calcRuns, true);
        float result = (float)results.getDefenderWinPercent();
        return result;
    }

    public static float average(Float ... values) {
        float total = 0.0f;
        for (Float val : values) {
            total += val.floatValue();
        }
        return total / (float)values.length;
    }

    public static List<Territory> GetTerritoriesWithinXDistanceOfY(GameData data, Territory start, int maxDistance) {
        return DUtils.GetTerritoriesWithinXDistanceOfYMatchingZ(data, start, maxDistance, Match.ALWAYS_MATCH);
    }

    public static List<Territory> GetTerritoriesWithinXDistanceOfYMatchingZ(GameData data, Territory start, int maxDistance, Match<Territory> match) {
        return DUtils.GetTerritoriesWithinXDistanceOfYMatchingZAndHavingRouteMatchingA(data, start, maxDistance, match, Match.ALWAYS_MATCH);
    }

    public static List<Territory> GetTerritoriesWithinXDistanceOfYMatchingZAndHavingRouteMatchingA(GameData data, Territory start, int maxDistance, Match<Territory> match, Match<Territory> routeMatch) {
        HashSet<Territory> processed = new HashSet<Territory>();
        processed.add(start);
        ArrayList<Territory> result = new ArrayList<Territory>();
        HashSet<Territory> nextSet = new HashSet<Territory>(data.getMap().getNeighbors(start));
        if (match.match(start)) {
            result.add(start);
        }
        for (int dist = 1; nextSet.size() > 0 && dist <= maxDistance; ++dist) {
            HashSet newSet = new HashSet();
            for (Territory ter : nextSet) {
                processed.add(ter);
                if (routeMatch.match(ter)) {
                    List neighbors = DUtils.ToList(data.getMap().getNeighbors(ter));
                    newSet.addAll(neighbors);
                }
                if (!match.match(ter)) continue;
                result.add(ter);
            }
            newSet.removeAll(processed);
            nextSet = newSet;
        }
        return result;
    }

    public static List<Territory> GetEnemySeaTersThatCanBeAttackedBySeaOrAirUnitsOwnedBy(GameData data, PlayerID player) {
        ArrayList<Territory> result = new ArrayList<Territory>();
        for (Territory ter : data.getMap().getTerritories()) {
            if (!ter.isWater()) continue;
            List<Unit> possibleAttackers = DUtils.GetUnitsOwnedByPlayerThatCanReach(data, ter, player, Matches.TerritoryIsLandOrWater);
            if ((possibleAttackers = Match.getMatches(possibleAttackers, new CompositeMatchOr(Matches.UnitIsSea, Matches.UnitIsAir))).size() <= 0) continue;
            result.add(ter);
        }
        return result;
    }

    public static List CloneList(Collection list) {
        return new ArrayList(list);
    }

    public static UnitType GetRandomUnitType() {
        List<ProductionRule> rules = GlobalCenter.GetMergedAndAveragedProductionFrontier().getRules();
        return (UnitType)((ProductionRule)DUtils.PickRandom(rules)).getResults().keySet().iterator().next();
    }

    public static AggregateResults GetBattleResults(Collection<Unit> attacking, Collection<Unit> defending, Territory testingTer, GameData data, int runCount, boolean toTake) {
        if (attacking == null || attacking.isEmpty()) {
            if (defending == null || defending.isEmpty()) {
                if (toTake) {
                    return DUtils.CreateDefenderWinsAggregateResults(data, testingTer, defending);
                }
                return DUtils.CreateDrawAggregateResults(data, testingTer);
            }
            return DUtils.CreateDefenderWinsAggregateResults(data, testingTer, defending);
        }
        if (defending == null || defending.isEmpty()) {
            if (toTake && Match.getNMatches(attacking, 1, Matches.UnitIsLand).isEmpty()) {
                return DUtils.CreateDefenderWinsAggregateResults(data, testingTer, defending);
            }
            return DUtils.CreateAttackerWinsAggregateResults(data, testingTer, attacking);
        }
        PlayerID attacker = attacking.iterator().next().getOwner();
        PlayerID defender = defending.iterator().next().getOwner();
        if (runCount != 1) {
            float defenderUnitsStrength;
            float attackerUnitsStrength;
            if (DSettings.LoadSettings().AllowCalcingDecrease && Dynamix_AI.GetTimeTillNextScheduledActionDisplay() == 0L) {
                runCount = (int)DUtils.Limit((float)runCount * DUtils.ToFloat(DSettings.LoadSettings().CalcingDecreaseToPercentage), 1.0f, 2.1474836E9f);
            }
            if ((attackerUnitsStrength = DUtils.GetAttackScoreOfUnits(attacking)) > (defenderUnitsStrength = DUtils.GetDefenseScoreOfUnits(defending)) * 2.0f) {
                runCount = (int)DUtils.Limit((float)runCount / (attackerUnitsStrength / defenderUnitsStrength * 5.0f), 1.0f, 2.1474836E9f);
            } else if (defenderUnitsStrength > attackerUnitsStrength * 2.0f) {
                runCount = (int)DUtils.Limit((float)runCount / (defenderUnitsStrength / attackerUnitsStrength * 5.0f), 1.0f, 2.1474836E9f);
            }
            if (Properties.getLow_Luck(data)) {
                runCount = (int)DUtils.Limit((float)runCount / 5.0f, 10.0f, 2.1474836E9f);
            }
        }
        if (runCount <= 0) {
            throw new IllegalStateException("RunCount for calc can never be less than 1");
        }
        DOddsCalculator calc = new DOddsCalculator();
        calc.setKeepOneAttackingLandUnit(toTake);
        AggregateResults results = calc.calculate(data, attacker, defender, testingTer, attacking, defending, new ArrayList<Unit>(), runCount);
        if (toTake && (results == null || results.GetAverageAttackingUnitsRemaining() == null || Match.getNMatches(results.GetAverageAttackingUnitsRemaining(), 1, Matches.unitIsLandAndOwnedBy(attacker)).isEmpty())) {
            return DUtils.CreateDefenderWinsAggregateResults(data, testingTer, defending);
        }
        return results;
    }

    public static AggregateResults CreateAttackerWinsAggregateResults(GameData data, Territory ter, Collection<Unit> attacking) {
        MustFightBattle battle = new MustFightBattle(ter, PlayerID.NULL_PLAYERID, data, null);
        battle.setUnits(new ArrayList<Unit>(), attacking, new ArrayList<Unit>(), PlayerID.NULL_PLAYERID);
        BattleResults result = new BattleResults(battle, IBattle.WhoWon.ATTACKER);
        AggregateResults dWins = new AggregateResults(1);
        dWins.addResult(result);
        return dWins;
    }

    public static AggregateResults CreateDefenderWinsAggregateResults(GameData data, Territory ter, Collection<Unit> defending) {
        MustFightBattle battle = new MustFightBattle(ter, PlayerID.NULL_PLAYERID, data, null);
        battle.setUnits(defending, new ArrayList<Unit>(), new ArrayList<Unit>(), PlayerID.NULL_PLAYERID);
        BattleResults result = new BattleResults(battle, IBattle.WhoWon.DEFENDER);
        AggregateResults dWins = new AggregateResults(1);
        dWins.addResult(result);
        return dWins;
    }

    public static AggregateResults CreateDrawAggregateResults(GameData data, Territory ter) {
        MustFightBattle battle = new MustFightBattle(ter, PlayerID.NULL_PLAYERID, data, null);
        battle.setUnits(new ArrayList<Unit>(), new ArrayList<Unit>(), new ArrayList<Unit>(), PlayerID.NULL_PLAYERID);
        BattleResults result = new BattleResults(battle, IBattle.WhoWon.DRAW);
        AggregateResults dWins = new AggregateResults(1);
        dWins.addResult(result);
        return dWins;
    }

    public static List<Unit> getMoveableUnits(List<Unit> units) {
        ArrayList<Unit> values = new ArrayList<Unit>();
        for (Unit unit : units) {
            if (!Matches.unitHasMovementLeft.match(unit)) continue;
            values.add(unit);
        }
        return values;
    }

    public static int GetTaskTradeScore(GameData data, Territory target, List<Unit> attackers, List<Unit> defenders, AggregateResults simulatedAttack, List<Unit> responseAttackers, List<Unit> responseDefenders, AggregateResults simulatedResponse) {
        if (simulatedAttack.getAttackerWinPercent() < 0.5) {
            return DConstants.Integer_HalfMin;
        }
        List<Integer> tuvLosses = DUtils.GetTUVChangeOfAttackerAndDefender(attackers, defenders, simulatedAttack);
        int tuvSwing = DUtils.GetTUVSwingForTUVChange(tuvLosses);
        int responseTUVSwing = 0;
        if (simulatedResponse != null) {
            List<Integer> responseTUVLosses = DUtils.GetTUVChangeOfAttackerAndDefender(responseAttackers, responseDefenders, simulatedResponse);
            responseTUVSwing = DUtils.GetTUVSwingForTUVChange(responseTUVLosses);
        }
        int terProduction = DUtils.GetProduction_PlusExtra(target);
        if (Match.getMatches(simulatedAttack.GetAverageAttackingUnitsRemaining(), Matches.UnitIsLand).isEmpty()) {
            terProduction = 0;
        }
        int score = terProduction + tuvSwing;
        if (responseTUVSwing > 0) {
            score -= responseTUVSwing / 2;
        }
        return score;
    }

    public static List<UnitGroup> TrimRecruits_NonMovedOnes(List<UnitGroup> list, int toTrim) {
        int trimmed = 0;
        ArrayList<UnitGroup> result = new ArrayList<UnitGroup>();
        for (int i = list.size() - 1; i >= 0; --i) {
            UnitGroup ug = list.get(i);
            if (ug.GetMovedTo() != null || trimmed >= toTrim) {
                result.add(ug);
                continue;
            }
            ++trimmed;
        }
        return result;
    }

    public static Route TrimRoute_AtFirstTerWithEnemyUnits(Route route, int newRouteJumpCount, PlayerID player, GameData data) {
        return DUtils.TrimRoute_AtFirstTerMatchingX(route, newRouteJumpCount, player, data, Matches.territoryHasUnitsThatMatch(new CompositeMatchAnd<Unit>(Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1), Matches.unitIsEnemyOf(data, player))));
    }

    public static Route TrimRoute_AtFirstTerMatchingX(Route route, int newRouteJumpCount, PlayerID player, GameData data, Match<Territory> match) {
        ArrayList<Territory> newTers = new ArrayList<Territory>();
        int i = 0;
        for (Territory ter : route.getTerritories()) {
            newTers.add(ter);
            if ((!match.match(ter) || i == 0) && ++i <= newRouteJumpCount) continue;
            break;
        }
        return new Route(newTers);
    }

    public static Route TrimRoute_AtLastFriendlyTer(Route route, int newRouteJumpCount, PlayerID player, GameData data) {
        return DUtils.TrimRoute_BeforeFirstTerMatching(route, newRouteJumpCount, player, data, DMatches.territoryIsOwnedByEnemy(data, player));
    }

    public static Route TrimRoute_BeforeFirstTerMatching(Route route, int newRouteJumpCount, PlayerID player, GameData data, Match<Territory> match) {
        ArrayList<Territory> newTers = new ArrayList<Territory>();
        int i = 0;
        for (Territory ter : route.getTerritories()) {
            if (match.match(ter) && i != 0) break;
            newTers.add(ter);
            if (++i <= newRouteJumpCount) continue;
            break;
        }
        if (newTers.size() < 2) {
            return null;
        }
        return new Route(newTers);
    }

    public static Route TrimRoute_BeforeFirstTerWithEnemyUnits(Route route, int newRouteJumpCount, PlayerID player, GameData data) {
        return DUtils.TrimRoute_BeforeFirstTerMatching(route, newRouteJumpCount, player, data, Matches.territoryHasUnitsThatMatch(new CompositeMatchAnd<Unit>(Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1), Matches.unitIsEnemyOf(data, player))));
    }

    public static Route TrimRoute_ToLength(Route route, int newRouteJumpCount, PlayerID player, GameData data) {
        ArrayList<Territory> newTers = new ArrayList<Territory>();
        int i = 0;
        for (Territory ter : route.getTerritories()) {
            newTers.add(ter);
            if (++i <= newRouteJumpCount) continue;
            break;
        }
        if (newTers.size() < 2) {
            return null;
        }
        return new Route(newTers);
    }

    public static int GetJumpsFromXToY_NoCond(GameData data, Territory ter1, Territory ter2) {
        Route route = CachedCalculationCenter.GetRoute(data, ter1, ter2);
        if (route == null) {
            return Integer.MAX_VALUE;
        }
        return route.getLength();
    }

    public static int GetJumpsFromXToY_AirPassable(GameData data, Territory ter1, Territory ter2) {
        Route route = CachedCalculationCenter.GetAirPassableRoute(data, ter1, ter2);
        if (route == null) {
            return Integer.MAX_VALUE;
        }
        return route.getLength();
    }

    public static int GetJumpsFromXToY_Land(GameData data, Territory ter1, Territory ter2) {
        Route route = CachedCalculationCenter.GetLandRoute(data, ter1, ter2);
        if (route == null) {
            return DConstants.Integer_HalfMax;
        }
        if (ter1.getName().equals(ter2.getName()) || route.getLength() < 1) {
            return DConstants.Integer_HalfMax;
        }
        return route.getLength();
    }

    public static int GetJumpsFromXToY_PassableLand(GameData data, Territory ter1, Territory ter2) {
        Route route = CachedCalculationCenter.GetPassableLandRoute(data, ter1, ter2);
        if (route == null) {
            return DConstants.Integer_HalfMax;
        }
        if (ter1.getName().equals(ter2.getName()) || route.getLength() < 1) {
            return DConstants.Integer_HalfMax;
        }
        return route.getLength();
    }

    public static int GetJumpsFromXToY_Sea(GameData data, Territory ter1, Territory ter2) {
        Route route = CachedCalculationCenter.GetSeaRoute(data, ter1, ter2);
        if (route == null) {
            return DConstants.Integer_HalfMax;
        }
        if (ter1.getName().equals(ter2.getName()) || route.getLength() < 1) {
            return DConstants.Integer_HalfMax;
        }
        return route.getLength();
    }

    public static boolean CanWeGetFromXToY_ByLand(GameData data, Territory ter1, Territory ter2) {
        if (ter1 == null || ter2 == null) {
            return false;
        }
        return CachedCalculationCenter.GetLandRoute(data, ter1, ter2) != null;
    }

    public static boolean CanWeGetFromXToY_ByPassableLand(GameData data, Territory ter1, Territory ter2) {
        if (ter1 == null || ter2 == null) {
            return false;
        }
        return CachedCalculationCenter.GetPassableLandRoute(data, ter1, ter2) != null;
    }

    public static boolean CanWeGetFromXToY_BySea(GameData data, Territory ter1, Territory ter2) {
        if (ter1 == null || ter2 == null) {
            return false;
        }
        return CachedCalculationCenter.GetSeaRoute(data, ter1, ter2) != null;
    }

    public static boolean CanWeAttackFromXToY_ByLand(GameData data, PlayerID player, Territory ter1, Territory ter2) {
        return DUtils.GetAttackRouteFromXToY_ByLand(data, player, ter1, ter2) != null;
    }

    public static Route GetAttackRouteFromXToY_ByLand(GameData data, PlayerID player, Territory ter1, Territory ter2) {
        if (ter2.isWater()) {
            return null;
        }
        if (ter1 == null || ter2 == null) {
            return null;
        }
        return data.getMap().getRoute_IgnoreEnd(ter1, ter2, new CompositeMatchAnd<Territory>(Matches.TerritoryIsLand, Matches.TerritoryIsNotImpassable, new InverseMatch<Territory>(Matches.territoryHasUnitsThatMatch(new CompositeMatchAnd<Unit>(Matches.unitIsEnemyOf(data, player), Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1))))));
    }

    public static Route GetAttackRouteFromXToY_ByLand_CountZAsPassthroughs(GameData data, PlayerID player, Territory ter1, Territory ter2, List<Territory> passthroughTers) {
        if (ter2.isWater()) {
            return null;
        }
        if (ter1 == null || ter2 == null) {
            return null;
        }
        ArrayList<Match> matches = new ArrayList<Match>();
        matches.add(new CompositeMatchAnd(Matches.TerritoryIsLand, Matches.TerritoryIsNotImpassable, new InverseMatch<Territory>(Matches.territoryHasUnitsThatMatch(new CompositeMatchAnd<Unit>(Matches.unitIsEnemyOf(data, player), Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1))))));
        for (Territory ter : passthroughTers) {
            matches.add(Matches.territoryIs(ter));
        }
        return data.getMap().getRoute_IgnoreEnd(ter1, ter2, DUtils.CompMatchOr(matches));
    }

    public static Route GetAttackRouteFromXToY_BySea(GameData data, PlayerID player, Territory ter1, Territory ter2) {
        if (!ter2.isWater()) {
            return null;
        }
        if (ter1 == null || ter2 == null) {
            return null;
        }
        return data.getMap().getRoute_IgnoreEnd(ter1, ter2, new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, new InverseMatch<Territory>(Matches.territoryHasUnitsThatMatch(new CompositeMatchAnd<Unit>(Matches.unitIsEnemyOf(data, player), Matches.unitHasDefenseThatIsMoreThanOrEqualTo(1))))));
    }

    public static Route GetNCMRouteFromXToY_ByLand(GameData data, PlayerID player, Territory ter1, Territory ter2) {
        if (ter2.isWater()) {
            return null;
        }
        if (ter1 == null || ter2 == null) {
            return null;
        }
        return data.getMap().getRoute_IgnoreEnd(ter1, ter2, new CompositeMatchAnd<Territory>(Matches.TerritoryIsLand, Matches.TerritoryIsNotImpassable, DMatches.territoryIsOwnedByXOrAlly(data, player)));
    }

    public static boolean HasNeighborsThatMatch(GameMap map, Territory ter, Match<Territory> match) {
        return Match.someMatch(map.getNeighbors(ter), match);
    }

    public static int GetTotalProductionOfTerritoriesInList(List<Territory> territories) {
        int result = 0;
        for (Territory ter : territories) {
            TerritoryAttachment ta = TerritoryAttachment.get(ter);
            if (ta == null) continue;
            result += ta.getProduction();
        }
        return result;
    }

    public static List<Unit> GetUnitsMatchingXThatCanReach(GameData data, Territory target, Match<Territory> terMatch, Match<Unit> unitMatch) {
        return DUtils.GetNUnitsMatchingXThatCanReach(data, target, terMatch, unitMatch, Integer.MAX_VALUE);
    }

    public static List<Unit> GetUnitsMatchingXThatCanReach_CountYAsPassthroughs(GameData data, Territory target, Match<Territory> terMatch, Match<Unit> unitMatch, List<Territory> passthroughTers) {
        return DUtils.GetNUnitsMatchingXThatCanReach_CountYAsPassthroughs(data, target, terMatch, unitMatch, passthroughTers, Integer.MAX_VALUE);
    }

    public static List<Unit> GetNUnitsMatchingXThatCanReach(GameData data, Territory target, Match<Territory> terMatch, Match<Unit> unitMatch, int maxResults) {
        return DUtils.GetNUnitsMatchingXThatCanReach_CountYAsPassthroughs(data, target, terMatch, unitMatch, new ArrayList<Territory>(), maxResults);
    }

    public static List<Unit> GetNUnitsMatchingXThatCanReach_CountYAsPassthroughs(GameData data, Territory target, Match<Territory> terMatch, Match<Unit> unitMatch, List<Territory> passthroughTers, int maxResults) {
        ArrayList<Unit> result = new ArrayList<Unit>();
        for (Territory ter : DUtils.GetMapTersFromPoint(target)) {
            if (CachedCalculationCenter.GetRoute(data, ter, target).getLength() > GlobalCenter.FastestUnitMovement) break;
            if (!terMatch.match(ter)) continue;
            List<Unit> matchingUnits = Match.getMatches(DUtils.ToList(ter.getUnits().getUnits()), unitMatch);
            for (Unit unit : matchingUnits) {
                if (!DUtils.CanUnitReachTer(data, ter, unit, target, passthroughTers)) continue;
                result.add(unit);
                if (result.size() < maxResults) continue;
                return result;
            }
        }
        return result;
    }

    public static HashMap<Territory, List<Unit>> GetUnitsMatchingXThatCanReach_Mapped(GameData data, Territory target, Match<Territory> terMatch, Match<Unit> unitMatch) {
        return DUtils.GetUnitsMatchingXThatCanReach_Mapped_CountYAsPassthroughs(data, target, terMatch, unitMatch, new ArrayList<Territory>());
    }

    public static HashMap<Territory, List<Unit>> GetUnitsMatchingXThatCanReach_Mapped_CountYAsPassthroughs(GameData data, Territory target, Match<Territory> terMatch, Match<Unit> unitMatch, List<Territory> passthroughTers) {
        HashMap<Territory, List<Unit>> result = new HashMap<Territory, List<Unit>>();
        for (Territory ter : DUtils.GetMapTersFromPoint(target)) {
            if (CachedCalculationCenter.GetRoute(data, ter, target).getLength() > GlobalCenter.FastestUnitMovement) break;
            if (!terMatch.match(ter)) continue;
            List<Unit> matchingUnits = Match.getMatches(DUtils.ToList(ter.getUnits().getUnits()), unitMatch);
            for (Unit unit : matchingUnits) {
                if (!DUtils.CanUnitReachTer(data, ter, unit, target, passthroughTers)) continue;
                DUtils.AddObjToListValueForKeyInMap(result, ter, unit);
            }
        }
        return result;
    }

    public static List<Unit> GetUnitsOwnedByPlayerThatCanReach(GameData data, Territory target, PlayerID playerToCheckFor, Match<Territory> terMatch) {
        return DUtils.GetUnitsMatchingXThatCanReach(data, target, terMatch, Matches.unitIsOwnedBy(playerToCheckFor));
    }

    public static HashMap<Territory, List<Unit>> GetSPNNEnemyUnitsThatCanReach_Mapped(GameData data, Territory territory, PlayerID playerToCheckFor, Match<Territory> terSearchMatch) {
        HashMap<Territory, List<Unit>> result = DUtils.GetNNEnemyUnitsThatCanReach_Mapped(data, territory, playerToCheckFor, terSearchMatch);
        return DUtils.GetTheUnitsOfTheStrongestPlayerContainedInMap_Mapped(result);
    }

    public static List<Unit> GetNNEnemyUnitsThatCanReach(GameData data, Territory target, PlayerID player, Match<Territory> terMatch) {
        return DUtils.GetNNEnemyUnitsThatCanReach_CountXAsPassthroughs(data, target, player, terMatch, new ArrayList<Territory>());
    }

    public static List<Unit> GetNNNEnemyUnitsThatCanReach(GameData data, Territory target, PlayerID player, Match<Territory> terMatch, int maxResults) {
        return DUtils.GetNNNEnemyUnitsThatCanReach_CountXAsPassthroughs(data, target, player, terMatch, new ArrayList<Territory>(), maxResults);
    }

    public static HashMap<Territory, List<Unit>> GetNNEnemyUnitsThatCanReach_Mapped(GameData data, Territory target, PlayerID player, Match<Territory> terMatch) {
        return DUtils.GetUnitsMatchingXThatCanReach_Mapped(data, target, terMatch, DMatches.unitIsNNEnemyOf(data, player));
    }

    public static List<Unit> GetNNEnemyUnitsThatCanReach_CountXAsPassthroughs(GameData data, Territory target, PlayerID player, Match<Territory> terMatch, List<Territory> passthroughTers) {
        return DUtils.GetNNNEnemyUnitsThatCanReach_CountXAsPassthroughs(data, target, player, terMatch, passthroughTers, Integer.MAX_VALUE);
    }

    public static List<Unit> GetNNNEnemyUnitsThatCanReach_CountXAsPassthroughs(GameData data, Territory target, PlayerID player, Match<Territory> terMatch, List<Territory> passthroughTers, int maxResults) {
        return DUtils.GetNUnitsMatchingXThatCanReach_CountYAsPassthroughs(data, target, terMatch, DMatches.unitIsNNEnemyOf(data, player), passthroughTers, maxResults);
    }

    public static List<Unit> GetNNEnemyLUnitsThatCanReach(GameData data, Territory target, PlayerID player, Match<Territory> terMatch) {
        return DUtils.GetNNNEnemyLUnitsThatCanReach(data, target, player, terMatch, Integer.MAX_VALUE);
    }

    public static List<Unit> GetNNNEnemyLUnitsThatCanReach(GameData data, Territory target, PlayerID player, Match<Territory> terMatch, int maxResults) {
        return DUtils.GetNUnitsMatchingXThatCanReach(data, target, terMatch, DUtils.CompMatchAnd(Matches.UnitIsLand, DMatches.unitIsNNEnemyOf(data, player)), maxResults);
    }

    public static List<Unit> GetSPUnitsMatchingXThatCanReach(GameData data, Territory territory, PlayerID playerToCheckFor, Match<Territory> terSearchMatch, Match<Unit> unitMatch) {
        List<Unit> result = DUtils.GetUnitsMatchingXThatCanReach(data, territory, terSearchMatch, unitMatch);
        return DUtils.GetSPUnitsInList(result);
    }

    public static List<Unit> GetSPNNEnemyUnitsThatCanReach(GameData data, Territory territory, PlayerID playerToCheckFor, Match<Territory> terMatch) {
        List<Unit> result = DUtils.GetNNEnemyUnitsThatCanReach(data, territory, playerToCheckFor, terMatch);
        return DUtils.GetSPUnitsInList(result);
    }

    public static List<Unit> GetSPNNEnemyUnitsThatCanReach_CountXAsPassthroughs(GameData data, Territory target, PlayerID player, Match<Territory> terMatch, List<Territory> passthroughTers) {
        List<Unit> result = DUtils.GetNNEnemyUnitsThatCanReach_CountXAsPassthroughs(data, target, player, terMatch, passthroughTers);
        return DUtils.GetSPUnitsInList(result);
    }

    public static List<Unit> GetSPNNEnemyWithLUnitsThatCanReach(GameData data, Territory target, PlayerID playerToCheckFor, Match<Territory> terMatch) {
        List<Unit> result = DUtils.GetNNEnemyUnitsThatCanReach(data, target, playerToCheckFor, terMatch);
        return DUtils.GetTheUnitsOfTheStrongestPlayerWithLUContainedInList(result);
    }

    public static List<Unit> GetSPNNEnemyWithLUnitsThatCanReach_CountXAsPassthrough(GameData data, Territory target, PlayerID player, Match<Territory> terMatch, Territory passthroughTer) {
        return DUtils.GetSPNNEnemyWithLUnitsThatCanReach_CountXAsPassthroughs(data, target, player, terMatch, Collections.singletonList(passthroughTer));
    }

    public static List<Unit> GetSPNNEnemyWithLUnitsThatCanReach_CountXAsPassthroughs(GameData data, Territory territory, PlayerID playerToCheckFor, Match<Territory> terSearchMatch, List<Territory> passthroughTers) {
        List<Unit> result = DUtils.GetNNEnemyUnitsThatCanReach_CountXAsPassthroughs(data, territory, playerToCheckFor, terSearchMatch, passthroughTers);
        return DUtils.GetTheUnitsOfTheStrongestPlayerWithLUContainedInList(result);
    }

    public static List<Unit> GetSPNNEnemyBasedOnLUnitsOnlyThatCanReach(GameData data, Territory territory, PlayerID playerToCheckFor, Match<Territory> terSearchMatch) {
        List<Unit> result = DUtils.GetNNEnemyLUnitsThatCanReach(data, territory, playerToCheckFor, terSearchMatch);
        return DUtils.GetTheUnitsOfTheStrongestPlayerWithLUContainedInList(result);
    }

    public static List<Unit> GetSPUnitsInList(List<Unit> unitsToSearch) {
        HashMap attackersUnits = new HashMap();
        List<Unit> highestAttackerUnits = new ArrayList<Unit>();
        for (Unit u : unitsToSearch) {
            List<Unit> newList;
            if (!attackersUnits.containsKey(u.getOwner().getName())) {
                newList = new ArrayList<Unit>();
                newList.add(u);
                attackersUnits.put(u.getOwner().getName(), newList);
                continue;
            }
            newList = (List)attackersUnits.get(u.getOwner().getName());
            newList.add(u);
            attackersUnits.put(u.getOwner().getName(), newList);
        }
        float highestAttackerUStrength = -2.1474836E9f;
        for (String key : attackersUnits.keySet()) {
            List units = (List)attackersUnits.get(key);
            float strength = DUtils.GetAttackScoreOfUnits(units);
            if (!(strength > highestAttackerUStrength)) continue;
            highestAttackerUStrength = strength;
            highestAttackerUnits = units;
        }
        return highestAttackerUnits;
    }

    public static List<Unit> GetTheUnitsOfTheStrongestPlayerWithLUContainedInList(List<Unit> unitsToSearch) {
        HashMap attackersUnits = new HashMap();
        List<Unit> highestAttackerUnits = new ArrayList<Unit>();
        for (Unit u : unitsToSearch) {
            List<Unit> newList;
            if (!attackersUnits.containsKey(u.getOwner().getName())) {
                newList = new ArrayList<Unit>();
                newList.add(u);
                attackersUnits.put(u.getOwner().getName(), newList);
                continue;
            }
            newList = (List)attackersUnits.get(u.getOwner().getName());
            newList.add(u);
            attackersUnits.put(u.getOwner().getName(), newList);
        }
        float highestAttackerUStrength = -2.1474836E9f;
        for (String key : attackersUnits.keySet()) {
            float strength;
            List units = (List)attackersUnits.get(key);
            boolean foundLand = Match.someMatch(units, Matches.UnitIsLand);
            if (!foundLand || !((strength = DUtils.GetAttackScoreOfUnits(units)) > highestAttackerUStrength)) continue;
            highestAttackerUStrength = strength;
            highestAttackerUnits = units;
        }
        return highestAttackerUnits;
    }

    public static HashMap<Territory, List<Unit>> GetTheUnitsOfTheStrongestPlayerContainedInMap_Mapped(HashMap<Territory, List<Unit>> unitsToSearch) {
        HashMap attackersUnits = new HashMap();
        for (Territory ter : unitsToSearch.keySet()) {
            for (Unit unit : unitsToSearch.get(ter)) {
                DUtils.AddObjToListValueForKeyInMap(attackersUnits, unit.getOwner().getName(), unit);
            }
        }
        HashSet highestAttackerUnits = new HashSet();
        float highestAttackerUStrength = -2.1474836E9f;
        for (String key : attackersUnits.keySet()) {
            List units = (List)attackersUnits.get(key);
            float strength = DUtils.GetAttackScoreOfUnits(units);
            if (!(strength > highestAttackerUStrength)) continue;
            highestAttackerUStrength = strength;
            highestAttackerUnits = DUtils.ToHashSet(units);
        }
        HashMap<Territory, List<Unit>> highestAttackerUnits_Mapped = new HashMap<Territory, List<Unit>>();
        for (Territory ter : unitsToSearch.keySet()) {
            for (Unit terUnit : unitsToSearch.get(ter)) {
                if (!highestAttackerUnits.contains(terUnit)) continue;
                DUtils.AddObjToListValueForKeyInMap(highestAttackerUnits_Mapped, ter, terUnit);
            }
        }
        return highestAttackerUnits_Mapped;
    }

    public static boolean CanAirUnitLandWithXSurvivalChanceIfAttackingFromXToY(GameData data, Territory from, Territory to, Unit airUnit, float survivalChance) {
        TripleAUnit ta = TripleAUnit.get(airUnit);
        int jumpDist = DUtils.GetJumpsFromXToY_AirPassable(data, from, to);
        int movementAfterAttack = ta.getMovementLeft() - jumpDist;
        for (Territory ter : data.getMap().getTerritories()) {
            int dist;
            if (!data.getRelationshipTracker().isAllied(ter.getOwner(), airUnit.getOwner()) || (dist = DUtils.GetJumpsFromXToY_AirPassable(data, ter, to)) > movementAfterAttack) continue;
            if (survivalChance != 0.0f) {
                List<Unit> attackers = DUtils.GetSPNNEnemyBasedOnLUnitsOnlyThatCanReach(data, ter, airUnit.getOwner(), Matches.TerritoryIsLandOrWater);
                List<Unit> defenders = DUtils.ToList(ter.getUnits().getUnits());
                if (data.getRelationshipTracker().isAtWar(airUnit.getOwner(), GlobalCenter.CurrentPlayer)) {
                    List<Territory> neighbors = DUtils.GetTerritoriesWithinXDistanceOfY(data, ter, 1);
                    defenders = DUtils.GetUnitsMatchingXInTerritories(neighbors, Matches.unitIsLandAndOwnedBy(airUnit.getOwner()));
                }
                defenders.remove(airUnit);
                defenders.add(airUnit);
                AggregateResults results = DUtils.GetBattleResults(attackers, defenders, ter, data, 1, false);
                if (!(results.getDefenderWinPercent() >= (double)survivalChance)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static int CountLandUnits(List<Unit> units) {
        int result = 0;
        for (Unit u : units) {
            UnitAttachment ua = UnitAttachment.get(u.getUnitType());
            if (ua.getIsSea() || ua.getIsAir()) continue;
            ++result;
        }
        return result;
    }

    public static HashSet ToHashSet(Collection collection) {
        HashSet result = new HashSet();
        for (Object obj : collection) {
            result.add(obj);
        }
        return result;
    }

    public static List InvertList(Collection list) {
        ArrayList result = new ArrayList(list);
        Collections.reverse(result);
        return result;
    }

    public static List ShuffleList(Collection list) {
        ArrayList result = new ArrayList(list);
        Collections.shuffle(result);
        return result;
    }

    public static List GetXPercentOfTheItemsInList(Collection list, float percentageToKeep) {
        if (percentageToKeep == 1.0f) {
            return new ArrayList(list);
        }
        if (percentageToKeep == 0.0f) {
            return new ArrayList();
        }
        ArrayList result = new ArrayList();
        for (Object obj : list) {
            if (!(Math.random() < (double)percentageToKeep)) continue;
            result.add(obj);
        }
        return result;
    }

    public static List<Unit> GetXPercentOfTheUnitsInList_CreateMoreIfNeeded(Collection<Unit> units, float percentageToResultIn) {
        if (percentageToResultIn == 1.0f) {
            return new ArrayList<Unit>(units);
        }
        if (percentageToResultIn == 0.0f) {
            return new ArrayList<Unit>();
        }
        ArrayList<Unit> result = new ArrayList<Unit>();
        while (percentageToResultIn > 1.0f) {
            for (Unit unit : units) {
                result.add(unit.getUnitType().create(unit.getOwner()));
            }
            percentageToResultIn -= 1.0f;
        }
        for (Unit unit : units) {
            if (!(Math.random() < (double)percentageToResultIn)) continue;
            result.add(unit.getUnitType().create(unit.getOwner()));
        }
        return result;
    }

    public static List<Unit> RecreateXPercentOfTheUnitsInList_CreateMoreIfNeeded(Collection<Unit> units, float percentageToResultIn) {
        if (percentageToResultIn == 1.0f) {
            return new ArrayList<Unit>(units);
        }
        if (percentageToResultIn == 0.0f) {
            return new ArrayList<Unit>();
        }
        ArrayList<Unit> result = new ArrayList<Unit>();
        while (percentageToResultIn > 1.0f) {
            for (Unit unit : units) {
                result.add(unit.getUnitType().create(unit.getOwner()));
            }
            percentageToResultIn -= 1.0f;
        }
        for (Unit unit : units) {
            if (!(Math.random() < (double)percentageToResultIn)) continue;
            result.add(unit.getUnitType().create(unit.getOwner()));
        }
        return result;
    }

    public static List<Unit> ToUnitList(Collection<UnitGroup> ugs) {
        ArrayList<Unit> result = new ArrayList<Unit>();
        for (UnitGroup ug : ugs) {
            result.addAll(ug.GetUnits());
        }
        return result;
    }

    public static String UnitGroupList_ToString(Collection<UnitGroup> ugs) {
        List<Unit> units = DUtils.ToUnitList(ugs);
        return DUtils.UnitList_ToString(units);
    }

    public static String UnitList_ToString(Collection<Unit> units) {
        if (units.isEmpty()) {
            return "(Empty)";
        }
        if (units.size() == 1) {
            return units.iterator().next().toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        HashMap unitsByOwner = new HashMap();
        for (Unit unit : units) {
            DUtils.AddObjToListValueForKeyInMap(unitsByOwner, unit.getOwner().getName(), unit);
        }
        for (String owner : unitsByOwner.keySet()) {
            int unitGroups = 0;
            String lastUnitType = null;
            int lastUnitTypeCount = 0;
            for (Unit unit : (List)unitsByOwner.get(owner)) {
                if (lastUnitType == null) {
                    unitGroups = 1;
                    lastUnitType = unit.getUnitType().getName();
                    lastUnitTypeCount = 1;
                    continue;
                }
                if (unit.getUnitType().getName().equals(lastUnitType)) {
                    ++lastUnitTypeCount;
                    continue;
                }
                if (unitGroups != 1) {
                    builder.append(", ");
                }
                if (lastUnitTypeCount == 1) {
                    builder.append(lastUnitType);
                } else {
                    builder.append(lastUnitTypeCount).append(" ").append(MyFormatter.pluralize(lastUnitType));
                }
                lastUnitType = unit.getUnitType().getName();
                lastUnitTypeCount = 1;
                ++unitGroups;
            }
            if (unitGroups > 1) {
                builder.append(", and ");
            }
            if (lastUnitTypeCount == 1) {
                builder.append(lastUnitType).append(" owned by ").append(owner);
                continue;
            }
            builder.append(lastUnitTypeCount).append(" ").append(MyFormatter.pluralize(lastUnitType)).append(" owned by ").append(owner);
        }
        builder.append("]");
        return builder.toString();
    }

    public static List<Unit> DetermineResponseAttackers(GameData data, PlayerID player, Territory battleTer, AggregateResults results) {
        List<Unit> responseAttackers = DUtils.GetSPNNEnemyUnitsThatCanReach(data, battleTer, player, Matches.TerritoryIsLandOrWater);
        responseAttackers.removeAll(battleTer.getUnits().getUnits());
        return responseAttackers;
    }

    public static List<Unit> GetUnitsGoingToBePlacedAtX(GameData data, PlayerID player, Territory ter) {
        PurchaseGroup terPG = FactoryCenter.get((GameData)data, (PlayerID)player).TurnTerritoryPurchaseGroups.get(ter);
        List<Unit> goingToBePlaced = new ArrayList<Unit>();
        if (terPG != null) {
            goingToBePlaced = terPG.GetSampleUnits();
        }
        return goingToBePlaced;
    }

    public static float GetTerTakeoverChance(GameData data, PlayerID player, Territory ter) {
        ArrayList<Unit> oldCapDefenders = new ArrayList<Unit>(ter.getUnits().getUnits());
        List<Unit> oldCapAttackers = DUtils.GetSPNNEnemyWithLUnitsThatCanReach(data, ter, player, Matches.TerritoryIsLandOrWater);
        AggregateResults oldResults = DUtils.GetBattleResults(oldCapAttackers, oldCapDefenders, ter, data, 1000, true);
        return (float)oldResults.getAttackerWinPercent();
    }

    public static float GetTerTakeoverChanceAtEndOfTurn(GameData data, PlayerID player, Territory ter) {
        List<Unit> oldTerDefenders = DUtils.GetTerUnitsAtEndOfTurn(data, player, ter);
        List<Unit> oldTerAttackers = DUtils.GetSPNNEnemyWithLUnitsThatCanReach(data, ter, player, Matches.TerritoryIsLandOrWater);
        AggregateResults oldResults = DUtils.GetBattleResults(oldTerAttackers, oldTerDefenders, ter, data, 1000, true);
        return (float)oldResults.getAttackerWinPercent();
    }

    public static List<Unit> GetTerUnitsGoingToBePlacedAt(GameData data, PlayerID player, Territory ter) {
        PurchaseGroup terPG = FactoryCenter.get((GameData)data, (PlayerID)player).TurnTerritoryPurchaseGroups.get(ter);
        List<Unit> goingToBePlaced = new ArrayList<Unit>();
        if (terPG != null) {
            goingToBePlaced = terPG.GetSampleUnits();
        }
        return goingToBePlaced;
    }

    public static List<Unit> GetTerUnitsAtEndOfTurn(GameData data, PlayerID player, Territory ter) {
        List<Unit> goingToBePlaced = DUtils.GetTerUnitsGoingToBePlacedAt(data, player, ter);
        ArrayList<Unit> result = new ArrayList<Unit>(ter.getUnits().getUnits());
        result.addAll(goingToBePlaced);
        return result;
    }

    public static List<Float> GetTerTakeoverChanceBeforeAndAfterMove(GameData data, PlayerID player, Territory terToCheck, Territory movedTo, List<Unit> unitsToMove, int calcAmount) {
        return DUtils.GetTerTakeoverChanceBeforeAndAfterMoves(data, player, terToCheck, Collections.singletonList(movedTo), unitsToMove, calcAmount);
    }

    public static List<Float> GetTerTakeoverChanceBeforeAndAfterMoves(GameData data, PlayerID player, Territory terToCheck, List<Territory> movedToTers, List<Unit> unitsToMove, int calcAmount) {
        ArrayList<Float> result = new ArrayList<Float>();
        ArrayList<Territory> movedFromTersThatBecomeEmpty = new ArrayList<Territory>();
        for (Territory ter : data.getMap().getTerritories()) {
            List<Unit> unitsOnTerBeingMoved;
            if (ter.isWater() || data.getRelationshipTracker().isAtWar(ter.getOwner(), player) || ter.getUnits().isEmpty() || (unitsOnTerBeingMoved = Match.getMatches(ter.getUnits().getUnits(), DMatches.unitIsInList(unitsToMove))).size() != ter.getUnits().size() || !DUtils.GetUnitsGoingToBePlacedAtX(data, player, ter).isEmpty()) continue;
            movedFromTersThatBecomeEmpty.add(ter);
        }
        ArrayList<Unit> unitsToMoveThatAreOnTerToCheck = new ArrayList<Unit>(unitsToMove);
        unitsToMoveThatAreOnTerToCheck.retainAll(terToCheck.getUnits().getUnits());
        PurchaseGroup terPG = FactoryCenter.get((GameData)data, (PlayerID)player).TurnTerritoryPurchaseGroups.get(terToCheck);
        List<Object> goingToBePlaced = new ArrayList();
        if (terPG != null) {
            goingToBePlaced = terPG.GetSampleUnits();
        }
        ArrayList<Unit> oldTerDefenders = new ArrayList<Unit>(terToCheck.getUnits().getUnits());
        oldTerDefenders.addAll(goingToBePlaced);
        List<Unit> oldTerAttackers = DUtils.GetSPNNEnemyWithLUnitsThatCanReach(data, terToCheck, player, Matches.TerritoryIsLandOrWater);
        AggregateResults oldResults = DUtils.GetBattleResults(oldTerAttackers, oldTerDefenders, terToCheck, data, calcAmount, true);
        ArrayList<Unit> newTerDefenders = new ArrayList<Unit>(oldTerDefenders);
        newTerDefenders.removeAll(unitsToMoveThatAreOnTerToCheck);
        if (movedToTers.contains(terToCheck)) {
            newTerDefenders.removeAll(unitsToMove);
            newTerDefenders.addAll(unitsToMove);
        }
        List<Unit> newTerAttackers = DUtils.GetSPNNEnemyWithLUnitsThatCanReach_CountXAsPassthroughs(data, terToCheck, player, DUtils.CompMatchAnd(Matches.TerritoryIsLandOrWater, Matches.territoryIsNotInList(movedToTers)), movedFromTersThatBecomeEmpty);
        List<Territory> attackFromLocs = DUtils.GetEnemyTerritoriesWithinXLandDistanceThatHaveEnemyUnitsThatCanAttack(terToCheck, data, player, GlobalCenter.FastestUnitMovement);
        for (Territory from : attackFromLocs) {
            Route route = DUtils.GetAttackRouteFromXToY_ByLand(data, from.getOwner(), from, terToCheck);
            if (route == null) continue;
            boolean doTheMovesBlockThisAttack = false;
            for (Territory to : movedToTers) {
                if (!route.getTerritories().contains(to) || route.getEnd().equals(to)) continue;
                doTheMovesBlockThisAttack = true;
                break;
            }
            if (!doTheMovesBlockThisAttack) continue;
            newTerAttackers.removeAll(from.getUnits().getUnits());
        }
        AggregateResults newResults = DUtils.GetBattleResults(newTerAttackers, newTerDefenders, terToCheck, data, calcAmount, true);
        result.add(Float.valueOf((float)oldResults.getAttackerWinPercent()));
        result.add(Float.valueOf((float)newResults.getAttackerWinPercent()));
        result.add(Float.valueOf((float)oldResults.getAverageAttackingUnitsLeft()));
        result.add(Float.valueOf((float)newResults.getAverageAttackingUnitsLeft()));
        return result;
    }

    public static float GetMostExtremeNum(List<Float> numbers) {
        float result = 0.0f;
        float farthestNumDist = 0.0f;
        for (Float num : numbers) {
            if (!(DUtils.MNN(num.floatValue()) > farthestNumDist)) continue;
            farthestNumDist = DUtils.MNN(num.floatValue());
            result = num.floatValue();
        }
        return result;
    }

    public static List<Float> ScaleNumbersTillWithinRange_P(float ceiling, float ... numbers) {
        float mostExtremeNum = DUtils.GetMostExtremeNum(DUtils.ToList(DUtils.ToArray(new Object[]{numbers})));
        float numberScaleToRange = mostExtremeNum / ceiling;
        ArrayList<Float> result = new ArrayList<Float>();
        float[] arr$ = numbers;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Float number = Float.valueOf(arr$[i$]);
            result.add(Float.valueOf(number.floatValue() / numberScaleToRange));
        }
        return result;
    }

    public static float Divide_SL(float quotient, float divisor) {
        return DUtils.Limit(DUtils.Divide_S(quotient, divisor));
    }

    public static float Divide_S(float quotient, float divisor) {
        quotient = DUtils.MNZ(quotient);
        divisor = DUtils.MNZ(divisor);
        return quotient / divisor;
    }

    public static float Limit(float value, float min, float max) {
        return Math.min(Math.max(value, min), max);
    }

    public static float Limit(float value) {
        return DUtils.Limit(value, 0.0f, 1.0f);
    }

    public static float MNZ(float value) {
        if (value == 0.0f) {
            value = 0.001f;
        }
        return value;
    }

    public static float MNN(float value) {
        if (value < 0.0f) {
            value = -value;
        }
        return value;
    }

    public static List<Territory> GetTersThatUnitsCanReach(GameData data, List<Unit> units, Territory territory, PlayerID playerToCheckFor, Match<Territory> terSearchMatch) {
        ArrayList<Territory> result = new ArrayList<Territory>();
        for (Territory ter : data.getMap().getTerritories()) {
            if (!terSearchMatch.match(ter)) continue;
            for (Unit u : units) {
                if (!DUtils.CanUnitReachTer(data, ter, u, territory)) continue;
                result.add(ter);
            }
        }
        return result;
    }

    public static List<Territory> GetTersThatMatchXThatUnitsOnTerCanAttack(GameData data, Territory territory, Match<Territory> terMatch, PlayerID player) {
        ArrayList<Territory> reachableMatches = new ArrayList<Territory>();
        block0: for (Territory ter : data.getMap().getTerritories()) {
            if (!terMatch.match(ter)) continue;
            for (Unit u : ter.getUnits().getMatches(Matches.unitIsOwnedBy(player))) {
                if (!DUtils.CanUnitReachTer(data, ter, u, territory)) continue;
                reachableMatches.add(ter);
                continue block0;
            }
        }
        return reachableMatches;
    }

    public static Unit CalculateUnitThatWillHelpWinAttackOnArmyTheMostPerPU(Territory testTer, GameData data, PlayerID player, Collection<Unit> unitsAlreadyAttacking, Collection<Unit> unitsToChooseFrom, Collection<Unit> unitsDefending, Match<Unit> match, int calcRunsPerUnit) {
        float bestTakeoverScore = -2.1474836E9f;
        Unit bestUnit = null;
        List<Unit> fakeDefenseUnits = DUtils.CreateDefendUnitsTillTakeoverChanceIsLessThanX(unitsAlreadyAttacking, unitsDefending, data, testTer, 0.85f);
        ArrayList<Unit> units = new ArrayList<Unit>(unitsAlreadyAttacking);
        AggregateResults oldResults = DUtils.GetBattleResults(units, fakeDefenseUnits, testTer, data, calcRunsPerUnit * 2, true);
        float oldAttackerWinPercent = (float)oldResults.getAttackerWinPercent();
        float oldAttackersLeft = (float)oldResults.getAverageAttackingUnitsLeft();
        float oldDefendersLeft = (float)oldResults.getAverageDefendingUnitsLeft();
        for (Unit testUnit : unitsToChooseFrom) {
            UnitType ut = testUnit.getUnitType();
            UnitAttachment ua = UnitAttachment.get(ut);
            if (Matches.UnitIsSea.match(testUnit) || Matches.UnitIsFactoryOrIsInfrastructure.match(testUnit) || Matches.UnitHasMaxBuildRestrictions.match(testUnit) || !match.match(testUnit)) continue;
            units.add(testUnit);
            AggregateResults results = DUtils.GetBattleResults(units, fakeDefenseUnits, testTer, data, calcRunsPerUnit, true);
            float attackerWinPercent = (float)results.getAttackerWinPercent();
            float attackersLeft = (float)results.getAverageAttackingUnitsLeft();
            float defendersLeft = (float)results.getAverageDefendingUnitsLeft();
            float cost = DUtils.GetTUVOfUnit(testUnit, GlobalCenter.GetPUResource());
            float dif = attackerWinPercent - oldAttackerWinPercent;
            float dif2 = attackersLeft - oldAttackersLeft + (oldDefendersLeft - defendersLeft);
            if (dif != 0.0f && dif > 0.0f) {
                if (dif / cost > bestTakeoverScore) {
                    bestUnit = testUnit;
                    bestTakeoverScore = dif / cost;
                }
            } else if (dif2 / cost > bestTakeoverScore) {
                bestUnit = testUnit;
                bestTakeoverScore = dif2 / cost;
            }
            units.remove(testUnit);
        }
        return bestUnit;
    }

    public static List<UnitGroup> CreateUnitGroupsForUnits(Collection<Unit> units, Territory ter, GameData data) {
        ArrayList<UnitGroup> result = new ArrayList<UnitGroup>();
        for (Unit unit : units) {
            result.add(new UnitGroup(unit, ter, data));
        }
        return result;
    }

    public static String Format(String message, Object ... args) {
        int count = 0;
        for (Object obj : args) {
            message = message.replace("{".concat(Integer.toString(count)).concat("}"), "" + obj);
            ++count;
        }
        return message;
    }

    private static String addIndentationCompensation(String message, Level level) {
        StringBuilder builder = new StringBuilder();
        int compensateLength = 6 - level.toString().length();
        if (compensateLength == 0) {
            return message;
        }
        for (int i = 0; i < compensateLength; ++i) {
            builder.append(" ");
        }
        builder.append(message);
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Log(Level level, String message, Object ... args) {
        if (GlobalCenter.IsPaused && !SwingUtilities.isEventDispatchThread()) {
            Object object = GlobalCenter.IsPaused_Object;
            synchronized (object) {
                while (GlobalCenter.IsPaused) {
                    try {
                        GlobalCenter.IsPaused_Object.wait();
                    }
                    catch (InterruptedException ex) {}
                }
            }
        }
        if (args.length > 0) {
            message = DUtils.Format(message, args);
        }
        Dynamix_AI.GetStaticLogger().log(level, DUtils.addIndentationCompensation(message, level));
        if (!DSettings.LoadSettings().EnableAILogging) {
            return;
        }
        Level logDepth = DSettings.LoadSettings().AILoggingDepth;
        if (logDepth.equals(Level.FINE) && (level.equals(Level.FINER) || level.equals(Level.FINEST))) {
            return;
        }
        if (logDepth.equals(Level.FINER) && level.equals(Level.FINEST)) {
            return;
        }
        UI.NotifyAILogMessage(level, message);
    }

    public static UnitGroup CreateUnitGroupForUnit(Unit unit, Territory ter, GameData data) {
        return DUtils.CreateUnitGroupForUnits(Collections.singleton(unit), ter, data);
    }

    public static UnitGroup CreateUnitGroupForUnits(Collection<Unit> units, Territory ter, GameData data) {
        return new UnitGroup(units, ter, data);
    }

    public static List<UnitGroup> CreateSpeedSplitUnitGroupsForUnits(Collection<Unit> units, Territory ter, GameData data) {
        ArrayList<UnitGroup> result = new ArrayList<UnitGroup>();
        HashMap<Integer, List<Unit>> splitUnits = DUtils.SeperateUnitsInListIntoSeperateMovementLists(new ArrayList<Unit>(units));
        for (Integer speed : splitUnits.keySet()) {
            List<Unit> unitsForSpeed = splitUnits.get(speed);
            result.add(new UnitGroup(unitsForSpeed, ter, data));
        }
        return result;
    }

    public static List<Unit> GetEndingCapitalUnits(GameData data, PlayerID player) {
        Territory ourCapital = TerritoryAttachment.getCapital(player, data);
        return DUtils.GetTerUnitsAtEndOfTurn(data, player, ourCapital);
    }

    static class ValueComparator_D
    implements Comparator {
        Map base;

        public ValueComparator_D(Map base) {
            this.base = base;
        }

        public int compare(Object a, Object b) {
            if ((Double)this.base.get(a) > (Double)this.base.get(b)) {
                return 1;
            }
            if ((Double)this.base.get(a) == (Double)this.base.get(b)) {
                return 0;
            }
            return -1;
        }
    }

    static class ValueComparator_A
    implements Comparator {
        Map base;

        public ValueComparator_A(Map base) {
            this.base = base;
        }

        public int compare(Object a, Object b) {
            if ((Double)this.base.get(a) < (Double)this.base.get(b)) {
                return 1;
            }
            if ((Double)this.base.get(a) == (Double)this.base.get(b)) {
                return 0;
            }
            return -1;
        }
    }
}

