/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.Group;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Dynamix_AI;
import games.strategy.triplea.delegate.remote.IPurchaseDelegate;
import games.strategy.util.IntegerMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurchaseGroup {
    private Collection<Unit> m_units = new ArrayList<Unit>();
    private IPurchaseDelegate m_purchaser = null;
    private GameData m_data = null;
    private PlayerID m_player = null;
    private final IntegerMap<ProductionRule> m_generatedRules = new IntegerMap();
    private final List<Unit> m_generatedSampleUnits = new ArrayList<Unit>();
    private int m_totalPurchasePrice = 0;
    private int m_maxPurchaseCost = Integer.MAX_VALUE;
    private int m_maxPurchaseCount = 1;

    public PurchaseGroup(Unit unit, IPurchaseDelegate purchaser, GameData data, PlayerID player) {
        this.m_units = Collections.singleton(unit);
        this.m_purchaser = purchaser;
        this.m_data = data;
        this.m_player = player;
        this.GenerateProductionRulesAndSampleUnits();
    }

    public PurchaseGroup(Collection<Unit> units, IPurchaseDelegate purchaser, GameData data, PlayerID player) {
        this.m_units = units;
        this.m_purchaser = purchaser;
        this.m_data = data;
        this.m_player = player;
        this.GenerateProductionRulesAndSampleUnits();
    }

    private void GenerateProductionRulesAndSampleUnits() {
        List<ProductionRule> rules = this.m_player.getProductionFrontier().getRules();
        int index = 0;
        this.m_generatedRules.clear();
        this.m_generatedSampleUnits.clear();
        this.m_totalPurchasePrice = 0;
        int totalUnitRulesCosts = 0;
        for (Unit unit : this.m_units) {
            for (ProductionRule rule : rules) {
                if (rule == null || rule.getResults() == null || rule.getResults().keySet() == null || rule.getResults().keySet().toArray() == null || rule.getResults().keySet().toArray().length <= 0 || rule.getResults().keySet().toArray()[0] == null || !(rule.getResults().keySet().toArray()[0] instanceof UnitType) || unit == null || unit.getUnitType() == null || (UnitType)rule.getResults().keySet().toArray()[0] != unit.getUnitType()) continue;
                int cost = rule.getCosts().getInt(this.m_data.getResourceList().getResource("PUs"));
                totalUnitRulesCosts += cost;
            }
        }
        if (totalUnitRulesCosts == 0) {
            return;
        }
        int timesUnitsCanBeBought = this.m_maxPurchaseCost / totalUnitRulesCosts;
        int timesEachUnitShouldBeBought = Math.min(timesUnitsCanBeBought, this.m_maxPurchaseCount / this.m_units.size());
        timesEachUnitShouldBeBought = Math.max(timesEachUnitShouldBeBought, 1);
        block2: for (Unit unit : this.m_units) {
            for (ProductionRule rule : rules) {
                if (rule == null || rule.getResults() == null || rule.getResults().keySet() == null || rule.getResults().keySet().toArray() == null || rule.getResults().keySet().toArray().length <= 0 || rule.getResults().keySet().toArray()[0] == null || !(rule.getResults().keySet().toArray()[0] instanceof UnitType) || unit == null || unit.getUnitType() == null || (UnitType)rule.getResults().keySet().toArray()[0] != unit.getUnitType()) continue;
                int cost = rule.getCosts().getInt(this.m_data.getResourceList().getResource("PUs"));
                this.m_generatedRules.add(rule, timesEachUnitShouldBeBought);
                this.m_totalPurchasePrice += cost * timesEachUnitShouldBeBought;
                for (int i = 0; i < timesEachUnitShouldBeBought; ++i) {
                    this.m_generatedSampleUnits.add(unit.getType().create(this.m_player));
                }
                ++index;
                continue block2;
            }
        }
    }

    public int GetCost() {
        return this.m_totalPurchasePrice;
    }

    public void ApplyMaxValues(int maxPurchaseCost, int maxPurchaseCount) {
        if (maxPurchaseCost != this.m_maxPurchaseCost || maxPurchaseCount != this.m_maxPurchaseCount) {
            this.m_maxPurchaseCost = maxPurchaseCost;
            this.m_maxPurchaseCount = maxPurchaseCount;
            this.GenerateProductionRulesAndSampleUnits();
        }
    }

    public int Purchase() {
        Dynamix_AI.Pause();
        this.m_purchaser.purchase(this.m_generatedRules);
        DUtils.Log(Level.FINER, "      Purchase made. Units: {0}", DUtils.UnitList_ToString(this.GetSampleUnits()));
        return this.m_totalPurchasePrice;
    }

    public List<Unit> GetSampleUnits() {
        return this.m_generatedSampleUnits;
    }
}

