/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.Dynamix_AI.Others;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ai.Dynamix_AI.CommandCenter.CachedCalculationCenter;
import games.strategy.triplea.ai.Dynamix_AI.DMatches;
import games.strategy.triplea.ai.Dynamix_AI.DSorting;
import games.strategy.triplea.ai.Dynamix_AI.DUtils;
import games.strategy.triplea.ai.Dynamix_AI.Dynamix_AI;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_TargetCalculator;
import games.strategy.triplea.ai.Dynamix_AI.Others.NCM_Task;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.oddsCalculator.ta.AggregateResults;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Purchase_UnitPlacementLocationSorter {
    public static List<Territory> CalculateAndSortUnitPlacementLocations(Dynamix_AI ai, boolean purchaseForBid, GameData data, PlayerID player) {
        List<Territory> result = new ArrayList();
        List<Territory> possibles = Match.getMatches(data.getMap().getTerritories(), DMatches.territoryCanHaveUnitsPlacedOnIt(data, player));
        HashMap<Territory, Integer> scores = new HashMap<Territory, Integer>();
        List<Territory> ourCaps = DUtils.GetAllOurCaps_ThatWeOwn(data, player);
        List<Territory> ownedCaps = DUtils.GetAllCapsOwnedBy(data, player);
        Collections.shuffle(possibles);
        for (Territory ter : possibles) {
            Route terToClosestEnemyRoute;
            Territory closestEnemy;
            Route terToTargetRoute;
            if (DMatches.territoryIsIsolated(data).match(ter) || !DMatches.territoryCanHaveUnitsPlacedOnIt(data, player).match(ter)) continue;
            List<Unit> possibleAttackers = DUtils.GetSPNNEnemyUnitsThatCanReach(data, ter, player, Matches.TerritoryIsLandOrWater);
            AggregateResults results = DUtils.GetBattleResults(possibleAttackers, DUtils.GetTerUnitsAtEndOfTurn(data, player, ter), ter, data, 500, true);
            int score = 0;
            if (ourCaps.contains(ter) && results.getAttackerWinPercent() > (double)0.1f) {
                score += 1000;
            }
            if (ownedCaps.contains(ter)) {
                score += 100;
            }
            score = (int)((float)score + DUtils.GetValueOfLandTer(ter, data, player));
            Territory target = NCM_TargetCalculator.CalculateNCMTargetForTerritory(data, player, ter, ter.getUnits().getUnits(), new ArrayList<NCM_Task>());
            if (target != null && (terToTargetRoute = CachedCalculationCenter.GetPassableLandRoute(data, ter, target)) != null) {
                score -= terToTargetRoute.getLength() * 5;
            }
            if ((closestEnemy = DUtils.GetClosestTerMatchingXAndHavingRouteMatchingY(data, ter, DMatches.territoryIsOwnedByNNEnemy(data, player), Matches.TerritoryIsLandOrWater)) != null && (terToClosestEnemyRoute = CachedCalculationCenter.GetPassableLandRoute(data, ter, closestEnemy)) != null) {
                score -= terToClosestEnemyRoute.getLength() * 10;
            }
            if (results.getAttackerWinPercent() > (double)0.3f && results.getAttackerWinPercent() < (double)0.7f) {
                score = (int)((double)score + results.getAttackerWinPercent() * 10.0);
            } else if (results.getAttackerWinPercent() > (double)0.7f && results.getAttackerWinPercent() < (double)0.95f) {
                score = (int)((double)score - results.getAttackerWinPercent() * 10.0);
            } else if (results.getAttackerWinPercent() > (double)0.95f) {
                score -= 10000;
            }
            if (DMatches.territoryIsOnSmallIsland(data).match(ter)) {
                score -= 10000;
            }
            int randNum = 100 + new Random().nextInt(10);
            double randomMultiplyAmount = (float)randNum / 100.0f;
            score = (int)((double)score * randomMultiplyAmount);
            result.add(ter);
            scores.put(ter, score);
        }
        result = DSorting.SortListByScores_HashMap_D(result, scores);
        if (purchaseForBid && result.size() > 0) {
            return result.subList(0, 1);
        }
        return result;
    }
}

