/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai.weakAI;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RepairRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.net.GUID;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.ai.AIUtils;
import games.strategy.triplea.ai.AbstractAI;
import games.strategy.triplea.ai.weakAI.Utils;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.BattleDelegate;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.triplea.delegate.dataObjects.CasualtyList;
import games.strategy.triplea.delegate.dataObjects.PlaceableUnits;
import games.strategy.triplea.delegate.remote.IAbstractPlaceDelegate;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.triplea.delegate.remote.IPurchaseDelegate;
import games.strategy.triplea.delegate.remote.ITechDelegate;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.InverseMatch;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import games.strategy.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakAI
extends AbstractAI
implements IGamePlayer,
ITripleaPlayer {
    private static final Logger s_logger = Logger.getLogger(WeakAI.class.getName());
    public static final Match<Unit> Transporting = new Match<Unit>(){

        @Override
        public boolean match(Unit o) {
            return TripleAUnit.get(o).getTransporting().size() > 0;
        }
    };

    public WeakAI(String name, String type) {
        super(name, type);
    }

    @Override
    protected void tech(ITechDelegate techDelegate, GameData data, PlayerID player) {
    }

    private Route getAmphibRoute(final PlayerID player) {
        CompositeMatchAnd<Territory> routeCond;
        Match<Territory> endMatch;
        if (!this.isAmphibAttack(player)) {
            return null;
        }
        final GameData data = this.getPlayerBridge().getGameData();
        Territory ourCapitol = TerritoryAttachment.getCapital(player, data);
        Route withNoEnemy = Utils.findNearest(ourCapitol, endMatch = new Match<Territory>(){

            @Override
            public boolean match(Territory o) {
                boolean impassable = TerritoryAttachment.get(o) != null && TerritoryAttachment.get(o).getIsImpassible();
                return !impassable && !o.isWater() && Utils.hasLandRouteToEnemyOwnedCapitol(o, player, data);
            }
        }, routeCond = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, Matches.territoryHasNoEnemyUnits(player, data)), this.getPlayerBridge().getGameData());
        if (withNoEnemy != null && withNoEnemy.getLength() > 0) {
            return withNoEnemy;
        }
        Route route = Utils.findNearest(ourCapitol, endMatch, Matches.TerritoryIsWater, this.getPlayerBridge().getGameData());
        if (route != null && route.getLength() == 0) {
            return null;
        }
        return route;
    }

    private boolean isAmphibAttack(PlayerID player) {
        Territory capitol = TerritoryAttachment.getCapital(player, this.getPlayerBridge().getGameData());
        if (capitol == null || !capitol.getOwner().equals(player)) {
            return false;
        }
        Route invasionRoute = Utils.findNearest(capitol, Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, this.getPlayerBridge().getGameData()), new CompositeMatchAnd<Territory>(Matches.TerritoryIsLand, new InverseMatch<Territory>(Matches.TerritoryIsNeutralButNotWater)), this.getPlayerBridge().getGameData());
        return invasionRoute == null;
    }

    @Override
    protected void move(boolean nonCombat, IMoveDelegate moveDel, GameData data, PlayerID player) {
        if (nonCombat) {
            this.doNonCombatMove(moveDel, player);
        } else {
            this.doCombatMove(moveDel, player);
        }
        this.pause();
    }

    private void doNonCombatMove(IMoveDelegate moveDel, PlayerID player) {
        GameData data = this.getPlayerBridge().getGameData();
        ArrayList<Collection<Unit>> moveUnits = new ArrayList<Collection<Unit>>();
        ArrayList<Route> moveRoutes = new ArrayList<Route>();
        ArrayList<Collection<Unit>> transportsToLoad = new ArrayList<Collection<Unit>>();
        this.populateTransportLoad(false, data, moveUnits, moveRoutes, transportsToLoad, player);
        this.doMove(moveUnits, moveRoutes, transportsToLoad, moveDel);
        moveRoutes.clear();
        moveUnits.clear();
        transportsToLoad.clear();
        this.populateNonCombat(data, moveUnits, moveRoutes, player);
        this.populateNonCombatSea(true, data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveUnits.clear();
        moveRoutes.clear();
        transportsToLoad.clear();
        this.populateTransportLoad(false, data, moveUnits, moveRoutes, transportsToLoad, player);
        this.doMove(moveUnits, moveRoutes, transportsToLoad, moveDel);
        moveRoutes.clear();
        moveUnits.clear();
        transportsToLoad.clear();
        this.populateTransportUnloadNonCom(true, data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
    }

    private void doCombatMove(IMoveDelegate moveDel, PlayerID player) {
        GameData data = this.getPlayerBridge().getGameData();
        ArrayList<Collection<Unit>> moveUnits = new ArrayList<Collection<Unit>>();
        ArrayList<Route> moveRoutes = new ArrayList<Route>();
        ArrayList<Collection<Unit>> transportsToLoad = new ArrayList<Collection<Unit>>();
        this.populateTransportLoad(true, data, moveUnits, moveRoutes, transportsToLoad, player);
        this.doMove(moveUnits, moveRoutes, transportsToLoad, moveDel);
        moveRoutes.clear();
        moveUnits.clear();
        this.populateNonCombatSea(false, data, moveUnits, moveRoutes, player);
        Route altRoute = this.getAlternativeAmphibRoute(player);
        if (altRoute != null) {
            this.moveCombatSea(data, moveUnits, moveRoutes, player, altRoute, 1);
        }
        this.doMove(moveUnits, moveRoutes, null, moveDel);
        moveUnits.clear();
        moveRoutes.clear();
        transportsToLoad.clear();
        this.populateCombatMove(data, moveUnits, moveRoutes, player);
        this.populateCombatMoveSea(data, moveUnits, moveRoutes, player);
        this.doMove(moveUnits, moveRoutes, null, moveDel);
    }

    private void populateTransportLoad(boolean nonCombat, GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, List<Collection<Unit>> transportsToLoad, PlayerID player) {
        TransportTracker tracker = DelegateFinder.moveDelegate(data).getTransportTracker();
        if (!this.isAmphibAttack(player)) {
            return;
        }
        Territory capitol = TerritoryAttachment.getCapital(player, data);
        if (capitol == null || !capitol.getOwner().equals(player)) {
            return;
        }
        List<Unit> unitsToLoad = capitol.getUnits().getMatches(Matches.UnitIsFactoryOrIsInfrastructure.invert());
        unitsToLoad = Match.getMatches(unitsToLoad, Matches.unitIsOwnedBy(this.getWhoAmI()));
        for (Territory neighbor : data.getMap().getNeighbors(capitol)) {
            if (!neighbor.isWater()) continue;
            ArrayList<Unit> units = new ArrayList<Unit>();
            for (Unit transport : neighbor.getUnits().getMatches(Matches.unitIsOwnedBy(player))) {
                int free = tracker.getAvailableCapacity(transport);
                if (free <= 0) continue;
                Iterator<Unit> iter = unitsToLoad.iterator();
                while (iter.hasNext() && free > 0) {
                    Unit current = iter.next();
                    UnitAttachment ua = UnitAttachment.get(current.getType());
                    if (ua.getIsAir() || ua.getTransportCost() > free) continue;
                    iter.remove();
                    free -= ua.getTransportCost();
                    units.add(current);
                }
            }
            if (units.size() <= 0) continue;
            Route route = new Route();
            route.setStart(capitol);
            route.add(neighbor);
            moveUnits.add(units);
            moveRoutes.add(route);
            transportsToLoad.add(neighbor.getUnits().getMatches(Matches.UnitIsTransport));
        }
    }

    private void populateTransportUnloadNonCom(boolean nonCombat, GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        Route amphibRoute = this.getAmphibRoute(player);
        if (amphibRoute == null) {
            return;
        }
        Territory lastSeaZoneOnAmphib = amphibRoute.getTerritories().get(amphibRoute.getLength() - 1);
        Territory landOn = amphibRoute.getEnd();
        CompositeMatchAnd<Unit> landAndOwned = new CompositeMatchAnd<Unit>(Matches.UnitIsLand, Matches.unitIsOwnedBy(player));
        List<Unit> units = lastSeaZoneOnAmphib.getUnits().getMatches(landAndOwned);
        if (units.size() > 0) {
            Route route = new Route();
            route.setStart(lastSeaZoneOnAmphib);
            route.add(landOn);
            moveUnits.add(units);
            moveRoutes.add(route);
        }
    }

    private List<Unit> load2Transports(boolean reload, GameData data, List<Unit> transportsToLoad, Territory loadFrom, PlayerID player) {
        TransportTracker tracker = DelegateFinder.moveDelegate(data).getTransportTracker();
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (Unit transport : transportsToLoad) {
            Collection<Unit> landunits = tracker.transporting(transport);
            for (Unit u : landunits) {
                units.add(u);
            }
        }
        return units;
    }

    private void doMove(List<Collection<Unit>> moveUnits, List<Route> moveRoutes, List<Collection<Unit>> transportsToLoad, IMoveDelegate moveDel) {
        for (int i = 0; i < moveRoutes.size(); ++i) {
            this.pause();
            if (moveRoutes.get(i) == null || moveRoutes.get(i).getEnd() == null || moveRoutes.get(i).getStart() == null) {
                s_logger.fine("Route not valid" + moveRoutes.get(i) + " units:" + moveUnits.get(i));
                continue;
            }
            String result = transportsToLoad == null ? moveDel.move(moveUnits.get(i), moveRoutes.get(i)) : moveDel.move(moveUnits.get(i), moveRoutes.get(i), transportsToLoad.get(i));
            if (result == null) continue;
            s_logger.fine("could not move " + moveUnits.get(i) + " over " + moveRoutes.get(i) + " because : " + result);
        }
    }

    private void moveCombatSea(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player, Route amphibRoute, int maxTrans) {
        if (moveRoutes.size() == 2) {
            moveRoutes.remove(1);
            moveUnits.remove(1);
        }
        Territory firstSeaZoneOnAmphib = null;
        Territory lastSeaZoneOnAmphib = null;
        if (amphibRoute != null) {
            firstSeaZoneOnAmphib = amphibRoute.getTerritories().get(0);
            lastSeaZoneOnAmphib = amphibRoute.getTerritories().get(amphibRoute.getLength() - 1);
        }
        CompositeMatchAnd<Unit> ownedAndNotMoved = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.unitHasNotMoved, Transporting);
        ArrayList<Unit> unitsToMove = new ArrayList<Unit>();
        List<Unit> transports = firstSeaZoneOnAmphib.getUnits().getMatches(ownedAndNotMoved);
        if (transports.size() <= maxTrans) {
            unitsToMove.addAll(transports);
        } else {
            unitsToMove.addAll(transports.subList(0, maxTrans));
        }
        List<Unit> landUnits = this.load2Transports(true, data, unitsToMove, firstSeaZoneOnAmphib, player);
        Route r = this.getMaxSeaRoute(data, firstSeaZoneOnAmphib, lastSeaZoneOnAmphib, player);
        moveRoutes.add(r);
        unitsToMove.addAll(landUnits);
        moveUnits.add(unitsToMove);
    }

    private void populateNonCombatSea(boolean nonCombat, GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        Route amphibRoute = this.getAmphibRoute(player);
        Territory firstSeaZoneOnAmphib = null;
        Territory lastSeaZoneOnAmphib = null;
        if (amphibRoute != null) {
            firstSeaZoneOnAmphib = amphibRoute.getTerritories().get(1);
            lastSeaZoneOnAmphib = amphibRoute.getTerritories().get(amphibRoute.getLength() - 1);
        }
        HashSet<Unit> alreadyMoved = new HashSet<Unit>();
        CompositeMatchAnd<Unit> ownedAndNotMoved = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.unitHasNotMoved);
        for (Territory t : data.getMap()) {
            Route r;
            if (!t.isWater()) continue;
            if (t.getUnits().someMatch(Matches.UnitIsLand) && lastSeaZoneOnAmphib != null && (r = this.getMaxSeaRoute(data, t, lastSeaZoneOnAmphib, player)) != null && r.getLength() > 0) {
                moveRoutes.add(r);
                List<Unit> unitsToMove = t.getUnits().getMatches(Matches.unitIsOwnedBy(player));
                moveUnits.add(unitsToMove);
                alreadyMoved.addAll(unitsToMove);
            }
            if (!nonCombat || !t.getUnits().someMatch(ownedAndNotMoved) || firstSeaZoneOnAmphib == null) continue;
            r = this.getMaxSeaRoute(data, t, firstSeaZoneOnAmphib, player);
            moveRoutes.add(r);
            moveUnits.add(t.getUnits().getMatches(ownedAndNotMoved));
        }
    }

    private Route getMaxSeaRoute(GameData data, Territory start, Territory destination, PlayerID player) {
        CompositeMatchAnd<Territory> routeCond = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, Matches.territoryHasEnemyUnits(player, data).invert(), Matches.territoryHasNonAllowedCanal(player, null, data).invert());
        Route r = data.getMap().getRoute(start, destination, routeCond);
        if (r == null) {
            return null;
        }
        if (r.getLength() > 2) {
            Route newRoute = new Route();
            newRoute.setStart(start);
            newRoute.add(r.getTerritories().get(1));
            newRoute.add(r.getTerritories().get(2));
            r = newRoute;
        }
        return r;
    }

    private void populateCombatMoveSea(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        final HashSet<Unit> unitsAlreadyMoved = new HashSet<Unit>();
        for (Territory t : data.getMap()) {
            Territory enemy;
            float enemyStrength;
            if (!t.isWater() || !t.getUnits().someMatch(Matches.enemyUnit(player, data)) || !((enemyStrength = AIUtils.strength((enemy = t).getUnits().getUnits(), false, true)) > 0.0f)) continue;
            CompositeMatchAnd<Unit> attackable = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), new Match<Unit>(){

                @Override
                public boolean match(Unit o) {
                    return !unitsAlreadyMoved.contains(o);
                }
            });
            HashSet<Territory> dontMoveFrom = new HashSet<Territory>();
            int ourStrength = 0;
            Set<Territory> attackFrom = data.getMap().getNeighbors(enemy, Matches.TerritoryIsWater);
            for (Territory owned : attackFrom) {
                if (owned.getUnits().someMatch(Matches.UnitIsLand)) {
                    dontMoveFrom.add(owned);
                    continue;
                }
                ourStrength = (int)((float)ourStrength + AIUtils.strength(owned.getUnits().getMatches(attackable), true, true));
            }
            if (!((double)ourStrength > 1.32 * (double)enemyStrength)) continue;
            s_logger.fine("Attacking : " + enemy + " our strength:" + ourStrength + " enemy strength" + enemyStrength);
            for (Territory owned : attackFrom) {
                if (dontMoveFrom.contains(owned)) continue;
                List<Unit> units = owned.getUnits().getMatches(attackable);
                unitsAlreadyMoved.addAll(units);
                moveUnits.add(units);
                moveRoutes.add(data.getMap().getRoute(owned, enemy));
            }
        }
    }

    private Route getAlternativeAmphibRoute(PlayerID player) {
        if (!this.isAmphibAttack(player)) {
            return null;
        }
        GameData data = this.getPlayerBridge().getGameData();
        CompositeMatchAnd<Territory> routeCondition = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, Matches.territoryHasNoEnemyUnits(player, data));
        CompositeMatchAnd<Territory> transportOnSea = new CompositeMatchAnd<Territory>(Matches.TerritoryIsWater, Matches.territoryHasLandUnitsOwnedBy(player));
        Route altRoute = null;
        int length = Integer.MAX_VALUE;
        for (Territory t : data.getMap()) {
            Route newRoute;
            if (!((Match)transportOnSea).match(t)) continue;
            CompositeMatchAnd<Unit> ownedTransports = new CompositeMatchAnd<Unit>(Matches.UnitCanTransport, Matches.unitIsOwnedBy(player), Matches.unitHasNotMoved);
            CompositeMatchAnd<Territory> enemyTerritory = new CompositeMatchAnd<Territory>(Matches.isTerritoryEnemy(player, data), Matches.TerritoryIsLand, new InverseMatch<Territory>(Matches.TerritoryIsNeutralButNotWater), Matches.TerritoryIsEmpty);
            int trans = t.getUnits().countMatches(ownedTransports);
            if (trans <= 0 || (newRoute = Utils.findNearest(t, enemyTerritory, routeCondition, data)) == null || Integer.MAX_VALUE <= newRoute.getLength()) continue;
            altRoute = newRoute;
        }
        return altRoute;
    }

    private void populateNonCombat(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        Collection<Territory> territories = data.getMap().getTerritories();
        this.movePlanesHomeNonCom(moveUnits, moveRoutes, player);
        for (Territory t : territories) {
            Route route;
            if (t.isWater()) continue;
            if (TerritoryAttachment.get(t).isCapital()) {
                float ourStrength = AIUtils.strength(player.getUnits().getUnits(), false, false);
                float attackerStrength = Utils.getStrengthOfPotentialAttackers(t, data);
                if (attackerStrength > ourStrength) continue;
            }
            CompositeMatchAnd<Unit> moveOfType = new CompositeMatchAnd<Unit>(new Match[0]);
            moveOfType.add(Matches.unitIsOwnedBy(player));
            moveOfType.add(Matches.UnitIsNotAA);
            moveOfType.add(Matches.UnitIsNotStatic(player));
            moveOfType.add(Matches.UnitIsNotFactory);
            moveOfType.add(Matches.UnitIsLand);
            CompositeMatchAnd<Territory> moveThrough = new CompositeMatchAnd<Territory>(new InverseMatch<Territory>(Matches.TerritoryIsImpassable), new InverseMatch<Territory>(Matches.TerritoryIsNeutralButNotWater), Matches.TerritoryIsLand);
            List<Unit> units = t.getUnits().getMatches(moveOfType);
            if (units.size() == 0) continue;
            int minDistance = Integer.MAX_VALUE;
            Territory to = null;
            for (PlayerID otherPlayer : data.getPlayerList().getPlayers()) {
                int distance;
                Territory capitol = TerritoryAttachment.getCapital(otherPlayer, data);
                if (capitol == null || data.getRelationshipTracker().isAllied(player, capitol.getOwner()) || (route = data.getMap().getRoute(t, capitol, moveThrough)) == null || (distance = route.getLength()) == 0 || distance >= minDistance) continue;
                minDistance = distance;
                to = capitol;
            }
            if (to != null) {
                if (units.size() <= 0) continue;
                moveUnits.add(units);
                Route routeToCapitol = data.getMap().getRoute(t, to, moveThrough);
                Territory firstStep = routeToCapitol.getTerritories().get(1);
                Route route2 = new Route();
                route2.setStart(t);
                route2.add(firstStep);
                moveRoutes.add(route2);
                continue;
            }
            CompositeMatchAnd<Territory> routeCondition = new CompositeMatchAnd<Territory>(Matches.TerritoryIsLand, Matches.TerritoryIsImpassable.invert());
            Route newRoute = Utils.findNearest(t, Matches.territoryHasEnemyLandUnits(player, data), routeCondition, data);
            if (newRoute == null) {
                newRoute = Utils.findNearest(t, Matches.isTerritoryEnemy(player, data), routeCondition, data);
            }
            if (newRoute == null || newRoute.getLength() == 0) continue;
            moveUnits.add(units);
            Territory firstStep = newRoute.getTerritories().get(1);
            route = new Route();
            route.setStart(t);
            route.add(firstStep);
            moveRoutes.add(route);
        }
    }

    private void movePlanesHomeNonCom(List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        IMoveDelegate delegateRemote = (IMoveDelegate)this.getPlayerBridge().getRemote();
        final BattleDelegate delegate = DelegateFinder.battleDelegate(this.getPlayerBridge().getGameData());
        CompositeMatchAnd<Territory> canLand = new CompositeMatchAnd<Territory>(Matches.isTerritoryAllied(player, this.getPlayerBridge().getGameData()), new Match<Territory>(){

            @Override
            public boolean match(Territory o) {
                return !delegate.getBattleTracker().wasConquered(o);
            }
        });
        CompositeMatchAnd<Territory> routeCondition = new CompositeMatchAnd<Territory>(Matches.territoryHasEnemyAAforCombatOnly(player, this.getPlayerBridge().getGameData()).invert(), Matches.TerritoryIsImpassable.invert());
        for (Territory t : delegateRemote.getTerritoriesWhereAirCantLand()) {
            Route noAARoute = Utils.findNearest(t, canLand, routeCondition, this.getPlayerBridge().getGameData());
            Route aaRoute = Utils.findNearest(t, canLand, Matches.TerritoryIsImpassable.invert(), this.getPlayerBridge().getGameData());
            List<Unit> airToLand = t.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.UnitIsAir, Matches.unitIsOwnedBy(player)));
            moveUnits.add(airToLand);
            moveRoutes.add(noAARoute);
            moveUnits.add(airToLand);
            moveRoutes.add(aaRoute);
        }
    }

    private void populateCombatMove(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        this.populateBomberCombat(data, moveUnits, moveRoutes, player);
        final HashSet<Unit> unitsAlreadyMoved = new HashSet<Unit>();
        CompositeMatchOr walkInto = new CompositeMatchOr(Matches.isTerritoryEnemyAndNotUnownedWaterOrImpassibleOrRestricted(player, data), Matches.isTerritoryFreeNeutral(data));
        List<Territory> enemyOwned = Match.getMatches(data.getMap().getTerritories(), walkInto);
        Collections.sort(enemyOwned, new Comparator<Territory>(){
            private final Map<Territory, Integer> randomInts = new HashMap<Territory, Integer>();

            @Override
            public int compare(Territory o1, Territory o2) {
                if (o1.equals(o2)) {
                    return 0;
                }
                TerritoryAttachment ta1 = TerritoryAttachment.get(o1);
                TerritoryAttachment ta2 = TerritoryAttachment.get(o2);
                if (ta1 != null && ta2 != null) {
                    if (ta1.isCapital() && !ta2.isCapital()) {
                        return -1;
                    }
                    if (!ta1.isCapital() && ta2.isCapital()) {
                        return 1;
                    }
                }
                boolean factoryInT1 = o1.getUnits().someMatch(Matches.UnitIsFactory);
                boolean factoryInT2 = o2.getUnits().someMatch(Matches.UnitIsFactory);
                if (factoryInT1 && !factoryInT2) {
                    return -1;
                }
                if (!factoryInT1 && factoryInT2) {
                    return 1;
                }
                if (!this.randomInts.containsKey(o1)) {
                    this.randomInts.put(o1, (int)(Math.random() * 1000.0));
                }
                if (!this.randomInts.containsKey(o2)) {
                    this.randomInts.put(o2, (int)(Math.random() * 1000.0));
                }
                return this.randomInts.get(o1) - this.randomInts.get(o2);
            }
        });
        List<Territory> isWaterTerr = Utils.onlyWaterTerr(data, enemyOwned);
        enemyOwned.removeAll(isWaterTerr);
        block0: for (Territory enemy : enemyOwned) {
            if (AIUtils.strength(enemy.getUnits().getUnits(), false, false) != 0.0f) continue;
            boolean taken = false;
            block1: for (Territory attackFrom : data.getMap().getNeighbors(enemy, Matches.territoryHasLandUnitsOwnedBy(player))) {
                if (taken) continue block0;
                ArrayList<Unit> unitsSortedByCost = new ArrayList<Unit>(attackFrom.getUnits().getUnits());
                Collections.sort(unitsSortedByCost, AIUtils.getCostComparator());
                for (Unit unit : unitsSortedByCost) {
                    CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsLand, Matches.UnitIsNotFactory, Matches.UnitIsNotStatic(player), Matches.UnitIsNotAA);
                    if (unitsAlreadyMoved.contains(unit) || !((Match)match).match(unit)) continue;
                    moveRoutes.add(data.getMap().getRoute(attackFrom, enemy));
                    if (attackFrom.isWater()) {
                        List<Unit> units = attackFrom.getUnits().getMatches(Matches.unitIsLandAndOwnedBy(player));
                        moveUnits.add(Util.difference(units, unitsAlreadyMoved));
                        unitsAlreadyMoved.addAll(units);
                    } else {
                        moveUnits.add(Collections.singleton(unit));
                    }
                    unitsAlreadyMoved.add(unit);
                    taken = true;
                    continue block1;
                }
            }
        }
        for (Territory enemy : enemyOwned) {
            float enemyStrength = AIUtils.strength(enemy.getUnits().getUnits(), false, false);
            if (!(enemyStrength > 0.0f)) continue;
            CompositeMatchAnd<Unit> attackable = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsStrategicBomber.invert(), new Match<Unit>(){

                @Override
                public boolean match(Unit o) {
                    return !unitsAlreadyMoved.contains(o);
                }
            });
            attackable.add(Matches.UnitIsNotAA);
            attackable.add(Matches.UnitIsNotStatic(player));
            attackable.add(Matches.UnitIsNotFactory);
            attackable.add(Matches.UnitIsNotSea);
            HashSet<Territory> dontMoveFrom = new HashSet<Territory>();
            int ourStrength = 0;
            Set<Territory> attackFrom = data.getMap().getNeighbors(enemy, Matches.territoryHasLandUnitsOwnedBy(player));
            for (Territory owned : attackFrom) {
                if (TerritoryAttachment.get(owned) != null && TerritoryAttachment.get(owned).isCapital() && Utils.getStrengthOfPotentialAttackers(owned, this.getPlayerBridge().getGameData()) > AIUtils.strength(owned.getUnits().getUnits(), false, false)) {
                    dontMoveFrom.add(owned);
                    continue;
                }
                ourStrength = (int)((float)ourStrength + AIUtils.strength(owned.getUnits().getMatches(attackable), true, false));
            }
            if (!((double)ourStrength > 1.37 * (double)enemyStrength)) continue;
            double remainingStrengthNeeded = 2.5 * (double)enemyStrength + 4.0;
            for (Territory owned : attackFrom) {
                if (dontMoveFrom.contains(owned)) continue;
                List<Unit> units = owned.getUnits().getMatches(attackable);
                if (!owned.isWater() && data.getMap().getNeighbors(owned, Matches.territoryHasEnemyLandUnits(player, data)).size() > 1) {
                    units = Utils.getUnitsUpToStrength(remainingStrengthNeeded, units, true, false);
                }
                remainingStrengthNeeded -= (double)AIUtils.strength(units, true, false);
                if (units.size() <= 0) continue;
                unitsAlreadyMoved.addAll(units);
                moveUnits.add(units);
                moveRoutes.add(data.getMap().getRoute(owned, enemy));
            }
            s_logger.fine("Attacking : " + enemy + " our strength:" + ourStrength + " enemy strength" + enemyStrength + " remaining strength needed " + remainingStrengthNeeded);
        }
    }

    private void populateBomberCombat(GameData data, List<Collection<Unit>> moveUnits, List<Route> moveRoutes, PlayerID player) {
        Match<Territory> enemyFactory = Matches.territoryHasEnemyFactory(this.getPlayerBridge().getGameData(), player);
        CompositeMatchAnd<Unit> ownBomber = new CompositeMatchAnd<Unit>(Matches.UnitIsStrategicBomber, Matches.unitIsOwnedBy(player));
        for (Territory t : data.getMap().getTerritories()) {
            List<Unit> bombers = t.getUnits().getMatches(ownBomber);
            if (bombers.isEmpty()) continue;
            InverseMatch<Territory> routeCond = new InverseMatch<Territory>(Matches.territoryHasEnemyAAforCombatOnly(player, this.getPlayerBridge().getGameData()));
            Route bombRoute = Utils.findNearest(t, enemyFactory, routeCond, this.getPlayerBridge().getGameData());
            moveUnits.add(bombers);
            moveRoutes.add(bombRoute);
        }
    }

    private int countTransports(GameData data, PlayerID player) {
        CompositeMatchAnd<Unit> ownedTransport = new CompositeMatchAnd<Unit>(Matches.UnitIsTransport, Matches.unitIsOwnedBy(player));
        int sum = 0;
        for (Territory t : data.getMap()) {
            sum += t.getUnits().countMatches(ownedTransport);
        }
        return sum;
    }

    private int countLandUnits(GameData data, PlayerID player) {
        CompositeMatchAnd<Unit> ownedLandUnit = new CompositeMatchAnd<Unit>(Matches.UnitIsLand, Matches.unitIsOwnedBy(player));
        int sum = 0;
        for (Territory t : data.getMap()) {
            sum += t.getUnits().countMatches(ownedLandUnit);
        }
        return sum;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void purchase(boolean purchaseForBid, int PUsToSpend, IPurchaseDelegate purchaseDelegate, GameData data, PlayerID player) {
        HashMap<Unit, IntegerMap<RepairRule>> repair;
        IntegerMap<RepairRule> repairMap;
        int totPU;
        if (!this.canWePurchaseOrRepair(purchaseForBid)) {
            return;
        }
        if (purchaseForBid) {
            Resource PUs = data.getResourceList().getResource("PUs");
            int leftToSpend = PUsToSpend;
            List<ProductionRule> rules = player.getProductionFrontier().getRules();
            IntegerMap<ProductionRule> purchase = new IntegerMap<ProductionRule>();
            int minCost = Integer.MAX_VALUE;
            int i = 0;
            while ((minCost == Integer.MAX_VALUE || leftToSpend >= minCost) && i < 100000) {
                ++i;
                for (ProductionRule rule : rules) {
                    int cost;
                    UnitType results = (UnitType)rule.getResults().keySet().iterator().next();
                    if (Matches.UnitTypeIsSea.match(results) || Matches.UnitTypeIsAir.match(results) || Matches.UnitTypeIsFactoryOrIsInfrastructure.match(results) || Matches.UnitTypeIsAAforAnything.match(results) || Matches.UnitTypeHasMaxBuildRestrictions.match(results) || Matches.UnitTypeConsumesUnitsOnCreation.match(results) || Matches.unitTypeIsStatic(player).match(results) || (cost = rule.getCosts().getInt(PUs)) < 1) continue;
                    if (minCost == Integer.MAX_VALUE) {
                        minCost = cost;
                    }
                    if (minCost > cost) {
                        minCost = cost;
                    }
                    if (!(Math.random() * (double)cost < 2.0) || cost > leftToSpend) continue;
                    leftToSpend -= cost;
                    purchase.add(rule, 1);
                }
            }
            purchaseDelegate.purchase(purchase);
            return;
        }
        this.pause();
        boolean isAmphib = this.isAmphibAttack(player);
        Route amphibRoute = this.getAmphibRoute(player);
        int transportCount = this.countTransports(this.getPlayerBridge().getGameData(), player);
        int landUnitCount = this.countLandUnits(this.getPlayerBridge().getGameData(), player);
        int defUnitsAtAmpibRoute = 0;
        if (isAmphib && amphibRoute != null) {
            defUnitsAtAmpibRoute = amphibRoute.getEnd().getUnits().getUnitCount();
        }
        Resource PUs = data.getResourceList().getResource("PUs");
        int leftToSpend = totPU = player.getResources().getQuantity(PUs);
        Territory capitol = TerritoryAttachment.getCapital(player, data);
        List<ProductionRule> rules = player.getProductionFrontier().getRules();
        IntegerMap<ProductionRule> purchase = new IntegerMap<ProductionRule>();
        List<Object> rrules = Collections.emptyList();
        CompositeMatchAnd<Unit> ourFactories = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsFactory);
        List<Territory> rfactories = Utils.findUnitTerr(data, player, ourFactories);
        if (player.getRepairFrontier() != null && Properties.getSBRAffectsUnitProduction(data)) {
            rrules = player.getRepairFrontier().getRules();
            repairMap = new IntegerMap<RepairRule>();
            repair = new HashMap<Unit, IntegerMap<RepairRule>>();
            int minimumUnitPrice = 3;
            int diff = 0;
            int totalDamage = 0;
            int capDamage = 0;
            int maxUnits = (totPU - 1) / 3;
            int currentProduction = 0;
            int maxProduction = 0;
            for (Territory territory : rfactories) {
                if (!Matches.territoryHasOwnedFactory(data, player).match(territory)) continue;
                TerritoryAttachment territoryAttachment = TerritoryAttachment.get(territory);
                maxProduction += territoryAttachment.getProduction();
                diff = territoryAttachment.getProduction() - territoryAttachment.getUnitProduction();
                totalDamage += diff;
                if (territory == capitol) {
                    capDamage += diff;
                }
                if (territoryAttachment.getUnitProduction() <= 0) continue;
                currentProduction += territoryAttachment.getUnitProduction();
            }
            rfactories.remove(capitol);
            Collections.shuffle(rfactories);
            if (TerritoryAttachment.get(capitol).getUnitProduction() <= maxUnits / 2 || rfactories.isEmpty()) {
                for (RepairRule repairRule : rrules) {
                    if (!Matches.territoryHasOwnedFactory(data, player).match(capitol)) continue;
                    TerritoryAttachment territoryAttachment = TerritoryAttachment.get(capitol);
                    diff = territoryAttachment.getProduction() - territoryAttachment.getUnitProduction();
                    diff = !rfactories.isEmpty() ? Math.min(diff, maxUnits / 2 - territoryAttachment.getUnitProduction() + 1) : Math.min(diff, maxUnits - territoryAttachment.getUnitProduction());
                    if ((diff = Math.min(diff, leftToSpend - 3)) <= 0) continue;
                    currentProduction = territoryAttachment.getUnitProduction() >= 0 ? (currentProduction += diff) : (currentProduction += diff + territoryAttachment.getUnitProduction());
                    repairMap.add(repairRule, diff);
                    repair.put(Match.getMatches(capitol.getUnits().getUnits(), Matches.UnitIsFactoryOrCanBeDamaged).iterator().next(), repairMap);
                    purchaseDelegate.purchaseRepair(repair);
                    repair.clear();
                    repairMap.clear();
                    maxUnits = ((leftToSpend -= diff) - 1) / 3;
                }
            }
            for (int i = 0; currentProduction < maxUnits && i < 2; ++i) {
                for (RepairRule repairRule : rrules) {
                    for (Territory fixTerr : rfactories) {
                        if (!Matches.territoryHasOwnedFactory(data, player).match(fixTerr) || currentProduction >= maxUnits) continue;
                        TerritoryAttachment ta2 = TerritoryAttachment.get(fixTerr);
                        diff = ta2.getProduction() - ta2.getUnitProduction();
                        if (i == 0) {
                            diff = ta2.getUnitProduction() < 0 ? Math.min(diff, maxUnits - currentProduction - ta2.getUnitProduction()) : Math.min(diff, maxUnits - currentProduction);
                        }
                        if ((diff = Math.min(diff, leftToSpend - 3)) <= 0) continue;
                        currentProduction = ta2.getUnitProduction() >= 0 ? (currentProduction += diff) : (currentProduction += diff + ta2.getUnitProduction());
                        repairMap.add(repairRule, diff);
                        repair.put(Match.getMatches(fixTerr.getUnits().getUnits(), Matches.UnitIsFactoryOrCanBeDamaged).iterator().next(), repairMap);
                        purchaseDelegate.purchaseRepair(repair);
                        repair.clear();
                        repairMap.clear();
                        maxUnits = ((leftToSpend -= diff) - 1) / 3;
                    }
                }
                rfactories.add(capitol);
            }
        } else if (player.getRepairFrontier() != null && Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(data)) {
            int n;
            void var30_55;
            rrules = player.getRepairFrontier().getRules();
            repairMap = new IntegerMap();
            repair = new HashMap();
            ArrayList<Object> unitsThatCanProduceNeedingRepair = new ArrayList<Object>();
            ArrayList<Unit> unitsThatAreDisabledNeedingRepair = new ArrayList<Unit>();
            CompositeMatchAnd ourDisabled = new CompositeMatchAnd(Matches.unitIsOwnedBy(player), Matches.UnitIsDisabled());
            int minimumUnitPrice = 3;
            int diff = 0;
            int totalDamage = 0;
            int capDamage = 0;
            int capProduction = 0;
            Object var30_54 = null;
            int n2 = (totPU - 1) / 3;
            int currentProduction = 0;
            int maxProduction = 0;
            Collections.shuffle(rfactories);
            for (Territory territory : rfactories) {
                if (!Matches.territoryHasOwnedFactory(data, player).match(territory)) continue;
                Unit unit = TripleAUnit.getBiggestProducer(Match.getMatches(territory.getUnits().getUnits(), ourFactories), territory, player, data, false);
                if (Matches.UnitHasSomeUnitDamage().match(unit)) {
                    unitsThatCanProduceNeedingRepair.add(unit);
                }
                unitsThatAreDisabledNeedingRepair.addAll(Match.getMatches(territory.getUnits().getUnits(), ourDisabled));
                TripleAUnit taUnit = (TripleAUnit)unit;
                maxProduction += TripleAUnit.getHowMuchCanUnitProduce(unit, territory, player, data, false, true);
                diff = taUnit.getUnitDamage();
                totalDamage += diff;
                if (territory == capitol) {
                    capDamage += diff;
                    capProduction = TripleAUnit.getHowMuchCanUnitProduce(unit, territory, player, data, true, true);
                    Unit unit2 = unit;
                }
                currentProduction += TripleAUnit.getHowMuchCanUnitProduce(unit, territory, player, data, true, true);
            }
            rfactories.remove(capitol);
            unitsThatCanProduceNeedingRepair.remove(var30_55);
            if ((capProduction <= n2 / 2 || rfactories.isEmpty()) && var30_55 != null) {
                for (RepairRule repairRule : rrules) {
                    int n3;
                    if (var30_55 == null || !var30_55.getUnitType().equals(repairRule.getResults().keySet().iterator().next()) || !Matches.territoryHasOwnedFactory(data, player).match(capitol)) continue;
                    TripleAUnit tripleAUnit = (TripleAUnit)var30_55;
                    diff = tripleAUnit.getUnitDamage();
                    int unitProductionAllowNegative = TripleAUnit.getHowMuchCanUnitProduce((Unit)var30_55, var30_55.getTerritoryUnitIsIn(), player, data, false, true) - diff;
                    diff = !rfactories.isEmpty() ? Math.min(diff, (int)(n3 / 2 - unitProductionAllowNegative + true)) : Math.min(diff, (int)(n3 - unitProductionAllowNegative));
                    if ((diff = Math.min(diff, leftToSpend - 3)) <= 0) continue;
                    currentProduction = unitProductionAllowNegative >= 0 ? (currentProduction += diff) : (currentProduction += diff + unitProductionAllowNegative);
                    repairMap.add(repairRule, diff);
                    repair.put((Unit)var30_55, repairMap);
                    purchaseDelegate.purchaseRepair(repair);
                    repair.clear();
                    repairMap.clear();
                    n3 = ((leftToSpend -= diff) - 1) / 3;
                }
            }
            for (int i = 0; currentProduction < n && i < 2; ++i) {
                for (RepairRule repairRule : rrules) {
                    for (Unit fixUnit : unitsThatCanProduceNeedingRepair) {
                        if (fixUnit == null || !fixUnit.getType().equals(repairRule.getResults().keySet().iterator().next()) || !Matches.territoryHasOwnedFactory(data, player).match(fixUnit.getTerritoryUnitIsIn()) || currentProduction >= n) continue;
                        TripleAUnit taUnit = (TripleAUnit)fixUnit;
                        diff = taUnit.getUnitDamage();
                        int unitProductionAllowNegative = TripleAUnit.getHowMuchCanUnitProduce(fixUnit, fixUnit.getTerritoryUnitIsIn(), player, data, false, true) - diff;
                        if (i == 0) {
                            diff = unitProductionAllowNegative < 0 ? Math.min(diff, (int)(n - currentProduction - unitProductionAllowNegative)) : Math.min(diff, (int)(n - currentProduction));
                        }
                        if ((diff = Math.min(diff, leftToSpend - 3)) <= 0) continue;
                        currentProduction = unitProductionAllowNegative >= 0 ? (currentProduction += diff) : (currentProduction += diff + unitProductionAllowNegative);
                        repairMap.add(repairRule, diff);
                        repair.put(fixUnit, repairMap);
                        purchaseDelegate.purchaseRepair(repair);
                        repair.clear();
                        repairMap.clear();
                        n = ((leftToSpend -= diff) - 1) / 3;
                    }
                }
                rfactories.add(capitol);
                if (var30_55 == null) continue;
                unitsThatCanProduceNeedingRepair.add(var30_55);
            }
        }
        int minCost = Integer.MAX_VALUE;
        int i = 0;
        while ((minCost == Integer.MAX_VALUE || leftToSpend >= minCost) && i < 100000) {
            ++i;
            for (ProductionRule rule : rules) {
                boolean bl;
                boolean isTransport;
                int cost;
                UnitType results = (UnitType)rule.getResults().keySet().iterator().next();
                if (Matches.UnitTypeIsAir.match(results) || Matches.UnitTypeIsFactoryOrIsInfrastructure.match(results) || Matches.UnitTypeIsAAforAnything.match(results) || Matches.UnitTypeHasMaxBuildRestrictions.match(results) || Matches.UnitTypeConsumesUnitsOnCreation.match(results) || Matches.unitTypeIsStatic(player).match(results)) continue;
                int transportCapacity = UnitAttachment.get(results).getTransportCapacity();
                if (Matches.UnitTypeIsSea.match(results) && (!isAmphib || transportCapacity <= 0) || (cost = rule.getCosts().getInt(PUs)) < 1) continue;
                if (minCost == Integer.MAX_VALUE) {
                    minCost = cost;
                }
                if (minCost > cost) {
                    minCost = cost;
                }
                int goodNumberOfTransports = 0;
                boolean bl2 = isTransport = transportCapacity > 0;
                if (amphibRoute != null) {
                    goodNumberOfTransports = landUnitCount / 4;
                    if (isTransport && defUnitsAtAmpibRoute > goodNumberOfTransports && landUnitCount > defUnitsAtAmpibRoute && defUnitsAtAmpibRoute > transportCount) {
                        int transports = leftToSpend / cost;
                        leftToSpend -= cost * transports;
                        purchase.add(rule, transports);
                        continue;
                    }
                }
                boolean buyBecauseTransport = Math.random() < 0.7 && transportCount < goodNumberOfTransports || Math.random() < 0.1;
                boolean bl3 = bl = transportCount > 2 * goodNumberOfTransports;
                if (!(!isTransport && Math.random() * (double)cost < 2.0) && (!isTransport || !buyBecauseTransport || bl) || cost > leftToSpend) continue;
                leftToSpend -= cost;
                purchase.add(rule, 1);
            }
        }
        purchaseDelegate.purchase(purchase);
    }

    @Override
    protected void place(boolean bid, IAbstractPlaceDelegate placeDelegate, GameData data, PlayerID player) {
        if (player.getUnits().size() == 0) {
            return;
        }
        Territory capitol = TerritoryAttachment.getCapital(player, data);
        this.placeAllWeCanOn(data, capitol, placeDelegate, player);
        ArrayList<Territory> randomTerritories = new ArrayList<Territory>(data.getMap().getTerritories());
        Collections.shuffle(randomTerritories);
        for (Territory t : randomTerritories) {
            if (t == capitol || !t.getOwner().equals(player) || !t.getUnits().someMatch(Matches.UnitIsFactory)) continue;
            this.placeAllWeCanOn(data, t, placeDelegate, player);
        }
    }

    private void placeAllWeCanOn(GameData data, Territory placeAt, IAbstractPlaceDelegate placeDelegate, PlayerID player) {
        ArrayList<Unit> landUnits;
        ArrayList<Unit> seaUnits;
        PlaceableUnits pu = placeDelegate.getPlaceableUnits(player.getUnits().getUnits(), placeAt);
        if (pu.getErrorMessage() != null) {
            return;
        }
        int placementLeft = pu.getMaxUnits();
        if (placementLeft == -1) {
            placementLeft = Integer.MAX_VALUE;
        }
        if ((seaUnits = new ArrayList<Unit>(player.getUnits().getMatches(Matches.UnitIsSea))).size() > 0) {
            Route amphibRoute = this.getAmphibRoute(player);
            Territory seaPlaceAt = null;
            if (amphibRoute != null) {
                seaPlaceAt = amphibRoute.getTerritories().get(1);
            } else {
                Set<Territory> seaNeighbors = data.getMap().getNeighbors(placeAt, Matches.TerritoryIsWater);
                if (!seaNeighbors.isEmpty()) {
                    seaPlaceAt = seaNeighbors.iterator().next();
                }
            }
            if (seaPlaceAt != null) {
                int seaPlacement = Math.min(placementLeft, seaUnits.size());
                placementLeft -= seaPlacement;
                List<Unit> toPlace = seaUnits.subList(0, seaPlacement);
                this.doPlace(seaPlaceAt, toPlace, placeDelegate);
            }
        }
        if (!(landUnits = new ArrayList<Unit>(player.getUnits().getMatches(Matches.UnitIsLand))).isEmpty()) {
            int landPlaceCount = Math.min(placementLeft, landUnits.size());
            placementLeft -= landPlaceCount;
            List<Unit> toPlace = landUnits.subList(0, landPlaceCount);
            this.doPlace(placeAt, toPlace, placeDelegate);
        }
    }

    private void doPlace(Territory where, Collection<Unit> toPlace, IAbstractPlaceDelegate del) {
        String message = del.placeUnits(new ArrayList<Unit>(toPlace), where);
        if (message != null) {
            s_logger.fine(message);
            s_logger.fine("Attempt was at:" + where + " with:" + toPlace);
        }
        this.pause();
    }

    @Override
    public CasualtyDetails selectCasualties(Collection<Unit> selectFrom, Map<Unit, Collection<Unit>> dependents, int count, String message, DiceRoll dice, PlayerID hit, CasualtyList defaultCasualties, GUID battleID) {
        ArrayList<Unit> rDamaged = new ArrayList<Unit>();
        ArrayList<Unit> rKilled = new ArrayList<Unit>();
        rDamaged.addAll(defaultCasualties.getDamaged());
        rKilled.addAll(defaultCasualties.getKilled());
        CasualtyDetails m2 = new CasualtyDetails(rKilled, rDamaged, false);
        return m2;
    }

    @Override
    public boolean shouldBomberBomb(Territory territory) {
        return true;
    }

    @Override
    public Unit whatShouldBomberBomb(Territory territory, Collection<Unit> units) {
        if (units == null || units.isEmpty()) {
            return null;
        }
        if (!Match.someMatch(units, Matches.UnitIsFactoryOrCanProduceUnits)) {
            return units.iterator().next();
        }
        if (Match.someMatch(units, Matches.UnitIsFactory)) {
            return Match.getMatches(units, Matches.UnitIsFactory).iterator().next();
        }
        return Match.getMatches(units, Matches.UnitCanProduceUnits).iterator().next();
    }

    @Override
    public Collection<Unit> getNumberOfFightersToMoveToNewCarrier(Collection<Unit> fightersThatCanBeMoved, Territory from) {
        ArrayList<Unit> rVal = new ArrayList<Unit>();
        for (Unit fighter : fightersThatCanBeMoved) {
            if (!(Math.random() < 0.8)) continue;
            rVal.add(fighter);
        }
        return rVal;
    }

    @Override
    public Territory selectTerritoryForAirToLand(Collection<Territory> candidates, Territory currentTerritory, String unitMessage) {
        return candidates.iterator().next();
    }

    @Override
    public boolean confirmMoveInFaceOfAA(Collection<Territory> aaFiringTerritories) {
        return true;
    }

    @Override
    public Territory retreatQuery(GUID battleID, boolean submerge, Collection<Territory> possibleTerritories, String message) {
        return null;
    }

    @Override
    public HashMap<Territory, Collection<Unit>> scrambleUnitsQuery(Territory scrambleTo, Map<Territory, Tuple<Integer, Collection<Unit>>> possibleScramblers) {
        return null;
    }

    @Override
    public Collection<Unit> selectUnitsQuery(Territory current, Collection<Unit> possible, String message) {
        return null;
    }

    @Override
    public int[] selectFixedDice(int numRolls, int hitAt, boolean hitOnlyIfEquals, String message, int diceSides) {
        int[] dice = new int[numRolls];
        for (int i = 0; i < numRolls; ++i) {
            dice[i] = (int)Math.ceil(Math.random() * (double)diceSides);
        }
        return dice;
    }
}

