/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.triplea.attatchments.AbstractRulesAttachment;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.util.IntegerMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPlayerRulesAttachment
extends AbstractRulesAttachment {
    private static final long serialVersionUID = 7224407193725789143L;
    protected String m_movementRestrictionType = null;
    protected String[] m_movementRestrictionTerritories;
    protected boolean m_placementAnyTerritory = false;
    protected boolean m_placementAnySeaZone = false;
    protected boolean m_placementCapturedTerritory = false;
    protected boolean m_unlimitedProduction = false;
    protected boolean m_placementInCapitalRestricted = false;
    protected boolean m_dominatingFirstRoundAttack = false;
    protected boolean m_negateDominatingFirstRoundAttack = false;
    protected IntegerMap<UnitType> m_productionPerXTerritories = new IntegerMap();
    protected int m_placementPerTerritory = -1;
    protected int m_maxPlacePerTerritory = -1;

    public AbstractPlayerRulesAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    public static RulesAttachment get(PlayerID player) {
        RulesAttachment rVal = (RulesAttachment)player.getAttachment("rulesAttatchment");
        if (rVal == null) {
            throw new IllegalStateException("Rules & Conditions: No rule attachment for:" + player.getName());
        }
        return rVal;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMovementRestrictionTerritories(String value) throws GameParseException {
        if (value == null) {
            this.m_movementRestrictionTerritories = null;
            return;
        }
        this.m_movementRestrictionTerritories = value.split(":");
        this.validateNames(this.m_movementRestrictionTerritories);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMovementRestrictionTerritories(String[] value) {
        this.m_movementRestrictionTerritories = value;
    }

    public String[] getMovementRestrictionTerritories() {
        return this.m_movementRestrictionTerritories;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMovementRestrictionType(String value) throws GameParseException {
        if (value == null) {
            this.m_movementRestrictionType = null;
            return;
        }
        if (!value.equals("disallowed") && !value.equals("allowed")) {
            throw new GameParseException("movementRestrictionType must be allowed or disallowed" + this.thisErrorMsg());
        }
        this.m_movementRestrictionType = value;
    }

    public String getMovementRestrictionType() {
        return this.m_movementRestrictionType;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setProductionPerXTerritories(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length <= 0 || s.length > 2) {
            throw new GameParseException("productionPerXTerritories can not be empty or have more than two fields" + this.thisErrorMsg());
        }
        String unitTypeToProduce = s.length == 1 ? "infantry" : s[1];
        UnitType ut = this.getData().getUnitTypeList().getUnitType(unitTypeToProduce);
        if (ut == null) {
            throw new GameParseException("No unit called: " + unitTypeToProduce + this.thisErrorMsg());
        }
        int n = AbstractPlayerRulesAttachment.getInt(s[0]);
        if (n <= 0) {
            throw new GameParseException("productionPerXTerritories must be a positive integer" + this.thisErrorMsg());
        }
        this.m_productionPerXTerritories.put(ut, n);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setProductionPerXTerritories(IntegerMap<UnitType> value) {
        this.m_productionPerXTerritories = value;
    }

    public IntegerMap<UnitType> getProductionPerXTerritories() {
        return this.m_productionPerXTerritories;
    }

    public void clearProductionPerXTerritories() {
        this.m_productionPerXTerritories.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlacementPerTerritory(String value) {
        this.m_placementPerTerritory = AbstractPlayerRulesAttachment.getInt(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlacementPerTerritory(Integer value) {
        this.m_placementPerTerritory = value;
    }

    public int getPlacementPerTerritory() {
        return this.m_placementPerTerritory;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMaxPlacePerTerritory(String value) {
        this.m_maxPlacePerTerritory = AbstractPlayerRulesAttachment.getInt(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setMaxPlacePerTerritory(Integer value) {
        this.m_maxPlacePerTerritory = value;
    }

    public int getMaxPlacePerTerritory() {
        return this.m_maxPlacePerTerritory;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlacementAnyTerritory(String value) {
        this.m_placementAnyTerritory = AbstractPlayerRulesAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlacementAnyTerritory(Boolean value) {
        this.m_placementAnyTerritory = value;
    }

    public boolean getPlacementAnyTerritory() {
        return this.m_placementAnyTerritory;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlacementAnySeaZone(String value) {
        this.m_placementAnySeaZone = AbstractPlayerRulesAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlacementAnySeaZone(Boolean value) {
        this.m_placementAnySeaZone = value;
    }

    public boolean getPlacementAnySeaZone() {
        return this.m_placementAnySeaZone;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlacementCapturedTerritory(String value) {
        this.m_placementCapturedTerritory = AbstractPlayerRulesAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlacementCapturedTerritory(Boolean value) {
        this.m_placementCapturedTerritory = value;
    }

    public boolean getPlacementCapturedTerritory() {
        return this.m_placementCapturedTerritory;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlacementInCapitalRestricted(String value) {
        this.m_placementInCapitalRestricted = AbstractPlayerRulesAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlacementInCapitalRestricted(Boolean value) {
        this.m_placementInCapitalRestricted = value;
    }

    public boolean getPlacementInCapitalRestricted() {
        return this.m_placementInCapitalRestricted;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUnlimitedProduction(String value) {
        this.m_unlimitedProduction = AbstractPlayerRulesAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUnlimitedProduction(Boolean value) {
        this.m_unlimitedProduction = value;
    }

    public boolean getUnlimitedProduction() {
        return this.m_unlimitedProduction;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDominatingFirstRoundAttack(String value) {
        this.m_dominatingFirstRoundAttack = AbstractPlayerRulesAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDominatingFirstRoundAttack(Boolean value) {
        this.m_dominatingFirstRoundAttack = value;
    }

    public boolean getDominatingFirstRoundAttack() {
        return this.m_dominatingFirstRoundAttack;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setNegateDominatingFirstRoundAttack(String value) {
        this.m_negateDominatingFirstRoundAttack = AbstractPlayerRulesAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setNegateDominatingFirstRoundAttack(Boolean value) {
        this.m_negateDominatingFirstRoundAttack = value;
    }

    public boolean getNegateDominatingFirstRoundAttack() {
        return this.m_negateDominatingFirstRoundAttack;
    }

    @Override
    public void validate(GameData data) throws GameParseException {
        super.validate(data);
        this.validateNames(this.m_movementRestrictionTerritories);
    }
}

