/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.engine.data.annotations.InternalDoNotExport;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.AbstractConditionsAttachment;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoliticalActionAttachment
extends AbstractConditionsAttachment
implements ICondition {
    private static final long serialVersionUID = 4392770599777282477L;
    public static final String ATTEMPTS_LEFT_THIS_TURN = "attemptsLeftThisTurn";
    private ArrayList<String> m_relationshipChange = new ArrayList();
    private String m_text = "";
    private int m_costPU = 0;
    private int m_attemptsPerTurn = 1;
    @InternalDoNotExport
    private int m_attemptsLeftThisTurn = 1;
    private ArrayList<PlayerID> m_actionAccept = new ArrayList();

    public PoliticalActionAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    public static Collection<PoliticalActionAttachment> getPoliticalActionAttachments(PlayerID player) {
        ArrayList<PoliticalActionAttachment> returnList = new ArrayList<PoliticalActionAttachment>();
        Map<String, IAttachment> map = player.getAttachments();
        Iterator<String> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            IAttachment a = map.get(iter.next());
            if (!(a instanceof PoliticalActionAttachment)) continue;
            returnList.add((PoliticalActionAttachment)a);
        }
        return returnList;
    }

    public static PoliticalActionAttachment get(PlayerID player, String nameOfAttachment) {
        PoliticalActionAttachment rVal = (PoliticalActionAttachment)player.getAttachment(nameOfAttachment);
        if (rVal == null) {
            throw new IllegalStateException("PoliticalActionAttachment: No attachment for:" + player.getName() + " with name: " + nameOfAttachment);
        }
        return rVal;
    }

    public static Match<PoliticalActionAttachment> isSatisfiedMatch(final HashMap<ICondition, Boolean> testedConditions) {
        return new Match<PoliticalActionAttachment>(){

            @Override
            public boolean match(PoliticalActionAttachment paa) {
                return paa.isSatisfied(testedConditions);
            }
        };
    }

    public boolean canPerform(HashMap<ICondition, Boolean> testedConditions) {
        return this.m_conditions == null || this.isSatisfied(testedConditions);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setRelationshipChange(String relChange) throws GameParseException {
        String[] s = relChange.split(":");
        if (s.length != 3) {
            throw new GameParseException("Invalid relationshipChange declaration: " + relChange + " \n Use: player1:player2:newRelation\n" + this.thisErrorMsg());
        }
        if (this.getData().getPlayerList().getPlayerID(s[0]) == null) {
            throw new GameParseException("Invalid relationshipChange declaration: " + relChange + " \n player: " + s[0] + " unknown in: " + this.getName() + this.thisErrorMsg());
        }
        if (this.getData().getPlayerList().getPlayerID(s[1]) == null) {
            throw new GameParseException("Invalid relationshipChange declaration: " + relChange + " \n player: " + s[1] + " unknown in: " + this.getName() + this.thisErrorMsg());
        }
        if (!Matches.isValidRelationshipName(this.getData()).match(s[2])) {
            throw new GameParseException("Invalid relationshipChange declaration: " + relChange + " \n relationshipType: " + s[2] + " unknown in: " + this.getName() + this.thisErrorMsg());
        }
        this.m_relationshipChange.add(relChange);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRelationshipChange(ArrayList<String> value) {
        this.m_relationshipChange = value;
    }

    public ArrayList<String> getRelationshipChange() {
        return this.m_relationshipChange;
    }

    public void clearRelationshipChange() {
        this.m_relationshipChange.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setText(String text) {
        this.m_text = text;
    }

    public String getText() {
        return this.m_text;
    }

    public int toHit() {
        return PoliticalActionAttachment.getInt(this.getChance().split(":")[0]);
    }

    public int diceSides() {
        return PoliticalActionAttachment.getInt(this.getChance().split(":")[1]);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCostPU(String s) {
        this.m_costPU = PoliticalActionAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCostPU(Integer s) {
        this.m_costPU = s;
    }

    public int getCostPU() {
        return this.m_costPU;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAttemptsPerTurn(String s) {
        this.m_attemptsPerTurn = PoliticalActionAttachment.getInt(s);
        this.setAttemptsLeftThisTurn(this.m_attemptsPerTurn);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAttemptsPerTurn(Integer s) {
        this.m_attemptsPerTurn = s;
        this.setAttemptsLeftThisTurn(this.m_attemptsPerTurn);
    }

    public int getAttemptsPerTurn() {
        return this.m_attemptsPerTurn;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setAttemptsLeftThisTurn(int attempts) {
        this.m_attemptsLeftThisTurn = attempts;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setAttemptsLeftThisTurn(Integer attempts) {
        this.m_attemptsLeftThisTurn = attempts;
    }

    public int getAttemptsLeftThisTurn() {
        return this.m_attemptsLeftThisTurn;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setActionAccept(String value) throws GameParseException {
        String[] temp;
        for (String name : temp = value.split(":")) {
            PlayerID tempPlayer = this.getData().getPlayerList().getPlayerID(name);
            if (tempPlayer == null) {
                throw new GameParseException("No player named: " + name + this.thisErrorMsg());
            }
            this.m_actionAccept.add(tempPlayer);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setActionAccept(ArrayList<PlayerID> value) {
        this.m_actionAccept = value;
    }

    public ArrayList<PlayerID> getActionAccept() {
        return this.m_actionAccept;
    }

    public void clearActionAccept() {
        this.m_actionAccept.clear();
    }

    public Set<PlayerID> getOtherPlayers() {
        HashSet<PlayerID> otherPlayers = new HashSet<PlayerID>();
        for (String relationshipChange : this.m_relationshipChange) {
            String[] s = relationshipChange.split(":");
            otherPlayers.add(this.getData().getPlayerList().getPlayerID(s[0]));
            otherPlayers.add(this.getData().getPlayerList().getPlayerID(s[1]));
        }
        otherPlayers.remove(this.getAttachedTo());
        return otherPlayers;
    }

    public static Collection<PoliticalActionAttachment> getValidActions(PlayerID player, HashMap<ICondition, Boolean> testedConditions, GameData data) {
        if (!Properties.getUsePolitics(data) || !player.amNotDeadYet(data)) {
            return new ArrayList<PoliticalActionAttachment>();
        }
        return Match.getMatches(PoliticalActionAttachment.getPoliticalActionAttachments(player), new CompositeMatchAnd(Matches.PoliticalActionCanBeAttempted(testedConditions), Matches.politicalActionAffectsAtLeastOneAlivePlayer(player, data)));
    }

    public void resetAttempts(IDelegateBridge aBridge) {
        if (this.m_attemptsLeftThisTurn != this.m_attemptsPerTurn) {
            aBridge.addChange(ChangeFactory.attachmentPropertyChange(this, this.m_attemptsPerTurn, ATTEMPTS_LEFT_THIS_TURN));
        }
    }

    public void useAttempt(IDelegateBridge aBridge) {
        aBridge.addChange(ChangeFactory.attachmentPropertyChange(this, this.m_attemptsLeftThisTurn - 1, ATTEMPTS_LEFT_THIS_TURN));
    }

    public boolean hasAttemptsLeft() {
        return this.m_attemptsLeftThisTurn > 0;
    }

    @Override
    public void validate(GameData data) throws GameParseException {
        super.validate(data);
        if (this.m_relationshipChange.isEmpty()) {
            throw new GameParseException("value: relationshipChange can't be empty" + this.thisErrorMsg());
        }
        if (this.m_text.equals("")) {
            throw new GameParseException("value: text can't be empty" + this.thisErrorMsg());
        }
    }
}

