/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.DefaultAttachment;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.ResourceCollection;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.engine.data.annotations.InternalDoNotExport;
import games.strategy.triplea.Properties;
import games.strategy.triplea.formatter.MyFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerritoryAttachment
extends DefaultAttachment {
    private String m_capital = null;
    private boolean m_originalFactory = false;
    private int m_production = 0;
    private boolean m_victoryCity = false;
    private boolean m_isImpassible = false;
    @InternalDoNotExport
    private PlayerID m_originalOwner = null;
    private PlayerID m_occupiedTerrOf = null;
    private boolean m_convoyRoute = false;
    private HashSet<Territory> m_convoyAttached = new HashSet();
    private ArrayList<PlayerID> m_changeUnitOwners = new ArrayList();
    private ArrayList<PlayerID> m_captureUnitOnEnteringBy = new ArrayList();
    private boolean m_navalBase = false;
    private boolean m_airBase = false;
    private boolean m_kamikazeZone = false;
    private int m_unitProduction = 0;
    private boolean m_blockadeZone = false;
    private ArrayList<TerritoryEffect> m_territoryEffect = new ArrayList();
    private ArrayList<String> m_whenCapturedByGoesTo = new ArrayList();
    private ResourceCollection m_resources = null;

    public static Territory getCapital(PlayerID player, GameData data) {
        for (Territory current : data.getMap().getTerritories()) {
            TerritoryAttachment ta = TerritoryAttachment.get(current);
            if (ta == null || ta.getCapital() == null) continue;
            PlayerID whoseCapital = data.getPlayerList().getPlayerID(ta.getCapital());
            if (whoseCapital == null) {
                throw new IllegalStateException("Invalid capital for player name:" + ta.getCapital());
            }
            if (!player.equals(whoseCapital)) continue;
            return current;
        }
        if (player.getOptional()) {
            return null;
        }
        throw new IllegalStateException("Capital not found for:" + player);
    }

    public static List<Territory> getAllCapitals(PlayerID player, GameData data) {
        ArrayList<Territory> capitals = new ArrayList<Territory>();
        for (Territory current : data.getMap().getTerritories()) {
            TerritoryAttachment ta = TerritoryAttachment.get(current);
            if (ta == null || ta.getCapital() == null) continue;
            PlayerID whoseCapital = data.getPlayerList().getPlayerID(ta.getCapital());
            if (whoseCapital == null) {
                throw new IllegalStateException("Invalid capital for player name:" + ta.getCapital());
            }
            if (!player.equals(whoseCapital)) continue;
            capitals.add(current);
        }
        if (!capitals.isEmpty()) {
            return capitals;
        }
        if (player.getOptional()) {
            return capitals;
        }
        throw new IllegalStateException("Capital not found for:" + player);
    }

    public static List<Territory> getAllCurrentlyOwnedCapitals(PlayerID player, GameData data) {
        ArrayList<Territory> capitals = new ArrayList<Territory>();
        for (Territory current : data.getMap().getTerritories()) {
            TerritoryAttachment ta = TerritoryAttachment.get(current);
            if (ta == null || ta.getCapital() == null) continue;
            PlayerID whoseCapital = data.getPlayerList().getPlayerID(ta.getCapital());
            if (whoseCapital == null) {
                throw new IllegalStateException("Invalid capital for player name:" + ta.getCapital());
            }
            if (!player.equals(whoseCapital) || !player.equals(current.getOwner())) continue;
            capitals.add(current);
        }
        return capitals;
    }

    public static TerritoryAttachment get(Territory t) {
        TerritoryAttachment rVal = (TerritoryAttachment)t.getAttachment("territoryAttatchment");
        if (rVal == null && !t.isWater()) {
            throw new IllegalStateException("No territory attachment for:" + t.getName());
        }
        return rVal;
    }

    public static TerritoryAttachment get(Territory t, String nameOfAttachment) {
        TerritoryAttachment rVal = (TerritoryAttachment)t.getAttachment(nameOfAttachment);
        if (rVal == null && !t.isWater()) {
            throw new IllegalStateException("No territory attachment for:" + t.getName() + " with name:" + nameOfAttachment);
        }
        return rVal;
    }

    public TerritoryAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setResources(String value) throws GameParseException {
        if (value == null) {
            this.m_resources = null;
            return;
        }
        if (this.m_resources == null) {
            this.m_resources = new ResourceCollection(this.getData());
        }
        String[] s = value.split(":");
        int amount = TerritoryAttachment.getInt(s[0]);
        if (s[1].equals("PUs")) {
            throw new GameParseException("Please set PUs using production, not resource" + this.thisErrorMsg());
        }
        Resource resource = this.getData().getResourceList().getResource(s[1]);
        if (resource == null) {
            throw new GameParseException("No resource named: " + s[1] + this.thisErrorMsg());
        }
        this.m_resources.putResource(resource, amount);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setResources(ResourceCollection value) {
        this.m_resources = value;
    }

    public ResourceCollection getResources() {
        return this.m_resources;
    }

    public void clearResources() {
        this.m_resources = new ResourceCollection(this.getData());
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsImpassible(String value) {
        this.m_isImpassible = TerritoryAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setIsImpassible(Boolean value) {
        this.m_isImpassible = value;
    }

    public boolean getIsImpassible() {
        return this.m_isImpassible;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCapital(String value) throws GameParseException {
        if (value == null) {
            this.m_capital = null;
            return;
        }
        PlayerID p = this.getData().getPlayerList().getPlayerID(value);
        if (p == null) {
            throw new GameParseException("No Player named: " + value + this.thisErrorMsg());
        }
        this.m_capital = value;
    }

    public boolean isCapital() {
        return this.m_capital != null;
    }

    public String getCapital() {
        return this.m_capital;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setVictoryCity(String value) {
        this.m_victoryCity = TerritoryAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setVictoryCity(Boolean value) {
        this.m_victoryCity = value;
    }

    public boolean getVictoryCity() {
        return this.m_victoryCity;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setOriginalFactory(String value) {
        this.m_originalFactory = TerritoryAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setOriginalFactory(Boolean value) {
        this.m_originalFactory = value;
    }

    public boolean getOriginalFactory() {
        return this.m_originalFactory;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setProduction(String value) {
        this.m_unitProduction = this.m_production = TerritoryAttachment.getInt(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setProduction(Integer value) {
        this.m_unitProduction = this.m_production = value.intValue();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setProductionOnly(String value) {
        this.m_production = TerritoryAttachment.getInt(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setProductionOnly(int value) {
        this.m_production = value;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setProductionOnly(Integer value) {
        this.m_production = value;
    }

    public int getProduction() {
        return this.m_production;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUnitProduction(Integer value) {
        this.m_unitProduction = value;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUnitProduction(String value) {
        this.m_unitProduction = Integer.parseInt(value);
    }

    public int getUnitProduction() {
        return this.m_unitProduction;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setOccupiedTerrOf(String value) {
        if (value == null) {
            this.m_occupiedTerrOf = null;
            return;
        }
        this.m_occupiedTerrOf = this.getData().getPlayerList().getPlayerID(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setOccupiedTerrOf(PlayerID value) {
        this.m_occupiedTerrOf = value;
    }

    public PlayerID getOccupiedTerrOf() {
        return this.m_occupiedTerrOf;
    }

    @GameProperty(xmlProperty=false, gameProperty=true, adds=false)
    public void setOriginalOwner(PlayerID player) {
        this.m_originalOwner = player;
    }

    public PlayerID getOriginalOwner() {
        return this.m_originalOwner;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setConvoyRoute(String value) {
        this.m_convoyRoute = TerritoryAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setConvoyRoute(Boolean value) {
        this.m_convoyRoute = value;
    }

    public boolean getConvoyRoute() {
        return this.m_convoyRoute;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setChangeUnitOwners(String value) throws GameParseException {
        String[] temp;
        for (String name : temp = value.split(":")) {
            PlayerID tempPlayer = this.getData().getPlayerList().getPlayerID(name);
            if (tempPlayer != null) {
                this.m_changeUnitOwners.add(tempPlayer);
                continue;
            }
            if (name.equalsIgnoreCase("true") || name.equalsIgnoreCase("false")) {
                this.m_changeUnitOwners.clear();
                continue;
            }
            throw new GameParseException("No player named: " + name + this.thisErrorMsg());
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setChangeUnitOwners(ArrayList<PlayerID> value) {
        this.m_changeUnitOwners = value;
    }

    public ArrayList<PlayerID> getChangeUnitOwners() {
        return this.m_changeUnitOwners;
    }

    public void clearChangeUnitOwners() {
        this.m_changeUnitOwners.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setCaptureUnitOnEnteringBy(String value) throws GameParseException {
        String[] temp;
        for (String name : temp = value.split(":")) {
            PlayerID tempPlayer = this.getData().getPlayerList().getPlayerID(name);
            if (tempPlayer == null) {
                throw new GameParseException("No player named: " + name + this.thisErrorMsg());
            }
            this.m_captureUnitOnEnteringBy.add(tempPlayer);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setCaptureUnitOnEnteringBy(ArrayList<PlayerID> value) {
        this.m_captureUnitOnEnteringBy = value;
    }

    public ArrayList<PlayerID> getCaptureUnitOnEnteringBy() {
        return this.m_captureUnitOnEnteringBy;
    }

    public void clearCaptureUnitOnEnteringBy() {
        this.m_captureUnitOnEnteringBy.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setWhenCapturedByGoesTo(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length != 2) {
            throw new GameParseException("whenCapturedByGoesTo must have 2 player names separated by a colon" + this.thisErrorMsg());
        }
        for (String name : s) {
            PlayerID player = this.getData().getPlayerList().getPlayerID(name);
            if (player != null) continue;
            throw new GameParseException("No player named: " + name + this.thisErrorMsg());
        }
        this.m_whenCapturedByGoesTo.add(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setWhenCapturedByGoesTo(ArrayList<String> value) {
        this.m_whenCapturedByGoesTo = value;
    }

    public ArrayList<String> getWhenCapturedByGoesTo() {
        return this.m_whenCapturedByGoesTo;
    }

    public void clearWhenCapturedByGoesTo() {
        this.m_whenCapturedByGoesTo.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setTerritoryEffect(String value) throws GameParseException {
        String[] s;
        for (String name : s = value.split(":")) {
            TerritoryEffect effect = this.getData().getTerritoryEffectList().get(name);
            if (effect == null) {
                throw new GameParseException("No TerritoryEffect named: " + name + this.thisErrorMsg());
            }
            this.m_territoryEffect.add(effect);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTerritoryEffect(ArrayList<TerritoryEffect> value) {
        this.m_territoryEffect = value;
    }

    public ArrayList<TerritoryEffect> getTerritoryEffect() {
        return this.m_territoryEffect;
    }

    public void clearTerritoryEffect() {
        this.m_territoryEffect.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setConvoyAttached(String value) throws GameParseException {
        if (value.length() <= 0) {
            return;
        }
        for (String subString : value.split(":")) {
            Territory territory = this.getData().getMap().getTerritory(subString);
            if (territory == null) {
                throw new GameParseException("No territory called:" + subString + this.thisErrorMsg());
            }
            this.m_convoyAttached.add(territory);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setConvoyAttached(HashSet<Territory> value) {
        this.m_convoyAttached = value;
    }

    public HashSet<Territory> getConvoyAttached() {
        return this.m_convoyAttached;
    }

    public void clearConvoyAttached() {
        this.m_convoyAttached.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setNavalBase(String value) {
        this.m_navalBase = TerritoryAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setNavalBase(Boolean value) {
        this.m_navalBase = value;
    }

    public boolean getNavalBase() {
        return this.m_navalBase;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAirBase(String value) {
        this.m_airBase = TerritoryAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAirBase(Boolean value) {
        this.m_airBase = value;
    }

    public boolean getAirBase() {
        return this.m_airBase;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setKamikazeZone(String value) {
        this.m_kamikazeZone = TerritoryAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setKamikazeZone(Boolean value) {
        this.m_kamikazeZone = value;
    }

    public boolean getKamikazeZone() {
        return this.m_kamikazeZone;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setBlockadeZone(String value) {
        this.m_blockadeZone = TerritoryAttachment.getBool(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setBlockadeZone(Boolean value) {
        this.m_blockadeZone = value;
    }

    public boolean getBlockadeZone() {
        return this.m_blockadeZone;
    }

    public static Set<Territory> getWhatTerritoriesThisIsUsedInConvoysFor(Territory t, GameData data) {
        HashSet<Territory> rVal = new HashSet<Territory>();
        TerritoryAttachment ta = TerritoryAttachment.get(t);
        if (ta == null || !ta.getConvoyRoute()) {
            return null;
        }
        for (Territory current : data.getMap().getTerritories()) {
            TerritoryAttachment cta = TerritoryAttachment.get(current);
            if (cta == null || !cta.getConvoyRoute() || !cta.getConvoyAttached().contains(t)) continue;
            rVal.add(current);
        }
        return rVal;
    }

    public String toStringForInfo(boolean useHTML, boolean includeAttachedToName) {
        Iterator<TerritoryEffect> iter;
        StringBuilder sb = new StringBuilder("");
        String br = useHTML ? "<br>" : ", ";
        Territory t = (Territory)this.getAttachedTo();
        if (t == null) {
            return sb.toString();
        }
        if (includeAttachedToName) {
            sb.append(t.getName());
            sb.append(br);
            if (t.isWater()) {
                sb.append("Water Territory");
            } else {
                sb.append("Land Territory");
            }
            sb.append(br);
            PlayerID owner = t.getOwner();
            if (owner != null && !owner.isNull()) {
                sb.append("Owned by " + t.getOwner().getName());
                sb.append(br);
            }
        }
        if (this.m_isImpassible) {
            sb.append("Is Impassable");
            sb.append(br);
        }
        if (this.m_capital != null && this.m_capital.length() > 0) {
            sb.append("A Capital of " + this.m_capital);
            sb.append(br);
        }
        if (this.m_victoryCity) {
            sb.append("Is a Victory location");
            sb.append(br);
        }
        if (this.m_kamikazeZone) {
            sb.append("Is Kamikaze Zone");
            sb.append(br);
        }
        if (this.m_blockadeZone) {
            sb.append("Is a Blockade Zone");
            sb.append(br);
        }
        if (this.m_convoyRoute) {
            Set<Territory> requiredBy;
            if (!this.m_convoyAttached.isEmpty()) {
                sb.append("Needs: " + MyFormatter.asList(this.m_convoyAttached) + br);
            }
            if (!(requiredBy = TerritoryAttachment.getWhatTerritoriesThisIsUsedInConvoysFor(t, this.getData())).isEmpty()) {
                sb.append("Required By: " + MyFormatter.asList(requiredBy) + br);
            }
        }
        if (!t.isWater() && this.m_production > 0 && Properties.getSBRAffectsUnitProduction(this.getData())) {
            sb.append("Unit Production: ");
            sb.append(this.m_unitProduction);
            sb.append(br);
        } else if (!t.isWater() && this.m_unitProduction > 0 && Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(this.getData())) {
            sb.append("Base Unit Production: ");
            sb.append(this.m_unitProduction);
            sb.append(br);
        }
        if (this.m_production > 0 || this.m_resources != null && this.m_resources.toString().length() > 0) {
            sb.append("Production: ");
            sb.append(br);
            if (this.m_production > 0) {
                sb.append("&nbsp;&nbsp;&nbsp;&nbsp;" + this.m_production + " PUs");
                sb.append(br);
            }
            if (this.m_resources != null) {
                if (useHTML) {
                    sb.append("&nbsp;&nbsp;&nbsp;&nbsp;" + this.m_resources.toStringForHTML().replaceAll("<br>", "<br>&nbsp;&nbsp;&nbsp;&nbsp;"));
                } else {
                    sb.append(this.m_resources.toString());
                }
                sb.append(br);
            }
        }
        if ((iter = this.m_territoryEffect.iterator()).hasNext()) {
            sb.append("Territory Effects: ");
            sb.append(br);
        }
        while (iter.hasNext()) {
            sb.append("&nbsp;&nbsp;&nbsp;&nbsp;" + iter.next().getName());
            sb.append(br);
        }
        return sb.toString();
    }

    @Override
    public void validate(GameData data) throws GameParseException {
    }
}

