/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.DefaultAttachment;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RelationshipType;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.TechnologyFrontier;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.engine.delegate.IDelegate;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.AbstractTriggerAttachment;
import games.strategy.triplea.attatchments.CanalAttachment;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.PoliticalActionAttachment;
import games.strategy.triplea.attatchments.RelationshipTypeAttachment;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.TerritoryEffectAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.attatchments.UnitSupportAttachment;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.EndRoundDelegate;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.triplea.ui.NotificationMessages;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerAttachment
extends AbstractTriggerAttachment
implements ICondition {
    private static final long serialVersionUID = -3327739180569606093L;
    private ProductionFrontier m_frontier = null;
    private ArrayList<String> m_productionRule = null;
    private ArrayList<TechAdvance> m_tech = new ArrayList();
    private HashMap<String, LinkedHashMap<TechAdvance, Boolean>> m_availableTech = null;
    private HashMap<Territory, IntegerMap<UnitType>> m_placement = null;
    private HashMap<Territory, IntegerMap<UnitType>> m_removeUnits = null;
    private IntegerMap<UnitType> m_purchase = null;
    private String m_resource = null;
    private int m_resourceCount = 0;
    private LinkedHashMap<UnitSupportAttachment, Boolean> m_support = null;
    private ArrayList<String> m_relationshipChange = new ArrayList();
    private String m_victory = null;
    private ArrayList<Tuple<TriggerAttachment, String>> m_activateTrigger = new ArrayList();
    private ArrayList<String> m_changeOwnership = new ArrayList();
    private ArrayList<UnitType> m_unitType = new ArrayList();
    private Tuple<String, String> m_unitAttachmentName = null;
    private ArrayList<Tuple<String, String>> m_unitProperty = null;
    private ArrayList<Territory> m_territories = new ArrayList();
    private Tuple<String, String> m_territoryAttachmentName = null;
    private ArrayList<Tuple<String, String>> m_territoryProperty = null;
    private ArrayList<PlayerID> m_players = new ArrayList();
    private Tuple<String, String> m_playerAttachmentName = null;
    private ArrayList<Tuple<String, String>> m_playerProperty = null;
    private ArrayList<RelationshipType> m_relationshipTypes = new ArrayList();
    private Tuple<String, String> m_relationshipTypeAttachmentName = null;
    private ArrayList<Tuple<String, String>> m_relationshipTypeProperty = null;
    private ArrayList<TerritoryEffect> m_territoryEffects = new ArrayList();
    private Tuple<String, String> m_territoryEffectAttachmentName = null;
    private ArrayList<Tuple<String, String>> m_territoryEffectProperty = null;

    public TriggerAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    public static TriggerAttachment get(PlayerID player, String nameOfAttachment) {
        TriggerAttachment rVal = (TriggerAttachment)player.getAttachment(nameOfAttachment);
        if (rVal == null) {
            throw new IllegalStateException("Triggers: No trigger attachment for:" + player.getName() + " with name: " + nameOfAttachment);
        }
        return rVal;
    }

    public static Set<TriggerAttachment> getTriggers(PlayerID player, GameData data, Match<TriggerAttachment> cond) {
        HashSet<TriggerAttachment> trigs = new HashSet<TriggerAttachment>();
        Map<String, IAttachment> map = player.getAttachments();
        Iterator<String> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            IAttachment a = map.get(iter.next());
            if (!(a instanceof TriggerAttachment) || cond != null && !cond.match((TriggerAttachment)a)) continue;
            trigs.add((TriggerAttachment)a);
        }
        return trigs;
    }

    public static void collectAndFireTriggers(HashSet<PlayerID> players, Match<TriggerAttachment> triggerMatch, IDelegateBridge aBridge, String beforeOrAfter, String stepName) {
        HashSet<TriggerAttachment> toFirePossible = TriggerAttachment.collectForAllTriggersMatching(players, triggerMatch, aBridge);
        if (toFirePossible.isEmpty()) {
            return;
        }
        HashMap<ICondition, Boolean> testedConditions = TriggerAttachment.collectTestsForAllTriggers(toFirePossible, aBridge);
        List<TriggerAttachment> toFireTestedAndSatisfied = Match.getMatches(toFirePossible, TriggerAttachment.isSatisfiedMatch(testedConditions));
        if (toFireTestedAndSatisfied.isEmpty()) {
            return;
        }
        TriggerAttachment.fireTriggers(new HashSet<TriggerAttachment>(toFireTestedAndSatisfied), testedConditions, aBridge, beforeOrAfter, stepName, true, true, true, true);
    }

    public static HashSet<TriggerAttachment> collectForAllTriggersMatching(HashSet<PlayerID> players, Match<TriggerAttachment> triggerMatch, IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        HashSet<TriggerAttachment> toFirePossible = new HashSet<TriggerAttachment>();
        for (PlayerID player : players) {
            toFirePossible.addAll(TriggerAttachment.getTriggers(player, data, triggerMatch));
        }
        return toFirePossible;
    }

    public static HashMap<ICondition, Boolean> collectTestsForAllTriggers(HashSet<TriggerAttachment> toFirePossible, IDelegateBridge aBridge) {
        return TriggerAttachment.collectTestsForAllTriggers(toFirePossible, aBridge, null, null);
    }

    public static HashMap<ICondition, Boolean> collectTestsForAllTriggers(HashSet<TriggerAttachment> toFirePossible, IDelegateBridge aBridge, HashSet<ICondition> allConditionsNeededSoFar, HashMap<ICondition, Boolean> allConditionsTestedSoFar) {
        HashSet<ICondition> allConditionsNeeded = RulesAttachment.getAllConditionsRecursive(new HashSet<ICondition>(toFirePossible), allConditionsNeededSoFar);
        return RulesAttachment.testAllConditionsRecursive(allConditionsNeeded, allConditionsTestedSoFar, aBridge);
    }

    public static void fireTriggers(HashSet<TriggerAttachment> triggersToBeFired, HashMap<ICondition, Boolean> testedConditionsSoFar, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        TriggerAttachment.triggerNotifications(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerPlayerPropertyChange(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerRelationshipTypePropertyChange(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerTerritoryPropertyChange(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerTerritoryEffectPropertyChange(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerUnitPropertyChange(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerRelationshipChange(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerAvailableTechChange(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerTechChange(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerProductionChange(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerProductionFrontierEditChange(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerSupportChange(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerChangeOwnership(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerUnitRemoval(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerPurchase(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerUnitPlacement(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerResourceChange(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerActivateTriggerOther(testedConditionsSoFar, triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        TriggerAttachment.triggerVictory(triggersToBeFired, aBridge, beforeOrAfter, stepName, useUses, testUses, testChance, testWhen);
        if (useUses) {
            TriggerAttachment.setUsesForWhenTriggers(triggersToBeFired, aBridge, useUses);
        }
    }

    protected static void setUsesForWhenTriggers(HashSet<TriggerAttachment> triggersToBeFired, IDelegateBridge aBridge, boolean useUses) {
        if (!useUses) {
            return;
        }
        CompositeChange change = new CompositeChange();
        for (TriggerAttachment trig : triggersToBeFired) {
            int currentUses = trig.getUses();
            if (currentUses <= 0 || trig.getWhen() == null) continue;
            change.add(ChangeFactory.attachmentPropertyChange(trig, Integer.toString(currentUses - 1), "uses"));
            if (!trig.getUsedThisRound()) continue;
            change.add(ChangeFactory.attachmentPropertyChange(trig, false, "usedThisRound"));
        }
        if (!change.isEmpty()) {
            aBridge.getHistoryWriter().startEvent("Setting uses for triggers used this phase.");
            aBridge.addChange(change);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setActivateTrigger(String value) throws GameParseException {
        String[] s = value.split(":");
        if (s.length != 6) {
            throw new GameParseException("activateTrigger must have 6 parts: triggerName:numberOfTimes:useUses:testUses:testConditions:testChance" + this.thisErrorMsg());
        }
        TriggerAttachment trigger = null;
        for (PlayerID player : this.getData().getPlayerList().getPlayers()) {
            for (TriggerAttachment ta : TriggerAttachment.getTriggers(player, this.getData(), null)) {
                if (!ta.getName().equals(s[0])) continue;
                trigger = ta;
                break;
            }
            if (trigger == null) continue;
            break;
        }
        if (trigger == null) {
            throw new GameParseException("No TriggerAttachment named: " + s[0] + this.thisErrorMsg());
        }
        if (trigger == this) {
            throw new GameParseException("Can not have a trigger activate itself!" + this.thisErrorMsg());
        }
        String options = value;
        options = options.replaceFirst(s[0] + ":", "");
        int numberOfTimes = TriggerAttachment.getInt(s[1]);
        if (numberOfTimes < 0) {
            throw new GameParseException("activateTrigger must be positive for the number of times to fire: " + s[1] + this.thisErrorMsg());
        }
        TriggerAttachment.getBool(s[2]);
        TriggerAttachment.getBool(s[3]);
        TriggerAttachment.getBool(s[4]);
        TriggerAttachment.getBool(s[5]);
        this.m_activateTrigger.add(new Tuple<TriggerAttachment, String>(trigger, options));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setActivateTrigger(ArrayList<Tuple<TriggerAttachment, String>> value) {
        this.m_activateTrigger = value;
    }

    public ArrayList<Tuple<TriggerAttachment, String>> getActivateTrigger() {
        return this.m_activateTrigger;
    }

    public void clearActivateTrigger() {
        this.m_activateTrigger.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setFrontier(String s) throws GameParseException {
        if (s == null) {
            this.m_frontier = null;
            return;
        }
        ProductionFrontier front = this.getData().getProductionFrontierList().getProductionFrontier(s);
        if (front == null) {
            throw new GameParseException("Could not find frontier. name:" + s + this.thisErrorMsg());
        }
        this.m_frontier = front;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setFrontier(ProductionFrontier value) {
        this.m_frontier = value;
    }

    public ProductionFrontier getFrontier() {
        return this.m_frontier;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setProductionRule(String prop) throws GameParseException {
        if (prop == null) {
            this.m_productionRule = null;
            return;
        }
        String[] s = prop.split(":");
        if (s.length != 2) {
            throw new GameParseException("Invalid productionRule declaration: " + prop + this.thisErrorMsg());
        }
        if (this.m_productionRule == null) {
            this.m_productionRule = new ArrayList();
        }
        if (this.getData().getProductionFrontierList().getProductionFrontier(s[0]) == null) {
            throw new GameParseException("Could not find frontier. name:" + s[0] + this.thisErrorMsg());
        }
        String rule = s[1];
        if (rule.startsWith("-")) {
            rule = rule.replaceFirst("-", "");
        }
        if (this.getData().getProductionRuleList().getProductionRule(rule) == null) {
            throw new GameParseException("Could not find production rule. name:" + rule + this.thisErrorMsg());
        }
        this.m_productionRule.add(prop);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setProductionRule(ArrayList<String> value) {
        this.m_productionRule = value;
    }

    public ArrayList<String> getProductionRule() {
        return this.m_productionRule;
    }

    public void clearProductionRule() {
        this.m_productionRule.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setResourceCount(String s) {
        this.m_resourceCount = TriggerAttachment.getInt(s);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setResourceCount(Integer s) {
        this.m_resourceCount = s;
    }

    public int getResourceCount() {
        return this.m_resourceCount;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setVictory(String s) {
        if (s == null) {
            this.m_victory = null;
            return;
        }
        this.m_victory = s;
    }

    public String getVictory() {
        return this.m_victory;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setTech(String techs) throws GameParseException {
        for (String subString : techs.split(":")) {
            TechAdvance ta = this.getData().getTechnologyFrontier().getAdvanceByProperty(subString);
            if (ta == null) {
                ta = this.getData().getTechnologyFrontier().getAdvanceByName(subString);
            }
            if (ta == null) {
                throw new GameParseException("Technology not found :" + subString + this.thisErrorMsg());
            }
            this.m_tech.add(ta);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTech(ArrayList<TechAdvance> value) {
        this.m_tech = value;
    }

    public ArrayList<TechAdvance> getTech() {
        return this.m_tech;
    }

    public void clearTech() {
        this.m_tech.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setAvailableTech(String techs) throws GameParseException {
        if (techs == null) {
            this.m_availableTech = null;
            return;
        }
        String[] s = techs.split(":");
        if (s.length < 2) {
            throw new GameParseException("Invalid tech availability: " + techs + " should be category:techs" + this.thisErrorMsg());
        }
        String cat = s[0];
        LinkedHashMap<TechAdvance, Boolean> tlist = new LinkedHashMap<TechAdvance, Boolean>();
        for (int i = 1; i < s.length; ++i) {
            TechAdvance ta;
            boolean add = true;
            if (s[i].startsWith("-")) {
                add = false;
                s[i] = s[i].substring(1);
            }
            if ((ta = this.getData().getTechnologyFrontier().getAdvanceByProperty(s[i])) == null) {
                ta = this.getData().getTechnologyFrontier().getAdvanceByName(s[i]);
            }
            if (ta == null) {
                throw new GameParseException("Technology not found :" + s[i] + this.thisErrorMsg());
            }
            tlist.put(ta, add);
        }
        if (this.m_availableTech == null) {
            this.m_availableTech = new HashMap();
        }
        if (this.m_availableTech.containsKey(cat)) {
            tlist.putAll((Map)this.m_availableTech.get(cat));
        }
        this.m_availableTech.put(cat, tlist);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setAvailableTech(HashMap<String, LinkedHashMap<TechAdvance, Boolean>> value) {
        this.m_availableTech = value;
    }

    public HashMap<String, LinkedHashMap<TechAdvance, Boolean>> getAvailableTech() {
        return this.m_availableTech;
    }

    public void clearAvailableTech() {
        this.m_availableTech.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setSupport(String sup) throws GameParseException {
        if (sup == null) {
            this.m_support = null;
            return;
        }
        String[] s = sup.split(":");
        for (int i = 0; i < s.length; ++i) {
            boolean add = true;
            if (s[i].startsWith("-")) {
                add = false;
                s[i] = s[i].substring(1);
            }
            boolean found = false;
            for (UnitSupportAttachment support : UnitSupportAttachment.get(this.getData())) {
                if (!support.getName().equals(s[i])) continue;
                found = true;
                if (this.m_support == null) {
                    this.m_support = new LinkedHashMap();
                }
                this.m_support.put(support, add);
                break;
            }
            if (found) continue;
            throw new GameParseException("Could not find unitSupportAttachment. name:" + s[i] + this.thisErrorMsg());
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setSupport(LinkedHashMap<UnitSupportAttachment, Boolean> value) {
        this.m_support = value;
    }

    public LinkedHashMap<UnitSupportAttachment, Boolean> getSupport() {
        return this.m_support;
    }

    public void clearSupport() {
        this.m_support.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setResource(String s) throws GameParseException {
        if (s == null) {
            this.m_resource = null;
            return;
        }
        Resource r = this.getData().getResourceList().getResource(s);
        if (r == null) {
            throw new GameParseException("Invalid resource: " + s + this.thisErrorMsg());
        }
        this.m_resource = s;
    }

    public String getResource() {
        return this.m_resource;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setRelationshipChange(String relChange) throws GameParseException {
        String[] s = relChange.split(":");
        if (s.length != 4) {
            throw new GameParseException("Invalid relationshipChange declaration: " + relChange + " \n Use: player1:player2:oldRelation:newRelation\n" + this.thisErrorMsg());
        }
        if (this.getData().getPlayerList().getPlayerID(s[0]) == null) {
            throw new GameParseException("Invalid relationshipChange declaration: " + relChange + " \n player: " + s[0] + " unknown " + this.thisErrorMsg());
        }
        if (this.getData().getPlayerList().getPlayerID(s[1]) == null) {
            throw new GameParseException("Invalid relationshipChange declaration: " + relChange + " \n player: " + s[1] + " unknown " + this.thisErrorMsg());
        }
        if (!(s[2].equals("anyNeutral") || s[2].equals("any") || s[2].equals("anyAllied") || s[2].equals("anyWar") || Matches.isValidRelationshipName(this.getData()).match(s[2]))) {
            throw new GameParseException("Invalid relationshipChange declaration: " + relChange + " \n relationshipType: " + s[2] + " unknown " + this.thisErrorMsg());
        }
        if (Matches.isValidRelationshipName(this.getData()).invert().match(s[3])) {
            throw new GameParseException("Invalid relationshipChange declaration: " + relChange + " \n relationshipType: " + s[3] + " unknown " + this.thisErrorMsg());
        }
        this.m_relationshipChange.add(relChange);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRelationshipChange(ArrayList<String> value) {
        this.m_relationshipChange = value;
    }

    public ArrayList<String> getRelationshipChange() {
        return this.m_relationshipChange;
    }

    public void clearRelationshipChange() {
        this.m_relationshipChange.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setUnitType(String names) throws GameParseException {
        String[] s = names.split(":");
        for (int i = 0; i < s.length; ++i) {
            UnitType type = this.getData().getUnitTypeList().getUnitType(s[i]);
            if (type == null) {
                throw new GameParseException("Could not find unitType. name:" + s[i] + this.thisErrorMsg());
            }
            this.m_unitType.add(type);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUnitType(ArrayList<UnitType> value) {
        this.m_unitType = value;
    }

    public ArrayList<UnitType> getUnitType() {
        return this.m_unitType;
    }

    public void clearUnitType() {
        this.m_unitType.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUnitAttachmentName(String name) throws GameParseException {
        if (name == null) {
            this.m_unitAttachmentName = null;
            return;
        }
        String[] s = name.split(":");
        if (s.length != 2) {
            throw new GameParseException("unitAttachmentName must have 2 entries, the type of attachment and the name of the attachment." + this.thisErrorMsg());
        }
        if (!s[1].equals("UnitAttachment") && !s[1].equals("UnitSupportAttachment")) {
            throw new GameParseException("unitAttachmentName value must be UnitAttachment or UnitSupportAttachment" + this.thisErrorMsg());
        }
        if (s[0].length() < 1) {
            throw new GameParseException("unitAttachmentName count must be a valid attachment name" + this.thisErrorMsg());
        }
        if (s[1].equals("UnitAttachment") && !s[0].startsWith("unitAttatchment")) {
            throw new GameParseException("attachment incorrectly named:" + s[0] + this.thisErrorMsg());
        }
        if (s[1].equals("UnitSupportAttachment") && !s[0].startsWith("supportAttachment")) {
            throw new GameParseException("attachment incorrectly named:" + s[0] + this.thisErrorMsg());
        }
        this.m_unitAttachmentName = new Tuple<String, String>(s[1], s[0]);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUnitAttachmentName(Tuple<String, String> value) {
        this.m_unitAttachmentName = value;
    }

    public Tuple<String, String> getUnitAttachmentName() {
        if (this.m_unitAttachmentName == null) {
            return new Tuple<String, String>("UnitAttachment", "unitAttatchment");
        }
        return this.m_unitAttachmentName;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setUnitProperty(String prop) throws GameParseException {
        if (prop == null) {
            this.m_unitProperty = null;
            return;
        }
        String[] s = prop.split(":");
        if (this.m_unitProperty == null) {
            this.m_unitProperty = new ArrayList();
        }
        String property = s[s.length - 1];
        this.m_unitProperty.add(new Tuple<String, String>(property, TriggerAttachment.getValueFromStringArrayForAllExceptLastSubstring(s)));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUnitProperty(ArrayList<Tuple<String, String>> value) {
        this.m_unitProperty = value;
    }

    public ArrayList<Tuple<String, String>> getUnitProperty() {
        return this.m_unitProperty;
    }

    public void clearUnitProperty() {
        this.m_unitProperty.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setTerritories(String names) throws GameParseException {
        String[] s = names.split(":");
        for (int i = 0; i < s.length; ++i) {
            Territory terr = this.getData().getMap().getTerritory(s[i]);
            if (terr == null) {
                throw new GameParseException("Could not find territory. name:" + s[i] + this.thisErrorMsg());
            }
            this.m_territories.add(terr);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTerritories(ArrayList<Territory> value) {
        this.m_territories = value;
    }

    public ArrayList<Territory> getTerritories() {
        return this.m_territories;
    }

    public void clearTerritories() {
        this.m_territories.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTerritoryAttachmentName(String name) throws GameParseException {
        if (name == null) {
            this.m_territoryAttachmentName = null;
            return;
        }
        String[] s = name.split(":");
        if (s.length != 2) {
            throw new GameParseException("territoryAttachmentName must have 2 entries, the type of attachment and the name of the attachment." + this.thisErrorMsg());
        }
        if (!s[1].equals("TerritoryAttachment") && !s[1].equals("CanalAttachment")) {
            throw new GameParseException("territoryAttachmentName value must be TerritoryAttachment or CanalAttachment" + this.thisErrorMsg());
        }
        if (s[0].length() < 1) {
            throw new GameParseException("territoryAttachmentName count must be a valid attachment name" + this.thisErrorMsg());
        }
        if (s[1].equals("TerritoryAttachment") && !s[0].startsWith("territoryAttatchment")) {
            throw new GameParseException("attachment incorrectly named:" + s[0] + this.thisErrorMsg());
        }
        if (s[1].equals("CanalAttachment") && !s[0].startsWith("canalAttatchment")) {
            throw new GameParseException("attachment incorrectly named:" + s[0] + this.thisErrorMsg());
        }
        this.m_territoryAttachmentName = new Tuple<String, String>(s[1], s[0]);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTerritoryAttachmentName(Tuple<String, String> value) {
        this.m_territoryAttachmentName = value;
    }

    public Tuple<String, String> getTerritoryAttachmentName() {
        if (this.m_territoryAttachmentName == null) {
            return new Tuple<String, String>("TerritoryAttachment", "territoryAttatchment");
        }
        return this.m_territoryAttachmentName;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setTerritoryProperty(String prop) throws GameParseException {
        if (prop == null) {
            this.m_territoryProperty = null;
            return;
        }
        String[] s = prop.split(":");
        if (this.m_territoryProperty == null) {
            this.m_territoryProperty = new ArrayList();
        }
        String property = s[s.length - 1];
        this.m_territoryProperty.add(new Tuple<String, String>(property, TriggerAttachment.getValueFromStringArrayForAllExceptLastSubstring(s)));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTerritoryProperty(ArrayList<Tuple<String, String>> value) {
        this.m_territoryProperty = value;
    }

    public ArrayList<Tuple<String, String>> getTerritoryProperty() {
        return this.m_territoryProperty;
    }

    public void clearTerritoryProperty() {
        this.m_territoryProperty.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setPlayers(String names) throws GameParseException {
        String[] s = names.split(":");
        for (int i = 0; i < s.length; ++i) {
            PlayerID player = this.getData().getPlayerList().getPlayerID(s[i]);
            if (player == null) {
                throw new GameParseException("Could not find player. name:" + s[i] + this.thisErrorMsg());
            }
            this.m_players.add(player);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlayers(ArrayList<PlayerID> value) {
        this.m_players = value;
    }

    public ArrayList<PlayerID> getPlayers() {
        if (this.m_players.isEmpty()) {
            return new ArrayList<PlayerID>(Collections.singletonList((PlayerID)this.getAttachedTo()));
        }
        return this.m_players;
    }

    public void clearPlayers() {
        this.m_players.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlayerAttachmentName(String name) throws GameParseException {
        if (name == null) {
            this.m_playerAttachmentName = null;
            return;
        }
        String[] s = name.split(":");
        if (s.length != 2) {
            throw new GameParseException("playerAttachmentName must have 2 entries, the type of attachment and the name of the attachment." + this.thisErrorMsg());
        }
        if (!(s[1].equals("PlayerAttachment") || s[1].equals("RulesAttachment") || s[1].equals("TriggerAttachment") || s[1].equals("TechAttachment") || s[1].equals("PoliticalActionAttachment"))) {
            throw new GameParseException("playerAttachmentName value must be PlayerAttachment or RulesAttachment or TriggerAttachment or TechAttachment or PoliticalActionAttachment" + this.thisErrorMsg());
        }
        if (s[0].length() < 1) {
            throw new GameParseException("playerAttachmentName count must be a valid attachment name" + this.thisErrorMsg());
        }
        if (s[1].equals("PlayerAttachment") && !s[0].startsWith("playerAttatchment")) {
            throw new GameParseException("attachment incorrectly named:" + s[0] + this.thisErrorMsg());
        }
        if (s[1].equals("RulesAttachment") && !s[0].startsWith("rulesAttatchment") && !s[0].startsWith("objectiveAttachment") && !s[0].startsWith("conditionAttachment")) {
            throw new GameParseException("attachment incorrectly named:" + s[0] + this.thisErrorMsg());
        }
        if (s[1].equals("TriggerAttachment") && !s[0].startsWith("triggerAttachment")) {
            throw new GameParseException("attachment incorrectly named:" + s[0] + this.thisErrorMsg());
        }
        if (s[1].equals("TechAttachment") && !s[0].startsWith("techAttatchment")) {
            throw new GameParseException("attachment incorrectly named:" + s[0] + this.thisErrorMsg());
        }
        if (s[1].equals("PoliticalActionAttachment") && !s[0].startsWith("politicalActionAttachment")) {
            throw new GameParseException("attachment incorrectly named:" + s[0] + this.thisErrorMsg());
        }
        this.m_playerAttachmentName = new Tuple<String, String>(s[1], s[0]);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlayerAttachmentName(Tuple<String, String> value) {
        this.m_playerAttachmentName = value;
    }

    public Tuple<String, String> getPlayerAttachmentName() {
        if (this.m_playerAttachmentName == null) {
            return new Tuple<String, String>("PlayerAttachment", "playerAttatchment");
        }
        return this.m_playerAttachmentName;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setPlayerProperty(String prop) throws GameParseException {
        if (prop == null) {
            this.m_playerProperty = null;
            return;
        }
        String[] s = prop.split(":");
        if (this.m_playerProperty == null) {
            this.m_playerProperty = new ArrayList();
        }
        String property = s[s.length - 1];
        this.m_playerProperty.add(new Tuple<String, String>(property, TriggerAttachment.getValueFromStringArrayForAllExceptLastSubstring(s)));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlayerProperty(ArrayList<Tuple<String, String>> value) {
        this.m_playerProperty = value;
    }

    public ArrayList<Tuple<String, String>> getPlayerProperty() {
        return this.m_playerProperty;
    }

    public void clearPlayerProperty() {
        this.m_playerProperty.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setRelationshipTypes(String names) throws GameParseException {
        String[] s = names.split(":");
        for (int i = 0; i < s.length; ++i) {
            RelationshipType relation = this.getData().getRelationshipTypeList().getRelationshipType(s[i]);
            if (relation == null) {
                throw new GameParseException("Could not find relationshipType. name:" + s[i] + this.thisErrorMsg());
            }
            this.m_relationshipTypes.add(relation);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRelationshipTypes(ArrayList<RelationshipType> value) {
        this.m_relationshipTypes = value;
    }

    public ArrayList<RelationshipType> getRelationshipTypes() {
        return this.m_relationshipTypes;
    }

    public void clearRelationshipTypes() {
        this.m_relationshipTypes.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRelationshipTypeAttachmentName(String name) throws GameParseException {
        if (name == null) {
            this.m_relationshipTypeAttachmentName = null;
            return;
        }
        String[] s = name.split(":");
        if (s.length != 2) {
            throw new GameParseException("relationshipTypeAttachmentName must have 2 entries, the type of attachment and the name of the attachment." + this.thisErrorMsg());
        }
        if (!s[1].equals("RelationshipTypeAttachment")) {
            throw new GameParseException("relationshipTypeAttachmentName value must be RelationshipTypeAttachment" + this.thisErrorMsg());
        }
        if (s[0].length() < 1) {
            throw new GameParseException("relationshipTypeAttachmentName count must be a valid attachment name" + this.thisErrorMsg());
        }
        if (s[1].equals("RelationshipTypeAttachment") && !s[0].startsWith("relationshipTypeAttachment")) {
            throw new GameParseException("attachment incorrectly named:" + s[0] + this.thisErrorMsg());
        }
        this.m_relationshipTypeAttachmentName = new Tuple<String, String>(s[1], s[0]);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRelationshipTypeAttachmentName(Tuple<String, String> value) {
        this.m_relationshipTypeAttachmentName = value;
    }

    public Tuple<String, String> getRelationshipTypeAttachmentName() {
        if (this.m_relationshipTypeAttachmentName == null) {
            return new Tuple<String, String>("RelationshipTypeAttachment", "relationshipTypeAttachment");
        }
        return this.m_relationshipTypeAttachmentName;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setRelationshipTypeProperty(String prop) throws GameParseException {
        if (prop == null) {
            this.m_relationshipTypeProperty = null;
            return;
        }
        String[] s = prop.split(":");
        if (this.m_relationshipTypeProperty == null) {
            this.m_relationshipTypeProperty = new ArrayList();
        }
        String property = s[s.length - 1];
        this.m_relationshipTypeProperty.add(new Tuple<String, String>(property, TriggerAttachment.getValueFromStringArrayForAllExceptLastSubstring(s)));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRelationshipTypeProperty(ArrayList<Tuple<String, String>> value) {
        this.m_relationshipTypeProperty = value;
    }

    public ArrayList<Tuple<String, String>> getRelationshipTypeProperty() {
        return this.m_relationshipTypeProperty;
    }

    public void clearRelationshipTypeProperty() {
        this.m_relationshipTypeProperty.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setTerritoryEffects(String names) throws GameParseException {
        String[] s = names.split(":");
        for (int i = 0; i < s.length; ++i) {
            TerritoryEffect effect = this.getData().getTerritoryEffectList().get(s[i]);
            if (effect == null) {
                throw new GameParseException("Could not find territoryEffect. name:" + s[i] + this.thisErrorMsg());
            }
            this.m_territoryEffects.add(effect);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTerritoryEffects(ArrayList<TerritoryEffect> value) {
        this.m_territoryEffects = value;
    }

    public ArrayList<TerritoryEffect> getTerritoryEffects() {
        return this.m_territoryEffects;
    }

    public void clearTerritoryEffects() {
        this.m_territoryEffects.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTerritoryEffectAttachmentName(String name) throws GameParseException {
        if (name == null) {
            this.m_territoryEffectAttachmentName = null;
            return;
        }
        String[] s = name.split(":");
        if (s.length != 2) {
            throw new GameParseException("territoryEffectAttachmentName must have 2 entries, the type of attachment and the name of the attachment." + this.thisErrorMsg());
        }
        if (!s[1].equals("TerritoryEffectAttachment")) {
            throw new GameParseException("territoryEffectAttachmentName value must be TerritoryEffectAttachment" + this.thisErrorMsg());
        }
        if (s[0].length() < 1) {
            throw new GameParseException("territoryEffectAttachmentName count must be a valid attachment name" + this.thisErrorMsg());
        }
        if (s[1].equals("TerritoryEffectAttachment") && !s[0].startsWith("territoryEffectAttachment")) {
            throw new GameParseException("attachment incorrectly named:" + s[0] + this.thisErrorMsg());
        }
        this.m_territoryEffectAttachmentName = new Tuple<String, String>(s[1], s[0]);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTerritoryEffectAttachmentName(Tuple<String, String> value) {
        this.m_territoryEffectAttachmentName = value;
    }

    public Tuple<String, String> getTerritoryEffectAttachmentName() {
        if (this.m_territoryEffectAttachmentName == null) {
            return new Tuple<String, String>("TerritoryEffectAttachment", "territoryEffectAttachment");
        }
        return this.m_territoryEffectAttachmentName;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setTerritoryEffectProperty(String prop) throws GameParseException {
        if (prop == null) {
            this.m_territoryEffectProperty = null;
            return;
        }
        String[] s = prop.split(":");
        if (this.m_territoryEffectProperty == null) {
            this.m_territoryEffectProperty = new ArrayList();
        }
        String property = s[s.length - 1];
        this.m_territoryEffectProperty.add(new Tuple<String, String>(property, TriggerAttachment.getValueFromStringArrayForAllExceptLastSubstring(s)));
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setTerritoryEffectProperty(ArrayList<Tuple<String, String>> value) {
        this.m_territoryEffectProperty = value;
    }

    public ArrayList<Tuple<String, String>> getTerritoryEffectProperty() {
        return this.m_territoryEffectProperty;
    }

    public void clearTerritoryEffectProperty() {
        this.m_territoryEffectProperty.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setPlacement(String place) throws GameParseException {
        if (place == null) {
            this.m_placement = null;
            return;
        }
        String[] s = place.split(":");
        int count = -1;
        int i = 0;
        if (s.length < 1) {
            throw new GameParseException("Empty placement list" + this.thisErrorMsg());
        }
        try {
            count = TriggerAttachment.getInt(s[0]);
            ++i;
        }
        catch (Exception e) {
            count = 1;
        }
        if (s.length < 1 || s.length == 1 && count != -1) {
            throw new GameParseException("Empty placement list" + this.thisErrorMsg());
        }
        Territory territory = this.getData().getMap().getTerritory(s[i]);
        if (territory == null) {
            throw new GameParseException("Territory does not exist " + s[i] + this.thisErrorMsg());
        }
        ++i;
        IntegerMap<UnitType> map = new IntegerMap<UnitType>();
        while (i < s.length) {
            UnitType type = this.getData().getUnitTypeList().getUnitType(s[i]);
            if (type == null) {
                throw new GameParseException("UnitType does not exist " + s[i] + this.thisErrorMsg());
            }
            map.add(type, count);
            ++i;
        }
        if (this.m_placement == null) {
            this.m_placement = new HashMap();
        }
        if (this.m_placement.containsKey(territory)) {
            map.add(this.m_placement.get(territory));
        }
        this.m_placement.put(territory, map);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlacement(HashMap<Territory, IntegerMap<UnitType>> value) {
        this.m_placement = value;
    }

    public HashMap<Territory, IntegerMap<UnitType>> getPlacement() {
        return this.m_placement;
    }

    public void clearPlacement() {
        this.m_placement.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setRemoveUnits(String value) throws GameParseException {
        if (value == null) {
            this.m_removeUnits = null;
            return;
        }
        if (this.m_removeUnits == null) {
            this.m_removeUnits = new HashMap();
        }
        String[] s = value.split(":");
        int count = -1;
        int i = 0;
        if (s.length < 1) {
            throw new GameParseException("Empty removeUnits list" + this.thisErrorMsg());
        }
        try {
            count = TriggerAttachment.getInt(s[0]);
            ++i;
        }
        catch (Exception e) {
            count = 1;
        }
        if (s.length < 1 || s.length == 1 && count != -1) {
            throw new GameParseException("Empty removeUnits list" + this.thisErrorMsg());
        }
        ArrayList<Territory> territories = new ArrayList<Territory>();
        Territory terr = this.getData().getMap().getTerritory(s[i]);
        if (terr == null) {
            if (!s[i].equalsIgnoreCase("all")) throw new GameParseException("Territory does not exist " + s[i] + this.thisErrorMsg());
            territories.addAll(this.getData().getMap().getTerritories());
        } else {
            territories.add(terr);
        }
        ++i;
        IntegerMap<UnitType> map = new IntegerMap<UnitType>();
        while (i < s.length) {
            ArrayList<UnitType> types = new ArrayList<UnitType>();
            UnitType tp = this.getData().getUnitTypeList().getUnitType(s[i]);
            if (tp == null) {
                if (!s[i].equalsIgnoreCase("all")) throw new GameParseException("UnitType does not exist " + s[i] + this.thisErrorMsg());
                types.addAll(this.getData().getUnitTypeList().getAllUnitTypes());
            } else {
                types.add(tp);
            }
            for (UnitType type : types) {
                map.add(type, count);
            }
            ++i;
        }
        for (Territory t : territories) {
            if (this.m_removeUnits.containsKey(t)) {
                map.add(this.m_removeUnits.get(t));
            }
            this.m_removeUnits.put(t, map);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setRemoveUnits(HashMap<Territory, IntegerMap<UnitType>> value) {
        this.m_removeUnits = value;
    }

    public HashMap<Territory, IntegerMap<UnitType>> getRemoveUnits() {
        return this.m_removeUnits;
    }

    public void clearRemoveUnits() {
        this.m_removeUnits.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setPurchase(String place) throws GameParseException {
        if (place == null) {
            this.m_purchase = null;
            return;
        }
        String[] s = place.split(":");
        int count = -1;
        int i = 0;
        if (s.length < 1) {
            throw new GameParseException("Empty purchase list" + this.thisErrorMsg());
        }
        try {
            count = TriggerAttachment.getInt(s[0]);
            ++i;
        }
        catch (Exception e) {
            count = 1;
        }
        if (s.length < 1 || s.length == 1 && count != -1) {
            throw new GameParseException("Empty purchase list" + this.thisErrorMsg());
        }
        if (this.m_purchase == null) {
            this.m_purchase = new IntegerMap();
        }
        while (i < s.length) {
            UnitType type = this.getData().getUnitTypeList().getUnitType(s[i]);
            if (type == null) {
                throw new GameParseException("UnitType does not exist " + s[i] + this.thisErrorMsg());
            }
            this.m_purchase.add(type, count);
            ++i;
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPurchase(IntegerMap<UnitType> value) {
        this.m_purchase = value;
    }

    public IntegerMap<UnitType> getPurchase() {
        return this.m_purchase;
    }

    public void clearPurchase() {
        this.m_purchase.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setChangeOwnership(String value) throws GameParseException {
        PlayerID oldOwner;
        Territory t;
        String[] s = value.split(":");
        if (s.length < 4) {
            throw new GameParseException("changeOwnership must have 4 fields: territory:oldOwner:newOwner:booleanConquered" + this.thisErrorMsg());
        }
        if (!s[0].equalsIgnoreCase("all") && (t = this.getData().getMap().getTerritory(s[0])) == null) {
            throw new GameParseException("No such territory: " + s[0] + this.thisErrorMsg());
        }
        if (!s[1].equalsIgnoreCase("any") && (oldOwner = this.getData().getPlayerList().getPlayerID(s[1])) == null) {
            throw new GameParseException("No such player: " + s[1] + this.thisErrorMsg());
        }
        PlayerID newOwner = this.getData().getPlayerList().getPlayerID(s[2]);
        if (newOwner == null) {
            throw new GameParseException("No such player: " + s[2] + this.thisErrorMsg());
        }
        TriggerAttachment.getBool(s[3]);
        this.m_changeOwnership.add(value);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setChangeOwnership(ArrayList<String> value) {
        this.m_changeOwnership = value;
    }

    public ArrayList<String> getChangeOwnership() {
        return this.m_changeOwnership;
    }

    public void clearChangeOwnership() {
        this.m_changeOwnership.clear();
    }

    private static void removeUnits(TriggerAttachment t, Territory terr, IntegerMap<UnitType> uMap, PlayerID player, IDelegateBridge aBridge) {
        CompositeChange change = new CompositeChange();
        ArrayList<Unit> totalRemoved = new ArrayList<Unit>();
        for (UnitType ut : uMap.keySet()) {
            int removeNum = uMap.getInt(ut);
            List<Unit> toRemove = Match.getNMatches(terr.getUnits().getUnits(), removeNum, new CompositeMatchAnd(Matches.unitIsOwnedBy(player), Matches.unitIsOfType(ut)));
            if (toRemove.isEmpty()) continue;
            totalRemoved.addAll(toRemove);
            change.add(ChangeFactory.removeUnits(terr, toRemove));
        }
        if (!change.isEmpty()) {
            String transcriptText = MyFormatter.attachmentNameToText(t.getName()) + ": has removed " + MyFormatter.unitsToTextNoOwner(totalRemoved) + " owned by " + player.getName() + " in " + terr.getName();
            aBridge.getHistoryWriter().startEvent(transcriptText);
            aBridge.getHistoryWriter().setRenderingData(totalRemoved);
            aBridge.addChange(change);
        }
    }

    private static void placeUnits(TriggerAttachment t, Territory terr, IntegerMap<UnitType> uMap, PlayerID player, GameData data, IDelegateBridge aBridge) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (UnitType u : uMap.keySet()) {
            units.addAll(u.create(uMap.getInt(u), player));
        }
        CompositeChange change = new CompositeChange();
        for (Unit unit : units) {
            change.add(ChangeFactory.markNoMovementChange(unit));
        }
        List<Unit> factoryAndInfrastructure = Match.getMatches(units, Matches.UnitIsFactoryOrIsInfrastructure);
        change.add(DelegateFinder.battleDelegate(data).getOriginalOwnerTracker().addOriginalOwnerChange(factoryAndInfrastructure, player));
        String transcriptText = MyFormatter.attachmentNameToText(t.getName()) + ": " + player.getName() + " has " + MyFormatter.unitsToTextNoOwner(units) + " placed in " + terr.getName();
        aBridge.getHistoryWriter().startEvent(transcriptText);
        aBridge.getHistoryWriter().setRenderingData(units);
        Change place = ChangeFactory.addUnits(terr, units);
        change.add(place);
        aBridge.addChange(change);
    }

    public static void triggerNotifications(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.notificationMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        HashSet<String> notifications = new HashSet<String>();
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            notifications.add(t.getNotification());
        }
        for (String notificationMessageKey : notifications) {
            String message = NotificationMessages.getInstance().getMessage(notificationMessageKey);
            aBridge.getHistoryWriter().startEvent("Notification to player " + aBridge.getPlayerID().getName() + ": " + message);
            ((ITripleaPlayer)aBridge.getRemote(aBridge.getPlayerID())).reportMessage("<html>" + message + "</html>", "Notification");
        }
    }

    public static void triggerPlayerPropertyChange(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.playerPropertyMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        CompositeChange change = new CompositeChange();
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            for (Tuple<String, String> property : t.getPlayerProperty()) {
                for (PlayerID aPlayer : t.getPlayers()) {
                    DefaultAttachment attachment;
                    String newValue = property.getSecond();
                    boolean clearFirst = false;
                    if (newValue.length() > 0 && newValue.startsWith("-clear-")) {
                        newValue = newValue.replaceFirst("-clear-", "");
                        clearFirst = true;
                    }
                    if (t.getPlayerAttachmentName().getFirst().equals("PlayerAttachment")) {
                        attachment = PlayerAttachment.get(aPlayer, t.getPlayerAttachmentName().getSecond());
                        if (attachment.getRawPropertyString(property.getFirst()).equals(newValue)) continue;
                        if (clearFirst && newValue.length() < 1) {
                            change.add(ChangeFactory.attachmentPropertyClear(attachment, property.getFirst(), true));
                        } else {
                            change.add(ChangeFactory.attachmentPropertyChange(attachment, newValue, property.getFirst(), true, clearFirst));
                        }
                        aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": Setting " + property.getFirst() + (newValue.length() > 0 ? " to " + newValue : " cleared ") + " for " + t.getPlayerAttachmentName().getSecond() + " attached to " + aPlayer.getName());
                        continue;
                    }
                    if (t.getPlayerAttachmentName().getFirst().equals("RulesAttachment")) {
                        attachment = RulesAttachment.get(aPlayer, t.getPlayerAttachmentName().getSecond());
                        if (attachment.getRawPropertyString(property.getFirst()).equals(newValue)) continue;
                        if (clearFirst && newValue.length() < 1) {
                            change.add(ChangeFactory.attachmentPropertyClear(attachment, property.getFirst(), true));
                        } else {
                            change.add(ChangeFactory.attachmentPropertyChange(attachment, newValue, property.getFirst(), true, clearFirst));
                        }
                        aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": Setting " + property.getFirst() + (newValue.length() > 0 ? " to " + newValue : " cleared ") + " for " + t.getPlayerAttachmentName().getSecond() + " attached to " + aPlayer.getName());
                        continue;
                    }
                    if (t.getPlayerAttachmentName().getFirst().equals("TriggerAttachment")) {
                        attachment = TriggerAttachment.get(aPlayer, t.getPlayerAttachmentName().getSecond());
                        if (attachment.getRawPropertyString(property.getFirst()).equals(newValue)) continue;
                        if (clearFirst && newValue.length() < 1) {
                            change.add(ChangeFactory.attachmentPropertyClear(attachment, property.getFirst(), true));
                        } else {
                            change.add(ChangeFactory.attachmentPropertyChange(attachment, newValue, property.getFirst(), true, clearFirst));
                        }
                        aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": Setting " + property.getFirst() + (newValue.length() > 0 ? " to " + newValue : " cleared ") + " for " + t.getPlayerAttachmentName().getSecond() + " attached to " + aPlayer.getName());
                        continue;
                    }
                    if (t.getPlayerAttachmentName().getFirst().equals("TechAttachment")) {
                        attachment = TechAttachment.get(aPlayer, t.getPlayerAttachmentName().getSecond());
                        if (attachment.getRawPropertyString(property.getFirst()).equals(newValue)) continue;
                        if (clearFirst && newValue.length() < 1) {
                            change.add(ChangeFactory.attachmentPropertyClear(attachment, property.getFirst(), true));
                        } else {
                            change.add(ChangeFactory.attachmentPropertyChange(attachment, newValue, property.getFirst(), true, clearFirst));
                        }
                        aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": Setting " + property.getFirst() + (newValue.length() > 0 ? " to " + newValue : " cleared ") + " for " + t.getPlayerAttachmentName().getSecond() + " attached to " + aPlayer.getName());
                        continue;
                    }
                    if (!t.getPlayerAttachmentName().getFirst().equals("PoliticalActionAttachment") || (attachment = PoliticalActionAttachment.get(aPlayer, t.getPlayerAttachmentName().getSecond())).getRawPropertyString(property.getFirst()).equals(newValue)) continue;
                    if (clearFirst && newValue.length() < 1) {
                        change.add(ChangeFactory.attachmentPropertyClear(attachment, property.getFirst(), true));
                    } else {
                        change.add(ChangeFactory.attachmentPropertyChange(attachment, newValue, property.getFirst(), true, clearFirst));
                    }
                    aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": Setting " + property.getFirst() + (newValue.length() > 0 ? " to " + newValue : " cleared ") + " for " + t.getPlayerAttachmentName().getSecond() + " attached to " + aPlayer.getName());
                }
            }
        }
        if (!change.isEmpty()) {
            aBridge.addChange(change);
        }
    }

    public static void triggerRelationshipTypePropertyChange(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.relationshipTypePropertyMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        CompositeChange change = new CompositeChange();
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            for (Tuple<String, String> property : t.getRelationshipTypeProperty()) {
                for (RelationshipType aRelationshipType : t.getRelationshipTypes()) {
                    RelationshipTypeAttachment attachment;
                    String newValue = property.getSecond();
                    boolean clearFirst = false;
                    if (newValue.length() > 0 && newValue.startsWith("-clear-")) {
                        newValue = newValue.replaceFirst("-clear-", "");
                        clearFirst = true;
                    }
                    if (!t.getTerritoryAttachmentName().getFirst().equals("RelationshipTypeAttachment") || (attachment = RelationshipTypeAttachment.get(aRelationshipType, t.getRelationshipTypeAttachmentName().getSecond())).getRawPropertyString(property.getFirst()).equals(newValue)) continue;
                    if (clearFirst && newValue.length() < 1) {
                        change.add(ChangeFactory.attachmentPropertyClear(attachment, property.getFirst(), true));
                    } else {
                        change.add(ChangeFactory.attachmentPropertyChange(attachment, newValue, property.getFirst(), true, clearFirst));
                    }
                    aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": Setting " + property.getFirst() + (newValue.length() > 0 ? " to " + newValue : " cleared ") + " for " + t.getRelationshipTypeAttachmentName().getSecond() + " attached to " + aRelationshipType.getName());
                }
            }
        }
        if (!change.isEmpty()) {
            aBridge.addChange(change);
        }
    }

    public static void triggerTerritoryPropertyChange(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.territoryPropertyMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        CompositeChange change = new CompositeChange();
        HashSet<Territory> territoriesNeedingReDraw = new HashSet<Territory>();
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            for (Tuple<String, String> property : t.getTerritoryProperty()) {
                for (Territory aTerritory : t.getTerritories()) {
                    DefaultAttachment attachment;
                    territoriesNeedingReDraw.add(aTerritory);
                    String newValue = property.getSecond();
                    boolean clearFirst = false;
                    if (newValue.length() > 0 && newValue.startsWith("-clear-")) {
                        newValue = newValue.replaceFirst("-clear-", "");
                        clearFirst = true;
                    }
                    if (t.getTerritoryAttachmentName().getFirst().equals("TerritoryAttachment")) {
                        attachment = TerritoryAttachment.get(aTerritory, t.getTerritoryAttachmentName().getSecond());
                        if (attachment == null) {
                            throw new IllegalStateException("Triggers: No territory attachment for:" + aTerritory.getName());
                        }
                        if (attachment.getRawPropertyString(property.getFirst()).equals(newValue)) continue;
                        if (clearFirst && newValue.length() < 1) {
                            change.add(ChangeFactory.attachmentPropertyClear(attachment, property.getFirst(), true));
                        } else {
                            change.add(ChangeFactory.attachmentPropertyChange(attachment, newValue, property.getFirst(), true, clearFirst));
                        }
                        aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": Setting " + property.getFirst() + (newValue.length() > 0 ? " to " + newValue : " cleared ") + " for " + t.getTerritoryAttachmentName().getSecond() + " attached to " + aTerritory.getName());
                        continue;
                    }
                    if (!t.getTerritoryAttachmentName().getFirst().equals("CanalAttachment") || (attachment = CanalAttachment.get(aTerritory, t.getTerritoryAttachmentName().getSecond())).getRawPropertyString(property.getFirst()).equals(newValue)) continue;
                    if (clearFirst && newValue.length() < 1) {
                        change.add(ChangeFactory.attachmentPropertyClear(attachment, property.getFirst(), true));
                    } else {
                        change.add(ChangeFactory.attachmentPropertyChange(attachment, newValue, property.getFirst(), true, clearFirst));
                    }
                    aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": Setting " + property.getFirst() + (newValue.length() > 0 ? " to " + newValue : " cleared ") + " for " + t.getTerritoryAttachmentName().getSecond() + " attached to " + aTerritory.getName());
                }
            }
        }
        if (!change.isEmpty()) {
            aBridge.addChange(change);
            for (Territory aTerritory : territoriesNeedingReDraw) {
                aTerritory.notifyAttachmentChanged();
            }
        }
    }

    public static void triggerTerritoryEffectPropertyChange(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.territoryEffectPropertyMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        CompositeChange change = new CompositeChange();
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            for (Tuple<String, String> property : t.getTerritoryEffectProperty()) {
                for (TerritoryEffect aTerritoryEffect : t.getTerritoryEffects()) {
                    TerritoryEffectAttachment attachment;
                    String newValue = property.getSecond();
                    boolean clearFirst = false;
                    if (newValue.length() > 0 && newValue.startsWith("-clear-")) {
                        newValue = newValue.replaceFirst("-clear-", "");
                        clearFirst = true;
                    }
                    if (!t.getTerritoryEffectAttachmentName().getFirst().equals("TerritoryEffectAttachment") || (attachment = TerritoryEffectAttachment.get(aTerritoryEffect, t.getTerritoryEffectAttachmentName().getSecond())).getRawPropertyString(property.getFirst()).equals(newValue)) continue;
                    if (clearFirst && newValue.length() < 1) {
                        change.add(ChangeFactory.attachmentPropertyClear(attachment, property.getFirst(), true));
                    } else {
                        change.add(ChangeFactory.attachmentPropertyChange(attachment, newValue, property.getFirst(), true, clearFirst));
                    }
                    aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": Setting " + property.getFirst() + (newValue.length() > 0 ? " to " + newValue : " cleared ") + " for " + t.getTerritoryEffectAttachmentName().getSecond() + " attached to " + aTerritoryEffect.getName());
                }
            }
        }
        if (!change.isEmpty()) {
            aBridge.addChange(change);
        }
    }

    public static void triggerUnitPropertyChange(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.unitPropertyMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        CompositeChange change = new CompositeChange();
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            for (Tuple<String, String> property : t.getUnitProperty()) {
                for (UnitType aUnitType : t.getUnitType()) {
                    DefaultAttachment attachment;
                    String newValue = property.getSecond();
                    boolean clearFirst = false;
                    if (newValue.length() > 0 && newValue.startsWith("-clear-")) {
                        newValue = newValue.replaceFirst("-clear-", "");
                        clearFirst = true;
                    }
                    if (t.getUnitAttachmentName().getFirst().equals("UnitAttachment")) {
                        attachment = UnitAttachment.get(aUnitType, t.getUnitAttachmentName().getSecond());
                        if (attachment.getRawPropertyString(property.getFirst()).equals(newValue)) continue;
                        if (clearFirst && newValue.length() < 1) {
                            change.add(ChangeFactory.attachmentPropertyClear(attachment, property.getFirst(), true));
                        } else {
                            change.add(ChangeFactory.attachmentPropertyChange(attachment, newValue, property.getFirst(), true, clearFirst));
                        }
                        aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": Setting " + property.getFirst() + (newValue.length() > 0 ? " to " + newValue : " cleared ") + " for " + t.getUnitAttachmentName().getSecond() + " attached to " + aUnitType.getName());
                        continue;
                    }
                    if (!t.getUnitAttachmentName().getFirst().equals("UnitSupportAttachment") || (attachment = UnitSupportAttachment.get(aUnitType, t.getUnitAttachmentName().getSecond())).getRawPropertyString(property.getFirst()).equals(newValue)) continue;
                    if (clearFirst && newValue.length() < 1) {
                        change.add(ChangeFactory.attachmentPropertyClear(attachment, property.getFirst(), true));
                    } else {
                        change.add(ChangeFactory.attachmentPropertyChange(attachment, newValue, property.getFirst(), true, clearFirst));
                    }
                    aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": Setting " + property.getFirst() + (newValue.length() > 0 ? " to " + newValue : " cleared ") + " for " + t.getUnitAttachmentName().getSecond() + " attached to " + aUnitType.getName());
                }
            }
        }
        if (!change.isEmpty()) {
            aBridge.addChange(change);
        }
    }

    public static void triggerRelationshipChange(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        GameData data = aBridge.getData();
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.relationshipChangeMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        CompositeChange change = new CompositeChange();
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            for (String relationshipChange : t.getRelationshipChange()) {
                String[] s = relationshipChange.split(":");
                PlayerID player1 = data.getPlayerList().getPlayerID(s[0]);
                PlayerID player2 = data.getPlayerList().getPlayerID(s[1]);
                RelationshipType currentRelation = data.getRelationshipTracker().getRelationshipType(player1, player2);
                if (!(s[2].equals("any") || s[2].equals("anyNeutral") && Matches.RelationshipTypeIsNeutral.match(currentRelation) || s[2].equals("anyAllied") && Matches.RelationshipTypeIsAllied.match(currentRelation) || s[2].equals("anyWar") && Matches.RelationshipTypeIsAtWar.match(currentRelation)) && !currentRelation.equals(data.getRelationshipTypeList().getRelationshipType(s[2]))) continue;
                RelationshipType triggerNewRelation = data.getRelationshipTypeList().getRelationshipType(s[3]);
                change.add(ChangeFactory.relationshipChange(player1, player2, currentRelation, triggerNewRelation));
                aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": Changing Relationship for " + player1.getName() + " and " + player2.getName() + " from " + currentRelation.getName() + " to " + triggerNewRelation.getName());
            }
        }
        if (!change.isEmpty()) {
            aBridge.addChange(change);
        }
    }

    public static void triggerAvailableTechChange(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.techAvailableMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            for (PlayerID aPlayer : t.getPlayers()) {
                for (String cat : t.getAvailableTech().keySet()) {
                    TechnologyFrontier tf = aPlayer.getTechnologyFrontierList().getTechnologyFrontier(cat);
                    if (tf == null) {
                        throw new IllegalStateException("Triggers: tech category doesn't exist:" + cat + " for player:" + aPlayer);
                    }
                    for (TechAdvance ta : t.getAvailableTech().get(cat).keySet()) {
                        Change change;
                        if (t.getAvailableTech().get(cat).get(ta).booleanValue()) {
                            aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": " + aPlayer.getName() + " gains access to " + ta);
                            change = ChangeFactory.addAvailableTech(tf, ta, aPlayer);
                            aBridge.addChange(change);
                            continue;
                        }
                        aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": " + aPlayer.getName() + " loses access to " + ta);
                        change = ChangeFactory.removeAvailableTech(tf, ta, aPlayer);
                        aBridge.addChange(change);
                    }
                }
            }
        }
    }

    public static void triggerTechChange(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        GameData data = aBridge.getData();
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.techMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            for (PlayerID aPlayer : t.getPlayers()) {
                for (TechAdvance ta : t.getTech()) {
                    if (ta.hasTech(TechAttachment.get(aPlayer)) || !TechAdvance.getTechAdvances(data, aPlayer).contains(ta)) continue;
                    aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": " + aPlayer.getName() + " activates " + ta);
                    TechTracker.addAdvance(aPlayer, aBridge, ta);
                }
            }
        }
    }

    public static void triggerProductionChange(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.prodMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        CompositeChange change = new CompositeChange();
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            for (PlayerID aPlayer : t.getPlayers()) {
                change.add(ChangeFactory.changeProductionFrontier(aPlayer, t.getFrontier()));
                aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": " + aPlayer.getName() + " has their production frontier changed to: " + t.getFrontier().toString());
            }
        }
        if (!change.isEmpty()) {
            aBridge.addChange(change);
        }
    }

    public static void triggerProductionFrontierEditChange(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        GameData data = aBridge.getData();
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.prodFrontierEditMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        CompositeChange change = new CompositeChange();
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            Iterator<String> iter = t.getProductionRule().iterator();
            while (iter.hasNext()) {
                boolean add = true;
                String[] s = iter.next().split(":");
                ProductionFrontier front = data.getProductionFrontierList().getProductionFrontier(s[0]);
                String rule = s[1];
                if (rule.startsWith("-")) {
                    rule = rule.replaceFirst("-", "");
                    add = false;
                }
                ProductionRule pRule = data.getProductionRuleList().getProductionRule(rule);
                if (add) {
                    if (front.getRules().contains(pRule)) continue;
                    change.add(ChangeFactory.addProductionRule(pRule, front));
                    aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": " + pRule.getName() + " added to " + front.getName());
                    continue;
                }
                if (!front.getRules().contains(pRule)) continue;
                change.add(ChangeFactory.removeProductionRule(pRule, front));
                aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": " + pRule.getName() + " removed from " + front.getName());
            }
        }
        if (!change.isEmpty()) {
            aBridge.addChange(change);
        }
    }

    public static void triggerSupportChange(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.supportMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        CompositeChange change = new CompositeChange();
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            for (PlayerID aPlayer : t.getPlayers()) {
                for (UnitSupportAttachment usa : t.getSupport().keySet()) {
                    ArrayList<PlayerID> p = new ArrayList<PlayerID>(usa.getPlayers());
                    if (p.contains(aPlayer)) {
                        if (t.getSupport().get(usa).booleanValue()) continue;
                        p.remove(aPlayer);
                        change.add(ChangeFactory.attachmentPropertyChange(usa, p, "players"));
                        aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": " + aPlayer.getName() + " is removed from " + usa.toString());
                        continue;
                    }
                    if (!t.getSupport().get(usa).booleanValue()) continue;
                    p.add(aPlayer);
                    change.add(ChangeFactory.attachmentPropertyChange(usa, p, "players"));
                    aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": " + aPlayer.getName() + " is added to " + usa.toString());
                }
            }
        }
        if (!change.isEmpty()) {
            aBridge.addChange(change);
        }
    }

    public static void triggerChangeOwnership(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        GameData data = aBridge.getData();
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.changeOwnershipMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        BattleTracker bt = DelegateFinder.battleDelegate(data).getBattleTracker();
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            for (String value : t.getChangeOwnership()) {
                String[] s = value.split(":");
                ArrayList<Territory> territories = new ArrayList<Territory>();
                if (s[0].equalsIgnoreCase("all")) {
                    territories.addAll(data.getMap().getTerritories());
                } else {
                    Territory territorySet = data.getMap().getTerritory(s[0]);
                    territories.add(territorySet);
                }
                PlayerID oldOwner = data.getPlayerList().getPlayerID(s[1]);
                PlayerID newOwner = data.getPlayerList().getPlayerID(s[2]);
                boolean captured = TriggerAttachment.getBool(s[3]);
                for (Territory terr : territories) {
                    PlayerID currentOwner = terr.getOwner();
                    if (currentOwner == null || currentOwner.isNull() || TerritoryAttachment.get(terr) == null || oldOwner != null && !oldOwner.equals(currentOwner)) continue;
                    aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + ": " + newOwner.getName() + (captured ? " captures territory " : " takes ownership of territory ") + terr.getName());
                    if (!captured) {
                        aBridge.addChange(ChangeFactory.changeOwner(terr, newOwner));
                        continue;
                    }
                    bt.takeOver(terr, newOwner, aBridge, null, null);
                }
            }
        }
    }

    public static void triggerPurchase(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.purchaseMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            int eachMultiple = TriggerAttachment.getEachMultiple(t);
            for (PlayerID aPlayer : t.getPlayers()) {
                for (int i = 0; i < eachMultiple; ++i) {
                    ArrayList<Unit> units = new ArrayList<Unit>();
                    for (UnitType u : t.getPurchase().keySet()) {
                        units.addAll(u.create(t.getPurchase().getInt(u), aPlayer));
                    }
                    if (units.isEmpty()) continue;
                    String transcriptText = MyFormatter.attachmentNameToText(t.getName()) + ": " + MyFormatter.unitsToTextNoOwner(units) + " gained by " + aPlayer;
                    aBridge.getHistoryWriter().startEvent(transcriptText);
                    aBridge.getHistoryWriter().setRenderingData(units);
                    Change place = ChangeFactory.addUnits(aPlayer, units);
                    aBridge.addChange(place);
                }
            }
        }
    }

    public static void triggerUnitRemoval(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.removeUnitsMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            int eachMultiple = TriggerAttachment.getEachMultiple(t);
            for (PlayerID aPlayer : t.getPlayers()) {
                for (Territory ter : t.getRemoveUnits().keySet()) {
                    for (int i = 0; i < eachMultiple; ++i) {
                        TriggerAttachment.removeUnits(t, ter, t.getRemoveUnits().get(ter), aPlayer, aBridge);
                    }
                }
            }
        }
    }

    public static void triggerUnitPlacement(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        GameData data = aBridge.getData();
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.placeMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            int eachMultiple = TriggerAttachment.getEachMultiple(t);
            for (PlayerID aPlayer : t.getPlayers()) {
                for (Territory ter : t.getPlacement().keySet()) {
                    for (int i = 0; i < eachMultiple; ++i) {
                        TriggerAttachment.placeUnits(t, ter, t.getPlacement().get(ter), aPlayer, data, aBridge);
                    }
                }
            }
        }
    }

    public static void triggerResourceChange(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        GameData data = aBridge.getData();
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.resourceMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            int eachMultiple = TriggerAttachment.getEachMultiple(t);
            for (PlayerID aPlayer : t.getPlayers()) {
                for (int i = 0; i < eachMultiple; ++i) {
                    int total;
                    int toAdd = t.getResourceCount();
                    if (t.getResource().equals("PUs")) {
                        toAdd *= Properties.getPU_Multiplier(data).intValue();
                    }
                    if ((total = aPlayer.getResources().getQuantity(t.getResource()) + toAdd) < 0) {
                        toAdd -= total;
                        total = 0;
                    }
                    aBridge.addChange(ChangeFactory.changeResourcesChange(aPlayer, data.getResourceList().getResource(t.getResource()), toAdd));
                    String PUMessage = MyFormatter.attachmentNameToText(t.getName()) + ": " + aPlayer.getName() + " met a national objective for an additional " + t.getResourceCount() + " " + t.getResource() + "; end with " + total + " " + t.getResource();
                    aBridge.getHistoryWriter().startEvent(PUMessage);
                }
            }
        }
    }

    public static void triggerActivateTriggerOther(HashMap<ICondition, Boolean> testedConditionsSoFar, Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.activateTriggerMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            int eachMultiple = TriggerAttachment.getEachMultiple(t);
            for (Tuple<TriggerAttachment, String> tuple : t.getActivateTrigger()) {
                TriggerAttachment toFire = tuple.getFirst();
                HashSet<TriggerAttachment> toFireSet = new HashSet<TriggerAttachment>();
                toFireSet.add(toFire);
                String[] options = tuple.getSecond().split(":");
                int numberOfTimesToFire = TriggerAttachment.getInt(options[0]);
                boolean useUsesToFire = TriggerAttachment.getBool(options[1]);
                boolean testUsesToFire = TriggerAttachment.getBool(options[2]);
                boolean testConditionsToFire = TriggerAttachment.getBool(options[3]);
                boolean testChanceToFire = TriggerAttachment.getBool(options[4]);
                if (testConditionsToFire) {
                    if (!testedConditionsSoFar.containsKey(toFire)) {
                        TriggerAttachment.collectTestsForAllTriggers(toFireSet, aBridge, new HashSet<ICondition>(testedConditionsSoFar.keySet()), testedConditionsSoFar);
                    }
                    if (!TriggerAttachment.isSatisfiedMatch(testedConditionsSoFar).match(toFire)) continue;
                }
                for (int i = 0; i < numberOfTimesToFire * eachMultiple; ++i) {
                    aBridge.getHistoryWriter().startEvent(MyFormatter.attachmentNameToText(t.getName()) + " activates a trigger called: " + MyFormatter.attachmentNameToText(toFire.getName()));
                    TriggerAttachment.fireTriggers(toFireSet, testedConditionsSoFar, aBridge, beforeOrAfter, stepName, useUsesToFire, testUsesToFire, testChanceToFire, false);
                }
            }
        }
    }

    public static void triggerVictory(Set<TriggerAttachment> satisfiedTriggers, IDelegateBridge aBridge, String beforeOrAfter, String stepName, boolean useUses, boolean testUses, boolean testChance, boolean testWhen) {
        GameData data = aBridge.getData();
        List<TriggerAttachment> trigs = Match.getMatches(satisfiedTriggers, TriggerAttachment.victoryMatch());
        if (testWhen) {
            trigs = Match.getMatches(trigs, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
        }
        if (testUses) {
            trigs = Match.getMatches(trigs, availableUses);
        }
        for (TriggerAttachment t : trigs) {
            if (testChance && !t.testChance(aBridge)) continue;
            if (useUses) {
                t.use(aBridge);
            }
            if (t.getVictory() == null || t.getPlayers() == null) continue;
            String victoryMessage = NotificationMessages.getInstance().getMessage(t.getVictory());
            try {
                aBridge.getHistoryWriter().startEvent("Players: " + MyFormatter.defaultNamedToString(t.getPlayers()) + " have just won the game, with this victory: " + victoryMessage);
                IDelegate delegateEndRound = data.getDelegateList().getDelegate("endRound");
                ((EndRoundDelegate)delegateEndRound).signalGameOver("<html>" + victoryMessage + "</html>", t.getPlayers(), aBridge);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Match<TriggerAttachment> prodMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return t.getFrontier() != null;
            }
        };
    }

    public static Match<TriggerAttachment> prodFrontierEditMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return t.getProductionRule() != null && t.getProductionRule().size() > 0;
            }
        };
    }

    public static Match<TriggerAttachment> techMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return !t.getTech().isEmpty();
            }
        };
    }

    public static Match<TriggerAttachment> techAvailableMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return t.getAvailableTech() != null;
            }
        };
    }

    public static Match<TriggerAttachment> removeUnitsMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return t.getRemoveUnits() != null;
            }
        };
    }

    public static Match<TriggerAttachment> placeMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return t.getPlacement() != null;
            }
        };
    }

    public static Match<TriggerAttachment> purchaseMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return t.getPurchase() != null;
            }
        };
    }

    public static Match<TriggerAttachment> resourceMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return t.getResource() != null && t.getResourceCount() != 0;
            }
        };
    }

    public static Match<TriggerAttachment> supportMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return t.getSupport() != null;
            }
        };
    }

    public static Match<TriggerAttachment> changeOwnershipMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return !t.getChangeOwnership().isEmpty();
            }
        };
    }

    public static Match<TriggerAttachment> unitPropertyMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return !t.getUnitType().isEmpty() && t.getUnitProperty() != null;
            }
        };
    }

    public static Match<TriggerAttachment> territoryPropertyMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return !t.getTerritories().isEmpty() && t.getTerritoryProperty() != null;
            }
        };
    }

    public static Match<TriggerAttachment> playerPropertyMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return t.getPlayerProperty() != null;
            }
        };
    }

    public static Match<TriggerAttachment> relationshipTypePropertyMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return !t.getRelationshipTypes().isEmpty() && t.getRelationshipTypeProperty() != null;
            }
        };
    }

    public static Match<TriggerAttachment> territoryEffectPropertyMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return !t.getTerritoryEffects().isEmpty() && t.getTerritoryEffectProperty() != null;
            }
        };
    }

    public static Match<TriggerAttachment> relationshipChangeMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return !t.getRelationshipChange().isEmpty();
            }
        };
    }

    public static Match<TriggerAttachment> victoryMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return t.getVictory() != null && t.getVictory().length() > 0;
            }
        };
    }

    public static Match<TriggerAttachment> activateTriggerMatch() {
        return new Match<TriggerAttachment>(){

            @Override
            public boolean match(TriggerAttachment t) {
                return !t.getActivateTrigger().isEmpty();
            }
        };
    }

    @Override
    public void validate(GameData data) throws GameParseException {
        super.validate(data);
    }
}

