/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.DefaultAttachment;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.annotations.GameProperty;
import games.strategy.engine.data.annotations.InternalDoNotExport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitSupportAttachment
extends DefaultAttachment {
    private static final long serialVersionUID = -3015679930172496082L;
    private HashSet<UnitType> m_unitType = null;
    @InternalDoNotExport
    private boolean m_offence = false;
    @InternalDoNotExport
    private boolean m_defence = false;
    @InternalDoNotExport
    private boolean m_roll = false;
    @InternalDoNotExport
    private boolean m_strength = false;
    private int m_bonus = 0;
    private int m_number = 0;
    @InternalDoNotExport
    private boolean m_allied = false;
    @InternalDoNotExport
    private boolean m_enemy = false;
    private String m_bonusType = null;
    private ArrayList<PlayerID> m_players = new ArrayList();
    private boolean m_impArtTech = false;
    private String m_dice = null;
    private String m_faction = null;
    private String m_side = null;

    public UnitSupportAttachment(String name, Attachable attachable, GameData gameData) {
        super(name, attachable, gameData);
    }

    public static Set<UnitSupportAttachment> get(UnitType u) {
        HashSet<UnitSupportAttachment> supports = new HashSet<UnitSupportAttachment>();
        Map<String, IAttachment> map = u.getAttachments();
        Iterator<String> objsIter = map.keySet().iterator();
        while (objsIter.hasNext()) {
            IAttachment attachment = map.get(objsIter.next());
            String name = attachment.getName();
            if (!name.startsWith("supportAttachment")) continue;
            supports.add((UnitSupportAttachment)attachment);
        }
        return supports;
    }

    public static UnitSupportAttachment get(UnitType u, String nameOfAttachment) {
        UnitSupportAttachment rVal = (UnitSupportAttachment)u.getAttachment(nameOfAttachment);
        if (rVal == null) {
            throw new IllegalStateException("No unit type attachment for:" + u.getName() + " with name:" + nameOfAttachment);
        }
        return rVal;
    }

    public static Set<UnitSupportAttachment> get(GameData data) {
        HashSet<UnitSupportAttachment> supports = new HashSet<UnitSupportAttachment>();
        data.acquireReadLock();
        Iterator<UnitType> i = data.getUnitTypeList().iterator();
        while (i.hasNext()) {
            supports.addAll(UnitSupportAttachment.get(i.next()));
        }
        data.releaseReadLock();
        return supports;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUnitType(String names) throws GameParseException {
        if (names == null) {
            this.m_unitType = null;
            return;
        }
        this.m_unitType = new HashSet();
        String[] s = names.split(":");
        for (int i = 0; i < s.length; ++i) {
            UnitType type = this.getData().getUnitTypeList().getUnitType(s[i]);
            if (type == null) {
                throw new GameParseException("Could not find unitType. name:" + s[i] + this.thisErrorMsg());
            }
            this.m_unitType.add(type);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setUnitType(HashSet<UnitType> value) {
        this.m_unitType = value;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setFaction(String faction) throws GameParseException {
        if (faction == null) {
            this.m_faction = null;
            return;
        }
        String[] s = faction.split(":");
        for (int i = 0; i < s.length; ++i) {
            if (s[i].equalsIgnoreCase("allied")) {
                this.m_allied = true;
                continue;
            }
            if (s[i].equalsIgnoreCase("enemy")) {
                this.m_enemy = true;
                continue;
            }
            throw new GameParseException(faction + " faction must be allied, or enemy" + this.thisErrorMsg());
        }
        this.m_faction = faction;
    }

    public String getFaction() {
        return this.m_faction;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setSide(String side) throws GameParseException {
        if (side == null) {
            this.m_side = null;
            return;
        }
        String[] s = side.split(":");
        for (int i = 0; i < s.length; ++i) {
            if (s[i].equalsIgnoreCase("defence")) {
                this.m_defence = true;
                continue;
            }
            if (s[i].equalsIgnoreCase("offence")) {
                this.m_offence = true;
                continue;
            }
            throw new GameParseException(side + " side must be defence or offence" + this.thisErrorMsg());
        }
        this.m_side = side;
    }

    public String getSide() {
        return this.m_side;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setDice(String dice) throws GameParseException {
        if (dice == null) {
            this.m_dice = null;
            return;
        }
        String[] s = dice.split(":");
        for (int i = 0; i < s.length; ++i) {
            if (s[i].equalsIgnoreCase("roll")) {
                this.m_roll = true;
                continue;
            }
            if (s[i].equalsIgnoreCase("strength")) {
                this.m_strength = true;
                continue;
            }
            throw new GameParseException(dice + " dice must be roll or strength" + this.thisErrorMsg());
        }
        this.m_dice = dice;
    }

    public String getDice() {
        return this.m_dice;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setBonus(String bonus) {
        this.m_bonus = UnitSupportAttachment.getInt(bonus);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setBonus(Integer bonus) {
        this.m_bonus = bonus;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setNumber(String number) {
        this.m_number = UnitSupportAttachment.getInt(number);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setNumber(Integer number) {
        this.m_number = number;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setBonusType(String type) {
        if (type == null) {
            this.m_bonusType = null;
            return;
        }
        this.m_bonusType = type;
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=true)
    public void setPlayers(String names) throws GameParseException {
        String[] s = names.split(":");
        for (int i = 0; i < s.length; ++i) {
            PlayerID player = this.getData().getPlayerList().getPlayerID(s[i]);
            if (player == null) {
                throw new GameParseException("Could not find player. name:" + s[i] + this.thisErrorMsg());
            }
            this.m_players.add(player);
        }
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setPlayers(ArrayList<PlayerID> value) {
        this.m_players = value;
    }

    public ArrayList<PlayerID> getPlayers() {
        return this.m_players;
    }

    public void clearPlayers() {
        this.m_players.clear();
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setImpArtTech(String tech) {
        this.m_impArtTech = UnitSupportAttachment.getBool(tech);
    }

    @GameProperty(xmlProperty=true, gameProperty=true, adds=false)
    public void setImpArtTech(Boolean tech) {
        this.m_impArtTech = tech;
    }

    public HashSet<UnitType> getUnitType() {
        return this.m_unitType;
    }

    public int getNumber() {
        return this.m_number;
    }

    public int getBonus() {
        return this.m_bonus;
    }

    public boolean getDefence() {
        return this.m_defence;
    }

    public boolean getOffence() {
        return this.m_offence;
    }

    public String getBonusType() {
        return this.m_bonusType;
    }

    public boolean getImpArtTech() {
        return this.m_impArtTech;
    }

    @InternalDoNotExport
    public static void addRule(UnitType type, GameData data, boolean first) throws GameParseException {
        UnitSupportAttachment rule = new UnitSupportAttachment("supportAttachmentArtyOld" + type.getName(), type, data);
        rule.setBonus("1");
        rule.setBonusType("ArtyOld");
        rule.setDice("strength");
        rule.setFaction("allied");
        rule.setImpArtTech("true");
        if (first) {
            rule.setNumber("0");
        } else {
            rule.setNumber("1");
        }
        rule.setSide("offence");
        if (first) {
            rule.addUnitTypes(Collections.singleton(type));
        } else {
            rule.addUnitTypes(UnitSupportAttachment.getTargets(data));
        }
        rule.setPlayers(new ArrayList<PlayerID>(data.getPlayerList().getPlayers()));
        type.addAttachment("supportAttachmentArtyOld" + type.getName(), rule);
    }

    @InternalDoNotExport
    private static Set<UnitType> getTargets(GameData data) {
        for (UnitSupportAttachment rule : UnitSupportAttachment.get(data)) {
            if (!rule.getBonusType().equals("ArtyOld")) continue;
            return rule.getUnitType();
        }
        return null;
    }

    @InternalDoNotExport
    private void addUnitTypes(Set<UnitType> types) {
        if (types == null) {
            return;
        }
        if (this.m_unitType == null) {
            this.m_unitType = new HashSet();
        }
        this.m_unitType.addAll(types);
    }

    @InternalDoNotExport
    public static void setOldSupportCount(UnitType type, GameData data, String count) {
        for (UnitSupportAttachment rule : UnitSupportAttachment.get(data)) {
            if (!rule.getBonusType().equals("ArtyOld") || rule.getAttachedTo() != type) continue;
            rule.setNumber(count);
        }
    }

    @InternalDoNotExport
    public static void addTarget(UnitType type, GameData data) throws GameParseException {
        Iterator<UnitSupportAttachment> iter = UnitSupportAttachment.get(data).iterator();
        boolean first = true;
        while (iter.hasNext()) {
            UnitSupportAttachment rule = iter.next();
            if (!rule.getBonusType().equals("ArtyOld")) continue;
            rule.addUnitTypes(Collections.singleton(type));
            first = false;
        }
        if (first) {
            UnitSupportAttachment.addRule(type, data, first);
        }
    }

    @Override
    public void validate(GameData data) throws GameParseException {
    }
}

