/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.attatchments;

import games.strategy.engine.data.UnitType;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitTypeComparator
implements Comparator<UnitType> {
    @Override
    public int compare(UnitType o1, UnitType o2) {
        UnitType u1 = o1;
        UnitType u2 = o2;
        UnitAttachment ua1 = UnitAttachment.get(u1);
        UnitAttachment ua2 = UnitAttachment.get(u2);
        if (ua1 == null) {
            throw new IllegalStateException("No unit type attachment for unit type : " + u1.getName());
        }
        if (ua2 == null) {
            throw new IllegalStateException("No unit type attachment for unit type : " + u2.getName());
        }
        if (ua1.getIsFactory() && !ua2.getIsFactory()) {
            return 1;
        }
        if (ua2.getIsFactory() && !ua1.getIsFactory()) {
            return -1;
        }
        if (Matches.UnitTypeIsAAforAnything.match(u1) && !Matches.UnitTypeIsAAforAnything.match(u2)) {
            return 1;
        }
        if (!Matches.UnitTypeIsAAforAnything.match(u1) && Matches.UnitTypeIsAAforAnything.match(u2)) {
            return -1;
        }
        if (ua1.getIsAir() && !ua2.getIsAir()) {
            return 1;
        }
        if (ua2.getIsAir() && !ua1.getIsAir()) {
            return -1;
        }
        if (ua1.getIsSea() && !ua2.getIsSea()) {
            return 1;
        }
        if (ua2.getIsSea() && !ua1.getIsSea()) {
            return -1;
        }
        if (ua1.getRawAttack() != ua2.getRawAttack()) {
            return ua1.getRawAttack() - ua2.getRawAttack();
        }
        return u1.getName().compareTo(u2.getName());
    }
}

