/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseDelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipTracker;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.message.IRemote;
import games.strategy.engine.pbem.PBEMMessagePoster;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.EndTurnExtendedDelegateState;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveDelegate;
import games.strategy.triplea.delegate.remote.IAbstractEndTurnDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEndTurnDelegate
extends BaseDelegate
implements IAbstractEndTurnDelegate {
    private boolean m_needToInitialize = true;
    private boolean m_hasPostedTurnSummary = false;

    private boolean doBattleShipsRepairEndOfTurn() {
        return Properties.getBattleshipsRepairAtEndOfRound(this.getData());
    }

    private boolean isGiveUnitsByTerritory() {
        return Properties.getGiveUnitsByTerritory(this.getData());
    }

    @Override
    public void start(IDelegateBridge aBridge) {
        GameData data = aBridge.getData();
        Resource PUs = data.getResourceList().getResource("PUs");
        int leftOverPUs = aBridge.getPlayerID().getResources().getQuantity(PUs);
        super.start(aBridge);
        if (!this.m_needToInitialize) {
            return;
        }
        this.m_hasPostedTurnSummary = false;
        PlayerAttachment pa = PlayerAttachment.get(this.m_player);
        ArrayList<Territory> capitalsListOriginal = new ArrayList<Territory>(TerritoryAttachment.getAllCapitals(this.m_player, data));
        ArrayList<Territory> capitalsListOwned = new ArrayList<Territory>(TerritoryAttachment.getAllCurrentlyOwnedCapitals(this.m_player, data));
        if (!capitalsListOriginal.isEmpty() && capitalsListOwned.isEmpty() || pa != null && pa.getRetainCapitalProduceNumber() > capitalsListOwned.size()) {
            return;
        }
        Collection<Territory> territories = data.getMap().getTerritoriesOwnedBy(this.m_player);
        int toAdd = this.getProduction(territories);
        int blockadeLoss = this.getProductionLoss(this.m_player, data);
        toAdd -= blockadeLoss;
        int total = this.m_player.getResources().getQuantity(PUs) + (toAdd *= Properties.getPU_Multiplier(data).intValue());
        String transcriptText = blockadeLoss == 0 ? this.m_player.getName() + " collect " + toAdd + MyFormatter.pluralize(" PU", toAdd) + "; end with " + total + MyFormatter.pluralize(" PU", total) + " total" : this.m_player.getName() + " collect " + toAdd + MyFormatter.pluralize(" PU", toAdd) + " (" + blockadeLoss + " lost to blockades)" + "; end with " + total + MyFormatter.pluralize(" PU", total) + " total";
        aBridge.getHistoryWriter().startEvent(transcriptText);
        if (this.isWarBonds(this.m_player)) {
            int bonds = this.rollWarBonds(aBridge);
            toAdd += bonds;
            transcriptText = this.m_player.getName() + " collect " + bonds + MyFormatter.pluralize(" PU", bonds) + " from War Bonds; end with " + (total += bonds) + MyFormatter.pluralize(" PU", total) + " total";
            aBridge.getHistoryWriter().startEvent(transcriptText);
        }
        if (total < 0) {
            toAdd -= total;
            total = 0;
        }
        Change change = ChangeFactory.changeResourcesChange(this.m_player, PUs, toAdd);
        aBridge.addChange(change);
        if (data.getProperties().get("Pacific Theater", false) && pa != null) {
            Change changeVP = ChangeFactory.attachmentPropertyChange(pa, pa.getVps() + toAdd / 10 + pa.getCaptureVps() / 10, "vps");
            Change changeCapVP = ChangeFactory.attachmentPropertyChange(pa, "0", "captureVps");
            CompositeChange ccVP = new CompositeChange(changeVP, changeCapVP);
            aBridge.addChange(ccVP);
        }
        this.addOtherResources(aBridge);
        this.doNationalObjectivesAndOtherEndTurnEffects(aBridge);
        if (this.doBattleShipsRepairEndOfTurn()) {
            MoveDelegate.repairBattleShips(aBridge, aBridge.getPlayerID(), false);
        }
        if (this.isGiveUnitsByTerritory() && pa != null && pa.getGiveUnitControl() != null && !pa.getGiveUnitControl().isEmpty()) {
            this.changeUnitOwnership(aBridge);
        }
        int currentPUs = this.m_player.getResources().getQuantity(PUs);
        float gainedPUS = Math.max(0, currentPUs - leftOverPUs);
        int relationshipUpkeepCostFlat = 0;
        int relationshipUpkeepCostPercentage = 0;
        int relationshipUpkeepTotalCost = 0;
        for (RelationshipTracker.Relationship r : data.getRelationshipTracker().getRelationships(this.m_player)) {
            String[] upkeep = r.getRelationshipType().getRelationshipTypeAttachment().getUpkeepCost().split(":");
            if (upkeep.length == 1 || upkeep[1].equals("flat")) {
                relationshipUpkeepCostFlat += Integer.parseInt(upkeep[0]);
                continue;
            }
            if (!upkeep[1].equals("percentage")) continue;
            relationshipUpkeepCostPercentage += Integer.parseInt(upkeep[0]);
        }
        if ((relationshipUpkeepCostPercentage = Math.min(100, relationshipUpkeepCostPercentage)) != 0) {
            relationshipUpkeepTotalCost += Math.round(gainedPUS * (float)relationshipUpkeepCostPercentage / 100.0f);
        }
        if (relationshipUpkeepCostFlat != 0) {
            relationshipUpkeepTotalCost += relationshipUpkeepCostFlat;
        }
        relationshipUpkeepTotalCost = Math.min(currentPUs, relationshipUpkeepTotalCost);
        if ((relationshipUpkeepTotalCost = -1 * relationshipUpkeepTotalCost) != 0) {
            int newTotal = currentPUs + relationshipUpkeepTotalCost;
            transcriptText = this.m_player.getName() + (relationshipUpkeepTotalCost < 0 ? " pays " : " taxes ") + -1 * relationshipUpkeepTotalCost + MyFormatter.pluralize(" PU", relationshipUpkeepTotalCost) + " in order to maintain current relationships with other players, and ends the turn with " + newTotal + MyFormatter.pluralize(" PU", newTotal);
            aBridge.getHistoryWriter().startEvent(transcriptText);
            Change upkeep = ChangeFactory.changeResourcesChange(this.m_player, PUs, relationshipUpkeepTotalCost);
            aBridge.addChange(upkeep);
        }
        this.m_needToInitialize = false;
    }

    @Override
    public void end() {
        super.end();
        this.m_needToInitialize = true;
        DelegateFinder.battleDelegate(this.getData()).getBattleTracker().clear();
    }

    @Override
    public Serializable saveState() {
        EndTurnExtendedDelegateState state = new EndTurnExtendedDelegateState();
        state.superState = super.saveState();
        state.m_needToInitialize = this.m_needToInitialize;
        state.m_hasPostedTurnSummary = this.m_hasPostedTurnSummary;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        EndTurnExtendedDelegateState s = (EndTurnExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_needToInitialize = s.m_needToInitialize;
        this.m_hasPostedTurnSummary = s.m_hasPostedTurnSummary;
    }

    private int rollWarBonds(IDelegateBridge aBridge) {
        PlayerID player = aBridge.getPlayerID();
        boolean count = true;
        int sides = aBridge.getData().getDiceSides();
        String annotation = player.getName() + " roll to resolve War Bonds: ";
        DiceRoll dice = DiceRoll.rollNDice(aBridge, 1, sides, annotation);
        int total = dice.getDie(0).getValue() + 1;
        this.getRemotePlayer(player).reportMessage(annotation + total, annotation + total);
        return total;
    }

    private ITripleaPlayer getRemotePlayer(PlayerID player) {
        return (ITripleaPlayer)this.m_bridge.getRemote(player);
    }

    private void changeUnitOwnership(IDelegateBridge aBridge) {
        PlayerID Player = aBridge.getPlayerID();
        PlayerAttachment pa = PlayerAttachment.get(Player);
        ArrayList<PlayerID> PossibleNewOwners = pa.getGiveUnitControl();
        Collection<Territory> territories = aBridge.getData().getMap().getTerritories();
        for (Territory currTerritory : territories) {
            TerritoryAttachment ta = (TerritoryAttachment)currTerritory.getAttachment("territoryAttatchment");
            if (ta == null || ta.getChangeUnitOwners() == null || ta.getChangeUnitOwners().isEmpty()) continue;
            ArrayList<PlayerID> terrNewOwners = ta.getChangeUnitOwners();
            for (PlayerID terrNewOwner : terrNewOwners) {
                List<Unit> units;
                if (!PossibleNewOwners.contains(terrNewOwner) || (units = currTerritory.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.unitOwnedBy(Player), Matches.UnitCanBeGivenByTerritoryTo(terrNewOwner)))).isEmpty()) continue;
                Change changeOwner = ChangeFactory.changeOwner(units, terrNewOwner, currTerritory);
                aBridge.getHistoryWriter().addChildToEvent(changeOwner.toString());
                aBridge.addChange(changeOwner);
            }
        }
    }

    protected abstract void addOtherResources(IDelegateBridge var1);

    protected abstract void doNationalObjectivesAndOtherEndTurnEffects(IDelegateBridge var1);

    protected int getProduction(Collection<Territory> territories) {
        return AbstractEndTurnDelegate.getProduction(territories, this.getData());
    }

    public static int getProduction(Collection<Territory> territories, GameData data) {
        int value = 0;
        for (Territory current : territories) {
            TerritoryAttachment attachment = (TerritoryAttachment)current.getAttachment("territoryAttatchment");
            if (attachment == null) {
                throw new IllegalStateException("No attachment for owned territory:" + current.getName());
            }
            if (!Matches.territoryCanCollectIncomeFrom(current.getOwner(), data).match(current)) continue;
            value += attachment.getProduction();
        }
        return value;
    }

    protected int getProductionLoss(PlayerID player, GameData data) {
        List<Territory> blockable = Match.getMatches(data.getMap().getTerritories(), Matches.territoryIsBlockadeZone);
        CompositeMatchAnd enemyUnits = new CompositeMatchAnd(Matches.enemyUnit(player, data));
        int totalLoss = 0;
        for (Territory b : blockable) {
            int maxLoss = 0;
            for (Territory m : data.getMap().getNeighbors(b)) {
                if (!m.getOwner().equals(player)) continue;
                maxLoss += TerritoryAttachment.get(m).getProduction();
            }
            int loss = 0;
            List<Unit> enemies = Match.getMatches(b.getUnits().getUnits(), enemyUnits);
            for (Unit u : enemies) {
                loss += UnitAttachment.get(u.getType()).getBlockade();
            }
            totalLoss += Math.min(maxLoss, loss);
        }
        return totalLoss;
    }

    private boolean isWarBonds(PlayerID player) {
        TechAttachment ta = (TechAttachment)player.getAttachment("techAttatchment");
        if (ta != null) {
            return ta.getWarBonds();
        }
        return false;
    }

    @Override
    public void setHasPostedTurnSummary(boolean hasPostedTurnSummary) {
        this.m_hasPostedTurnSummary = hasPostedTurnSummary;
    }

    @Override
    public boolean getHasPostedTurnSummary() {
        return this.m_hasPostedTurnSummary;
    }

    @Override
    public boolean postTurnSummary(PBEMMessagePoster poster) {
        this.m_hasPostedTurnSummary = poster.post(this.m_bridge.getHistoryWriter());
        return this.m_hasPostedTurnSummary;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getDisplayName() {
        return this.m_displayName;
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IAbstractEndTurnDelegate.class;
    }
}

