/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.delegate.dataObjects.AbstractMoveDescription;
import java.io.Serializable;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUndoableMove
implements Serializable {
    protected final CompositeChange m_change;
    protected int m_index;
    protected final Collection<Unit> m_units;

    public AbstractUndoableMove(CompositeChange change, Collection<Unit> units) {
        this.m_change = change;
        this.m_units = units;
    }

    public final void undo(GameData data, IDelegateBridge delegateBridge) {
        delegateBridge.getHistoryWriter().startEvent(delegateBridge.getPlayerID().getName() + " undo move " + (this.getIndex() + 1) + ".");
        delegateBridge.getHistoryWriter().setRenderingData(this.getDescriptionObject());
        delegateBridge.addChange(this.m_change.invert());
        this.undoSpecific(delegateBridge);
    }

    protected abstract void undoSpecific(IDelegateBridge var1);

    public final CompositeChange getChange() {
        return this.m_change;
    }

    public final void addChange(Change aChange) {
        this.m_change.add(aChange);
    }

    public Collection<Unit> getUnits() {
        return this.m_units;
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setIndex(int index) {
        this.m_index = index;
    }

    public abstract String getMoveLabel();

    public abstract Territory getEnd();

    protected abstract AbstractMoveDescription getDescriptionObject();
}

