/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AirMovementValidator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AirThatCantLandUtil {
    private final IDelegateBridge m_bridge;

    public AirThatCantLandUtil(IDelegateBridge bridge) {
        this.m_bridge = bridge;
    }

    public static boolean isLHTRCarrierProduction(GameData data) {
        return Properties.getLHTRCarrierProductionRules(data);
    }

    public static boolean isLandExistingFightersOnNewCarriers(GameData data) {
        return Properties.getLandExistingFightersOnNewCarriers(data);
    }

    public Collection<Territory> getTerritoriesWhereAirCantLand(PlayerID player) {
        GameData data = this.m_bridge.getData();
        ArrayList<Territory> cantLand = new ArrayList<Territory>();
        for (Territory current : data.getMap().getTerritories()) {
            CompositeMatchAnd<Unit> ownedAir = new CompositeMatchAnd<Unit>(new Match[0]);
            ownedAir.add(Matches.UnitIsAir);
            ownedAir.add(Matches.unitIsOwnedBy(player));
            List<Unit> air = current.getUnits().getMatches(ownedAir);
            if (air.size() == 0 || AirMovementValidator.canLand(air, current, player, data)) continue;
            cantLand.add(current);
        }
        return cantLand;
    }

    public void removeAirThatCantLand(PlayerID player, boolean spareAirInSeaZonesBesideFactories) {
        GameData data = this.m_bridge.getData();
        GameMap map = data.getMap();
        for (Territory current : this.getTerritoriesWhereAirCantLand(player)) {
            CompositeMatchAnd<Unit> ownedAir = new CompositeMatchAnd<Unit>(new Match[0]);
            ownedAir.add(Matches.UnitIsAir);
            ownedAir.add(Matches.alliedUnit(player, data));
            List<Unit> air = current.getUnits().getMatches(ownedAir);
            boolean hasNeighboringFriendlyFactory = map.getNeighbors(current, Matches.territoryHasAlliedIsFactoryOrCanProduceUnits(data, player)).size() > 0;
            boolean skip = spareAirInSeaZonesBesideFactories && current.isWater() && hasNeighboringFriendlyFactory;
            if (skip) continue;
            this.removeAirThatCantLand(player, current, air);
        }
    }

    private void removeAirThatCantLand(PlayerID player, Territory territory, Collection<Unit> airUnits) {
        ArrayList<Unit> toRemove = new ArrayList<Unit>(airUnits.size());
        if (!territory.isWater()) {
            toRemove.addAll(airUnits);
        } else {
            List<Unit> carriers = territory.getUnits().getMatches(Matches.alliedUnit(player, this.m_bridge.getData()));
            int capacity = AirMovementValidator.carrierCapacity(carriers, territory);
            for (Unit unit : airUnits) {
                UnitAttachment ua = UnitAttachment.get(unit.getType());
                int cost = ua.getCarrierCost();
                if (cost == -1 || cost > capacity) {
                    toRemove.add(unit);
                    continue;
                }
                capacity -= cost;
            }
        }
        Change remove = ChangeFactory.removeUnits(territory, toRemove);
        String transcriptText = MyFormatter.unitsToTextNoOwner(toRemove) + " could not land in " + territory.getName() + " and " + (toRemove.size() > 1 ? "were" : "was") + " removed";
        this.m_bridge.getHistoryWriter().startEvent(transcriptText);
        this.m_bridge.addChange(remove);
    }
}

