/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseDelegate;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.history.Event;
import games.strategy.engine.history.EventChild;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.Step;
import games.strategy.engine.message.IRemote;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.EditExtendedDelegateState;
import games.strategy.triplea.delegate.EditValidator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TripleADelegateBridge;
import games.strategy.triplea.delegate.remote.IEditDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditDelegate
extends BaseDelegate
implements IEditDelegate {
    public void initialize(String name) {
        this.initialize(name, name);
    }

    @Override
    public void start(IDelegateBridge bridge) {
        this.m_bridge = new TripleADelegateBridge(bridge);
        this.m_player = bridge.getPlayerID();
    }

    @Override
    public void end() {
    }

    @Override
    public Serializable saveState() {
        EditExtendedDelegateState state = new EditExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        EditExtendedDelegateState s = (EditExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    public static boolean getEditMode(GameData data) {
        Object editMode = data.getProperties().get("EditMode");
        if (editMode == null) {
            return false;
        }
        if (!(editMode instanceof Boolean)) {
            return false;
        }
        return (Boolean)editMode;
    }

    private String checkPlayerID() {
        ITripleaPlayer remotePlayer = (ITripleaPlayer)this.m_bridge.getRemote();
        if (!this.m_bridge.getPlayerID().equals(remotePlayer.getID())) {
            return "Edit actions can only be performed during players turn";
        }
        return null;
    }

    private String checkEditMode() {
        String result = this.checkPlayerID();
        if (null != result) {
            return result;
        }
        if (!EditDelegate.getEditMode(this.getData())) {
            return "Edit mode is not enabled";
        }
        return null;
    }

    @Override
    public String setEditMode(boolean editMode) {
        ITripleaPlayer remotePlayer = (ITripleaPlayer)this.m_bridge.getRemote();
        if (!this.m_bridge.getPlayerID().equals(remotePlayer.getID())) {
            return "Edit Mode can only be toggled during players turn";
        }
        this.logEvent("Turning " + (editMode ? "on" : "off") + " Edit Mode", null);
        this.m_bridge.addChange(ChangeFactory.setProperty("EditMode", editMode, this.getData()));
        return null;
    }

    @Override
    public boolean getEditMode() {
        return EditDelegate.getEditMode(this.getData());
    }

    @Override
    public String removeUnits(Territory territory, Collection<Unit> units) {
        String result = null;
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        result = EditValidator.validateRemoveUnits(this.getData(), territory, units);
        if (null != result) {
            return result;
        }
        if (units == null || units.isEmpty()) {
            return null;
        }
        this.logEvent(this.m_bridge.getPlayerID().getName() + " player Removing units owned by " + units.iterator().next().getOwner() + " from " + territory.getName() + ": " + MyFormatter.unitsToTextNoOwner(units), units);
        this.m_bridge.addChange(ChangeFactory.removeUnits(territory, units));
        return null;
    }

    @Override
    public String addUnits(Territory territory, Collection<Unit> units) {
        String result = null;
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        result = EditValidator.validateAddUnits(this.getData(), territory, units);
        if (null != result) {
            return result;
        }
        if (units == null || units.isEmpty()) {
            return null;
        }
        this.logEvent(this.m_bridge.getPlayerID().getName() + " player Adding units owned by " + units.iterator().next().getOwner() + " to " + territory.getName() + ": " + MyFormatter.unitsToTextNoOwner(units), units);
        this.m_bridge.addChange(ChangeFactory.addUnits(territory, units));
        return null;
    }

    protected int getProduction(Territory territory) {
        TerritoryAttachment ta = TerritoryAttachment.get(territory);
        if (ta != null) {
            return ta.getProduction();
        }
        return 0;
    }

    @Override
    public String changeTerritoryOwner(Territory territory, PlayerID player) {
        String result = null;
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        GameData data = this.getData();
        result = EditValidator.validateChangeTerritoryOwner(data, territory, player);
        if (null != result) {
            return result;
        }
        this.logEvent(this.m_bridge.getPlayerID().getName() + " player Changing ownership of " + territory.getName() + " from " + territory.getOwner().getName() + " to " + player.getName(), territory);
        if (data.getRelationshipTracker().isAllied(territory.getOwner(), player)) {
            List<Unit> units = territory.getUnits().getMatches(Matches.UnitIsFactory);
            for (Unit unit : units) {
                this.m_bridge.addChange(ChangeFactory.changeOwner(unit, player, territory));
            }
        } else {
            CompositeMatchAnd<Unit> enemyNonCom = new CompositeMatchAnd<Unit>(new Match[0]);
            enemyNonCom.add(Matches.UnitIsFactoryOrIsInfrastructure);
            enemyNonCom.add(Matches.enemyUnit(player, data));
            List<Unit> units = territory.getUnits().getMatches(enemyNonCom);
            this.m_bridge.addChange(ChangeFactory.markNoMovementChange(units));
            for (Unit unit : units) {
                this.m_bridge.addChange(ChangeFactory.changeOwner(unit, player, territory));
            }
        }
        this.m_bridge.addChange(ChangeFactory.changeOwner(territory, player));
        return null;
    }

    @Override
    public String changePUs(PlayerID player, int newTotal) {
        String result = null;
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        Resource PUs = this.getData().getResourceList().getResource("PUs");
        int oldTotal = player.getResources().getQuantity(PUs);
        if (oldTotal == newTotal) {
            return "New PUs total is unchanged";
        }
        if (newTotal < 0) {
            return "New PUs total is invalid";
        }
        this.logEvent(this.m_bridge.getPlayerID().getName() + " player Changing PUs for " + player.getName() + " from " + oldTotal + " to " + newTotal, null);
        this.m_bridge.addChange(ChangeFactory.changeResourcesChange(player, PUs, newTotal - oldTotal));
        return null;
    }

    @Override
    public String changeTechTokens(PlayerID player, int newTotal) {
        String result = null;
        result = this.checkEditMode();
        if (null != result) {
            return result;
        }
        Resource techTokens = this.getData().getResourceList().getResource("techTokens");
        int oldTotal = player.getResources().getQuantity(techTokens);
        if (oldTotal == newTotal) {
            return "New token total is unchanged";
        }
        if (newTotal < 0) {
            return "New token total is invalid";
        }
        this.logEvent(this.m_bridge.getPlayerID().getName() + " player Changing tech tokens for " + player.getName() + " from " + oldTotal + " to " + newTotal, null);
        this.m_bridge.addChange(ChangeFactory.changeResourcesChange(player, techTokens, newTotal - oldTotal));
        return null;
    }

    @Override
    public String addComment(String message) {
        String result = null;
        result = this.checkPlayerID();
        if (null != result) {
            return result;
        }
        this.logEvent("COMMENT: " + message, null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logEvent(String message, Object data) {
        boolean foundChild = false;
        GameData game_data = this.getData();
        game_data.acquireReadLock();
        try {
            HistoryNode curNode = game_data.getHistory().getLastNode();
            while (!(curNode instanceof Step) && !(curNode instanceof Event)) {
                if (curNode instanceof EventChild) {
                    foundChild = true;
                    break;
                }
                curNode = (HistoryNode)curNode.getPreviousNode();
            }
        }
        finally {
            game_data.releaseReadLock();
        }
        if (foundChild) {
            this.m_bridge.getHistoryWriter().addChildToEvent(message, game_data);
        } else {
            this.m_bridge.getHistoryWriter().startEvent(message);
            this.m_bridge.getHistoryWriter().setRenderingData(game_data);
        }
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IEditDelegate.class;
    }
}

