/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.message.ConnectionLostException;
import games.strategy.net.GUID;
import games.strategy.triplea.Properties;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.ExecutionStack;
import games.strategy.triplea.delegate.IExecutable;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MustFightBattle;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fire
implements IExecutable {
    private static final long serialVersionUID = -3687054738070722403L;
    private final String m_stepName;
    private final Collection<Unit> m_firingUnits;
    private final Collection<Unit> m_attackableUnits;
    private final MustFightBattle.ReturnFire m_canReturnFire;
    private final String m_text;
    private final MustFightBattle m_battle;
    private final PlayerID m_firingPlayer;
    private final PlayerID m_hitPlayer;
    private final boolean m_defending;
    private final Map<Unit, Collection<Unit>> m_dependentUnits;
    private final GUID m_battleID;
    private DiceRoll m_dice;
    private Collection<Unit> m_killed;
    private Collection<Unit> m_damaged;
    private boolean m_confirmOwnCasualties = true;
    private final boolean m_isHeadless;

    public Fire(Collection<Unit> attackableUnits, MustFightBattle.ReturnFire canReturnFire, PlayerID firingPlayer, PlayerID hitPlayer, Collection<Unit> firingUnits, String stepName, String text, MustFightBattle battle, boolean defending, Map<Unit, Collection<Unit>> dependentUnits, ExecutionStack stack, boolean headless) {
        this.m_attackableUnits = Match.getMatches(attackableUnits, Matches.UnitIsDestructibleInCombatShort);
        this.m_canReturnFire = canReturnFire;
        this.m_firingUnits = firingUnits;
        this.m_stepName = stepName;
        this.m_text = text;
        this.m_battle = battle;
        this.m_hitPlayer = hitPlayer;
        this.m_firingPlayer = firingPlayer;
        this.m_defending = defending;
        this.m_dependentUnits = dependentUnits;
        this.m_isHeadless = headless;
        this.m_battleID = battle.getBattleID();
    }

    private void rollDice(IDelegateBridge bridge) {
        if (this.m_dice != null) {
            throw new IllegalStateException("Already rolled");
        }
        ArrayList<Unit> units = new ArrayList<Unit>(this.m_firingUnits);
        String annotation = this.m_isHeadless ? "" : DiceRoll.getAnnotation(units, this.m_firingPlayer, this.m_battle);
        this.m_dice = DiceRoll.rollDice(units, this.m_defending, this.m_firingPlayer, bridge, this.m_battle, annotation);
    }

    private void selectCasualties(IDelegateBridge bridge) {
        int hitCount = this.m_dice.getHits();
        MustFightBattle.getDisplay(bridge).notifyDice(this.m_battle.getBattleID(), this.m_dice, this.m_stepName);
        int countTransports = Match.countMatches(this.m_attackableUnits, new CompositeMatchAnd(Matches.UnitIsTransport, Matches.UnitIsSea));
        if (countTransports > 0 && this.isTransportCasualtiesRestricted(bridge.getData())) {
            List<Unit> nonTransports = Match.getMatches(this.m_attackableUnits, new CompositeMatchOr(Matches.UnitIsNotTransportButCouldBeCombatTransport, Matches.UnitIsNotSea));
            List<Unit> transportsOnly = Match.getMatches(this.m_attackableUnits, new CompositeMatchAnd(Matches.UnitIsTransportButNotCombatTransport, Matches.UnitIsSea));
            int numPossibleHits = MustFightBattle.getMaxHits(nonTransports);
            if (hitCount > numPossibleHits) {
                int extraHits = hitCount - numPossibleHits;
                ArrayList<Unit> remainingTargets = new ArrayList<Unit>();
                remainingTargets.addAll(this.m_attackableUnits);
                remainingTargets.removeAll(nonTransports);
                ArrayList<PlayerID> alliedHitPlayer = new ArrayList<PlayerID>();
                for (Unit unit : transportsOnly) {
                    if (alliedHitPlayer.contains(unit.getOwner())) continue;
                    alliedHitPlayer.add(unit.getOwner());
                }
                for (PlayerID player : alliedHitPlayer) {
                    CompositeMatchAnd<Unit> match = new CompositeMatchAnd<Unit>(new Match[0]);
                    match.add(Matches.UnitIsTransportButNotCombatTransport);
                    match.add(Matches.unitIsOwnedBy(player));
                    List<Unit> playerTransports = Match.getMatches(transportsOnly, match);
                    int transportsToRemove = Math.max(0, playerTransports.size() - extraHits);
                    transportsOnly.removeAll(Match.getNMatches(playerTransports, transportsToRemove, Matches.UnitIsTransportButNotCombatTransport));
                }
                this.m_killed = nonTransports;
                this.m_damaged = Collections.emptyList();
                if (extraHits > transportsOnly.size()) {
                    extraHits = transportsOnly.size();
                }
                CasualtyDetails message = BattleCalculator.selectCasualties(this.m_stepName, this.m_hitPlayer, transportsOnly, bridge, this.m_text, this.m_dice, !this.m_defending, this.m_battleID, this.m_isHeadless, extraHits);
                this.m_killed.addAll(message.getKilled());
                this.m_confirmOwnCasualties = true;
            } else if (hitCount == numPossibleHits) {
                this.m_killed = nonTransports;
                this.m_damaged = Collections.emptyList();
                this.m_confirmOwnCasualties = true;
            } else {
                CasualtyDetails message = BattleCalculator.selectCasualties(this.m_stepName, this.m_hitPlayer, nonTransports, bridge, this.m_text, this.m_dice, !this.m_defending, this.m_battleID, this.m_isHeadless, this.m_dice.getHits());
                this.m_killed = message.getKilled();
                this.m_damaged = message.getDamaged();
                this.m_confirmOwnCasualties = message.getAutoCalculated();
            }
        } else if (hitCount >= MustFightBattle.getMaxHits(this.m_attackableUnits)) {
            this.m_killed = this.m_attackableUnits;
            this.m_damaged = Collections.emptyList();
            this.m_confirmOwnCasualties = true;
        } else {
            CasualtyDetails message = BattleCalculator.selectCasualties(this.m_stepName, this.m_hitPlayer, this.m_attackableUnits, bridge, this.m_text, this.m_dice, !this.m_defending, this.m_battleID, this.m_isHeadless, this.m_dice.getHits());
            this.m_killed = message.getKilled();
            this.m_damaged = message.getDamaged();
            this.m_confirmOwnCasualties = message.getAutoCalculated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCasualties(final IDelegateBridge bridge) {
        if (this.m_isHeadless) {
            return;
        }
        MustFightBattle.getDisplay(bridge).casualtyNotification(this.m_battleID, this.m_stepName, this.m_dice, this.m_hitPlayer, new ArrayList<Unit>(this.m_killed), new ArrayList<Unit>(this.m_damaged), this.m_dependentUnits);
        Runnable r = new Runnable(){

            public void run() {
                try {
                    MustFightBattle.getRemote(Fire.this.m_firingPlayer, bridge).confirmEnemyCasualties(Fire.this.m_battleID, "Press space to continue", Fire.this.m_hitPlayer);
                }
                catch (ConnectionLostException cle) {
                    cle.printStackTrace(System.out);
                }
            }
        };
        Thread t = new Thread(r, "Click to continue waiter");
        t.start();
        if (this.m_confirmOwnCasualties) {
            MustFightBattle.getRemote(this.m_hitPlayer, bridge).confirmOwnCasualties(this.m_battleID, "Press space to continue");
        }
        try {
            bridge.leaveDelegateExecution();
            t.join();
        }
        catch (InterruptedException e) {
        }
        finally {
            bridge.enterDelegateExecution();
        }
    }

    @Override
    public void execute(ExecutionStack stack, IDelegateBridge bridge) {
        IExecutable rollDice = new IExecutable(){

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                Fire.this.rollDice(bridge);
            }
        };
        IExecutable selectCasualties = new IExecutable(){

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                Fire.this.selectCasualties(bridge);
            }
        };
        IExecutable notifyCasualties = new IExecutable(){
            private static final long serialVersionUID = -9173385989239225660L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                Fire.this.notifyCasualties(bridge);
                if (Fire.this.m_damaged != null) {
                    Fire.this.m_battle.markDamaged(Fire.this.m_damaged, bridge);
                }
                Fire.this.m_battle.removeCasualties(Fire.this.m_killed, Fire.this.m_canReturnFire, !Fire.this.m_defending, bridge, false);
            }
        };
        stack.push(notifyCasualties);
        stack.push(selectCasualties);
        stack.push(rollDice);
    }

    private boolean isTransportCasualtiesRestricted(GameData data) {
        return Properties.getTransportCasualtiesRestricted(data);
    }
}

