/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.net.GUID;
import games.strategy.triplea.delegate.dataObjects.BattleRecords;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IBattle
extends Serializable {
    public Change addAttackChange(Route var1, Collection<Unit> var2, HashMap<Unit, HashSet<Unit>> var3);

    public boolean isBombingRun();

    public BattleType getBattleType();

    public Territory getTerritory();

    public void fight(IDelegateBridge var1);

    public boolean isOver();

    public void unitsLostInPrecedingBattle(IBattle var1, Collection<Unit> var2, IDelegateBridge var3);

    public void addBombardingUnit(Unit var1);

    public boolean isAmphibious();

    public void removeAttack(Route var1, Collection<Unit> var2);

    public boolean isEmpty();

    public Collection<Unit> getDependentUnits(Collection<Unit> var1);

    public Collection<Unit> getAmphibiousLandAttackers();

    public Collection<Unit> getBombardingUnits();

    public int getBattleRound();

    public Collection<Unit> getAttackingUnits();

    public Collection<Unit> getDefendingUnits();

    public List<Unit> getRemainingAttackingUnits();

    public List<Unit> getRemainingDefendingUnits();

    public WhoWon getWhoWon();

    public BattleRecords.BattleResultDescription getBattleResultDescription();

    public PlayerID getAttacker();

    public PlayerID getDefender();

    public GUID getBattleID();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BattleType {
        NORMAL("Battle"),
        AIR_BATTLE("Air Battle"),
        MOCK_BATTLE("Mock Battle"),
        BOMBING_RAID("Bombing Raid");

        private final String m_type;

        private BattleType(String type) {
            this.m_type = type;
        }

        public String toString() {
            return this.m_type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WhoWon {
        NOTFINISHED,
        DRAW,
        ATTACKER,
        DEFENDER;

    }
}

