/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.delegate.TechAdvance;
import java.util.logging.Level;
import java.util.logging.Logger;

class IndustrialTechnologyAdvance
extends TechAdvance {
    IndustrialTechnologyAdvance() {
    }

    public String getName() {
        return "Industrial Technology";
    }

    public String getProperty() {
        return "industrialTechnology";
    }

    public void perform(PlayerID id, IDelegateBridge bridge) {
        ProductionFrontier current = id.getProductionFrontier();
        if (current.getName().endsWith("IndustrialTechnology")) {
            return;
        }
        String industrialTechName = current.getName() + "IndustrialTechnology";
        ProductionFrontier advancedTech = bridge.getData().getProductionFrontierList().getProductionFrontier(industrialTechName);
        if (advancedTech == null) {
            Logger.getLogger(TechAdvance.class.getName()).log(Level.WARNING, "No tech named:" + industrialTechName + " not adding tech");
            return;
        }
        Change prodChange = ChangeFactory.changeProductionFrontier(id, advancedTech);
        bridge.addChange(prodChange);
    }

    public boolean hasTech(TechAttachment ta) {
        return ta.getIndustrialTechnology();
    }
}

