/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.PurchaseDelegate;
import games.strategy.util.IntegerMap;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoPUPurchaseDelegate
extends PurchaseDelegate {
    private boolean isPacific;

    @Override
    public void start(IDelegateBridge aBridge) {
        super.start(aBridge);
        this.isPacific = this.isPacificTheater();
        PlayerID player = aBridge.getPlayerID();
        Collection<Territory> territories = this.getData().getMap().getTerritoriesOwnedBy(player);
        Collection<Unit> units = this.getProductionUnits(territories, player);
        Change productionChange = ChangeFactory.addUnits(player, units);
        String transcriptText = player.getName() + " builds " + units.size() + " units.";
        aBridge.getHistoryWriter().startEvent(transcriptText);
        if (productionChange != null) {
            aBridge.addChange(productionChange);
        }
    }

    private Collection<Unit> getProductionUnits(Collection<Territory> territories, PlayerID player) {
        ArrayList<Unit> productionUnits = new ArrayList<Unit>();
        if (!this.isProductionPerXTerritoriesRestricted() && !this.isProductionPerValuedTerritoryRestricted()) {
            return productionUnits;
        }
        IntegerMap<Object> productionPerXTerritories = new IntegerMap<UnitType>();
        RulesAttachment ra = (RulesAttachment)player.getAttachment("rulesAttatchment");
        if (this.isProductionPerValuedTerritoryRestricted() && (ra == null || ra.getProductionPerXTerritories() == null || ra.getProductionPerXTerritories().size() == 0)) {
            productionPerXTerritories.put((Object)this.getData().getUnitTypeList().getUnitType("infantry"), 1);
        } else if (this.isProductionPerXTerritoriesRestricted()) {
            productionPerXTerritories = ra.getProductionPerXTerritories();
        } else {
            return productionUnits;
        }
        ArrayList<Object> unitTypes = new ArrayList<Object>(productionPerXTerritories.keySet());
        for (UnitType unitType : unitTypes) {
            int unitCount = 0;
            int terrCount = 0;
            int prodPerXTerrs = productionPerXTerritories.getInt(unitType);
            if (this.isPacific) {
                unitCount += this.getBurmaRoad(player);
            }
            for (Territory current : territories) {
                if (!this.isProductionPerValuedTerritoryRestricted()) {
                    ++terrCount;
                    continue;
                }
                TerritoryAttachment ta = TerritoryAttachment.get(current);
                if (ta.getProduction() <= 0) continue;
                ++terrCount;
            }
            productionUnits.addAll(this.getData().getUnitTypeList().getUnitType(unitType.getName()).create(unitCount += terrCount / prodPerXTerrs, player));
        }
        return productionUnits;
    }

    private int getBurmaRoad(PlayerID player) {
        int burmaRoadCount = 0;
        for (Territory current : this.getData().getMap().getTerritories()) {
            String terrName = current.getName();
            if (!terrName.equals("Burma") && !terrName.equals("India") && !terrName.equals("Yunnan") && !terrName.equals("Szechwan") || !this.getData().getRelationshipTracker().isAllied(current.getOwner(), player)) continue;
            ++burmaRoadCount;
        }
        if (burmaRoadCount == 4) {
            return 1;
        }
        return 0;
    }

    private boolean isPacificTheater() {
        return Properties.getPacificTheater(this.getData());
    }

    private boolean isProductionPerValuedTerritoryRestricted() {
        return Properties.getProductionPerValuedTerritoryRestricted(this.getData());
    }

    private boolean isProductionPerXTerritoriesRestricted() {
        return Properties.getProductionPerXTerritoriesRestricted(this.getData());
    }
}

