/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.delegate.AbstractBattle;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TransportTracker;
import games.strategy.triplea.delegate.dataObjects.BattleRecords;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonFightingBattle
extends AbstractBattle {
    private static final long serialVersionUID = -1699534010648145123L;

    public NonFightingBattle(Territory battleSite, PlayerID attacker, BattleTracker battleTracker, GameData data) {
        super(battleSite, attacker, battleTracker, false, IBattle.BattleType.NORMAL, data);
    }

    @Override
    public Change addAttackChange(Route route, Collection<Unit> units, HashMap<Unit, HashSet<Unit>> targets) {
        Map<Unit, Collection<Unit>> addedTransporting = new TransportTracker().transporting(units);
        for (Unit unit : addedTransporting.keySet()) {
            if (this.m_dependentUnits.get(unit) != null) {
                ((Collection)this.m_dependentUnits.get(unit)).addAll(addedTransporting.get(unit));
                continue;
            }
            this.m_dependentUnits.put(unit, addedTransporting.get(unit));
        }
        return ChangeFactory.EMPTY_CHANGE;
    }

    @Override
    public void fight(IDelegateBridge bridge) {
        if (!this.m_battleTracker.getDependentOn(this).isEmpty()) {
            throw new IllegalStateException("Must fight battles that this battle depends on first");
        }
        boolean someAttacking = this.hasAttackingUnits();
        if (someAttacking) {
            this.m_whoWon = IBattle.WhoWon.ATTACKER;
            this.m_battleResultDescription = BattleRecords.BattleResultDescription.BLITZED;
            this.m_battleTracker.takeOver(this.m_battleSite, this.m_attacker, bridge, null, null);
            this.m_battleTracker.addToConquered(this.m_battleSite);
        } else {
            this.m_whoWon = IBattle.WhoWon.DEFENDER;
            this.m_battleResultDescription = BattleRecords.BattleResultDescription.LOST;
        }
        this.m_battleTracker.getBattleRecords().addResultToBattle(this.m_attacker, this.m_battleID, this.m_defender, this.m_attackerLostTUV, this.m_defenderLostTUV, this.m_battleResultDescription, new BattleResults(this), 0);
        this.end();
    }

    private void end() {
        this.m_battleTracker.removeBattle(this);
        this.m_isOver = true;
    }

    boolean hasAttackingUnits() {
        CompositeMatchAnd<Unit> attackingLand = new CompositeMatchAnd<Unit>(new Match[0]);
        attackingLand.add(Matches.alliedUnit(this.m_attacker, this.m_data));
        attackingLand.add(Matches.UnitIsLand);
        boolean someAttacking = this.m_battleSite.getUnits().someMatch(attackingLand);
        return someAttacking;
    }

    @Override
    public void removeAttack(Route route, Collection<Unit> units) {
        for (Unit dependence : this.m_dependentUnits.keySet()) {
            Collection dependent = (Collection)this.m_dependentUnits.get(dependence);
            dependent.removeAll(units);
        }
    }

    @Override
    public boolean isEmpty() {
        return !this.hasAttackingUnits();
    }

    @Override
    public void unitsLostInPrecedingBattle(IBattle battle, Collection<Unit> units, IDelegateBridge bridge) {
        Collection<Unit> lost = this.getDependentUnits(units);
        if ((lost = Match.getMatches(lost, Matches.unitIsInTerritory(this.m_battleSite))).size() != 0) {
            String transcriptText = MyFormatter.unitsToText(lost) + " lost in " + this.m_battleSite.getName();
            bridge.getHistoryWriter().startEvent(transcriptText);
            Change change = ChangeFactory.removeUnits(this.m_battleSite, lost);
            bridge.addChange(change);
        }
    }
}

