/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OriginalOwnerTracker
implements Serializable {
    public Change addOriginalOwnerChange(Territory t, PlayerID player) {
        return ChangeFactory.attachmentPropertyChange(TerritoryAttachment.get(t), player, "originalOwner");
    }

    public Change addOriginalOwnerChange(Unit unit, PlayerID player) {
        return ChangeFactory.unitPropertyChange(unit, player, "originalOwner");
    }

    public Change addOriginalOwnerChange(Collection<Unit> units, PlayerID player) {
        CompositeChange change = new CompositeChange();
        for (Unit unit : units) {
            change.add(this.addOriginalOwnerChange(unit, player));
        }
        return change;
    }

    public PlayerID getOriginalOwner(Unit unit) {
        return TripleAUnit.get(unit).getOriginalOwner();
    }

    public PlayerID getOriginalOwner(Territory t) {
        TerritoryAttachment ta = TerritoryAttachment.get(t);
        if (ta == null) {
            return null;
        }
        return ta.getOriginalOwner();
    }

    public Collection<Territory> getOriginallyOwned(GameData data, PlayerID player) {
        ArrayList<Territory> rVal = new ArrayList<Territory>();
        for (Territory t : data.getMap()) {
            PlayerID originalOwner = this.getOriginalOwner(t);
            if (originalOwner == null) {
                originalOwner = PlayerID.NULL_PLAYERID;
            }
            if (!originalOwner.equals(player)) continue;
            rVal.add(t);
        }
        return rVal;
    }
}

