/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseDelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RepairRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.message.IRemote;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.TriggerAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.attatchments.UnitTypeComparator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.PurchaseExtendedDelegateState;
import games.strategy.triplea.delegate.remote.IPurchaseDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurchaseDelegate
extends BaseDelegate
implements IPurchaseDelegate {
    private boolean m_needToInitialize = true;
    public static final String NOT_ENOUGH_RESOURCES = "Not enough resources";
    Comparator<RepairRule> repairRuleComparator = new Comparator<RepairRule>(){
        UnitTypeComparator utc = new UnitTypeComparator();

        @Override
        public int compare(RepairRule o1, RepairRule o2) {
            UnitType u1 = (UnitType)o1.getResults().keySet().iterator().next();
            UnitType u2 = (UnitType)o2.getResults().keySet().iterator().next();
            return this.utc.compare(u1, u2);
        }
    };

    @Override
    public void start(IDelegateBridge aBridge) {
        super.start(aBridge);
        GameData data = this.getData();
        if (this.m_needToInitialize) {
            if (Properties.getTriggers(data)) {
                CompositeMatchAnd<TriggerAttachment> purchaseDelegateTriggerMatch = new CompositeMatchAnd<TriggerAttachment>(TriggerAttachment.availableUses, TriggerAttachment.whenOrDefaultMatch(null, null), new CompositeMatchOr(TriggerAttachment.prodMatch(), TriggerAttachment.prodFrontierEditMatch(), TriggerAttachment.purchaseMatch()));
                HashSet<TriggerAttachment> toFirePossible = TriggerAttachment.collectForAllTriggersMatching(new HashSet<PlayerID>(Collections.singleton(this.m_player)), purchaseDelegateTriggerMatch, this.m_bridge);
                if (!toFirePossible.isEmpty()) {
                    HashMap<ICondition, Boolean> testedConditions = TriggerAttachment.collectTestsForAllTriggers(toFirePossible, this.m_bridge);
                    HashSet<TriggerAttachment> toFireTestedAndSatisfied = new HashSet<TriggerAttachment>(Match.getMatches(toFirePossible, TriggerAttachment.isSatisfiedMatch(testedConditions)));
                    TriggerAttachment.triggerProductionChange(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
                    TriggerAttachment.triggerProductionFrontierEditChange(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
                    TriggerAttachment.triggerPurchase(toFireTestedAndSatisfied, this.m_bridge, null, null, true, true, true, true);
                }
            }
            this.giveBonusIncomeToAI();
            this.m_needToInitialize = false;
        }
    }

    @Override
    public void end() {
        super.end();
        this.m_needToInitialize = true;
    }

    @Override
    public Serializable saveState() {
        PurchaseExtendedDelegateState state = new PurchaseExtendedDelegateState();
        state.superState = super.saveState();
        state.m_needToInitialize = this.m_needToInitialize;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        PurchaseExtendedDelegateState s = (PurchaseExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_needToInitialize = s.m_needToInitialize;
    }

    protected boolean canAfford(IntegerMap<Resource> costs, PlayerID player) {
        return player.getResources().has(costs);
    }

    @Override
    public String purchase(IntegerMap<ProductionRule> productionRules) {
        IntegerMap<Resource> costs = this.getCosts(productionRules, this.m_player);
        IntegerMap<NamedAttachable> results = this.getResults(productionRules);
        if (!this.canAfford(costs, this.m_player)) {
            return NOT_ENOUGH_RESOURCES;
        }
        for (NamedAttachable next : results.keySet()) {
            if (next instanceof Resource) continue;
            UnitType type = (UnitType)next;
            int quantity = results.getInt(type);
            UnitAttachment ua = UnitAttachment.get(type);
            int maxBuilt = ua.getMaxBuiltPerPlayer();
            if (maxBuilt == 0) {
                return "May not build any of this unit right now: " + type.getName();
            }
            if (maxBuilt <= 0) continue;
            int currentlyBuilt = 0;
            CompositeMatchAnd<Unit> unitTypeOwnedBy = new CompositeMatchAnd<Unit>(Matches.unitIsOfType(type), Matches.unitIsOwnedBy(this.m_player));
            Collection<Territory> allTerrs = this.getData().getMap().getTerritories();
            for (Territory t : allTerrs) {
                currentlyBuilt += t.getUnits().countMatches(unitTypeOwnedBy);
            }
            int allowedBuild = maxBuilt - currentlyBuilt;
            if (allowedBuild - quantity >= 0) continue;
            return "May only build " + allowedBuild + " of " + type.getName() + " this turn, may only build " + maxBuilt + " total";
        }
        Iterator<NamedAttachable> iter = results.keySet().iterator();
        ArrayList<Unit> totalUnits = new ArrayList<Unit>();
        CompositeChange changes = new CompositeChange();
        while (iter.hasNext()) {
            int quantity;
            NamedAttachable next = iter.next();
            if (next instanceof Resource) {
                Resource resource = (Resource)next;
                quantity = results.getInt(resource);
                Change change = ChangeFactory.changeResourcesChange(this.m_player, resource, quantity);
                changes.add(change);
                continue;
            }
            UnitType type = (UnitType)next;
            quantity = results.getInt(type);
            List<Unit> units = type.create(quantity, this.m_player);
            totalUnits.addAll(units);
        }
        if (!totalUnits.isEmpty()) {
            Change change = ChangeFactory.addUnits(this.m_player, totalUnits);
            changes.add(change);
        }
        String remaining = this.removeFromPlayer(this.m_player, costs, changes, totalUnits);
        this.addHistoryEvent(totalUnits, remaining, false);
        this.m_bridge.addChange(changes);
        return null;
    }

    @Override
    public String purchaseRepair(Map<Unit, IntegerMap<RepairRule>> repairRules) {
        IntegerMap<Resource> costs = this.getRepairCosts(repairRules, this.m_player);
        IntegerMap<NamedAttachable> results = this.getRepairResults(repairRules);
        if (!this.canAfford(costs, this.m_player)) {
            return NOT_ENOUGH_RESOURCES;
        }
        CompositeChange changes = new CompositeChange();
        ArrayList<Unit> totalUnits = new ArrayList<Unit>();
        for (NamedAttachable next : results.keySet()) {
            int quantity;
            if (next instanceof Resource) {
                Resource resource = (Resource)next;
                quantity = results.getInt(resource);
                Change change = ChangeFactory.changeResourcesChange(this.m_player, resource, quantity);
                changes.add(change);
                continue;
            }
            UnitType type = (UnitType)next;
            quantity = results.getInt(type);
            List<Unit> units = type.create(quantity, this.m_player);
            totalUnits.addAll(units);
        }
        HashMap<Unit, Integer> repairMap = this.getTerritoryRepairs(repairRules);
        if (!repairMap.isEmpty()) {
            Set repairUnits = repairMap.keySet();
            for (Unit u : repairUnits) {
                int repairCount;
                if (Properties.getSBRAffectsUnitProduction(this.getData())) {
                    repairCount = (Integer)repairMap.get(u);
                    if (repairCount <= 0) continue;
                    Territory terr = u.getTerritoryUnitIsIn();
                    TerritoryAttachment ta = TerritoryAttachment.get(terr);
                    int currentDamage = ta.getUnitProduction();
                    IntegerMap<Unit> hits = new IntegerMap<Unit>();
                    int newDamageTotal = ta.getProduction() - (currentDamage + repairCount);
                    if (newDamageTotal < 0) {
                        return "You cannot repair more than a territory has been hit";
                    }
                    hits.put(u, newDamageTotal);
                    changes.add(ChangeFactory.unitsHit(hits));
                    changes.add(ChangeFactory.attachmentPropertyChange(ta, Integer.toString(currentDamage + repairCount), "unitProduction"));
                    continue;
                }
                repairCount = (Integer)repairMap.get(u);
                if (repairCount <= 0) continue;
                IntegerMap<Unit> hits = new IntegerMap<Unit>();
                TripleAUnit taUnit = (TripleAUnit)u;
                int newDamageTotal = taUnit.getUnitDamage() - repairCount;
                if (newDamageTotal < 0) {
                    return "You cannot repair more than a unit has been hit";
                }
                hits.put(u, newDamageTotal);
                changes.add(ChangeFactory.unitsHit(hits));
                changes.add(ChangeFactory.unitPropertyChange(u, newDamageTotal, "unitDamage"));
            }
        } else {
            return null;
        }
        String remaining = this.removeFromPlayer(this.m_player, costs, changes, totalUnits);
        this.addHistoryEvent(totalUnits, remaining, true);
        this.m_bridge.addChange(changes);
        return null;
    }

    private HashMap<Unit, Integer> getTerritoryRepairs(Map<Unit, IntegerMap<RepairRule>> repairRules) {
        HashMap<Unit, Integer> repairMap = new HashMap<Unit, Integer>();
        for (Unit u : repairRules.keySet()) {
            IntegerMap<RepairRule> rules = repairRules.get(u);
            TreeSet<RepairRule> repRules = new TreeSet<RepairRule>(this.repairRuleComparator);
            repRules.addAll(rules.keySet());
            for (RepairRule repairRule : repRules) {
                int quantity = rules.getInt(repairRule);
                repairMap.put(u, quantity);
            }
        }
        return repairMap;
    }

    private void addHistoryEvent(Collection<Unit> totalUnits, String remainingText, boolean repair) {
        String transcriptText = !repair ? (!totalUnits.isEmpty() ? this.m_player.getName() + " buy " + MyFormatter.unitsToTextNoOwner(totalUnits) + "; " + remainingText : this.m_player.getName() + " buy nothing; " + remainingText) : (!totalUnits.isEmpty() ? this.m_player.getName() + " repair " + totalUnits.size() + " damage on " + MyFormatter.unitsToTextNoOwner(totalUnits) + "; " + remainingText : this.m_player.getName() + " buy nothing; " + remainingText);
        this.m_bridge.getHistoryWriter().startEvent(transcriptText);
        this.m_bridge.getHistoryWriter().setRenderingData(totalUnits);
    }

    private IntegerMap<Resource> getCosts(IntegerMap<ProductionRule> productionRules, PlayerID player) {
        IntegerMap<Resource> costs = new IntegerMap<Resource>();
        for (ProductionRule rule : productionRules.keySet()) {
            costs.addMultiple(rule.getCosts(), productionRules.getInt(rule));
        }
        return costs;
    }

    private IntegerMap<Resource> getRepairCosts(Map<Unit, IntegerMap<RepairRule>> repairRules, PlayerID player) {
        Set<Unit> units = repairRules.keySet();
        Iterator iter = units.iterator();
        IntegerMap<Resource> costs = new IntegerMap<Resource>();
        while (iter.hasNext()) {
            Unit u = (Unit)iter.next();
            for (RepairRule rule : repairRules.get(u).keySet()) {
                costs.addMultiple(rule.getCosts(), repairRules.get(u).getInt(rule));
            }
        }
        if (this.isIncreasedFactoryProduction(player)) {
            costs.multiplyAllValuesBy(0.5f, 3);
        }
        return costs;
    }

    private IntegerMap<NamedAttachable> getResults(IntegerMap<ProductionRule> productionRules) {
        IntegerMap<NamedAttachable> costs = new IntegerMap<NamedAttachable>();
        for (ProductionRule rule : productionRules.keySet()) {
            costs.addMultiple(rule.getResults(), productionRules.getInt(rule));
        }
        return costs;
    }

    private IntegerMap<NamedAttachable> getRepairResults(Map<Unit, IntegerMap<RepairRule>> repairRules) {
        Set<Unit> units = repairRules.keySet();
        Iterator iter = units.iterator();
        IntegerMap<NamedAttachable> costs = new IntegerMap<NamedAttachable>();
        while (iter.hasNext()) {
            Unit u = (Unit)iter.next();
            for (RepairRule rule : repairRules.get(u).keySet()) {
                costs.addMultiple(rule.getResults(), repairRules.get(u).getInt(rule));
            }
        }
        return costs;
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IPurchaseDelegate.class;
    }

    protected String removeFromPlayer(PlayerID player, IntegerMap<Resource> costs, CompositeChange changes, Collection<Unit> totalUnits) {
        StringBuffer returnString = new StringBuffer("Remaining resources: ");
        for (Resource resource : costs.keySet()) {
            float quantity = costs.getInt(resource);
            int cost = (int)quantity;
            Change change = ChangeFactory.changeResourcesChange(this.m_player, resource, -cost);
            changes.add(change);
            returnString.append(this.m_player.getResources().getQuantity(resource) - cost + " " + resource.getName() + "; ");
        }
        return returnString.toString();
    }

    private void giveBonusIncomeToAI() {
        if (!this.m_player.isAI()) {
            return;
        }
        int currentPUs = this.m_player.getResources().getQuantity("PUs");
        if (currentPUs == 0) {
            return;
        }
        int bonusPercent = Properties.getAIBonusIncomePercentage(this.getData());
        if (bonusPercent == 0) {
            return;
        }
        int toGive = (int)Math.round((double)currentPUs * (double)bonusPercent / 100.0);
        if (toGive == 0 && bonusPercent > 0 && currentPUs > 0) {
            toGive = 1;
        }
        if ((toGive += Properties.getAIBonusIncomeFlatRate(this.getData())) + currentPUs < 0) {
            toGive = currentPUs * -1;
        }
        if (toGive == 0) {
            return;
        }
        this.m_bridge.getHistoryWriter().startEvent("Giving AI player bonus income modifier of " + toGive + MyFormatter.pluralize(" PU", toGive));
        this.m_bridge.addChange(ChangeFactory.changeResourcesChange(this.m_player, this.getData().getResourceList().getResource("PUs"), toGive));
    }

    private boolean isIncreasedFactoryProduction(PlayerID player) {
        TechAttachment ta = (TechAttachment)player.getAttachment("techAttatchment");
        if (ta == null) {
            return false;
        }
        return ta.getIncreasedFactoryProduction();
    }
}

