/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RocketsFireHelper {
    private boolean isWW2V2(GameData data) {
        return Properties.getWW2V2(data);
    }

    private boolean isAllRocketsAttack(GameData data) {
        return Properties.getAllRocketsAttack(data);
    }

    private boolean isSBRAffectsUnitProduction(GameData data) {
        return Properties.getSBRAffectsUnitProduction(data);
    }

    private boolean isDamageFromBombingDoneToUnitsInsteadOfTerritories(GameData data) {
        return Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(data);
    }

    private boolean isOneRocketAttackPerFactory(GameData data) {
        return Properties.getRocketAttackPerFactoryRestricted(data);
    }

    private boolean isPUCap(GameData data) {
        return Properties.getPUCap(data);
    }

    private boolean isLimitRocketDamagePerTurn(GameData data) {
        return Properties.getLimitRocketDamagePerTurn(data);
    }

    private boolean isLimitRocketDamageToProduction(GameData data) {
        return Properties.getLimitRocketDamageToProduction(data);
    }

    public void fireRockets(IDelegateBridge bridge, PlayerID player) {
        GameData data = bridge.getData();
        Set<Territory> rocketTerritories = this.getTerritoriesWithRockets(data, player);
        if (rocketTerritories.isEmpty()) {
            this.getRemote(bridge).reportMessage("No rockets to fire", "No rockets to fire");
            return;
        }
        if (this.isWW2V2(data) || this.isAllRocketsAttack(data) || this.isOneRocketAttackPerFactory(data)) {
            this.fireWW2V2(bridge, player, rocketTerritories);
        } else {
            this.fireWW2V1(bridge, player, rocketTerritories);
        }
    }

    private void fireWW2V2(IDelegateBridge bridge, PlayerID player, Set<Territory> rocketTerritories) {
        GameData data = bridge.getData();
        HashSet<Territory> attackedTerritories = new HashSet<Territory>();
        for (Territory territory : rocketTerritories) {
            Territory target;
            Set<Territory> targets = this.getTargetsWithinRange(territory, data, player);
            targets.removeAll(attackedTerritories);
            if (targets.isEmpty() || (target = this.getTarget(targets, player, bridge, territory)) == null) continue;
            attackedTerritories.add(target);
            this.fireRocket(player, target, bridge, territory);
        }
    }

    private void fireWW2V1(IDelegateBridge bridge, PlayerID player, Set<Territory> rocketTerritories) {
        GameData data = bridge.getData();
        HashSet<Territory> targets = new HashSet<Territory>();
        for (Territory territory : rocketTerritories) {
            targets.addAll(this.getTargetsWithinRange(territory, data, player));
        }
        if (targets.isEmpty()) {
            this.getRemote(bridge).reportMessage("No targets to attack with rockets", "No targets to attack with rockets");
            return;
        }
        Territory attacked = this.getTarget(targets, player, bridge, null);
        if (attacked != null) {
            this.fireRocket(player, attacked, bridge, null);
        }
    }

    Set<Territory> getTerritoriesWithRockets(GameData data, PlayerID player) {
        HashSet<Territory> territories = new HashSet<Territory>();
        CompositeMatchAnd<Unit> ownedRockets = new CompositeMatchAnd<Unit>(new Match[0]);
        ownedRockets.add(Matches.UnitIsRocket);
        ownedRockets.add(Matches.unitIsOwnedBy(player));
        BattleTracker tracker = MoveDelegate.getBattleTracker(data);
        for (Territory current : data.getMap()) {
            if (current.isWater() || tracker.wasConquered(current) || !current.getUnits().someMatch(ownedRockets)) continue;
            territories.add(current);
        }
        return territories;
    }

    private Set<Territory> getTargetsWithinRange(Territory territory, GameData data, PlayerID player) {
        Set<Territory> possible = data.getMap().getNeighbors(territory, 3);
        HashSet<Territory> hasFactory = new HashSet<Territory>();
        Match<Territory> impassable = Matches.TerritoryIsNotImpassable;
        for (Territory current : possible) {
            Route route = data.getMap().getRoute(territory, current, impassable);
            if (route == null || route.numberOfSteps() > 3 || !current.getUnits().someMatch(new CompositeMatchAnd<Unit>(Matches.enemyUnit(player, data), Matches.UnitIsAtMaxDamageOrNotCanBeDamaged(current).invert()))) continue;
            hasFactory.add(current);
        }
        return hasFactory;
    }

    private Territory getTarget(Collection<Territory> targets, PlayerID player, IDelegateBridge bridge, Territory from) {
        return ((ITripleaPlayer)bridge.getRemote()).whereShouldRocketsAttack(targets, from);
    }

    private void fireRocket(PlayerID player, Territory attackedTerritory, IDelegateBridge bridge, Territory attackFrom) {
        int alreadyLost;
        GameData data = bridge.getData();
        PlayerID attacked = attackedTerritory.getOwner();
        Resource PUs = data.getResourceList().getResource("PUs");
        boolean SBRAffectsUnitProd = this.isSBRAffectsUnitProduction(data);
        boolean DamageFromBombingDoneToUnits = this.isDamageFromBombingDoneToUnitsInsteadOfTerritories(data);
        List<Unit> enemyUnits = attackedTerritory.getUnits().getMatches(Matches.enemyUnit(player, data));
        List<Unit> enemyTargets = Match.getMatches(enemyUnits, Matches.UnitIsAtMaxDamageOrNotCanBeDamaged(attackedTerritory).invert());
        ArrayList<Unit> targets = new ArrayList<Unit>();
        if (!SBRAffectsUnitProd && DamageFromBombingDoneToUnits) {
            Unit target;
            if (enemyTargets.size() == 1) {
                target = (Unit)enemyTargets.iterator().next();
            } else {
                ITripleaPlayer iplayer = (ITripleaPlayer)bridge.getRemote(player);
                target = iplayer.whatShouldBomberBomb(attackedTerritory, enemyTargets);
            }
            if (target == null) {
                throw new IllegalStateException("No Targets in " + attackedTerritory.getName());
            }
            targets.add(target);
        }
        int cost = 0;
        if (!Properties.getLL_DAMAGE_ONLY(data)) {
            cost = bridge.getRandom(data.getDiceSides(), "Rocket fired by " + player.getName() + " at " + attacked.getName());
        } else {
            CompositeMatchAnd ownedRockets = new CompositeMatchAnd(Matches.unitIsOwnedBy(player), Matches.UnitIsRocket);
            ArrayList<Unit> rockets = new ArrayList<Unit>(Match.getMatches(attackFrom.getUnits().getUnits(), ownedRockets));
            int highestMaxDice = 0;
            int highestBonus = 0;
            int diceSides = data.getDiceSides();
            for (Unit u : rockets) {
                UnitAttachment ua = UnitAttachment.get(u.getType());
                int maxDice = ua.getBombingMaxDieSides();
                int bonus = ua.getBombingBonus();
                if (maxDice < 0 && bonus < 0 && diceSides >= 5) {
                    maxDice = (diceSides + 1) / 3;
                    bonus = (diceSides + 1) / 3;
                }
                if (bonus < 0) {
                    bonus = 0;
                }
                if (maxDice < 0) {
                    maxDice = diceSides;
                }
                if (bonus + (maxDice + 1) / 2 <= highestBonus + (highestMaxDice + 1) / 2) continue;
                highestMaxDice = maxDice;
                highestBonus = bonus;
            }
            cost = highestMaxDice > 0 ? bridge.getRandom(highestMaxDice, "Rocket fired by " + player.getName() + " at " + attacked.getName()) + highestBonus : highestBonus;
        }
        ++cost;
        TerritoryAttachment ta = TerritoryAttachment.get(attackedTerritory);
        int territoryProduction = ta.getProduction();
        int unitProduction = 0;
        if (SBRAffectsUnitProd) {
            unitProduction = ta.getUnitProduction();
            alreadyLost = territoryProduction - unitProduction;
            int limit = 2 * territoryProduction - alreadyLost;
            cost = Math.min(cost, limit);
            List<Unit> damagedFactory = Match.getMatches(attackedTerritory.getUnits().getUnits(), Matches.UnitIsFactoryOrCanBeDamaged);
            IntegerMap<Unit> hits = new IntegerMap<Unit>();
            for (Unit factory : damagedFactory) {
                hits.put(factory, 1);
            }
            bridge.addChange(ChangeFactory.unitsHit(hits));
        } else if (DamageFromBombingDoneToUnits && !targets.isEmpty()) {
            Unit target = (Unit)targets.iterator().next();
            TripleAUnit taUnit = (TripleAUnit)target;
            int damageLimit = taUnit.getHowMuchMoreDamageCanThisUnitTake(target, attackedTerritory);
            cost = Math.max(0, Math.min(cost, damageLimit));
            int totalDamage = taUnit.getUnitDamage() + cost;
            IntegerMap<Unit> hits = new IntegerMap<Unit>();
            CompositeChange change = new CompositeChange();
            hits.put(target, 1);
            change.add(ChangeFactory.unitPropertyChange(target, totalDamage, "unitDamage"));
            bridge.addChange(ChangeFactory.unitsHit(hits));
            bridge.addChange(change);
        } else if (this.isWW2V2(data) || this.isLimitRocketDamageToProduction(data)) {
            if (this.isPUCap(data) || this.isLimitRocketDamagePerTurn(data)) {
                alreadyLost = DelegateFinder.moveDelegate(data).PUsAlreadyLost(attackedTerritory);
                territoryProduction -= alreadyLost;
                territoryProduction = Math.max(0, territoryProduction);
            }
            if (cost > territoryProduction) {
                cost = territoryProduction;
            }
        }
        DelegateFinder.moveDelegate(data).PUsLost(attackedTerritory, cost);
        if (SBRAffectsUnitProd) {
            this.getRemote(bridge).reportMessage("Rocket attack in " + attackedTerritory.getName() + " costs: " + cost + " production.", "Rocket attack in " + attackedTerritory.getName() + " costs: " + cost + " production.");
            bridge.getHistoryWriter().startEvent("Rocket attack in " + attackedTerritory.getName() + " costs: " + cost + " production.");
            Change change = ChangeFactory.attachmentPropertyChange(ta, Integer.toString(unitProduction - cost), "unitProduction");
            bridge.addChange(change);
        } else if (DamageFromBombingDoneToUnits && !targets.isEmpty()) {
            this.getRemote(bridge).reportMessage("Rocket attack in " + attackedTerritory.getName() + " does " + cost + " damage to " + targets.iterator().next(), "Rocket attack in " + attackedTerritory.getName() + " does " + cost + " damage to " + targets.iterator().next());
            bridge.getHistoryWriter().startEvent("Rocket attack in " + attackedTerritory.getName() + " does " + cost + " damage to " + targets.iterator().next());
        } else {
            this.getRemote(bridge).reportMessage("Rocket attack in " + attackedTerritory.getName() + " costs:" + (cost *= Properties.getPU_Multiplier(data).intValue()), "Rocket attack in " + attackedTerritory.getName() + " costs:" + cost);
            int availForRemoval = attacked.getResources().getQuantity(PUs);
            if (cost > availForRemoval) {
                cost = availForRemoval;
            }
            String transcriptText = attacked.getName() + " lost " + cost + " PUs to rocket attack by " + player.getName();
            bridge.getHistoryWriter().startEvent(transcriptText);
            Change rocketCharge = ChangeFactory.changeResourcesChange(attacked, PUs, -cost);
            bridge.addChange(rocketCharge);
        }
        if (attackFrom != null) {
            List<Unit> units = attackFrom.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.UnitIsRocket, Matches.unitIsOwnedBy(player)));
            if (units.size() > 0) {
                Change change = ChangeFactory.markNoMovementChange(Collections.singleton(units.get(0)));
                bridge.addChange(change);
            } else {
                throw new IllegalStateException("No rockets?" + attackFrom.getUnits().getUnits());
            }
        }
        if (Match.someMatch(targets, Matches.UnitCanDieFromReachingMaxDamage)) {
            List<Unit> unitsCanDie = Match.getMatches(targets, Matches.UnitCanDieFromReachingMaxDamage);
            unitsCanDie.retainAll(Match.getMatches(unitsCanDie, Matches.UnitIsAtMaxDamageOrNotCanBeDamaged(attackedTerritory)));
            if (!unitsCanDie.isEmpty()) {
                Change removeDead = ChangeFactory.removeUnits(attackedTerritory, unitsCanDie);
                String transcriptText = MyFormatter.unitsToText(unitsCanDie) + " lost in " + attackedTerritory.getName();
                bridge.getHistoryWriter().addChildToEvent(transcriptText, unitsCanDie);
                bridge.addChange(removeDead);
            }
        }
    }

    private ITripleaPlayer getRemote(IDelegateBridge bridge) {
        return (ITripleaPlayer)bridge.getRemote();
    }
}

