/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.RouteScripted;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.net.GUID;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.AbstractBattle;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.ExecutionStack;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.IExecutable;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.StrategicBombingRaidBattle;
import games.strategy.triplea.delegate.dataObjects.BattleRecords;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrategicBombingRaidPreBattle
extends StrategicBombingRaidBattle {
    private static final long serialVersionUID = 4686241714027216395L;
    private static final String AIR_BATTLE = "Air Battle";
    private static final String INTERCEPTORS_LAUNCH = "Defender Launches Interceptors";
    private static final String ATTACKERS_FIRE = "Attacking Escorts and Bombers Fire";
    private static final String DEFENDERS_FIRE = "Defending Interceptors Fire";
    private static final String WITHDRAW = "Escorts and Interceptors Withdraw";
    private static final String BOMBERS_TO_TARGETS = "Bombers Fly to Their Targets";
    private final Collection<Unit> m_defendingWaitingToDie = new ArrayList<Unit>();
    private final Collection<Unit> m_attackingWaitingToDie = new ArrayList<Unit>();
    protected boolean m_intercept = false;

    public StrategicBombingRaidPreBattle(Territory battleSite, GameData data, PlayerID attacker, BattleTracker battleTracker) {
        super(battleSite, data, attacker, battleTracker);
        this.m_battleType = IBattle.BattleType.AIR_BATTLE;
    }

    @Override
    protected void updateDefendingUnits() {
        this.m_defendingUnits = this.m_battleSite.getUnits().getMatches(StrategicBombingRaidPreBattle.defendingInterceptors(this.m_attacker, this.m_data));
    }

    @Override
    public Change addAttackChange(Route route, Collection<Unit> units, HashMap<Unit, HashSet<Unit>> targets) {
        return super.addAttackChange(route, units, targets);
    }

    @Override
    public void removeAttack(Route route, Collection<Unit> units) {
        this.m_attackingUnits.removeAll(units);
    }

    @Override
    public void fight(IDelegateBridge bridge) {
        if (this.m_stack.isExecuting()) {
            this.showBattle(bridge);
            this.m_stack.execute(bridge);
            return;
        }
        this.updateDefendingUnits();
        bridge.getHistoryWriter().startEvent("Air Battle in " + this.m_battleSite);
        bridge.getHistoryWriter().setRenderingData(this.m_battleSite);
        BattleCalculator.sortPreBattle(this.m_attackingUnits, this.m_data);
        BattleCalculator.sortPreBattle(this.m_defendingUnits, this.m_data);
        this.m_steps = new ArrayList();
        this.m_steps.add(AIR_BATTLE);
        this.m_steps.add(INTERCEPTORS_LAUNCH);
        this.m_steps.add(DEFENDERS_FIRE);
        this.m_steps.add(ATTACKERS_FIRE);
        this.m_steps.add(WITHDRAW);
        this.m_steps.add(BOMBERS_TO_TARGETS);
        this.showBattle(bridge);
        ArrayList<IExecutable> steps = new ArrayList<IExecutable>();
        if (Match.someMatch(this.m_attackingUnits, Matches.UnitIsStrategicBomber) && Match.someMatch(this.m_battleSite.getUnits().getUnits(), StrategicBombingRaidPreBattle.defendingInterceptors(this.m_attacker, this.m_data))) {
            steps.add(new InterceptorsLaunch());
            steps.add(new DefendersFire());
            steps.add(new AttackersFire());
            steps.add(new IExecutable(){
                private static final long serialVersionUID = -5575569705493214941L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    List<Unit> suicideUnits;
                    AbstractBattle.getDisplay(bridge).gotoBattleStep(StrategicBombingRaidPreBattle.this.m_battleID, StrategicBombingRaidPreBattle.BOMBERS_TO_TARGETS);
                    if (!StrategicBombingRaidPreBattle.this.m_intercept) {
                        return;
                    }
                    IntegerMap<UnitType> defenderCosts = BattleCalculator.getCostsForTUV(StrategicBombingRaidPreBattle.this.m_defender, StrategicBombingRaidPreBattle.this.m_data);
                    IntegerMap<UnitType> attackerCosts = BattleCalculator.getCostsForTUV(StrategicBombingRaidPreBattle.this.m_attacker, StrategicBombingRaidPreBattle.this.m_data);
                    StrategicBombingRaidPreBattle.this.m_attackingUnits.removeAll(StrategicBombingRaidPreBattle.this.m_attackingWaitingToDie);
                    StrategicBombingRaidPreBattle.this.remove(StrategicBombingRaidPreBattle.this.m_attackingWaitingToDie, bridge, StrategicBombingRaidPreBattle.this.m_battleSite);
                    StrategicBombingRaidPreBattle.this.m_defendingUnits.removeAll(StrategicBombingRaidPreBattle.this.m_defendingWaitingToDie);
                    StrategicBombingRaidPreBattle.this.remove(StrategicBombingRaidPreBattle.this.m_defendingWaitingToDie, bridge, StrategicBombingRaidPreBattle.this.m_battleSite);
                    int tuvLostAttacker = BattleCalculator.getTUV(StrategicBombingRaidPreBattle.this.m_attackingWaitingToDie, StrategicBombingRaidPreBattle.this.m_attacker, attackerCosts, StrategicBombingRaidPreBattle.this.m_data);
                    StrategicBombingRaidPreBattle.this.m_attackerLostTUV += tuvLostAttacker;
                    int tuvLostDefender = BattleCalculator.getTUV(StrategicBombingRaidPreBattle.this.m_defendingWaitingToDie, StrategicBombingRaidPreBattle.this.m_defender, defenderCosts, StrategicBombingRaidPreBattle.this.m_data);
                    StrategicBombingRaidPreBattle.this.m_defenderLostTUV += tuvLostDefender;
                    if (Match.someMatch(StrategicBombingRaidPreBattle.this.m_attackingUnits, new CompositeMatchAnd(Matches.UnitIsSuicide, Matches.UnitIsNotStrategicBomber))) {
                        suicideUnits = Match.getMatches(StrategicBombingRaidPreBattle.this.m_attackingUnits, Matches.UnitIsSuicide);
                        StrategicBombingRaidPreBattle.this.m_attackingUnits.removeAll(suicideUnits);
                        StrategicBombingRaidPreBattle.this.remove(suicideUnits, bridge, StrategicBombingRaidPreBattle.this.m_battleSite);
                        tuvLostAttacker = BattleCalculator.getTUV(suicideUnits, StrategicBombingRaidPreBattle.this.m_attacker, attackerCosts, StrategicBombingRaidPreBattle.this.m_data);
                        StrategicBombingRaidPreBattle.this.m_attackerLostTUV += tuvLostAttacker;
                    }
                    if (Match.someMatch(StrategicBombingRaidPreBattle.this.m_defendingUnits, Matches.UnitIsSuicide)) {
                        suicideUnits = Match.getMatches(StrategicBombingRaidPreBattle.this.m_defendingUnits, Matches.UnitIsSuicide);
                        StrategicBombingRaidPreBattle.this.m_defendingUnits.removeAll(suicideUnits);
                        StrategicBombingRaidPreBattle.this.remove(suicideUnits, bridge, StrategicBombingRaidPreBattle.this.m_battleSite);
                        tuvLostDefender = BattleCalculator.getTUV(suicideUnits, StrategicBombingRaidPreBattle.this.m_defender, defenderCosts, StrategicBombingRaidPreBattle.this.m_data);
                        StrategicBombingRaidPreBattle.this.m_defenderLostTUV += tuvLostDefender;
                    }
                }
            });
        }
        steps.add(new IExecutable(){
            private static final long serialVersionUID = 3148193405425861565L;

            public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                StrategicBombingRaidPreBattle.this.end(bridge);
            }
        });
        Collections.reverse(steps);
        for (IExecutable executable : steps) {
            this.m_stack.push(executable);
        }
        this.m_stack.execute(bridge);
    }

    private void end(IDelegateBridge bridge) {
        String text;
        if (Match.someMatch(this.m_attackingUnits, Matches.UnitIsStrategicBomber)) {
            this.m_whoWon = IBattle.WhoWon.ATTACKER;
            this.m_battleResultDescription = this.m_defendingUnits.isEmpty() ? BattleRecords.BattleResultDescription.WON_WITHOUT_CONQUERING : BattleRecords.BattleResultDescription.WON_WITH_ENEMY_LEFT;
            text = "Air Battle is over, the remaining Bombers go on to their targets";
        } else if (!this.m_attackingUnits.isEmpty()) {
            this.m_whoWon = IBattle.WhoWon.DRAW;
            this.m_battleResultDescription = BattleRecords.BattleResultDescription.STALEMATE;
            text = "Air Battle is over, the bombers have all died";
        } else {
            this.m_whoWon = IBattle.WhoWon.DEFENDER;
            this.m_battleResultDescription = BattleRecords.BattleResultDescription.LOST;
            text = "Air Battle is over, the bombers have all died";
        }
        bridge.getHistoryWriter().addChildToEvent(text);
        this.m_battleTracker.getBattleRecords().addResultToBattle(this.m_attacker, this.m_battleID, this.m_defender, this.m_attackerLostTUV, this.m_defenderLostTUV, this.m_battleResultDescription, new BattleResults(this), 0);
        this.m_battleTracker.removeBattle(this);
        StrategicBombingRaidPreBattle.getDisplay(bridge).battleEnd(this.m_battleID, "Air Battle over");
        this.m_isOver = true;
        List<Unit> bombers = Match.getMatches(this.m_attackingUnits, Matches.UnitIsStrategicBomber);
        if (!bombers.isEmpty()) {
            HashMap<Unit, HashSet<Unit>> targets = null;
            Unit target = null;
            List<Unit> enemyTargets = this.m_battleSite.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.enemyUnit(bridge.getPlayerID(), this.m_data), Matches.UnitIsAtMaxDamageOrNotCanBeDamaged(this.m_battleSite).invert()));
            for (Unit unit : bombers) {
                if (enemyTargets.size() > 1 && Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(this.m_data)) {
                    target = StrategicBombingRaidPreBattle.getRemote(bridge).whatShouldBomberBomb(this.m_battleSite, enemyTargets);
                } else if (!enemyTargets.isEmpty()) {
                    target = (Unit)enemyTargets.iterator().next();
                }
                if (target != null) {
                    targets = new HashMap<Unit, HashSet<Unit>>();
                    targets.put(target, new HashSet<Unit>(Collections.singleton(unit)));
                }
                this.m_battleTracker.addBattle(new RouteScripted(this.m_battleSite), Collections.singleton(unit), true, this.m_attacker, bridge, null, targets, true);
            }
        }
    }

    private void showBattle(IDelegateBridge bridge) {
        String title = "Air Battle in " + this.m_battleSite.getName();
        StrategicBombingRaidPreBattle.getDisplay(bridge).showBattle(this.m_battleID, this.m_battleSite, title, this.m_attackingUnits, this.m_defendingUnits, null, null, null, Collections.<Unit, Collection<Unit>>emptyMap(), this.m_attacker, this.m_defender, this.getBattleType());
        StrategicBombingRaidPreBattle.getDisplay(bridge).listBattleSteps(this.m_battleID, this.m_steps);
    }

    private static Match<Unit> unitHasAirDefenseGreaterThanZero() {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                return UnitAttachment.get(u.getType()).getAirDefense(u.getOwner()) > 0;
            }
        };
    }

    private static Match<Unit> unitHasAirAttackGreaterThanZero() {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                return UnitAttachment.get(u.getType()).getAirAttack(u.getOwner()) > 0;
            }
        };
    }

    public static Match<Unit> defendingInterceptors(final PlayerID attacker, final GameData data) {
        return new Match<Unit>(){

            @Override
            public boolean match(Unit u) {
                CompositeMatchAnd<Unit> canIntercept = new CompositeMatchAnd<Unit>(Matches.unitCanIntercept, Matches.unitIsEnemyOf(data, attacker), Matches.UnitWasScrambled.invert(), Matches.UnitIsDisabled().invert(), Matches.UnitWasInAirBattle.invert());
                return ((Match)canIntercept).match(u);
            }
        };
    }

    public static int getAirBattleRolls(Collection<Unit> units, boolean defending) {
        List<Unit> firingUnits = Match.getMatches(units, defending ? StrategicBombingRaidPreBattle.unitHasAirDefenseGreaterThanZero() : StrategicBombingRaidPreBattle.unitHasAirAttackGreaterThanZero());
        return firingUnits.size();
    }

    private void markDamaged(Collection<Unit> damaged, IDelegateBridge bridge) {
        if (damaged.size() == 0) {
            return;
        }
        Change damagedChange = null;
        IntegerMap<Unit> damagedMap = new IntegerMap<Unit>();
        damagedMap.putAll(damaged, 1);
        damagedChange = ChangeFactory.unitsHit(damagedMap);
        bridge.getHistoryWriter().addChildToEvent("Units damaged: " + MyFormatter.unitsToText(damaged), damaged);
        bridge.addChange(damagedChange);
    }

    private void remove(Collection<Unit> killed, IDelegateBridge bridge, Territory battleSite) {
        if (killed.size() == 0) {
            return;
        }
        Change killedChange = ChangeFactory.removeUnits(battleSite, killed);
        String transcriptText = MyFormatter.unitsToText(killed) + " lost in " + battleSite.getName();
        bridge.getHistoryWriter().addChildToEvent(transcriptText, killed);
        bridge.addChange(killedChange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCasualties(final GUID battleID, final IDelegateBridge bridge, String stepName, DiceRoll dice, final PlayerID hitPlayer, final PlayerID firingPlayer, CasualtyDetails details) {
        StrategicBombingRaidPreBattle.getDisplay(bridge).casualtyNotification(battleID, stepName, dice, hitPlayer, details.getKilled(), details.getDamaged(), Collections.<Unit, Collection<Unit>>emptyMap());
        Runnable r = new Runnable(){

            public void run() {
                try {
                    AbstractBattle.getRemote(firingPlayer, bridge).confirmEnemyCasualties(battleID, "Press space to continue", hitPlayer);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread t = new Thread(r, "Click to continue waiter");
        t.start();
        StrategicBombingRaidPreBattle.getRemote(hitPlayer, bridge).confirmOwnCasualties(battleID, "Press space to continue");
        try {
            bridge.leaveDelegateExecution();
            t.join();
        }
        catch (InterruptedException e) {
        }
        finally {
            bridge.enterDelegateExecution();
        }
    }

    class DefendersFire
    implements IExecutable {
        private static final long serialVersionUID = -7277182945495744003L;
        DiceRoll m_dice;
        CasualtyDetails m_details;

        DefendersFire() {
        }

        public void execute(ExecutionStack stack, IDelegateBridge bridge) {
            if (!StrategicBombingRaidPreBattle.this.m_intercept) {
                return;
            }
            IExecutable roll = new IExecutable(){
                private static final long serialVersionUID = 5953506121350176595L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    DefendersFire.this.m_dice = DiceRoll.airBattle(StrategicBombingRaidPreBattle.this.m_defendingUnits, true, StrategicBombingRaidPreBattle.this.m_defender, bridge, StrategicBombingRaidPreBattle.this, "Defenders Fire, ");
                }
            };
            IExecutable calculateCasualties = new IExecutable(){
                private static final long serialVersionUID = 6658309931909306564L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    DefendersFire.this.m_details = BattleCalculator.selectCasualties(StrategicBombingRaidPreBattle.this.m_attacker, StrategicBombingRaidPreBattle.this.m_attackingUnits, bridge, StrategicBombingRaidPreBattle.DEFENDERS_FIRE, DefendersFire.this.m_dice, false, StrategicBombingRaidPreBattle.this.m_battleID);
                    StrategicBombingRaidPreBattle.this.m_attackingWaitingToDie.addAll(DefendersFire.this.m_details.getKilled());
                    StrategicBombingRaidPreBattle.this.markDamaged(DefendersFire.this.m_details.getDamaged(), bridge);
                }
            };
            IExecutable notifyCasualties = new IExecutable(){
                private static final long serialVersionUID = 4461950841000674515L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    StrategicBombingRaidPreBattle.this.notifyCasualties(StrategicBombingRaidPreBattle.this.m_battleID, bridge, StrategicBombingRaidPreBattle.DEFENDERS_FIRE, DefendersFire.this.m_dice, StrategicBombingRaidPreBattle.this.m_attacker, StrategicBombingRaidPreBattle.this.m_defender, DefendersFire.this.m_details);
                }
            };
            stack.push(notifyCasualties);
            stack.push(calculateCasualties);
            stack.push(roll);
        }
    }

    class AttackersFire
    implements IExecutable {
        private static final long serialVersionUID = -5289634214875797408L;
        DiceRoll m_dice;
        CasualtyDetails m_details;

        AttackersFire() {
        }

        public void execute(ExecutionStack stack, IDelegateBridge bridge) {
            if (!StrategicBombingRaidPreBattle.this.m_intercept) {
                return;
            }
            IExecutable roll = new IExecutable(){
                private static final long serialVersionUID = 6579019987019614374L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    AttackersFire.this.m_dice = DiceRoll.airBattle(StrategicBombingRaidPreBattle.this.m_attackingUnits, false, StrategicBombingRaidPreBattle.this.m_attacker, bridge, StrategicBombingRaidPreBattle.this, "Attackers Fire, ");
                }
            };
            IExecutable calculateCasualties = new IExecutable(){
                private static final long serialVersionUID = 4556409970663527142L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    AttackersFire.this.m_details = BattleCalculator.selectCasualties(StrategicBombingRaidPreBattle.this.m_defender, StrategicBombingRaidPreBattle.this.m_defendingUnits, bridge, StrategicBombingRaidPreBattle.ATTACKERS_FIRE, AttackersFire.this.m_dice, true, StrategicBombingRaidPreBattle.this.m_battleID);
                    StrategicBombingRaidPreBattle.this.m_defendingWaitingToDie.addAll(AttackersFire.this.m_details.getKilled());
                    StrategicBombingRaidPreBattle.this.markDamaged(AttackersFire.this.m_details.getDamaged(), bridge);
                }
            };
            IExecutable notifyCasualties = new IExecutable(){
                private static final long serialVersionUID = 4224354422817922451L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    StrategicBombingRaidPreBattle.this.notifyCasualties(StrategicBombingRaidPreBattle.this.m_battleID, bridge, StrategicBombingRaidPreBattle.ATTACKERS_FIRE, AttackersFire.this.m_dice, StrategicBombingRaidPreBattle.this.m_defender, StrategicBombingRaidPreBattle.this.m_attacker, AttackersFire.this.m_details);
                }
            };
            stack.push(notifyCasualties);
            stack.push(calculateCasualties);
            stack.push(roll);
        }
    }

    class InterceptorsLaunch
    implements IExecutable {
        private static final long serialVersionUID = 4300406315014471768L;

        InterceptorsLaunch() {
        }

        public void execute(ExecutionStack stack, IDelegateBridge bridge) {
            IExecutable getInterceptors = new IExecutable(){
                private static final long serialVersionUID = 8309994140871853357L;

                public void execute(ExecutionStack stack, IDelegateBridge bridge) {
                    InterceptorsLaunch.this.getInterceptors(bridge);
                    if (!StrategicBombingRaidPreBattle.this.m_defendingUnits.isEmpty()) {
                        StrategicBombingRaidPreBattle.this.m_intercept = true;
                    }
                }
            };
            StrategicBombingRaidPreBattle.this.m_stack.push(getInterceptors);
        }

        private void getInterceptors(IDelegateBridge bridge) {
            Collection<Unit> interceptors = AbstractBattle.getRemote(StrategicBombingRaidPreBattle.this.m_defender, bridge).selectUnitsQuery(StrategicBombingRaidPreBattle.this.m_battleSite, StrategicBombingRaidPreBattle.this.m_defendingUnits, "Select Air to Intercept");
            if (interceptors != null && !StrategicBombingRaidPreBattle.this.m_defendingUnits.containsAll(interceptors)) {
                throw new IllegalStateException("Interceptors choose from outside of available units");
            }
            ArrayList<Unit> beingRemoved = new ArrayList<Unit>(StrategicBombingRaidPreBattle.this.m_defendingUnits);
            StrategicBombingRaidPreBattle.this.m_defendingUnits.clear();
            if (interceptors != null) {
                beingRemoved.removeAll(interceptors);
                StrategicBombingRaidPreBattle.this.m_defendingUnits.addAll(interceptors);
            }
            AbstractBattle.getDisplay(bridge).changedUnitsNotification(StrategicBombingRaidPreBattle.this.m_battleID, StrategicBombingRaidPreBattle.this.m_defender, beingRemoved, null, null);
            CompositeChange changeAttacker = new CompositeChange();
            for (Unit u : StrategicBombingRaidPreBattle.this.m_attackingUnits) {
                changeAttacker.add(ChangeFactory.unitPropertyChange(u, true, "wasInAirBattle"));
            }
            if (!changeAttacker.isEmpty()) {
                bridge.getHistoryWriter().startEvent(StrategicBombingRaidPreBattle.this.m_attacker.getName() + " attacks with " + StrategicBombingRaidPreBattle.this.m_attackingUnits.size() + " units heading to " + StrategicBombingRaidPreBattle.this.m_battleSite.getName());
                bridge.getHistoryWriter().setRenderingData(StrategicBombingRaidPreBattle.this.m_attackingUnits);
                bridge.addChange(changeAttacker);
            }
            CompositeChange changeDefender = new CompositeChange();
            for (Unit u : StrategicBombingRaidPreBattle.this.m_defendingUnits) {
                changeDefender.add(ChangeFactory.unitPropertyChange(u, true, "wasInAirBattle"));
            }
            if (!changeDefender.isEmpty()) {
                bridge.getHistoryWriter().startEvent(StrategicBombingRaidPreBattle.this.m_defender.getName() + " launches " + StrategicBombingRaidPreBattle.this.m_defendingUnits.size() + " interceptors out of " + StrategicBombingRaidPreBattle.this.m_battleSite.getName());
                bridge.getHistoryWriter().setRenderingData(StrategicBombingRaidPreBattle.this.m_defendingUnits);
                bridge.addChange(changeDefender);
            }
        }
    }
}

