/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.TechnologyFrontier;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.delegate.GenericTechAdvance;
import games.strategy.triplea.delegate.TechAdvance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TechTracker
implements Serializable {
    public static Collection<TechAdvance> getTechAdvances(PlayerID id, GameData data) {
        ArrayList<TechAdvance> rVal = new ArrayList<TechAdvance>();
        TechAttachment attachment = TechAttachment.get(id);
        for (TechAdvance ta : TechAdvance.getTechAdvances(data, id)) {
            if (!ta.hasTech(attachment)) continue;
            rVal.add(ta);
        }
        return rVal;
    }

    public static Collection<TechnologyFrontier> getTechCategories(GameData data, PlayerID id) {
        ArrayList<TechnologyFrontier> rVal = new ArrayList<TechnologyFrontier>();
        TechAttachment attachment = TechAttachment.get(id);
        for (TechnologyFrontier tf : TechAdvance.getTechCategories(data, id)) {
            TechAdvance t;
            boolean has = true;
            Iterator<TechAdvance> i$ = tf.getTechs().iterator();
            while (i$.hasNext() && (has = (t = i$.next()).hasTech(attachment))) {
            }
            if (!has) continue;
            rVal.add(tf);
        }
        return rVal;
    }

    public static int getTechCost(PlayerID id) {
        TechAttachment ta = TechAttachment.get(id);
        return ta.getTechCost();
    }

    public static synchronized void addAdvance(PlayerID player, IDelegateBridge bridge, TechAdvance advance) {
        Change attachmentChange = advance instanceof GenericTechAdvance ? (((GenericTechAdvance)advance).getAdvance() == null ? ChangeFactory.genericTechChange(TechAttachment.get(player), true, advance.getProperty()) : ChangeFactory.attachmentPropertyChange(TechAttachment.get(player), "true", advance.getProperty())) : ChangeFactory.attachmentPropertyChange(TechAttachment.get(player), "true", advance.getProperty());
        bridge.addChange(attachmentChange);
        advance.perform(player, bridge);
    }

    public static boolean hasLongRangeAir(PlayerID player) {
        return TechAttachment.get(player).getLongRangeAir();
    }

    public static boolean hasHeavyBomber(PlayerID player) {
        return TechAttachment.get(player).getHeavyBomber();
    }

    public static boolean hasSuperSubs(PlayerID player) {
        return TechAttachment.get(player).getSuperSub();
    }

    public static boolean hasJetFighter(PlayerID player) {
        return TechAttachment.get(player).getJetPower();
    }

    public static boolean hasRocket(PlayerID player) {
        return TechAttachment.get(player).getRocket();
    }

    public static boolean hasIndustrialTechnology(PlayerID player) {
        return TechAttachment.get(player).getIndustrialTechnology();
    }

    public static boolean hasDestroyerBombard(PlayerID player) {
        return TechAttachment.get(player).getDestroyerBombard();
    }

    public static boolean hasImprovedArtillerySupport(PlayerID player) {
        return TechAttachment.get(player).getImprovedArtillerySupport();
    }

    public static boolean hasParatroopers(PlayerID player) {
        return TechAttachment.get(player).getParatroopers();
    }

    public static boolean hasIncreasedFactoryProduction(PlayerID player) {
        return TechAttachment.get(player).getIncreasedFactoryProduction();
    }

    public static boolean hasWarBonds(PlayerID player) {
        return TechAttachment.get(player).getWarBonds();
    }

    public static boolean hasMechanizedInfantry(PlayerID player) {
        return TechAttachment.get(player).getMechanizedInfantry();
    }

    public static boolean hasAARadar(PlayerID player) {
        return TechAttachment.get(player).getAARadar();
    }

    public static boolean hasShipyards(PlayerID player) {
        return TechAttachment.get(player).getShipyards();
    }
}

