/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.common.delegate.BaseDelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.TechnologyFrontier;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.ICondition;
import games.strategy.triplea.attatchments.TriggerAttachment;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.EditDelegate;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.triplea.delegate.TechnologyExtendedDelegateState;
import games.strategy.triplea.delegate.TripleADelegateBridge;
import games.strategy.triplea.delegate.dataObjects.TechResults;
import games.strategy.triplea.delegate.remote.ITechDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.Match;
import games.strategy.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TechnologyDelegate
extends BaseDelegate
implements ITechDelegate {
    private int m_techCost;
    private HashMap<PlayerID, Collection<TechAdvance>> m_techs;
    private TechnologyFrontier m_techCategory;
    private boolean m_needToInitialize = true;

    @Override
    public void initialize(String name, String displayName) {
        super.initialize(name, displayName);
        this.m_techs = new HashMap();
        this.m_techCost = -1;
    }

    @Override
    public void start(IDelegateBridge aBridge) {
        super.start(new TripleADelegateBridge(aBridge));
        if (!this.m_needToInitialize) {
            return;
        }
        if (Properties.getTriggers(this.getData())) {
            CompositeMatchAnd<TriggerAttachment> technologyDelegateTriggerMatch = new CompositeMatchAnd<TriggerAttachment>(TriggerAttachment.availableUses, TriggerAttachment.whenOrDefaultMatch(null, null), new CompositeMatchOr(TriggerAttachment.techAvailableMatch()));
            HashSet<TriggerAttachment> toFirePossible = TriggerAttachment.collectForAllTriggersMatching(new HashSet<PlayerID>(Collections.singleton(this.m_player)), technologyDelegateTriggerMatch, this.m_bridge);
            if (!toFirePossible.isEmpty()) {
                HashMap<ICondition, Boolean> testedConditions = TriggerAttachment.collectTestsForAllTriggers(toFirePossible, this.m_bridge);
                List<TriggerAttachment> toFireTestedAndSatisfied = Match.getMatches(toFirePossible, TriggerAttachment.isSatisfiedMatch(testedConditions));
                TriggerAttachment.triggerAvailableTechChange(new HashSet<TriggerAttachment>(toFireTestedAndSatisfied), this.m_bridge, null, null, true, true, true, true);
            }
        }
        this.m_needToInitialize = false;
    }

    @Override
    public void end() {
        super.end();
        this.m_needToInitialize = true;
    }

    @Override
    public Serializable saveState() {
        TechnologyExtendedDelegateState state = new TechnologyExtendedDelegateState();
        state.superState = super.saveState();
        state.m_needToInitialize = this.m_needToInitialize;
        state.m_techs = this.m_techs;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        TechnologyExtendedDelegateState s = (TechnologyExtendedDelegateState)state;
        super.loadState(s.superState);
        this.m_needToInitialize = s.m_needToInitialize;
        this.m_techs = s.m_techs;
    }

    public Map<PlayerID, Collection<TechAdvance>> getAdvances() {
        return this.m_techs;
    }

    private boolean isWW2V2() {
        return Properties.getWW2V2(this.getData());
    }

    private boolean isWW2V3TechModel() {
        return Properties.getWW2V3TechModel(this.getData());
    }

    private boolean isSelectableTechRoll() {
        return Properties.getSelectableTechRoll(this.getData());
    }

    private boolean isLL_TECH_ONLY() {
        return Properties.getLL_TECH_ONLY(this.getData());
    }

    @Override
    public TechResults rollTech(int techRolls, TechnologyFrontier techToRollFor, int newTokens) {
        int[] random;
        boolean canPay;
        int rollCount = techRolls;
        if (this.isWW2V3TechModel()) {
            rollCount = newTokens;
        }
        if (!(canPay = this.checkEnoughMoney(rollCount))) {
            return new TechResults("Not enough money to pay for that many tech rolls.");
        }
        this.chargeForTechRolls(rollCount);
        int m_currTokens = 0;
        if (this.isWW2V3TechModel()) {
            m_currTokens = this.m_player.getResources().getQuantity("techTokens");
        }
        GameData data = this.getData();
        if (this.getAvailableTechs().isEmpty()) {
            if (this.isWW2V3TechModel()) {
                Resource techTokens = data.getResourceList().getResource("techTokens");
                String transcriptText = this.m_player.getName() + " No more available tech advances.";
                this.m_bridge.getHistoryWriter().startEvent(transcriptText);
                Change removeTokens = ChangeFactory.changeResourcesChange(this.m_bridge.getPlayerID(), techTokens, -m_currTokens);
                this.m_bridge.addChange(removeTokens);
            }
            return new TechResults("No more available tech advances.");
        }
        String annotation = this.m_player.getName() + " rolling for tech.";
        int techHits = 0;
        int remainder = 0;
        int diceSides = data.getDiceSides();
        if (EditDelegate.getEditMode(data)) {
            ITripleaPlayer tripleaPlayer = (ITripleaPlayer)this.m_bridge.getRemote();
            random = tripleaPlayer.selectFixedDice(techRolls, diceSides, true, annotation, diceSides);
            techHits = this.getTechHits(random);
        } else if (this.isLL_TECH_ONLY()) {
            techHits = techRolls / diceSides;
            remainder = techRolls % diceSides;
            if (remainder > 0) {
                random = this.m_bridge.getRandom(diceSides, 1, annotation);
                if (random[0] + 1 <= remainder) {
                    ++techHits;
                }
            } else {
                random = this.m_bridge.getRandom(diceSides, 1, annotation);
                remainder = diceSides;
            }
        } else {
            random = this.m_bridge.getRandom(diceSides, techRolls, annotation);
            techHits = this.getTechHits(random);
        }
        boolean isRevisedModel = this.isWW2V2() || this.isSelectableTechRoll() && !this.isWW2V3TechModel();
        String directedTechInfo = isRevisedModel ? " for " + techToRollFor.getTechs().get(0) : "";
        this.m_bridge.getHistoryWriter().startEvent(this.m_player.getName() + (random.hashCode() > 0 ? " roll " : " rolls : ") + MyFormatter.asDice(random) + directedTechInfo + " and gets " + techHits + " " + MyFormatter.pluralize("hit", techHits));
        if (techHits > 0 && this.isWW2V3TechModel()) {
            this.m_techCategory = techToRollFor;
            Resource techTokens = data.getResourceList().getResource("techTokens");
            String transcriptText = this.m_player.getName() + " removing all Technology Tokens after successful research.";
            this.m_bridge.getHistoryWriter().startEvent(transcriptText);
            Change removeTokens = ChangeFactory.changeResourcesChange(this.m_bridge.getPlayerID(), techTokens, -m_currTokens);
            this.m_bridge.addChange(removeTokens);
        }
        if (this.isLL_TECH_ONLY()) {
            this.m_bridge.getHistoryWriter().setRenderingData(new DiceRoll(random, techHits, remainder, false));
        } else {
            this.m_bridge.getHistoryWriter().setRenderingData(new DiceRoll(random, techHits, diceSides - 1, true));
        }
        Collection<Object> advances = isRevisedModel ? (techHits > 0 ? Collections.singletonList(techToRollFor.getTechs().get(0)) : Collections.emptyList()) : this.getTechAdvances(techHits);
        this.m_techs.put(this.m_player, advances);
        ArrayList<String> advancesAsString = new ArrayList<String>();
        Iterator<Object> iter = advances.iterator();
        int count = advances.size();
        StringBuilder text = new StringBuilder();
        while (iter.hasNext()) {
            TechAdvance advance = (TechAdvance)iter.next();
            text.append(advance.getName());
            advancesAsString.add(advance.getName());
            if (--count > 1) {
                text.append(", ");
            }
            if (count != 1) continue;
            text.append(" and ");
        }
        String transcriptText = this.m_player.getName() + " discover " + text.toString();
        if (advances.size() > 0) {
            this.m_bridge.getHistoryWriter().startEvent(transcriptText);
        }
        return new TechResults(random, remainder, techHits, advancesAsString, this.m_player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TechAdvance> getAvailableTechs() {
        GameData data = this.getData();
        data.acquireReadLock();
        try {
            Collection<TechAdvance> currentAdvances = TechTracker.getTechAdvances(this.m_player, data);
            List<TechAdvance> allAdvances = TechAdvance.getTechAdvances(data, this.m_player);
            List<TechAdvance> list = Util.difference(allAdvances, currentAdvances);
            return list;
        }
        finally {
            data.releaseReadLock();
        }
    }

    boolean checkEnoughMoney(int rolls) {
        Resource PUs = this.getData().getResourceList().getResource("PUs");
        int cost = rolls * this.getTechCost();
        int has = this.m_bridge.getPlayerID().getResources().getQuantity(PUs);
        return has >= cost;
    }

    private void chargeForTechRolls(int rolls) {
        Resource PUs = this.getData().getResourceList().getResource("PUs");
        int cost = rolls * this.getTechCost();
        String transcriptText = this.m_bridge.getPlayerID().getName() + " spend " + cost + " on tech rolls";
        this.m_bridge.getHistoryWriter().startEvent(transcriptText);
        Change charge = ChangeFactory.changeResourcesChange(this.m_bridge.getPlayerID(), PUs, -cost);
        this.m_bridge.addChange(charge);
        if (this.isWW2V3TechModel()) {
            Resource tokens = this.getData().getResourceList().getResource("techTokens");
            Change newTokens = ChangeFactory.changeResourcesChange(this.m_bridge.getPlayerID(), tokens, rolls);
            this.m_bridge.addChange(newTokens);
        }
    }

    private int getTechHits(int[] random) {
        int count = 0;
        for (int i = 0; i < random.length; ++i) {
            if (random[i] != this.getData().getDiceSides() - 1) continue;
            ++count;
        }
        return count;
    }

    private Collection<TechAdvance> getTechAdvances(int hits) {
        int i;
        ArrayList<Integer> rolled;
        int[] random;
        List<Object> available = new ArrayList();
        if (hits > 0 && this.isWW2V3TechModel()) {
            available = this.getAvailableAdvancesForCategory(this.m_techCategory);
            hits = 1;
        } else {
            available = this.getAvailableAdvances();
        }
        if (available.isEmpty()) {
            return Collections.emptyList();
        }
        if (hits >= available.size()) {
            return available;
        }
        if (hits == 0) {
            return Collections.emptyList();
        }
        ArrayList<TechAdvance> newAdvances = new ArrayList<TechAdvance>(hits);
        String annotation = this.m_player.getName() + " rolling to see what tech advances are aquired";
        if (this.isSelectableTechRoll() || EditDelegate.getEditMode(this.getData())) {
            ITripleaPlayer tripleaPlayer = (ITripleaPlayer)this.m_bridge.getRemote();
            random = tripleaPlayer.selectFixedDice(hits, 0, true, annotation, available.size());
        } else {
            random = new int[hits];
            rolled = new ArrayList<Integer>();
            for (i = 0; i < hits; ++i) {
                int roll = this.m_bridge.getRandom(available.size() - i, annotation);
                Iterator i$ = rolled.iterator();
                while (i$.hasNext()) {
                    int r = (Integer)i$.next();
                    if (roll < r) continue;
                    ++roll;
                }
                random[i] = roll;
                rolled.add(roll);
            }
        }
        rolled = new ArrayList();
        for (i = 0; i < random.length; ++i) {
            int index = random[i];
            if (rolled.contains(index) || index >= available.size()) continue;
            newAdvances.add((TechAdvance)available.get(index));
            rolled.add(index);
        }
        this.m_bridge.getHistoryWriter().startEvent("Rolls to resolve tech hits:" + MyFormatter.asDice(random));
        return newAdvances;
    }

    private List<TechAdvance> getAvailableAdvances() {
        List<TechAdvance> allAdvances = TechAdvance.getTechAdvances(this.getData(), this.m_bridge.getPlayerID());
        Collection<TechAdvance> playersAdvances = TechTracker.getTechAdvances(this.m_bridge.getPlayerID(), this.getData());
        List<TechAdvance> available = Util.difference(allAdvances, playersAdvances);
        return available;
    }

    private List<TechAdvance> getAvailableAdvancesForCategory(TechnologyFrontier techCategory) {
        Collection<TechAdvance> playersAdvances = TechTracker.getTechAdvances(this.m_bridge.getPlayerID(), this.getData());
        List<TechAdvance> available = Util.difference(techCategory.getTechs(), playersAdvances);
        return available;
    }

    public int getTechCost() {
        this.m_techCost = TechTracker.getTechCost(this.m_player);
        return this.m_techCost;
    }

    public Class<ITechDelegate> getRemoteType() {
        return ITechDelegate.class;
    }
}

