/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.MoveValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportTracker {
    public static int getCost(Collection<Unit> units) {
        return MoveValidator.getTransportCost(units);
    }

    private static void assertTransport(Unit u) {
        if (UnitAttachment.get(u.getType()).getTransportCapacity() == -1) {
            throw new IllegalStateException("Not a transport:" + u);
        }
    }

    public Collection<Unit> transporting(Unit transport) {
        return new ArrayList<Unit>(((TripleAUnit)transport).getTransporting());
    }

    public boolean isTransporting(Unit transport) {
        return !((TripleAUnit)transport).getTransporting().isEmpty();
    }

    public Collection<Unit> unloaded(Unit transport) {
        return ((TripleAUnit)transport).getUnloaded();
    }

    public Collection<Unit> transportingAndUnloaded(Unit transport) {
        Collection<Unit> rVal = this.transporting(transport);
        if (rVal == null) {
            rVal = new ArrayList<Unit>();
        }
        rVal.addAll(this.unloaded(transport));
        return rVal;
    }

    public Map<Unit, Collection<Unit>> transporting(Collection<Unit> units) {
        HashMap<Unit, Collection<Unit>> returnVal = new HashMap<Unit, Collection<Unit>>();
        for (Unit transported : units) {
            Unit transport = this.transportedBy(transported);
            Collection<Unit> transporting = null;
            if (transport != null) {
                transporting = this.transporting(transport);
            }
            if (transporting == null) continue;
            returnVal.put(transport, transporting);
        }
        return returnVal;
    }

    public Unit transportedBy(Unit unit) {
        return ((TripleAUnit)unit).getTransportedBy();
    }

    private boolean isNonCombat(GameData data) {
        return data.getSequence().getStep().getName().endsWith("NonCombatMove");
    }

    public Change unloadTransportChange(TripleAUnit unit, Territory territory, PlayerID id, boolean dependentBattle) {
        CompositeChange change = new CompositeChange();
        TripleAUnit transport = (TripleAUnit)this.transportedBy(unit);
        if (transport == null) {
            return change;
        }
        TransportTracker.assertTransport(transport);
        if (!transport.getTransporting().contains(unit)) {
            throw new IllegalStateException("Not being carried, unit:" + unit + " transport:" + transport);
        }
        ArrayList<Unit> newUnloaded = new ArrayList<Unit>(transport.getUnloaded());
        newUnloaded.add(unit);
        change.add(ChangeFactory.unitPropertyChange(unit, territory, "unloadedTo"));
        if (!this.isNonCombat(unit.getData())) {
            change.add(ChangeFactory.unitPropertyChange(unit, true, "wasUnloadedInCombatPhase"));
            change.add(ChangeFactory.unitPropertyChange(unit, true, "wasAmphibious"));
            change.add(ChangeFactory.unitPropertyChange(transport, true, "wasUnloadedInCombatPhase"));
            change.add(ChangeFactory.unitPropertyChange(transport, true, "wasAmphibious"));
        }
        if (!dependentBattle) {
            change.add(ChangeFactory.unitPropertyChange(unit, null, "transportedBy"));
        }
        change.add(ChangeFactory.unitPropertyChange(transport, newUnloaded, "unloaded"));
        return change;
    }

    public Change loadTransportChange(TripleAUnit transport, Unit unit, PlayerID id) {
        TransportTracker.assertTransport(transport);
        CompositeChange change = new CompositeChange();
        change.add(ChangeFactory.unitPropertyChange(unit, transport, "transportedBy"));
        ArrayList<Unit> newCarrying = new ArrayList<Unit>(transport.getTransporting());
        if (newCarrying.contains(unit)) {
            throw new IllegalStateException("Already carrying, transport:" + transport + " unt:" + unit);
        }
        newCarrying.add(unit);
        change.add(ChangeFactory.unitPropertyChange(unit, Boolean.TRUE, "wasLoadedThisTurn"));
        change.add(ChangeFactory.unitPropertyChange(transport, true, "wasLoadedThisTurn"));
        if (transport.getWasInCombat()) {
            change.add(ChangeFactory.unitPropertyChange(transport, true, "wasLoadedAfterCombat"));
        }
        return change;
    }

    public Change combatTransportChange(TripleAUnit transport, PlayerID id) {
        TransportTracker.assertTransport(transport);
        CompositeChange change = new CompositeChange();
        change.add(ChangeFactory.unitPropertyChange(transport, true, "wasInCombat"));
        return change;
    }

    public int getAvailableCapacity(Unit unit) {
        UnitAttachment ua = UnitAttachment.get(unit.getType());
        if (ua.getTransportCapacity() == -1 || unit.getData().getProperties().get("Pacific Theater", false) && ua.getIsDestroyer() && !unit.getOwner().getName().equals("Japanese")) {
            return 0;
        }
        int capacity = ua.getTransportCapacity();
        int used = TransportTracker.getCost(this.transporting(unit));
        int unloaded = TransportTracker.getCost(this.unloaded(unit));
        return capacity - used - unloaded;
    }

    public Change endOfRoundClearStateChange(GameData data) {
        CompositeChange change = new CompositeChange();
        for (Unit unit : data.getUnits().getUnits()) {
            TripleAUnit taUnit = (TripleAUnit)unit;
            if (!taUnit.getUnloaded().isEmpty()) {
                change.add(ChangeFactory.unitPropertyChange(unit, Collections.EMPTY_LIST, "unloaded"));
            }
            if (taUnit.getWasLoadedThisTurn()) {
                change.add(ChangeFactory.unitPropertyChange(unit, Boolean.FALSE, "wasLoadedThisTurn"));
            }
            if (taUnit.getUnloadedTo() != null) {
                change.add(ChangeFactory.unitPropertyChange(unit, null, "unloadedTo"));
            }
            if (taUnit.getWasUnloadedInCombatPhase()) {
                change.add(ChangeFactory.unitPropertyChange(unit, Boolean.FALSE, "wasUnloadedInCombatPhase"));
            }
            if (taUnit.getWasInCombat()) {
                change.add(ChangeFactory.unitPropertyChange(unit, Boolean.FALSE, "wasInCombat"));
            }
            if (!taUnit.getWasAmphibious()) continue;
            change.add(ChangeFactory.unitPropertyChange(unit, Boolean.FALSE, "wasAmphibious"));
        }
        return change;
    }

    public Collection<Unit> getUnitsLoadedOnAlliedTransportsThisTurn(Collection<Unit> units) {
        ArrayList<Unit> rVal = new ArrayList<Unit>();
        for (Unit u : units) {
            TripleAUnit taUnit = (TripleAUnit)u;
            if (!taUnit.getWasLoadedThisTurn() || taUnit.getTransportedBy() == null || taUnit.getTransportedBy().getOwner().equals(taUnit.getOwner())) continue;
            rVal.add(u);
        }
        return rVal;
    }

    public boolean hasTransportUnloadedInPreviousPhase(Unit transport) {
        List<Unit> unloaded = ((TripleAUnit)transport).getUnloaded();
        for (Unit u : unloaded) {
            TripleAUnit taUnit = (TripleAUnit)u;
            if (!this.isNonCombat(transport.getData()) || !taUnit.getWasUnloadedInCombatPhase()) continue;
            return true;
        }
        return false;
    }

    private boolean isWW2V2(GameData data) {
        return Properties.getWW2V2(data);
    }

    private boolean isTransportUnloadRestricted(GameData data) {
        return Properties.getTransportUnloadRestricted(data);
    }

    public boolean isTransportUnloadRestrictedToAnotherTerritory(Unit transport, Territory territory) {
        List<Unit> unloaded = ((TripleAUnit)transport).getUnloaded();
        if (unloaded.isEmpty()) {
            return false;
        }
        GameData data = transport.getData();
        for (Unit u : unloaded) {
            TripleAUnit taUnit = (TripleAUnit)u;
            if (!(this.isWW2V2(data) || this.isTransportUnloadRestricted(data) ? !taUnit.getUnloadedTo().equals(territory) : !this.isNonCombat(transport.getData()) && !taUnit.getUnloadedTo().equals(territory))) continue;
            return true;
        }
        return false;
    }

    public Territory getTerritoryTransportHasUnloadedTo(Unit transport) {
        List<Unit> unloaded = ((TripleAUnit)transport).getUnloaded();
        if (unloaded.isEmpty()) {
            return null;
        }
        Iterator iter = unloaded.iterator();
        return ((TripleAUnit)iter.next()).getUnloadedTo();
    }

    public boolean isTransportUnloadRestrictedInNonCombat(Unit transport) {
        TripleAUnit taUnit = (TripleAUnit)transport;
        return this.isNonCombat(transport.getData()) && taUnit.getWasInCombat() && taUnit.getWasLoadedAfterCombat();
    }
}

