/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.history.IDelegateHistoryWriter;
import games.strategy.triplea.delegate.EditDelegate;

public class TripleADelegateHistoryWriter
implements IDelegateHistoryWriter {
    IDelegateHistoryWriter m_delegateHistoryWriter;
    GameData m_data;

    public TripleADelegateHistoryWriter(IDelegateHistoryWriter delegateHistoryWriter, GameData data) {
        this.m_delegateHistoryWriter = delegateHistoryWriter;
        this.m_data = data;
    }

    public String getEventPrefix() {
        if (EditDelegate.getEditMode(this.m_data)) {
            return "EDIT: ";
        }
        return "";
    }

    public void startEvent(String eventName) {
        if (eventName.startsWith("COMMENT: ")) {
            this.m_delegateHistoryWriter.startEvent(eventName);
        } else {
            this.m_delegateHistoryWriter.startEvent(this.getEventPrefix() + eventName);
        }
    }

    public void addChildToEvent(String child) {
        if (child.startsWith("COMMENT: ")) {
            this.m_delegateHistoryWriter.addChildToEvent(child, null);
        } else {
            this.m_delegateHistoryWriter.addChildToEvent(this.getEventPrefix() + child, null);
        }
    }

    public void addChildToEvent(String child, Object renderingData) {
        if (child.startsWith("COMMENT: ")) {
            this.m_delegateHistoryWriter.addChildToEvent(child, renderingData);
        } else {
            this.m_delegateHistoryWriter.addChildToEvent(this.getEventPrefix() + child, renderingData);
        }
    }

    public void setRenderingData(Object renderingData) {
        this.m_delegateHistoryWriter.setRenderingData(renderingData);
    }
}

