/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.delegate.AbstractUndoableMove;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.dataObjects.MoveDescription;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.triplea.ui.MovePanel;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoableMove
extends AbstractUndoableMove {
    private String m_reasonCantUndo;
    private String m_description;
    private final Set<UndoableMove> m_iDependOn = new HashSet<UndoableMove>();
    private final Set<UndoableMove> m_dependOnMe = new HashSet<UndoableMove>();
    private final Set<Territory> m_conquered = new HashSet<Territory>();
    private final Set<Unit> m_loaded = new HashSet<Unit>();
    private final Set<Unit> m_unloaded = new HashSet<Unit>();
    private final Route m_route;

    public void addToConquered(Territory t) {
        this.m_conquered.add(t);
    }

    public Route getRoute() {
        return this.m_route;
    }

    public boolean getcanUndo() {
        return this.m_reasonCantUndo == null && this.m_dependOnMe.isEmpty();
    }

    public String getReasonCantUndo() {
        if (this.m_reasonCantUndo != null) {
            return this.m_reasonCantUndo;
        }
        if (!this.m_dependOnMe.isEmpty()) {
            return "Move " + (this.m_dependOnMe.iterator().next().getIndex() + 1) + " must be undone first";
        }
        throw new IllegalStateException("no reason");
    }

    public void setCantUndo(String reason) {
        this.m_reasonCantUndo = reason;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public UndoableMove(GameData data, Collection<Unit> units, Route route) {
        super(new CompositeChange(), units);
        this.m_route = route;
    }

    public void load(Unit transport) {
        this.m_loaded.add(transport);
    }

    public void unload(Unit transport) {
        this.m_unloaded.add(transport);
    }

    @Override
    protected void undoSpecific(IDelegateBridge bridge) {
        GameData data = bridge.getData();
        BattleTracker battleTracker = DelegateFinder.battleDelegate(data).getBattleTracker();
        battleTracker.undoBattle(this.m_route, this.m_units, bridge.getPlayerID(), bridge);
        for (UndoableMove other : this.m_iDependOn) {
            other.m_dependOnMe.remove(this);
        }
        IBattle battleNormal = battleTracker.getPendingBattle(this.m_route.getStart(), false);
        IBattle battleBombing = battleTracker.getPendingBattle(this.m_route.getStart(), true);
        if (battleNormal != null || battleBombing != null) {
            for (Unit unit : this.m_units) {
                Route routeUnitUsedToMove = DelegateFinder.moveDelegate(data).getRouteUsedToMoveInto(unit, this.m_route.getStart());
                if (battleNormal != null && !battleNormal.isOver() && routeUnitUsedToMove != null) {
                    Change change = battleNormal.addAttackChange(routeUnitUsedToMove, Collections.singleton(unit), null);
                    bridge.addChange(change);
                }
                if (battleBombing == null || battleBombing.isOver()) continue;
                HashMap<Unit, HashSet<Unit>> targets = null;
                Unit target = null;
                if (routeUnitUsedToMove != null && routeUnitUsedToMove.getEnd() != null) {
                    Territory end = routeUnitUsedToMove.getEnd();
                    List<Unit> enemyTargets = end.getUnits().getMatches(new CompositeMatchAnd<Unit>(Matches.enemyUnit(bridge.getPlayerID(), data), Matches.UnitIsAtMaxDamageOrNotCanBeDamaged(end).invert()));
                    if (enemyTargets.size() > 1 && Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(data) && !Properties.getRaidsMayBePreceededByAirBattles(data)) {
                        target = ((ITripleaPlayer)bridge.getRemote(bridge.getPlayerID())).whatShouldBomberBomb(end, enemyTargets);
                    } else if (!enemyTargets.isEmpty()) {
                        target = (Unit)enemyTargets.iterator().next();
                    }
                    if (target != null) {
                        targets = new HashMap<Unit, HashSet<Unit>>();
                        targets.put(target, new HashSet<Unit>(Collections.singleton(unit)));
                    }
                }
                Change change = battleBombing.addAttackChange(routeUnitUsedToMove, Collections.singleton(unit), targets);
                bridge.addChange(change);
            }
        }
        MovePanel.clearDependents(this.m_units);
    }

    public void initializeDependencies(List<UndoableMove> undoableMoves) {
        for (UndoableMove other : undoableMoves) {
            if (other == null) {
                System.err.println(undoableMoves);
                throw new IllegalStateException("other should not be null");
            }
            if (Util.intersection(other.getUnits(), this.getUnits()).isEmpty() && Util.intersection(other.m_units, this.m_loaded).isEmpty() && Util.intersection(other.m_conquered, this.m_route.getAllTerritories()).isEmpty() && Util.intersection(other.m_units, this.m_unloaded).isEmpty() && Util.intersection(other.m_unloaded, this.m_unloaded).isEmpty()) continue;
            this.m_iDependOn.add(other);
            other.m_dependOnMe.add(this);
        }
    }

    public boolean wasTransportUnloaded(Unit transport) {
        return this.m_unloaded.contains(transport);
    }

    public boolean wasTransportLoaded(Unit transport) {
        return this.m_loaded.contains(transport);
    }

    public String toString() {
        return "UndoableMove index;" + this.m_index + " description:" + this.m_description;
    }

    @Override
    public final String getMoveLabel() {
        return this.m_route.getStart() + " -> " + this.m_route.getEnd();
    }

    @Override
    public final Territory getEnd() {
        return this.m_route.getEnd();
    }

    @Override
    protected final MoveDescription getDescriptionObject() {
        return new MoveDescription(this.m_units, this.m_route);
    }
}

