/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate;

import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitComparator {
    public static Comparator<Unit> getDecreasingMovementComparator() {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                int left2;
                int left1 = TripleAUnit.get(u1).getMovementLeft();
                if (left1 == (left2 = TripleAUnit.get(u2).getMovementLeft())) {
                    return 0;
                }
                if (left1 > left2) {
                    return 1;
                }
                return -1;
            }
        };
    }

    public static Comparator<Unit> getIncreasingMovementComparator() {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                int left2;
                int left1 = TripleAUnit.get(u1).getMovementLeft();
                if (left1 == (left2 = TripleAUnit.get(u2).getMovementLeft())) {
                    return 0;
                }
                if (left1 < left2) {
                    return 1;
                }
                return -1;
            }
        };
    }

    public static Comparator<Unit> getIncreasingCapacityComparator(List<Unit> transports) {
        return UnitComparator.getCapacityComparator(transports, true);
    }

    public static Comparator<Unit> getDecreasingCapacityComparator(List<Unit> transports) {
        return UnitComparator.getCapacityComparator(transports, false);
    }

    private static Comparator<Unit> getCapacityComparator(List<Unit> transports, final boolean increasing) {
        final IntegerMap<Unit> capacityMap = new IntegerMap<Unit>(transports.size() + 1, 1.0f);
        for (Unit transport : transports) {
            List<Unit> transporting = TripleAUnit.get(transport).getTransporting();
            capacityMap.add(transport, MoveValidator.getTransportCost(transporting));
        }
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit t1, Unit t2) {
                int cost1 = capacityMap.getInt(t1);
                int cost2 = capacityMap.getInt(t2);
                if (increasing) {
                    return cost1 - cost2;
                }
                return cost2 - cost1;
            }
        };
    }

    public static Comparator<Unit> getLoadableTransportsComparator(List<Unit> transports, Route route, final PlayerID player, final boolean noTies) {
        final Comparator<Unit> decreasingCapacityComparator = UnitComparator.getDecreasingCapacityComparator(transports);
        final Match<Unit> incapableTransportMatch = Matches.transportCannotUnload(route.getEnd());
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                int left2;
                boolean isAlliedTrn2;
                TripleAUnit t1 = TripleAUnit.get(u1);
                TripleAUnit t2 = TripleAUnit.get(u2);
                boolean isIncapable1 = incapableTransportMatch.match(t1);
                boolean isIncapable2 = incapableTransportMatch.match(t2);
                if (!isIncapable1 && isIncapable2) {
                    return -1;
                }
                if (isIncapable1 && !isIncapable2) {
                    return 1;
                }
                boolean isAlliedTrn1 = !t1.getOwner().equals(player);
                boolean bl = isAlliedTrn2 = !t2.getOwner().equals(player);
                if (!isAlliedTrn1 && isAlliedTrn2) {
                    return -1;
                }
                if (isAlliedTrn1 && !isAlliedTrn2) {
                    return 1;
                }
                int compareCapacity = decreasingCapacityComparator.compare(t1, t2);
                if (compareCapacity != 0) {
                    return compareCapacity;
                }
                int left1 = t1.getMovementLeft();
                if (left1 != (left2 = t1.getMovementLeft())) {
                    return left2 - left1;
                }
                if (noTies) {
                    return t1.hashCode() - t2.hashCode();
                }
                return 0;
            }
        };
    }

    public static Comparator<Unit> getUnloadableTransportsComparator(List<Unit> transports, Route route, final PlayerID player, final boolean noTies) {
        final Comparator<Unit> decreasingCapacityComparator = UnitComparator.getDecreasingCapacityComparator(transports);
        final Match<Unit> incapableTransportMatch = Matches.transportCannotUnload(route.getEnd());
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit t1, Unit t2) {
                int left2;
                boolean isAlliedTrn2;
                boolean isIncapable1 = incapableTransportMatch.match(t1);
                boolean isIncapable2 = incapableTransportMatch.match(t2);
                if (!isIncapable1 && isIncapable2) {
                    return -1;
                }
                if (isIncapable1 && !isIncapable2) {
                    return 1;
                }
                boolean isAlliedTrn1 = !t1.getOwner().equals(player);
                boolean bl = isAlliedTrn2 = !t2.getOwner().equals(player);
                if (isAlliedTrn1 && !isAlliedTrn2) {
                    return -1;
                }
                if (!isAlliedTrn1 && isAlliedTrn2) {
                    return 1;
                }
                int compareCapacity = decreasingCapacityComparator.compare(t1, t2);
                if (compareCapacity != 0) {
                    return compareCapacity;
                }
                int left1 = TripleAUnit.get(t1).getMovementLeft();
                if (left1 != (left2 = TripleAUnit.get(t2).getMovementLeft())) {
                    return left1 - left2;
                }
                if (noTies) {
                    return t1.hashCode() - t2.hashCode();
                }
                return 0;
            }
        };
    }

    public static Comparator<Unit> getMovableUnitsComparator(final List<Unit> units, final Route route, PlayerID player, final boolean noTies) {
        final Comparator<Unit> decreasingCapacityComparator = UnitComparator.getDecreasingCapacityComparator(units);
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                int hasDepends2;
                int left1 = TripleAUnit.get(u1).getMovementLeft();
                int left2 = TripleAUnit.get(u2).getMovementLeft();
                if (route != null) {
                    if (left1 >= route.getMovementCost(u1) && left2 < route.getMovementCost(u2)) {
                        return -1;
                    }
                    if (left1 < route.getMovementCost(u1) && left2 >= route.getMovementCost(u2)) {
                        return 1;
                    }
                }
                List<Unit> transporting1 = TripleAUnit.get(u1).getTransporting();
                List<Unit> transporting2 = TripleAUnit.get(u2).getTransporting();
                if (transporting1 == null) {
                    transporting1 = Collections.emptyList();
                }
                if (transporting2 == null) {
                    transporting2 = Collections.emptyList();
                }
                int hasDepends1 = units.containsAll(transporting1) ? 1 : 0;
                int n = hasDepends2 = units.containsAll(transporting2) ? 1 : 0;
                if (hasDepends1 != hasDepends2) {
                    return hasDepends1 - hasDepends2;
                }
                int compareCapacity = decreasingCapacityComparator.compare(u1, u2);
                if (compareCapacity != 0) {
                    return compareCapacity;
                }
                if (left1 != left2) {
                    if (route.isLoad()) {
                        return left2 - left1;
                    }
                    return left1 - left2;
                }
                if (noTies) {
                    return u1.hashCode() - u2.hashCode();
                }
                return 0;
            }
        };
    }

    public static Comparator<Unit> getUnloadableUnitsComparator(List<Unit> units, Route route, PlayerID player, boolean noTies) {
        final Comparator<Unit> unloadableTransportsComparator = UnitComparator.getUnloadableTransportsComparator(units, route, player, false);
        final Comparator<Unit> movableUnitsComparator = UnitComparator.getMovableUnitsComparator(units, route, player, noTies);
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                int compareTransports;
                Unit t1 = TripleAUnit.get(u1).getTransportedBy();
                Unit t2 = TripleAUnit.get(u2).getTransportedBy();
                if (t1 != null && t2 == null) {
                    return -1;
                }
                if (t1 == null && t2 != null) {
                    return 1;
                }
                if (t1 != null && t2 != null && (compareTransports = unloadableTransportsComparator.compare(t1, t2)) != 0) {
                    return compareTransports;
                }
                return movableUnitsComparator.compare(u1, u2);
            }
        };
    }

    public static Comparator<Unit> getDecreasingAttackComparator(final PlayerID player) {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                int attack2;
                UnitAttachment ua1 = UnitAttachment.get(u1.getType());
                UnitAttachment ua2 = UnitAttachment.get(u2.getType());
                int attack1 = ua1.getAttack(player);
                if (attack1 == (attack2 = ua2.getAttack(player))) {
                    return 0;
                }
                if (attack1 < attack2) {
                    return 1;
                }
                return -1;
            }
        };
    }
}

