/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate.dataObjects;

import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.dataObjects.BattleRecords;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import java.io.Serializable;

class BattleRecord
implements Serializable {
    private static final long serialVersionUID = 3642216371483289106L;
    private Territory m_battleSite;
    private PlayerID m_attacker;
    private PlayerID m_defender;
    private int m_attackerLostTUV = 0;
    private int m_defenderLostTUV = 0;
    private BattleRecords.BattleResultDescription m_battleResultDescription;
    private int m_bombingDamage = 0;
    private IBattle.BattleType m_battleType;
    private BattleResults m_battleResults;

    protected BattleRecord(BattleRecord record) {
        this.m_battleSite = record.m_battleSite;
        this.m_attacker = record.m_attacker;
        this.m_defender = record.m_defender;
        this.m_attackerLostTUV = record.m_attackerLostTUV;
        this.m_defenderLostTUV = record.m_defenderLostTUV;
        this.m_battleResultDescription = record.m_battleResultDescription;
        this.m_bombingDamage = record.m_bombingDamage;
        this.m_battleType = record.m_battleType;
        this.m_battleResults = record.m_battleResults;
    }

    protected BattleRecord(Territory battleSite, PlayerID attacker, PlayerID defender, int attackerLostTUV, int defenderLostTUV, BattleRecords.BattleResultDescription battleResultDescription, BattleResults battleResults, int bombingDamage, IBattle.BattleType battleType) {
        this.m_battleSite = battleSite;
        this.m_attacker = attacker;
        this.m_defender = defender;
        this.m_attackerLostTUV = attackerLostTUV;
        this.m_defenderLostTUV = defenderLostTUV;
        this.m_battleResultDescription = battleResultDescription;
        this.m_battleResults = battleResults;
        this.m_bombingDamage = bombingDamage;
        this.m_battleType = battleType;
    }

    protected BattleRecord(Territory battleSite, PlayerID attacker, IBattle.BattleType battleType) {
        this.m_battleSite = battleSite;
        this.m_attacker = attacker;
        this.m_battleType = battleType;
    }

    protected void setResult(PlayerID defender, int attackerLostTUV, int defenderLostTUV, BattleRecords.BattleResultDescription battleResultDescription, BattleResults battleResults, int bombingDamage) {
        this.m_defender = defender;
        this.m_attackerLostTUV = attackerLostTUV;
        this.m_defenderLostTUV = defenderLostTUV;
        this.m_battleResultDescription = battleResultDescription;
        this.m_battleResults = battleResults;
        this.m_bombingDamage = bombingDamage;
    }

    protected Territory getBattleSite() {
        return this.m_battleSite;
    }

    protected void setBattleSite(Territory battleSite) {
        this.m_battleSite = battleSite;
    }

    protected PlayerID getAttacker() {
        return this.m_attacker;
    }

    protected void setAttacker(PlayerID attacker) {
        this.m_attacker = attacker;
    }

    protected PlayerID getDefender() {
        return this.m_defender;
    }

    protected void setDefenders(PlayerID defender) {
        this.m_defender = defender;
    }

    protected int getAttackerLostTUV() {
        return this.m_attackerLostTUV;
    }

    protected void setAttackerLostTUV(int attackerLostTUV) {
        this.m_attackerLostTUV = attackerLostTUV;
    }

    protected int getDefenderLostTUV() {
        return this.m_defenderLostTUV;
    }

    protected void setDefenderLostTUV(int defenderLostTUV) {
        this.m_defenderLostTUV = defenderLostTUV;
    }

    protected BattleRecords.BattleResultDescription getBattleResultDescription() {
        return this.m_battleResultDescription;
    }

    protected void setBattleResultDescription(BattleRecords.BattleResultDescription battleResult) {
        this.m_battleResultDescription = battleResult;
    }

    protected int getBombingDamage() {
        return this.m_bombingDamage;
    }

    protected void setBombingDamage(int bombingDamage) {
        this.m_bombingDamage = bombingDamage;
    }

    protected IBattle.BattleType getBattleType() {
        return this.m_battleType;
    }

    protected void setBattleType(IBattle.BattleType battleType) {
        this.m_battleType = battleType;
    }

    protected BattleResults getBattleResults() {
        return this.m_battleResults;
    }

    protected void setBattleResults(BattleResults battleResults) {
        this.m_battleResults = battleResults;
    }

    public int hashCode() {
        return this.m_battleSite.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof BattleRecord)) {
            return false;
        }
        BattleRecord other = (BattleRecord)o;
        return other.m_battleSite.equals(this.m_battleSite) && other.m_battleType.equals((Object)this.m_battleType) && other.m_attacker.equals(this.m_attacker);
    }

    public String toString() {
        return (Object)((Object)this.m_battleType) + " battle in " + this.m_battleSite;
    }
}

