/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate.dataObjects;

import games.strategy.engine.data.Unit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasualtyList
implements Serializable {
    protected List<Unit> m_killed;
    protected List<Unit> m_damaged;

    public CasualtyList(List<Unit> killed, List<Unit> damaged) {
        if (killed == null) {
            throw new IllegalArgumentException("null killed");
        }
        if (damaged == null) {
            throw new IllegalArgumentException("null damaged");
        }
        this.m_killed = killed;
        this.m_damaged = damaged;
    }

    public CasualtyList() {
        this.m_killed = new ArrayList<Unit>();
        this.m_damaged = new ArrayList<Unit>();
    }

    public List<Unit> getKilled() {
        return this.m_killed;
    }

    public List<Unit> getDamaged() {
        return this.m_damaged;
    }

    public void addToKilled(Unit deadUnit) {
        this.m_killed.add(deadUnit);
    }

    public void addToDamaged(Unit damagedUnit) {
        this.m_damaged.add(damagedUnit);
    }

    public void removeFromKilled(Unit deadUnit) {
        this.m_killed.remove(deadUnit);
    }

    public void removeFromDamaged(Unit damagedUnit) {
        this.m_damaged.remove(damagedUnit);
    }

    public void clear() {
        this.m_killed.clear();
        this.m_damaged.clear();
    }

    public int size() {
        return this.m_killed.size() + this.m_damaged.size();
    }

    public String toString() {
        return "Selected Casualties: damaged:" + this.m_damaged + " killed:" + this.m_killed;
    }
}

