/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.delegate.dataObjects;

import games.strategy.engine.data.Unit;
import games.strategy.triplea.util.UnitCategory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveValidationResult
implements Serializable,
Comparable<MoveValidationResult> {
    private String m_error = null;
    private final List<String> m_disallowedUnitWarnings = new ArrayList<String>();
    private final List<Collection<Unit>> m_disallowedUnitsList = new ArrayList<Collection<Unit>>();
    private final List<String> m_unresolvedUnitWarnings = new ArrayList<String>();
    private final List<Collection<Unit>> m_unresolvedUnitsList = new ArrayList<Collection<Unit>>();

    public MoveValidationResult() {
    }

    public MoveValidationResult(MoveValidationResult toCopy) {
        this();
        for (String warning : toCopy.getDisallowedUnitWarnings()) {
            for (Unit unit : toCopy.getDisallowedUnits(warning)) {
                this.addDisallowedUnit(warning, unit);
            }
        }
        for (String warning : toCopy.getUnresolvedUnitWarnings()) {
            for (Unit unit : toCopy.getUnresolvedUnits(warning)) {
                this.addUnresolvedUnit(warning, unit);
            }
        }
        this.setError(toCopy.getError());
    }

    public void addDisallowedUnit(String warning, Unit unit) {
        int index = this.m_disallowedUnitWarnings.indexOf(warning);
        if (index == -1) {
            index = this.m_disallowedUnitWarnings.size();
            this.m_disallowedUnitWarnings.add(warning);
            this.m_disallowedUnitsList.add(new ArrayList());
        }
        Collection<Unit> disallowedUnits = this.m_disallowedUnitsList.get(index);
        disallowedUnits.add(unit);
    }

    public boolean removeDisallowedUnit(String warning, Unit unit) {
        int index = this.m_disallowedUnitWarnings.indexOf(warning);
        if (index == -1) {
            return false;
        }
        Collection<Unit> disallowedUnits = this.m_disallowedUnitsList.get(index);
        if (!disallowedUnits.remove(unit)) {
            return false;
        }
        if (disallowedUnits.isEmpty()) {
            this.m_disallowedUnitsList.remove(disallowedUnits);
            this.m_disallowedUnitWarnings.remove(warning);
        }
        return true;
    }

    public void addUnresolvedUnit(String warning, Unit unit) {
        int index = this.m_unresolvedUnitWarnings.indexOf(warning);
        if (index == -1) {
            index = this.m_unresolvedUnitWarnings.size();
            this.m_unresolvedUnitWarnings.add(warning);
            this.m_unresolvedUnitsList.add(new ArrayList());
        }
        Collection<Unit> unresolvedUnits = this.m_unresolvedUnitsList.get(index);
        unresolvedUnits.add(unit);
    }

    public boolean removeUnresolvedUnit(String warning, Unit unit) {
        int index = this.m_unresolvedUnitWarnings.indexOf(warning);
        if (index == -1) {
            return false;
        }
        Collection<Unit> unresolvedUnits = this.m_unresolvedUnitsList.get(index);
        if (!unresolvedUnits.remove(unit)) {
            return false;
        }
        if (unresolvedUnits.isEmpty()) {
            this.m_unresolvedUnitsList.remove(unresolvedUnits);
            this.m_unresolvedUnitWarnings.remove(warning);
        }
        return true;
    }

    public void setError(String error) {
        this.m_error = error;
    }

    public MoveValidationResult setErrorReturnResult(String error) {
        this.m_error = error;
        return this;
    }

    public String getError() {
        return this.m_error;
    }

    public Collection<Unit> getDisallowedUnits() {
        LinkedHashSet<Unit> allDisallowedUnits = new LinkedHashSet<Unit>();
        for (Collection<Unit> unitList : this.m_disallowedUnitsList) {
            for (Unit unit : unitList) {
                allDisallowedUnits.add(unit);
            }
        }
        return allDisallowedUnits;
    }

    public Collection<Unit> getUnresolvedUnits() {
        LinkedHashSet<Unit> allUnresolvedUnits = new LinkedHashSet<Unit>();
        for (Collection<Unit> unitList : this.m_unresolvedUnitsList) {
            for (Unit unit : unitList) {
                allUnresolvedUnits.add(unit);
            }
        }
        return allUnresolvedUnits;
    }

    public Collection<UnitCategory> getUnresolvedUnitCategories() {
        HashSet<UnitCategory> unresolvedUnitCategories = new HashSet<UnitCategory>();
        for (Unit unit : this.getUnresolvedUnits()) {
            unresolvedUnitCategories.add(new UnitCategory(unit, false, false, false, false));
        }
        return unresolvedUnitCategories;
    }

    public Collection<Unit> getDisallowedUnits(String warning) {
        int index = this.m_disallowedUnitWarnings.indexOf(warning);
        if (index == -1) {
            return Collections.emptyList();
        }
        return new ArrayList<Unit>(this.m_disallowedUnitsList.get(index));
    }

    public Collection<Unit> getUnresolvedUnits(String warning) {
        int index = this.m_unresolvedUnitWarnings.indexOf(warning);
        if (index == -1) {
            return Collections.emptyList();
        }
        return new ArrayList<Unit>(this.m_unresolvedUnitsList.get(index));
    }

    public Collection<String> getDisallowedUnitWarnings() {
        return new ArrayList<String>(this.m_disallowedUnitWarnings);
    }

    public Collection<String> getUnresolvedUnitWarnings() {
        return new ArrayList<String>(this.m_unresolvedUnitWarnings);
    }

    public String getDisallowedUnitWarning(int index) {
        if (index < 0 || index >= this.m_disallowedUnitWarnings.size()) {
            return null;
        }
        return this.m_disallowedUnitWarnings.get(index);
    }

    public String getUnresolvedUnitWarning(int index) {
        if (index < 0 || index >= this.m_unresolvedUnitWarnings.size()) {
            return null;
        }
        return this.m_unresolvedUnitWarnings.get(index);
    }

    public boolean hasError() {
        return this.m_error != null;
    }

    public boolean hasDisallowedUnits() {
        return this.m_disallowedUnitWarnings.size() > 0;
    }

    public int getDisallowedUnitCount() {
        return this.m_disallowedUnitWarnings.size();
    }

    public boolean hasUnresolvedUnits() {
        return this.m_unresolvedUnitWarnings.size() > 0;
    }

    public int getUnresolvedUnitCount() {
        return this.m_unresolvedUnitWarnings.size();
    }

    public boolean isMoveValid() {
        return !this.hasError() && !this.hasDisallowedUnits() && !this.hasUnresolvedUnits();
    }

    public int getTotalWarningCount() {
        return this.m_unresolvedUnitWarnings.size() + this.m_disallowedUnitWarnings.size();
    }

    public void removeAnyUnresolvedUnitsThatAreDisallowed() {
        MoveValidationResult oldResult = new MoveValidationResult(this);
        Collection<Unit> disallowedUnits = oldResult.getDisallowedUnits();
        ArrayList<Unit> unresolvedAndDisallowed = new ArrayList<Unit>(disallowedUnits);
        unresolvedAndDisallowed.retainAll(oldResult.getUnresolvedUnits());
        for (String warning : oldResult.getUnresolvedUnitWarnings()) {
            for (Unit unit : oldResult.getUnresolvedUnits(warning)) {
                if (!disallowedUnits.contains(unit)) continue;
                this.removeUnresolvedUnit(warning, unit);
            }
        }
    }

    @Override
    public int compareTo(MoveValidationResult other) {
        if (!this.hasError() && other.hasError()) {
            return -1;
        }
        if (this.hasError() && !other.hasError()) {
            return 1;
        }
        if (this.getDisallowedUnitCount() < other.getDisallowedUnitCount()) {
            return -1;
        }
        if (this.getDisallowedUnitCount() > other.getDisallowedUnitCount()) {
            return 1;
        }
        if (this.getUnresolvedUnitCount() < other.getUnresolvedUnitCount()) {
            return -1;
        }
        if (this.getUnresolvedUnitCount() > other.getUnresolvedUnitCount()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "Move Validation Results, error:" + this.m_error + " isValid():" + this.isMoveValid();
    }
}

