/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.image;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

class BlendComposite
implements Composite {
    public static final BlendComposite Normal = new BlendComposite(BlendingMode.NORMAL);
    public static final BlendComposite Overlay = new BlendComposite(BlendingMode.OVERLAY);
    public static final BlendComposite Multiply = new BlendComposite(BlendingMode.MULTIPLY);
    public static final BlendComposite Difference = new BlendComposite(BlendingMode.DIFFERENCE);
    public static final BlendComposite Linear_Light = new BlendComposite(BlendingMode.LINEAR_LIGHT);
    private float alpha;
    private final BlendingMode mode;

    BlendComposite(BlendingMode mode) {
        this(mode, 1.0f);
    }

    private BlendComposite(BlendingMode mode, float alpha) {
        this.mode = mode;
        this.setAlpha(alpha);
    }

    public static BlendComposite getInstance(BlendingMode mode) {
        return new BlendComposite(mode);
    }

    public static BlendComposite getInstance(BlendingMode mode, float alpha) {
        return new BlendComposite(mode, alpha);
    }

    public BlendComposite derive(BlendingMode mode) {
        return this.mode == mode ? this : new BlendComposite(mode, this.getAlpha());
    }

    public BlendComposite derive(float alpha) {
        return this.alpha == alpha ? this : new BlendComposite(this.getMode(), alpha);
    }

    public float getAlpha() {
        return this.alpha;
    }

    public BlendingMode getMode() {
        return this.mode;
    }

    private void setAlpha(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("alpha must be comprised between 0.0f and 1.0f");
        }
        this.alpha = alpha;
    }

    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return new BlendingContext(this);
    }

    static abstract class Blender {
        Blender() {
        }

        public abstract int[] blend(int[] var1, int[] var2);

        public static Blender getBlenderFor(BlendComposite composite) {
            switch (composite.getMode()) {
                case NORMAL: {
                    return new Blender(){

                        public int[] blend(int[] src, int[] dst) {
                            return src;
                        }
                    };
                }
                case OVERLAY: {
                    return new Blender(){

                        public int[] blend(int[] src, int[] dst) {
                            return new int[]{dst[0] < 128 ? dst[0] * src[0] >> 7 : 255 - ((255 - dst[0]) * (255 - src[0]) >> 7), dst[1] < 128 ? dst[1] * src[1] >> 7 : 255 - ((255 - dst[1]) * (255 - src[1]) >> 7), dst[2] < 128 ? dst[2] * src[2] >> 7 : 255 - ((255 - dst[2]) * (255 - src[2]) >> 7), Math.min(255, src[3] + dst[3])};
                        }
                    };
                }
                case LINEAR_LIGHT: {
                    return new Blender(){

                        public int[] blend(int[] src, int[] dst) {
                            return new int[]{dst[0] < 128 ? dst[0] + src[0] >> -248 : dst[0] + (src[0] - 128) >> 7, dst[1] < 128 ? dst[1] + src[1] >> -248 : dst[1] + (src[1] - 128) >> 7, dst[2] < 128 ? dst[2] + src[2] >> -248 : dst[2] + (src[2] - 128) >> 7, Math.min(255, src[3] + dst[3])};
                        }
                    };
                }
                case MULTIPLY: {
                    return new Blender(){

                        public int[] blend(int[] src, int[] dst) {
                            return new int[]{src[0] * dst[0] >> 8, src[1] * dst[1] >> 8, src[2] * dst[2] >> 8, Math.min(255, src[3] + dst[3])};
                        }
                    };
                }
                case DIFFERENCE: {
                    return new Blender(){

                        public int[] blend(int[] src, int[] dst) {
                            return new int[]{Math.abs(dst[0] - src[0]), Math.abs(dst[1] - src[1]), Math.abs(dst[2] - src[2]), Math.min(255, src[3] + dst[3])};
                        }
                    };
                }
            }
            throw new IllegalArgumentException("Blender not implement for " + composite.getMode().name());
        }
    }

    private static final class BlendingContext
    implements CompositeContext {
        private final Blender blender;
        private final BlendComposite composite;

        private BlendingContext(BlendComposite composite) {
            this.composite = composite;
            this.blender = Blender.getBlenderFor(composite);
        }

        public void dispose() {
        }

        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            if (src.getSampleModel().getDataType() != 3 || dstIn.getSampleModel().getDataType() != 3 || dstOut.getSampleModel().getDataType() != 3) {
                throw new IllegalStateException("Source and destination must store pixels as INT.");
            }
            int width = Math.min(src.getWidth(), dstIn.getWidth());
            int height = Math.min(src.getHeight(), dstIn.getHeight());
            float alpha = this.composite.getAlpha();
            int[] srcPixel = new int[4];
            int[] dstPixel = new int[4];
            int[] srcPixels = new int[width];
            int[] dstPixels = new int[width];
            for (int y = 0; y < height; ++y) {
                src.getDataElements(0, y, width, 1, srcPixels);
                dstIn.getDataElements(0, y, width, 1, dstPixels);
                for (int x = 0; x < width; ++x) {
                    int pixel = srcPixels[x];
                    srcPixel[0] = pixel >> 16 & 0xFF;
                    srcPixel[1] = pixel >> 8 & 0xFF;
                    srcPixel[2] = pixel & 0xFF;
                    srcPixel[3] = pixel >> 24 & 0xFF;
                    pixel = dstPixels[x];
                    dstPixel[0] = pixel >> 16 & 0xFF;
                    dstPixel[1] = pixel >> 8 & 0xFF;
                    dstPixel[2] = pixel & 0xFF;
                    dstPixel[3] = pixel >> 24 & 0xFF;
                    int[] result = this.blender.blend(srcPixel, dstPixel);
                    dstPixels[x] = ((int)((float)dstPixel[3] + (float)(result[3] - dstPixel[3]) * alpha) & 0xFF) << 24 | ((int)((float)dstPixel[0] + (float)(result[0] - dstPixel[0]) * alpha) & 0xFF) << 16 | ((int)((float)dstPixel[1] + (float)(result[1] - dstPixel[1]) * alpha) & 0xFF) << 8 | (int)((float)dstPixel[2] + (float)(result[2] - dstPixel[2]) * alpha) & 0xFF;
                }
                dstOut.setDataElements(0, y, width, 1, dstPixels);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlendingMode {
        NORMAL,
        OVERLAY,
        MULTIPLY,
        DIFFERENCE,
        LINEAR_LIGHT;

    }
}

