/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.image;

import games.strategy.triplea.ResourceLoader;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class ImageFactory {
    private final Map<String, Image> m_images = new HashMap<String, Image>();
    private ResourceLoader m_resourceLoader;

    public void setResourceLoader(ResourceLoader loader) {
        this.m_resourceLoader = loader;
        this.m_images.clear();
    }

    protected Image getImage(String key1, String key2, boolean throwIfNotFound) {
        Image i1 = this.getImage(key1, false);
        if (i1 != null) {
            return i1;
        }
        return this.getImage(key2, throwIfNotFound);
    }

    protected Image getImage(String key, boolean throwIfNotFound) {
        if (!this.m_images.containsKey(key)) {
            BufferedImage image;
            URL url = this.m_resourceLoader.getResource(key);
            if (url == null && throwIfNotFound) {
                throw new IllegalStateException("Image Not Found:" + key);
            }
            if (url == null) {
                this.m_images.put(key, null);
                return null;
            }
            try {
                image = ImageIO.read(url);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalStateException(e.getMessage());
            }
            this.m_images.put(key, image);
        }
        return this.m_images.get(key);
    }
}

