/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.image;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.ResourceLoader;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.ui.Util;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class UnitImageFactory {
    public static final int UNIT_ICON_WIDTH = 48;
    public static final int UNIT_ICON_HEIGHT = 48;
    private static final String FILE_NAME_BASE = "units/";
    private final Map<String, Image> m_images = new HashMap<String, Image>();
    private final Map<String, ImageIcon> m_icons = new HashMap<String, ImageIcon>();
    private double m_scaleFactor;
    private ResourceLoader m_resourceLoader;

    public void setResourceLoader(ResourceLoader loader, double scaleFactor) {
        this.m_scaleFactor = scaleFactor;
        this.m_resourceLoader = loader;
        this.clearImageCache();
    }

    public void setScaleFactor(double scaleFactor) {
        if (this.m_scaleFactor != scaleFactor) {
            this.m_scaleFactor = scaleFactor;
            this.clearImageCache();
        }
    }

    public double getScaleFactor() {
        return this.m_scaleFactor;
    }

    public int getUnitImageWidth() {
        return (int)(this.m_scaleFactor * 48.0);
    }

    public int getUnitImageHeight() {
        return (int)(this.m_scaleFactor * 48.0);
    }

    private void clearImageCache() {
        this.m_images.clear();
        this.m_icons.clear();
    }

    public Image getImage(UnitType type, PlayerID player, GameData data, boolean damaged, boolean disabled) {
        String baseName = this.getBaseImageName(type, player, data, damaged, disabled);
        String fullName = baseName + player.getName();
        if (this.m_images.containsKey(fullName)) {
            return this.m_images.get(fullName);
        }
        Image baseImage = this.getBaseImage(baseName, player, damaged);
        int width = (int)((double)baseImage.getWidth(null) * this.m_scaleFactor);
        int height = (int)((double)baseImage.getHeight(null) * this.m_scaleFactor);
        Image scaledImage = baseImage.getScaledInstance(width, height, 4);
        try {
            Util.ensureImageLoaded(scaledImage);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.m_images.put(fullName, scaledImage);
        return scaledImage;
    }

    private Image getBaseImage(String baseImageName, PlayerID id, boolean damaged) {
        String fileName = FILE_NAME_BASE + id.getName() + "/" + baseImageName + ".png";
        URL url = this.m_resourceLoader.getResource(fileName);
        if (url == null) {
            throw new IllegalStateException("Cant load :" + baseImageName + " looking in:" + fileName);
        }
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        try {
            Util.ensureImageLoaded(image);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        return image;
    }

    public Image getHighlightImage(UnitType type, PlayerID player, GameData data, boolean damaged, boolean disabled) {
        Image base = this.getImage(type, player, data, damaged, disabled);
        BufferedImage newImage = Util.createImage(base.getWidth(null), base.getHeight(null), true);
        Graphics2D g = newImage.createGraphics();
        g.drawImage(base, 0, 0, null);
        g.setComposite(AlphaComposite.SrcIn);
        g.setColor(new Color(200, 200, 200, 80));
        g.fillRect(0, 0, base.getWidth(null), base.getHeight(null));
        g.dispose();
        return newImage;
    }

    public ImageIcon getIcon(UnitType type, PlayerID player, GameData data, boolean damaged, boolean disabled) {
        String baseName = this.getBaseImageName(type, player, data, damaged, disabled);
        String fullName = baseName + player.getName();
        if (this.m_icons.containsKey(fullName)) {
            return this.m_icons.get(fullName);
        }
        Image img = this.getBaseImage(baseName, player, damaged);
        ImageIcon icon = new ImageIcon(img);
        this.m_icons.put(fullName, icon);
        return icon;
    }

    public String getBaseImageName(UnitType type, PlayerID id, GameData data, boolean damaged, boolean disabled) {
        StringBuilder name = new StringBuilder(32);
        name.append(type.getName());
        if (!type.getName().endsWith("_hit") && !type.getName().endsWith("_disabled")) {
            if (type.getName().equals("aaGun")) {
                if (TechTracker.hasRocket(id) && UnitAttachment.get(type).getIsRocket()) {
                    name = new StringBuilder("rockets");
                }
                if (TechTracker.hasAARadar(id) && Matches.UnitTypeIsAAforAnything.match(type)) {
                    name.append("_r");
                }
            } else if (UnitAttachment.get(type).getIsRocket() && Matches.UnitTypeIsAAforAnything.match(type)) {
                if (TechTracker.hasRocket(id)) {
                    name.append("_rockets");
                }
                if (TechTracker.hasAARadar(id)) {
                    name.append("_r");
                }
            } else if (UnitAttachment.get(type).getIsRocket()) {
                if (TechTracker.hasRocket(id)) {
                    name.append("_rockets");
                }
            } else if (Matches.UnitTypeIsAAforAnything.match(type) && TechTracker.hasAARadar(id)) {
                name.append("_r");
            }
            if (UnitAttachment.get(type).getIsAir() && !UnitAttachment.get(type).getIsStrategicBomber()) {
                if (TechTracker.hasLongRangeAir(id)) {
                    name.append("_lr");
                }
                if (TechTracker.hasJetFighter(id) && (UnitAttachment.get(type).getAttack(id) > 0 || UnitAttachment.get(type).getDefense(id) > 0)) {
                    name.append("_jp");
                }
            }
            if (UnitAttachment.get(type).getIsAir() && UnitAttachment.get(type).getIsStrategicBomber()) {
                if (TechTracker.hasLongRangeAir(id)) {
                    name.append("_lr");
                }
                if (TechTracker.hasHeavyBomber(id)) {
                    name.append("_hb");
                }
            }
            if (UnitAttachment.get(type).getIsSub() && (UnitAttachment.get(type).getAttack(id) > 0 || UnitAttachment.get(type).getDefense(id) > 0)) {
                if (TechTracker.hasSuperSubs(id)) {
                    name.append("_ss");
                }
                if (TechTracker.hasRocket(id)) {
                    // empty if block
                }
            }
            if ((type.getName().equals("factory") || UnitAttachment.get(type).getIsFactory() || UnitAttachment.get(type).getCanProduceUnits()) && (TechTracker.hasIndustrialTechnology(id) || TechTracker.hasIncreasedFactoryProduction(id))) {
                name.append("_it");
            }
        }
        if (disabled) {
            name.append("_disabled");
        } else if (damaged) {
            name.append("_hit");
        }
        return name.toString();
    }
}

