/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangePerformer;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.UnitHitsChange;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.history.DelegateHistoryWriter;
import games.strategy.engine.history.IDelegateHistoryWriter;
import games.strategy.engine.message.IChannelSubscribor;
import games.strategy.engine.message.IRemote;
import games.strategy.engine.random.PlainRandomSource;
import games.strategy.triplea.oddsCalculator.ta.DummyGameModifiedChannel;
import games.strategy.triplea.oddsCalculator.ta.DummyPlayer;
import games.strategy.triplea.ui.display.DummyDisplay;
import java.util.Properties;

class DummyDelegateBridge
implements IDelegateBridge {
    private final PlainRandomSource m_randomSource = new PlainRandomSource();
    private final DummyDisplay m_display = new DummyDisplay();
    private final DummyPlayer m_attackingPlayer;
    private final DummyPlayer m_defendingPlayer;
    private final PlayerID m_attacker;
    private final DelegateHistoryWriter m_writer = new DelegateHistoryWriter(new DummyGameModifiedChannel());
    private final CompositeChange m_allChanges;
    private final GameData m_data;
    private final ChangePerformer m_changePerformer;

    public DummyDelegateBridge(PlayerID attacker, GameData data, CompositeChange allChanges, boolean attackerKeepOneLandUnit) {
        this.m_attackingPlayer = new DummyPlayer("battle calc dummy", "None (AI)", attackerKeepOneLandUnit);
        this.m_defendingPlayer = new DummyPlayer("battle calc dummy", "None (AI)", false);
        this.m_data = data;
        this.m_attacker = attacker;
        this.m_allChanges = allChanges;
        this.m_changePerformer = new ChangePerformer(this.m_data);
    }

    public GameData getData() {
        return this.m_data;
    }

    public void leaveDelegateExecution() {
    }

    public Properties getStepProperties() {
        throw new UnsupportedOperationException();
    }

    public String getStepName() {
        throw new UnsupportedOperationException();
    }

    public IRemote getRemote(PlayerID id) {
        if (id.equals(this.m_attacker)) {
            return this.m_attackingPlayer;
        }
        return this.m_defendingPlayer;
    }

    public IRemote getRemote() {
        return this.m_attackingPlayer;
    }

    public int[] getRandom(int max, int count, String annotation) {
        return this.m_randomSource.getRandom(max, count, annotation);
    }

    public int getRandom(int max, String annotation) {
        return this.m_randomSource.getRandom(max, annotation);
    }

    public PlayerID getPlayerID() {
        return this.m_attacker;
    }

    public IDelegateHistoryWriter getHistoryWriter() {
        return this.m_writer;
    }

    public IChannelSubscribor getDisplayChannelBroadcaster() {
        return this.m_display;
    }

    public void enterDelegateExecution() {
    }

    public void addChange(Change aChange) {
        if (!(aChange instanceof UnitHitsChange)) {
            return;
        }
        this.m_allChanges.add(aChange);
        this.m_changePerformer.perform(aChange);
    }

    public void stopGameSequence() {
    }
}

