/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.oddsCalculator.ta.UnitPanel;
import games.strategy.triplea.ui.UIContext;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.Match;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlayerUnitsPanel
extends JPanel {
    private final GameData m_data;
    private final UIContext m_context;
    private final boolean m_defender;

    PlayerUnitsPanel(GameData data, UIContext context, boolean defender) {
        this.m_data = data;
        this.m_context = context;
        this.m_defender = defender;
        this.setLayout(new BoxLayout(this, 1));
    }

    public void clear() {
        for (Component c : this.getComponents()) {
            UnitPanel panel = (UnitPanel)c;
            panel.setCount(0);
        }
    }

    public List<Unit> getUnits() {
        ArrayList<Unit> allUnits = new ArrayList<Unit>();
        for (Component c : this.getComponents()) {
            UnitPanel panel = (UnitPanel)c;
            allUnits.addAll(panel.getUnits());
        }
        return allUnits;
    }

    public void init(PlayerID id, List<Unit> units, final boolean land) {
        ArrayList<UnitCategory> categories = new ArrayList<UnitCategory>(this.categorize(id, units));
        Collections.sort(categories, new Comparator<UnitCategory>(){

            @Override
            public int compare(UnitCategory o1, UnitCategory o2) {
                UnitType ut1 = o1.getType();
                UnitType ut2 = o2.getType();
                UnitAttachment u1 = UnitAttachment.get(ut1);
                UnitAttachment u2 = UnitAttachment.get(ut2);
                if (land) {
                    if (u1.getIsSea() != u2.getIsSea()) {
                        return u1.getIsSea() ? 1 : -1;
                    }
                    if (Matches.UnitTypeIsAAforAnything.match(ut1) != Matches.UnitTypeIsAAforAnything.match(ut2)) {
                        return Matches.UnitTypeIsAAforAnything.match(ut1) ? 1 : -1;
                    }
                    if (u1.getIsAir() != u2.getIsAir()) {
                        return u1.getIsAir() ? 1 : -1;
                    }
                } else if (u1.getIsSea() != u2.getIsSea()) {
                    return u1.getIsSea() ? -1 : 1;
                }
                return u1.getName().compareTo(u2.getName());
            }
        });
        this.removeAll();
        Match<UnitType> predicate = land ? (this.m_defender ? Matches.UnitTypeIsNotSea : new CompositeMatchOr<UnitType>(Matches.UnitTypeIsNotSea, Matches.unitTypeCanBombard(id))) : Matches.UnitTypeIsSeaOrAir;
        for (UnitCategory category : categories) {
            if (!predicate.match(category.getType())) continue;
            this.add(new UnitPanel(this.m_data, this.m_context, category));
        }
        this.invalidate();
        this.validate();
        this.revalidate();
        this.getParent().invalidate();
    }

    private Set<UnitCategory> categorize(PlayerID id, List<Unit> units) {
        Set<UnitCategory> categories = UnitSeperator.categorize(units);
        for (UnitType t : this.getUnitTypes(id)) {
            UnitCategory category = new UnitCategory(t, id);
            categories.add(category);
        }
        return categories;
    }

    private Collection<UnitType> getUnitTypes(PlayerID player) {
        HashSet<UnitType> rVal = new HashSet();
        ProductionFrontier frontier = player.getProductionFrontier();
        if (frontier != null) {
            for (ProductionRule rule : frontier) {
                for (NamedAttachable type : rule.getResults().keySet()) {
                    if (!(type instanceof UnitType)) continue;
                    rVal.add((UnitType)type);
                }
            }
        }
        for (Territory t : this.m_data.getMap()) {
            for (Unit u : t.getUnits()) {
                if (!u.getOwner().equals(player)) continue;
                rVal.add(u.getType());
            }
        }
        rVal = Match.getMatches(rVal, Matches.UnitTypeCanBeInBattle(!this.m_defender, player, this.m_data));
        return rVal;
    }
}

