/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.ui.UIContext;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.ui.ScrollableTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnitPanel
extends JPanel {
    private final UIContext m_context;
    private final UnitCategory m_category;
    private final ScrollableTextField m_textField;
    private final GameData m_data;

    public UnitPanel(GameData data, UIContext context, UnitCategory category) {
        this.m_category = category;
        this.m_context = context;
        this.m_data = data;
        this.m_textField = new ScrollableTextField(0, 512);
        this.m_textField.setShowMaxAndMin(false);
        Image img = this.m_context.getUnitImageFactory().getImage(this.m_category.getType(), this.m_category.getOwner(), this.m_data, this.m_category.getDamaged(), this.m_category.getDisabled());
        String toolTipText = "<html>" + this.m_category.getType().getName() + ": " + this.m_category.getType().getTooltip(this.m_category.getOwner(), true) + "</html>";
        this.setCount(this.m_category.getUnits().size());
        this.setLayout(new GridBagLayout());
        JLabel label = new JLabel(new ImageIcon(img));
        label.setToolTipText(toolTipText);
        this.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.m_textField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public List<Unit> getUnits() {
        return this.m_category.getType().create(this.m_textField.getValue(), this.m_category.getOwner(), true);
    }

    public int getCount() {
        return this.m_textField.getValue();
    }

    public void setCount(int value) {
        this.m_textField.setValue(value);
    }

    public UnitCategory getCategory() {
        return this.m_category;
    }
}

