/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.zengland;

import games.strategy.triplea.oddsCalculator.zengland.OCUnit;

public class UnitGroup
implements Cloneable {
    private OCUnit unit;
    private int numUnits;
    private int totalHp;

    public UnitGroup(OCUnit unit, int numUnits) {
        this.setUnit(unit);
        this.setNumUnits(numUnits);
        this.setTotalHp(numUnits * unit.getMaxHP());
    }

    public int getNumUnits() {
        return this.numUnits;
    }

    public void setNumUnits(int numUnits) {
        this.numUnits = numUnits;
        if (this.numUnits < 0) {
            this.numUnits = 0;
        }
    }

    public OCUnit getUnit() {
        return this.unit;
    }

    public void setUnit(OCUnit unit) {
        this.unit = unit;
    }

    public void removeExtraHp() {
        --this.totalHp;
        if (this.totalHp < 0) {
            this.totalHp = 0;
        }
    }

    public void removeUnit() {
        --this.totalHp;
        if (this.totalHp < 0) {
            this.totalHp = 0;
        }
        this.setNumUnits(this.numUnits - 1);
        if (this.numUnits < 0) {
            this.numUnits = 0;
        }
    }

    public int rollUnitsAttack(int numBoosted) {
        int hits = 0;
        int maxHits = this.unit.getMaxHits();
        int maxRolls = this.unit.getMaxRolls();
        int curAttValue = this.unit.getAttackValue() + 1;
        for (int i = 0; i < this.numUnits; ++i) {
            if (i == numBoosted) {
                curAttValue = this.unit.getAttackValue();
            }
            for (int j = 0; j < maxHits; ++j) {
                boolean gotAHit = false;
                for (int k = 0; k < maxRolls && !gotAHit; ++k) {
                    int roll = this.unit.rollAttack();
                    if (roll > curAttValue) continue;
                    gotAHit = true;
                }
                if (!gotAHit) continue;
                ++hits;
            }
        }
        return hits;
    }

    public int rollUnitsAttack() {
        int hits = 0;
        int maxHits = this.unit.getMaxHits();
        int maxRolls = this.unit.getMaxRolls();
        for (int i = 0; i < this.numUnits; ++i) {
            for (int j = 0; j < maxHits; ++j) {
                boolean gotAHit = false;
                for (int k = 0; k < maxRolls && !gotAHit; ++k) {
                    int roll = this.unit.rollAttack();
                    if (roll > this.unit.getAttackValue()) continue;
                    gotAHit = true;
                }
                if (!gotAHit) continue;
                ++hits;
            }
        }
        return hits;
    }

    public int rollUnitsDefend() {
        int hits = 0;
        for (int i = 0; i < this.numUnits; ++i) {
            int roll = this.unit.rollDefend();
            if (roll > this.unit.getDefendValue()) continue;
            ++hits;
        }
        return hits;
    }

    public String toString() {
        String unitGroup = "";
        unitGroup = unitGroup + this.getUnit().toString();
        unitGroup = unitGroup + " " + this.getNumUnits();
        return unitGroup;
    }

    public static void main(String[] args) {
        UnitGroup ug = new UnitGroup(OCUnit.newInf(), 10);
        System.out.println(ug);
        int defHits = 0;
        int attHits = 0;
        boolean rounds = true;
        for (int i = 0; i < 1; ++i) {
            defHits += ug.rollUnitsDefend();
            attHits += ug.rollUnitsAttack(5);
        }
        System.out.println("Avg Attack hits " + (float)attHits / 1.0f);
        System.out.println("Avg Defense hits " + (float)defHits / 1.0f);
    }

    public int getTotalHp() {
        return this.totalHp;
    }

    public void setTotalHp(int totalHp) {
        this.totalHp = totalHp;
    }

    public Object clone() {
        UnitGroup c = null;
        c = new UnitGroup(this.getUnit(), this.getNumUnits());
        return c;
    }
}

